/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.profiles;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.views.profiles.ArrayQueue;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProfilesViewHelper {
    public static String[] addSDocFromJavaScriptSource(File base, String text) {
        URL baseFile = FileUtils.uriToURL((String)CoreUIUtils.getURI((File)base));
        return ProfilesViewHelper.addSDocFromJavaScriptSource(baseFile, text);
    }

    public static String[] addSDocFromJavaScriptSource(URL base, String text) {
        ArrayList<String> fileList = new ArrayList<String>();
        int commentStart = text.indexOf("/*");
        while (commentStart != -1) {
            int commentEnd = text.indexOf("*/", commentStart + 2);
            if (commentEnd == -1) break;
            Pattern p = Pattern.compile("@sdoc\\s+([^\r\n]+)");
            Matcher matcher = p.matcher(text);
            String matchedString = "";
            while (matcher.find()) {
                matchedString = matcher.group(1);
            }
            if (matchedString != "") {
                String filename = matchedString.trim();
                if (filename.charAt(0) != '/' || filename.indexOf(":") == -1) {
                    filename = CoreUIUtils.joinURI((URL)base, (String)filename);
                }
                fileList.add(CoreUIUtils.getURI((String)filename));
            }
            commentStart = text.indexOf("/*", commentEnd + 2);
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public static String[] addScriptTagsFromHTMLSource(File base, String text, IParseState parseState) {
        URL baseFile = FileUtils.uriToURL((String)CoreUIUtils.getURI((File)base));
        return ProfilesViewHelper.addScriptTagsFromHTMLSource(baseFile, text, parseState);
    }

    public static String[] addScriptTagsFromHTMLSource(URL base, String text, IParseState parseState) {
        ArrayList<String> fileList = new ArrayList<String>();
        IParseNode results = parseState.getParseResults();
        IParseNode[] current = results.getChildren();
        ArrayQueue queue = new ArrayQueue();
        ArrayList<String> srcs = new ArrayList<String>();
        int i = 0;
        while (i < current.length) {
            queue.enqueue(current[i]);
            ++i;
        }
        while (queue.size() > 0) {
            IParseNode node = (IParseNode)queue.dequeue();
            IParseNode[] children = node.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                IParseNode child = children[i2];
                if ("script".equals(child.getText())) {
                    boolean hasFile = false;
                    String filename = child.getAttribute("src");
                    filename = ProfilesViewHelper.makeHttpUrl(filename);
                    String aSrc = "";
                    int j = 0;
                    while (j < srcs.size()) {
                        aSrc = (String)srcs.get(j);
                        if (aSrc == filename) {
                            hasFile = true;
                            break;
                        }
                        ++j;
                    }
                    if (!hasFile) {
                        srcs.add(filename);
                    }
                } else {
                    queue.enqueue(child);
                }
                ++i2;
            }
        }
        i = 0;
        while (i < srcs.size()) {
            String src = (String)srcs.get(i);
            if (src != null && src.length() > 0) {
                URL url;
                String source = StringUtils.trimStringQuotes((String)src);
                if (!CoreUIUtils.isURI((String)(source = ProfilesViewHelper.stripQuerystring(source))) && source.charAt(0) != '/') {
                    source = CoreUIUtils.joinURI((URL)base, (String)source);
                }
                String uri = CoreUIUtils.getURI((String)source);
                fileList.add(uri);
                String sdocFile = ProfilesViewHelper.findScriptDocFile(uri);
                if (sdocFile != null) {
                    fileList.add(CoreUIUtils.getURI((String)sdocFile));
                }
                if ((url = FileUtils.uriToURL((String)uri)) != null) {
                    String[] subFiles = ProfilesViewHelper.addScriptFromJavaScriptSource(url);
                    fileList.addAll(Arrays.asList(subFiles));
                }
            }
            ++i;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public static String[] addSDocFromJavaScriptSource(URL url) {
        URL basePath = ProfilesViewHelper.getBasePath(url);
        try {
            String text = FileUtils.readContent((URL)url);
            if (text != null) {
                return ProfilesViewHelper.addSDocFromJavaScriptSource(basePath, text);
            }
            return new String[0];
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    public static URL getBasePath(URL url) {
        return CoreUIUtils.trimURLSegments((URL)url, (int)1);
    }

    public static URL getBasePath(String uri) {
        try {
            URI uri2 = new URI(uri);
            URL url = uri2.toURL();
            return ProfilesViewHelper.getBasePath(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] addScriptFromJavaScriptSource(URL url) {
        URL basePath = ProfilesViewHelper.getBasePath(url);
        try {
            String text = FileUtils.readContent((URL)url);
            if (text != null) {
                return ProfilesViewHelper.addScriptFromJavaScriptSource(basePath, text);
            }
        }
        catch (IOException iOException) {
            return new String[0];
        }
        return new String[0];
    }

    public static String[] addScriptFromJavaScriptSource(File base, String text) {
        URL baseFile = FileUtils.uriToURL((String)CoreUIUtils.getURI((File)base));
        return ProfilesViewHelper.addScriptFromJavaScriptSource(baseFile, text);
    }

    public static String[] addScriptFromJavaScriptSource(URL base, String text) {
        ArrayList<String> fileList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^MochiKit\\.MochiKit\\.SUBMODULES\\s*=\\s*\\[[\\r\\n]+([^\\]]+)\\]", 8);
        Matcher matcher = pattern.matcher(text);
        String names = "";
        while (matcher.find()) {
            names = matcher.group(1);
        }
        pattern = Pattern.compile("\"([^\"]+)\"");
        matcher = pattern.matcher(names);
        ArrayList<String> mochikitNames = new ArrayList<String>();
        while (matcher.find()) {
            mochikitNames.add(matcher.group(1));
        }
        String[] sdocs = ProfilesViewHelper.addSDocFromJavaScriptSource(base, text);
        fileList.addAll(Arrays.asList(sdocs));
        int i = 0;
        while (i < mochikitNames.size()) {
            String sdocFile;
            String source = CoreUIUtils.joinURI((URL)base, (String)(String.valueOf((String)mochikitNames.get(i)) + ".js"));
            fileList.add(CoreUIUtils.getURI((String)source));
            URL u = FileUtils.uriToURL((String)source);
            if (u != null) {
                String[] subFiles = ProfilesViewHelper.addSDocFromJavaScriptSource(u);
                fileList.addAll(Arrays.asList(subFiles));
            }
            if ((sdocFile = ProfilesViewHelper.findScriptDocFile(source)) != null) {
                fileList.add(CoreUIUtils.getURI((String)sdocFile));
            }
            ++i;
        }
        return fileList.toArray(new String[fileList.size()]);
    }

    public static String findScriptDocFile(String fileName) {
        String baseName = CoreUIUtils.getURI((String)FileUtils.stripExtension((String)fileName));
        String sdocName = String.valueOf(baseName) + ".sdoc";
        URL sdocURL = FileUtils.uriToURL((String)sdocName);
        if (ProfilesViewHelper.isValidURL(sdocURL)) {
            return sdocURL.toString();
        }
        return null;
    }

    public static String stripQuerystring(String source) {
        int tmp = source.indexOf("?");
        if (tmp > -1) {
            source = source.substring(0, tmp);
        }
        return source;
    }

    public static boolean isValidURL(URL url) {
        if (url == null) {
            return false;
        }
        try {
            if (FileUtils.isFileURL((URL)url)) {
                File file = FileUtils.urlToFile((URL)url);
                return file.exists() && file.isFile() && file.canRead();
            }
            InputStream is = url.openStream();
            is.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String makeHttpUrl(String url) {
        if (url != null && url.startsWith("//")) {
            return "http:" + url;
        }
        return url;
    }
}

