/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing;

import com.aptana.ide.editor.scriptdoc.parsing.DocumentationBase;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.metadata.UserAgent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PropertyDocumentation
extends DocumentationBase {
    private TypedDescription _returns = new TypedDescription();
    private TypedDescription _member = new TypedDescription();
    private TypedDescription _alias = new TypedDescription();
    private String _deprecatedDescription = "";
    private String _since = "";
    private List<UserAgent> _userAgents;
    private boolean _isDeprecated = false;
    private boolean _isPrivate = false;
    private boolean _isProtected = false;
    private boolean _isInternal = false;
    private boolean _isNative = false;
    private boolean _isInstance = false;
    private boolean _isInvocationOnly = false;
    private boolean _isIgnored = false;

    public void addUserAgent(UserAgent value) {
        String platform;
        if (value != null && (platform = value.getPlatform()) != null && platform.length() > 0) {
            if (this._userAgents == null) {
                this._userAgents = new ArrayList<UserAgent>();
            }
            this._userAgents.add(value);
        }
    }

    public TypedDescription getAliases() {
        if (this._alias == null) {
            this._alias = new TypedDescription();
        }
        return this._alias;
    }

    public String getDeprecatedDescription() {
        return this._deprecatedDescription;
    }

    public boolean getIsDeprecated() {
        return this._isDeprecated;
    }

    public boolean getIsIgnored() {
        return this._isIgnored;
    }

    public boolean getIsInstance() {
        return this._isInstance;
    }

    public boolean getIsInternal() {
        return this._isInternal;
    }

    public boolean getIsInvocationOnly() {
        return this._isInvocationOnly;
    }

    public boolean getIsNative() {
        return this._isNative;
    }

    public boolean getIsPrivate() {
        return this._isPrivate;
    }

    public boolean getIsProtected() {
        return this._isProtected;
    }

    public TypedDescription getMemberOf() {
        if (this._member == null) {
            this._member = new TypedDescription();
        }
        return this._member;
    }

    public TypedDescription getReturn() {
        if (this._returns == null) {
            this._returns = new TypedDescription();
        }
        return this._returns;
    }

    public String getSince() {
        return this._since;
    }

    public String[] getUserAgentPlatformNames() {
        ArrayList<String> al = new ArrayList<String>();
        if (this._userAgents != null) {
            int i = 0;
            while (i < this._userAgents.size()) {
                UserAgent param = this._userAgents.get(i);
                al.add(param.getPlatform());
                ++i;
            }
        }
        if (this.getUserAgent() != null && !this.getUserAgent().equals("")) {
            al.add(this.getUserAgent());
        }
        return al.toArray(new String[al.size()]);
    }

    public UserAgent[] getUserAgents() {
        if (this._userAgents == null) {
            return new UserAgent[0];
        }
        return this._userAgents.toArray(new UserAgent[this._userAgents.size()]);
    }

    protected void printBody(SourceWriter writer) {
        super.printBody(writer);
        this.printTag(writer, "@return", this._returns);
        this.printTag(writer, "@member", this._member);
        this.printTag(writer, "@alias", this._alias);
        if (this._isDeprecated) {
            String description = this._deprecatedDescription != null ? this._deprecatedDescription : "";
            this.printTag(writer, "@deprecated", description);
        }
        this.printTag(writer, "@private", this._isPrivate);
        this.printTag(writer, "@protected", this._isProtected);
        this.printTag(writer, "@internal", this._isInternal);
        this.printTag(writer, "@native", this._isNative);
        this.printTag(writer, "@instance", this._isInstance);
        this.printTag(writer, "@invocationOnly", this._isInvocationOnly);
        this.printTag(writer, "@ignored", this._isIgnored);
    }

    public void read(DataInput input) throws IOException {
        super.read(input);
        int size = input.readInt();
        if (size > 0) {
            this._userAgents = new ArrayList<UserAgent>();
            int i = 0;
            while (i < size) {
                UserAgent param = new UserAgent();
                param.read(input);
                this._userAgents.add(param);
                ++i;
            }
        }
        this._returns = new TypedDescription();
        this._returns.read(input);
        this._member = new TypedDescription();
        this._member.read(input);
        this._deprecatedDescription = input.readUTF();
        this._since = input.readUTF();
        this._isDeprecated = input.readBoolean();
        this._isPrivate = input.readBoolean();
        this._isProtected = input.readBoolean();
        this._isInternal = input.readBoolean();
        this._isNative = input.readBoolean();
        this._isInstance = input.readBoolean();
        this._isInvocationOnly = input.readBoolean();
        this._isIgnored = input.readBoolean();
    }

    public void setDeprecatedDescription(String value) {
        this._deprecatedDescription = value == null ? "" : value;
    }

    public void setIsDeprecated(boolean value) {
        this._isDeprecated = value;
    }

    public void setIsIgnored(boolean value) {
        this._isIgnored = value;
    }

    public void setIsInstance(boolean value) {
        this._isInstance = value;
    }

    public void setIsInternal(boolean value) {
        this._isInternal = value;
    }

    public void setIsInvocationOnly(boolean value) {
        this._isInvocationOnly = value;
    }

    public void setIsNative(boolean value) {
        this._isNative = value;
    }

    public void setIsPrivate(boolean value) {
        this._isPrivate = value;
    }

    public void setIsProtected(boolean value) {
        this._isProtected = value;
    }

    public void setSince(String value) {
        this._since = value == null ? "" : value;
    }

    public void write(DataOutput output) throws IOException {
        super.write(output);
        if (this._userAgents != null) {
            output.writeInt(this._userAgents.size());
            int i = 0;
            while (i < this._userAgents.size()) {
                UserAgent param = this._userAgents.get(i);
                param.write(output);
                ++i;
            }
        } else {
            output.writeInt(0);
        }
        this._returns.write(output);
        this._member.write(output);
        output.writeUTF(this._deprecatedDescription);
        output.writeUTF(this._since);
        output.writeBoolean(this._isDeprecated);
        output.writeBoolean(this._isPrivate);
        output.writeBoolean(this._isProtected);
        output.writeBoolean(this._isInternal);
        output.writeBoolean(this._isNative);
        output.writeBoolean(this._isInstance);
        output.writeBoolean(this._isInvocationOnly);
        output.writeBoolean(this._isIgnored);
    }
}

