/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing;

import com.aptana.ide.editor.scriptdoc.parsing.MixinDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.io.SourceWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FunctionDocumentation
extends PropertyDocumentation {
    private String _classDescription = "";
    private String _methodName = "";
    private TypedDescription _extends = new TypedDescription();
    private List<MixinDocumentation> _mixins;
    private List<TypedDescription> _params;
    private List<TypedDescription> _exceptions;
    private boolean _isConstructor = false;
    private boolean _isMethod = false;

    public void addException(TypedDescription value) {
        if (this._exceptions == null) {
            this._exceptions = new ArrayList<TypedDescription>();
        }
        this._exceptions.add(value);
    }

    public void addMixin(String string, boolean sourceInstanceProperties, boolean targetInstanceProperties) {
        if (this._mixins == null) {
            this._mixins = new ArrayList<MixinDocumentation>();
        }
        this._mixins.add(new MixinDocumentation(string, sourceInstanceProperties, targetInstanceProperties));
    }

    public void addParam(TypedDescription value) {
        if (this._params == null) {
            this._params = new ArrayList<TypedDescription>();
        }
        this._params.add(value);
    }

    public void clearExceptions() {
        if (this._exceptions != null) {
            this._exceptions.clear();
        }
    }

    public void clearParams() {
        if (this._params != null) {
            this._params.clear();
        }
    }

    public String getClassDescription() {
        return this._classDescription;
    }

    public TypedDescription[] getExceptions() {
        if (this._exceptions == null) {
            return new TypedDescription[0];
        }
        return this._exceptions.toArray(new TypedDescription[this._exceptions.size()]);
    }

    public TypedDescription getExtends() {
        if (this._extends == null) {
            return new TypedDescription();
        }
        return this._extends;
    }

    public boolean getIsConstructor() {
        return this._isConstructor;
    }

    public boolean getIsMethod() {
        return this._isMethod;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public MixinDocumentation[] getMixins() {
        MixinDocumentation[] result = new MixinDocumentation[]{};
        if (this._mixins != null) {
            result = this._mixins.toArray(new MixinDocumentation[this._mixins.size()]);
        }
        return result;
    }

    public TypedDescription[] getParams() {
        if (this._params == null) {
            return new TypedDescription[0];
        }
        return this._params.toArray(new TypedDescription[this._params.size()]);
    }

    public void read(DataInput input) throws IOException {
        int i;
        super.read(input);
        this._classDescription = input.readUTF();
        this._extends = new TypedDescription();
        this._extends.read(input);
        int size = input.readInt();
        if (size > 0) {
            this._params = new ArrayList<TypedDescription>();
            i = 0;
            while (i < size) {
                TypedDescription param = new TypedDescription();
                param.read(input);
                this._params.add(param);
                ++i;
            }
        }
        if ((size = input.readInt()) > 0) {
            this._exceptions = new ArrayList<TypedDescription>();
            i = 0;
            while (i < size) {
                TypedDescription exception = new TypedDescription();
                exception.read(input);
                this._exceptions.add(exception);
                ++i;
            }
        }
        this._isConstructor = input.readBoolean();
        this._isMethod = input.readBoolean();
        this.setIsIgnored(input.readBoolean());
    }

    public void setClassDescription(String value) {
        this._classDescription = value == null ? "" : value;
    }

    public void setExtends(TypedDescription value) {
        this._extends = value;
    }

    public void setIsConstructor(boolean value) {
        this._isConstructor = value;
    }

    public void setIsMethod(boolean value) {
        this._isMethod = value;
    }

    public void setMethodName(String value) {
        this._methodName = value == null ? "" : value;
    }

    protected void printBody(SourceWriter writer) {
        super.printBody(writer);
        this.printTag(writer, "@classDescription", this._classDescription);
        this.printTag(writer, "@method", this._methodName);
        this.printTag(writer, "@extends", this._extends);
        if (this._params != null) {
            for (TypedDescription typeInfo : this._params) {
                this.printTag(writer, "@param", typeInfo);
            }
        }
        if (this._exceptions != null) {
            for (TypedDescription exception : this._exceptions) {
                this.printTag(writer, "@exception", exception);
            }
        }
        this.printTag(writer, "@constructor", this._isConstructor);
        this.printTag(writer, "@method", this._isMethod);
    }

    public void write(DataOutput output) throws IOException {
        int i;
        super.write(output);
        output.writeUTF(this._classDescription);
        this._extends.write(output);
        if (this._params != null) {
            output.writeInt(this._params.size());
            i = 0;
            while (i < this._params.size()) {
                TypedDescription param = this._params.get(i);
                param.write(output);
                ++i;
            }
        } else {
            output.writeInt(0);
        }
        if (this._exceptions != null) {
            output.writeInt(this._exceptions.size());
            i = 0;
            while (i < this._exceptions.size()) {
                TypedDescription exception = this._exceptions.get(i);
                exception.write(output);
                ++i;
            }
        } else {
            output.writeInt(0);
        }
        output.writeBoolean(this._isConstructor);
        output.writeBoolean(this._isMethod);
        output.writeBoolean(this.getIsIgnored());
    }
}

