/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.JSNull;
import com.aptana.ide.editor.js.runtime.JSUndefined;
import com.aptana.ide.editor.js.runtime.Messages;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.metadata.IDocumentation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectBase
implements IObject {
    public static final JSNull NULL = JSNull.getSingletonInstance();
    public static final JSUndefined UNDEFINED = JSUndefined.getSingletonInstance();
    private IObject _prototype;
    private Map<String, Property> _properties;
    private IDocumentation _documentation;
    private IRange _range;

    private Map<String, Property> getProperties() {
        if (this._properties == null) {
            this._properties = new HashMap<String, Property>();
        }
        return this._properties;
    }

    public ObjectBase() {
        this(null);
    }

    public ObjectBase(IRange range) {
        this._range = range;
    }

    @Override
    public boolean canPut(String propertyName) {
        boolean result = true;
        if (this._properties != null && this.getProperties().containsKey(propertyName)) {
            Property p = this.getLocalProperty(propertyName);
            result = !p.isReadOnly();
        }
        return result;
    }

    @Override
    public Property getProperty(String propertyName) {
        Property result = null;
        if (this._properties != null && this.getProperties().containsKey(propertyName)) {
            result = this.getLocalProperty(propertyName);
        } else if (this._prototype != null) {
            result = this._prototype.getProperty(propertyName);
        }
        return result;
    }

    @Override
    public IObject getPropertyValue(String propertyName, int fileIndex, int offset) {
        IObject result = UNDEFINED;
        if (this._properties != null && this.getProperties().containsKey(propertyName)) {
            Property p = this.getLocalProperty(propertyName);
            result = p.getValue(fileIndex, offset);
        } else if (this._prototype != null) {
            result = this._prototype.getPropertyValue(propertyName, fileIndex, offset);
        }
        return result;
    }

    @Override
    public void putPropertyValue(String propertyName, IObject value, int fileIndex) {
        this.putPropertyValue(propertyName, value, fileIndex, 0);
    }

    @Override
    public void putPropertyValue(String propertyName, IObject value, int fileIndex, int attributes) {
        if (this.canPut(propertyName)) {
            Property p;
            Map<String, Property> properties = this.getProperties();
            if ("Jaxer".equals(propertyName)) {
                String message = "putPropertyValue put " + value + "\n" + this.getStackTrace();
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)message);
            }
            if (properties.containsKey(propertyName)) {
                p = this.getLocalProperty(propertyName);
                try {
                    p.setValue(value, fileIndex);
                }
                catch (IllegalStateException e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)Messages.ObjectBase_AttemptedToOverwritePropertyNameAtFileIndex, (Object[])new String[]{propertyName, String.valueOf(fileIndex)}), (Throwable)e);
                }
            } else {
                p = new Property(value, fileIndex, attributes);
                properties.put(propertyName, p);
            }
            p.addReference();
        }
    }

    @Override
    public String[] getPropertyNames() {
        return this.getPropertyNames(false);
    }

    @Override
    public String[] getPropertyNames(boolean getAll) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        IObject current = this;
        while (current != null) {
            int i;
            String[] localNames = current.getLocalPropertyNames();
            if (getAll) {
                i = 0;
                while (i < localNames.length) {
                    result.put(localNames[i], Boolean.TRUE);
                    ++i;
                }
            } else {
                i = 0;
                while (i < localNames.length) {
                    Property p;
                    String name = localNames[i];
                    if (!result.containsKey(name) && (p = current.getLocalProperty(name)).isEnumerable()) {
                        result.put(localNames[i], Boolean.TRUE);
                    }
                    ++i;
                }
            }
            current = current.getPrototype();
        }
        Set s = result.keySet();
        return s.toArray(new String[s.size()]);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        boolean result = false;
        if (this._properties != null && this.getProperties().containsKey(propertyName)) {
            result = true;
        } else if (this._prototype != null) {
            result = this._prototype.hasProperty(propertyName);
        }
        return result;
    }

    @Override
    public Property getLocalProperty(String propertyName) {
        Map<String, Property> properties;
        Property result = null;
        if (this._properties != null) {
            properties = this.getProperties();
            if (!properties.containsKey(propertyName)) {
                throw new IllegalArgumentException(String.valueOf(Messages.ObjectBase_LocalPropertyNameDoesNotExist) + propertyName);
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(Messages.ObjectBase_LocalPropertyNameDoesNotExist2) + propertyName);
        }
        result = properties.get(propertyName);
        return result;
    }

    @Override
    public void putLocalProperty(String propertyName, Property property) {
        Map<String, Property> properties = this.getProperties();
        if ("Jaxer".equals(propertyName)) {
            String message = "putLocalProperty put Jaxer\n" + this.getStackTrace();
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)message);
        }
        properties.put(propertyName, property);
    }

    @Override
    public String[] getLocalPropertyNames() {
        String[] result;
        if (this._properties != null) {
            Set<String> names = this.getProperties().keySet();
            result = names.toArray(new String[names.size()]);
        } else {
            result = new String[]{};
        }
        return result;
    }

    @Override
    public boolean hasLocalProperty(String propertyName) {
        boolean result = false;
        if (this._properties != null) {
            result = this.getProperties().containsKey(propertyName);
        }
        return result;
    }

    @Override
    public void unputPropertyName(String propertyName, int fileIndex, int offset) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new NullPointerException(Messages.ObjectBase_PropertyNameMustBeDefined);
        }
        Property p = this.getProperty(propertyName);
        if (p == null) {
            throw new NullPointerException(String.valueOf(Messages.ObjectBase_TryingToUnputAPropertyThatDoesNotExist) + propertyName);
        }
        if (p.removeReference() == 0) {
            if (!p.isPermanent()) {
                this.deletePropertyName(propertyName);
            }
        } else {
            if ("Jaxer".equals(propertyName)) {
                String message = "unputPropertyValue:\n" + this.getStackTrace();
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)message);
            }
            p.unsetValue(fileIndex, offset);
        }
    }

    @Override
    public boolean deletePropertyName(String propertyName) {
        Map<String, Property> properties;
        boolean result = true;
        if (this._properties != null && (properties = this.getProperties()).containsKey(propertyName)) {
            Property p = this.getLocalProperty(propertyName);
            if (p.isReadOnly()) {
                result = false;
            } else {
                if ("Jaxer".equals(propertyName)) {
                    String message = "deletePropertyName deleted Jaxer\n" + this.getStackTrace();
                    IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)message);
                }
                properties.remove(propertyName);
            }
        }
        return result;
    }

    @Override
    public IObject getPrototype() {
        return this._prototype;
    }

    @Override
    public void setPrototype(IObject prototype) {
        this._prototype = prototype;
    }

    @Override
    public abstract String getClassName();

    @Override
    public IObject getInstance(Environment environment, int fileIndex, int offset) {
        return this;
    }

    public int getEndingOffset() {
        int result = -1;
        if (this._range != null) {
            result = this._range.getEndingOffset();
        }
        return result;
    }

    public int getLength() {
        int result = 0;
        if (this._range != null) {
            result = this._range.getLength();
        }
        return result;
    }

    public IRange getRange() {
        return this._range;
    }

    public int getStartingOffset() {
        int result = -1;
        if (this._range != null) {
            result = this._range.getStartingOffset();
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = true;
        if (this._range != null) {
            result = this._range.isEmpty();
        }
        return result;
    }

    public boolean containsOffset(int offset) {
        boolean result = false;
        if (this._range != null) {
            result = this._range.containsOffset(offset);
        }
        return result;
    }

    public IDocumentation getDocumentation() {
        return this._documentation;
    }

    public boolean hasDocumentation() {
        return this._documentation != null;
    }

    public void setDocumentation(IDocumentation documentation) {
        this._documentation = documentation;
    }

    @Override
    public int getLocalPropertyCount() {
        int result = 0;
        if (this._properties != null) {
            result = this._properties.size();
        }
        return result;
    }

    private String getStackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append(element.toString()).append("\n");
            ++n2;
        }
        return sb.toString();
    }
}

