/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.preferences;

import com.aptana.ide.ui.editors.preferences.formatter.CompilationUnitPreview;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterMessages;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialog;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialogTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.Preview;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentationTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader((String)FormatterMessages.IndentationTabPage_preview_header)) + "  function foo(a, b, c, d,  e,  f) {" + "    switch(a) {" + "    case 0: " + "      Other.doFoo();" + "      break;" + "    default:" + "      Other.doBaz();" + "    }" + "  }" + "  function bar(v) {" + "    for (i= 0; i < 10; i++) {" + "      v.add(new Integer(i));" + "    }" + "  }" + "\n";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;
    private String editor;

    public IndentationTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues, String editor) {
        super((ModifyDialogTabPage.IModificationListener)modifyDialog, workingValues);
        this.editor = editor;
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{" ", "\t"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB};
        this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "com.aptana.ide.editors.codeassist.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 0, 32);
        ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        if (tabchar == null) {
            tabchar = " ";
        }
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body, "com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block, "com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_block", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body, "com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_switch", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements, "com.aptana.ide.editors.codeassist.formatter.indent_breaks_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines, "com.aptana.ide.editors.codeassist.formatter.indent_empty_lines", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected Preview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent, this.editor, null);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if (" ".equals(this.fOldTabChar) || "\t".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if (" ".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("\t".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        String tabSize = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        String indentSize = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.indentation.size");
        this.fWorkingValues.put("com.aptana.ide.editors.codeassist.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("com.aptana.ide.editors.codeassist.formatter.indentation.size", tabSize);
    }
}

