/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing;

import com.aptana.ide.editor.js.parsing.JSAbstractHandler;
import com.aptana.ide.editor.js.parsing.Messages;
import com.aptana.ide.editor.js.parsing.nodes.JSFunctionNode;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.ParseFragment;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class JSASTHandler
extends JSAbstractHandler {
    private List<JSParseNode> _statements = new ArrayList<JSParseNode>();

    public void afterParse(IParseState parseState, IParseNode parentNode) {
        Object result;
        Object[] results;
        if (parentNode != null && (results = this.getValues()) != null && results.length > 0 && (result = results[0]) instanceof ParseFragment) {
            parentNode.appendChild((IParseNode)((ParseFragment)result));
        }
        this._statements.clear();
        super.afterParse(parseState, parentNode);
    }

    protected Object onAddArgument(Object[] nodes) {
        ParseFragment arguments = (ParseFragment)nodes[0];
        JSParseNode argument = (JSParseNode)((Object)nodes[2]);
        arguments.appendChild((IParseNode)argument);
        return arguments;
    }

    protected Object onAddCaseClause(Object[] nodes) {
        ParseFragment clauses = (ParseFragment)nodes[0];
        JSParseNode clause = (JSParseNode)((Object)nodes[1]);
        clauses.appendChild((IParseNode)clause);
        return clauses;
    }

    protected Object onAddElement(Object[] nodes) {
        ParseFragment elements = (ParseFragment)nodes[0];
        JSParseNode element = (JSParseNode)((Object)nodes[2]);
        elements.appendChild((IParseNode)element);
        return elements;
    }

    protected Object onAddElidedElement(Object[] nodes) {
        ParseFragment elements = (ParseFragment)nodes[0];
        ParseFragment elisions = (ParseFragment)nodes[2];
        JSParseNode element = (JSParseNode)((Object)nodes[3]);
        elements.appendChild((IParseNode)elisions);
        elements.appendChild((IParseNode)element);
        return elements;
    }

    protected Object onAddElision(Object[] nodes) {
        JSParseNode nullNode = (JSParseNode)this.createNode(65, null);
        ParseFragment elisions = (ParseFragment)nodes[0];
        elisions.appendChild((IParseNode)nullNode);
        return elisions;
    }

    protected Object onAddParameter(Object[] nodes) {
        JSParseNode parameters = (JSParseNode)((Object)nodes[0]);
        Lexeme name = (Lexeme)nodes[2];
        JSParseNode identifier = (JSParseNode)this.createNode(64, name);
        parameters.appendChild((IParseNode)identifier);
        return parameters;
    }

    protected Object onAddProperty(Object[] nodes) {
        ParseFragment properties = (ParseFragment)nodes[0];
        Lexeme identifier = (Lexeme)nodes[2];
        JSParseNode name = (JSParseNode)this.createNode(64, identifier);
        JSParseNode value = (JSParseNode)((Object)nodes[4]);
        JSParseNode property = (JSParseNode)this.createNode(70, null);
        property.appendChild((IParseNode)name);
        property.appendChild((IParseNode)value);
        properties.appendChild((IParseNode)property);
        return properties;
    }

    protected Object onAddSourceElement(Object[] nodes) {
        ParseFragment fragment = (ParseFragment)nodes[0];
        JSParseNode element = (JSParseNode)((Object)nodes[1]);
        fragment.appendChild((IParseNode)element);
        return fragment;
    }

    protected Object onAddStatement(Object[] nodes) {
        JSParseNode statements = (JSParseNode)((Object)nodes[0]);
        JSParseNode statement = (JSParseNode)((Object)nodes[1]);
        statements.appendChild((IParseNode)statement);
        return statements;
    }

    protected Object onAddVarDeclaration(Object[] nodes) {
        ParseFragment declarations = (ParseFragment)nodes[0];
        JSParseNode declaration = (JSParseNode)((Object)nodes[2]);
        declarations.appendChild((IParseNode)declaration);
        return declarations;
    }

    protected Object onArguments(Object[] nodes) {
        Lexeme lparen = (Lexeme)nodes[0];
        ParseFragment arguments = (ParseFragment)nodes[1];
        Lexeme rparen = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(53, lparen);
        result.appendChild((IParseNode)arguments);
        result.includeLexemeInRange(rparen);
        return result;
    }

    protected Object onArrayLiteral(Object[] nodes) {
        Lexeme lbracket = (Lexeme)nodes[0];
        ParseFragment elements = (ParseFragment)nodes[1];
        Lexeme rbracket = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(54, lbracket);
        result.appendChild((IParseNode)elements);
        result.includeLexemeInRange(rbracket);
        return result;
    }

    protected Object onArrayLiteralTrailingComma(Object[] nodes) {
        Lexeme lbracket = (Lexeme)nodes[0];
        ParseFragment elements = (ParseFragment)nodes[1];
        JSParseNode nullNode = (JSParseNode)this.createNode(65, null);
        Lexeme rbracket = (Lexeme)nodes[3];
        JSParseNode result = (JSParseNode)this.createNode(54, lbracket);
        result.appendChild((IParseNode)elements);
        result.appendChild((IParseNode)nullNode);
        result.includeLexemeInRange(rbracket);
        return result;
    }

    protected Object onArrayLiteralTrailingElision(Object[] nodes) {
        Lexeme lbracket = (Lexeme)nodes[0];
        ParseFragment elements = (ParseFragment)nodes[1];
        ParseFragment elisions = (ParseFragment)nodes[3];
        Lexeme rbracket = (Lexeme)nodes[4];
        JSParseNode result = (JSParseNode)this.createNode(54, lbracket);
        result.appendChild((IParseNode)elements);
        result.appendChild((IParseNode)elisions);
        result.includeLexemeInRange(rbracket);
        return result;
    }

    protected Object onAssignmentExpression(Object[] nodes) {
        JSParseNode result;
        JSParseNode lhs = (JSParseNode)((Object)nodes[0]);
        Lexeme operator = (Lexeme)nodes[1];
        JSParseNode rhs = (JSParseNode)((Object)nodes[2]);
        switch (operator.typeIndex) {
            case 40: {
                result = (JSParseNode)this.createNode(1, operator);
                break;
            }
            case 64: {
                result = (JSParseNode)this.createNode(9, operator);
                break;
            }
            case 81: {
                result = (JSParseNode)this.createNode(7, operator);
                break;
            }
            case 72: {
                result = (JSParseNode)this.createNode(8, operator);
                break;
            }
            case 48: {
                result = (JSParseNode)this.createNode(2, operator);
                break;
            }
            case 56: {
                result = (JSParseNode)this.createNode(12, operator);
                break;
            }
            case 79: {
                result = (JSParseNode)this.createNode(10, operator);
                break;
            }
            case 41: {
                result = (JSParseNode)this.createNode(11, operator);
                break;
            }
            case 49: {
                result = (JSParseNode)this.createNode(3, operator);
                break;
            }
            case 57: {
                result = (JSParseNode)this.createNode(4, operator);
                break;
            }
            case 73: {
                result = (JSParseNode)this.createNode(6, operator);
                break;
            }
            case 65: {
                result = (JSParseNode)this.createNode(5, operator);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.JSASTHandler_Unknown_operator_0, operator));
            }
        }
        result.appendChild((IParseNode)lhs);
        result.appendChild((IParseNode)rhs);
        return result;
    }

    protected Object onBinaryExpression(Object[] nodes) {
        JSParseNode result;
        JSParseNode lhs = (JSParseNode)((Object)nodes[0]);
        Lexeme operator = (Lexeme)nodes[1];
        JSParseNode rhs = (JSParseNode)((Object)nodes[2]);
        switch (operator.typeIndex) {
            case 53: {
                result = (JSParseNode)this.createNode(34, operator);
                break;
            }
            case 80: {
                result = (JSParseNode)this.createNode(32, operator);
                break;
            }
            case 61: {
                result = (JSParseNode)this.createNode(33, operator);
                break;
            }
            case 45: {
                result = (JSParseNode)this.createNode(37, operator);
                break;
            }
            case 37: {
                result = (JSParseNode)this.createNode(27, operator);
                break;
            }
            case 38: {
                result = (JSParseNode)this.createNode(35, operator);
                break;
            }
            case 46: {
                result = (JSParseNode)this.createNode(36, operator);
                break;
            }
            case 54: {
                result = (JSParseNode)this.createNode(28, operator);
                break;
            }
            case 59: {
                result = (JSParseNode)this.createNode(21, operator);
                break;
            }
            case 67: {
                result = (JSParseNode)this.createNode(16, operator);
                break;
            }
            case 75: {
                result = (JSParseNode)this.createNode(22, operator);
                break;
            }
            case 36: {
                result = (JSParseNode)this.createNode(17, operator);
                break;
            }
            case 19: {
                result = (JSParseNode)this.createNode(20, operator);
                break;
            }
            case 18: {
                result = (JSParseNode)this.createNode(19, operator);
                break;
            }
            case 44: {
                result = (JSParseNode)this.createNode(15, operator);
                break;
            }
            case 52: {
                result = (JSParseNode)this.createNode(25, operator);
                break;
            }
            case 60: {
                result = (JSParseNode)this.createNode(18, operator);
                break;
            }
            case 68: {
                result = (JSParseNode)this.createNode(26, operator);
                break;
            }
            case 62: {
                result = (JSParseNode)this.createNode(29, operator);
                break;
            }
            case 77: {
                result = (JSParseNode)this.createNode(31, operator);
                break;
            }
            case 70: {
                result = (JSParseNode)this.createNode(30, operator);
                break;
            }
            case 55: {
                result = (JSParseNode)this.createNode(23, operator);
                break;
            }
            case 63: {
                result = (JSParseNode)this.createNode(24, operator);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.JSASTHandler_Unknown_operator_0, operator));
            }
        }
        result.appendChild((IParseNode)lhs);
        result.appendChild((IParseNode)rhs);
        return result;
    }

    protected Object onBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        Lexeme rcurly = (Lexeme)nodes[2];
        JSParseNode statements = (JSParseNode)((Object)nodes[1]);
        statements.includeLexemesInRange(lcurly, rcurly);
        return statements;
    }

    protected Object onBreak(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme semicolon = (Lexeme)nodes[1];
        JSParseNode label = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(51, keyword);
        result.appendChild((IParseNode)label);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onBreakLabel(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme identifier = (Lexeme)nodes[1];
        Lexeme semicolon = (Lexeme)nodes[2];
        JSParseNode label = (JSParseNode)this.createNode(64, identifier);
        JSParseNode result = (JSParseNode)this.createNode(51, keyword);
        result.appendChild((IParseNode)label);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onCallExpression(Object[] nodes) {
        JSParseNode expression = (JSParseNode)((Object)nodes[0]);
        JSParseNode arguments = (JSParseNode)((Object)nodes[1]);
        JSParseNode result = (JSParseNode)this.createNode(49, null);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)arguments);
        return result;
    }

    protected Object onCaseClause(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        JSParseNode statements = (JSParseNode)((Object)nodes[3]);
        JSParseNode result = (JSParseNode)this.createNode(57, keyword);
        result.appendChild((IParseNode)expression);
        int i = 0;
        while (i < statements.getChildCount()) {
            result.appendChild(statements.getChild(i));
            ++i;
        }
        return result;
    }

    protected Object onCasesAndDefaultBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        ParseFragment cases = (ParseFragment)nodes[1];
        JSParseNode defaultClause = (JSParseNode)((Object)nodes[2]);
        Lexeme rcurly = (Lexeme)nodes[3];
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)cases);
        result.appendChild((IParseNode)defaultClause);
        result.includeLexemesInRange(lcurly, rcurly);
        return result;
    }

    protected Object onCasesBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        ParseFragment cases = (ParseFragment)nodes[1];
        Lexeme rcurly = (Lexeme)nodes[2];
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)cases);
        result.includeLexemesInRange(lcurly, rcurly);
        return result;
    }

    protected Object onCasesDefaultCasesBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        ParseFragment cases1 = (ParseFragment)nodes[1];
        JSParseNode defaultClause = (JSParseNode)((Object)nodes[2]);
        ParseFragment cases2 = (ParseFragment)nodes[3];
        Lexeme rcurly = (Lexeme)nodes[4];
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)cases1);
        result.appendChild((IParseNode)defaultClause);
        result.appendChild((IParseNode)cases2);
        result.includeLexemesInRange(lcurly, rcurly);
        return result;
    }

    protected Object onCatch(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme identifier = (Lexeme)nodes[2];
        JSParseNode name = (JSParseNode)this.createNode(64, identifier);
        JSParseNode body = (JSParseNode)((Object)nodes[4]);
        JSParseNode result = (JSParseNode)this.createNode(38, keyword);
        result.appendChild((IParseNode)name);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onCommaExpression(Object[] nodes) {
        JSParseNode lhs = (JSParseNode)((Object)nodes[0]);
        JSParseNode rhs = (JSParseNode)((Object)nodes[2]);
        JSParseNode result = (JSParseNode)this.createNode(55, null);
        result.appendChild((IParseNode)lhs);
        result.appendChild((IParseNode)rhs);
        return result;
    }

    protected Object onConditionalExpression(Object[] nodes) {
        JSParseNode condition = (JSParseNode)((Object)nodes[0]);
        JSParseNode trueCase = (JSParseNode)((Object)nodes[2]);
        JSParseNode falseCase = (JSParseNode)((Object)nodes[4]);
        JSParseNode result = (JSParseNode)this.createNode(39, null);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)trueCase);
        result.appendChild((IParseNode)falseCase);
        return result;
    }

    protected Object onContinue(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme semicolon = (Lexeme)nodes[1];
        JSParseNode label = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(52, keyword);
        result.appendChild((IParseNode)label);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onContinueLabel(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme identifier = (Lexeme)nodes[1];
        Lexeme semicolon = (Lexeme)nodes[2];
        JSParseNode label = (JSParseNode)this.createNode(64, identifier);
        JSParseNode result = (JSParseNode)this.createNode(52, keyword);
        result.appendChild((IParseNode)label);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onDefaultAndCasesBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        JSParseNode defaultClause = (JSParseNode)((Object)nodes[1]);
        ParseFragment cases = (ParseFragment)nodes[2];
        Lexeme rcurly = (Lexeme)nodes[3];
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)defaultClause);
        result.appendChild((IParseNode)cases);
        result.includeLexemesInRange(lcurly, rcurly);
        return result;
    }

    protected Object onDefaultBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        JSParseNode defaultClause = (JSParseNode)((Object)nodes[1]);
        Lexeme rcurly = (Lexeme)nodes[2];
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)defaultClause);
        result.includeLexemesInRange(lcurly, rcurly);
        return result;
    }

    protected Object onDefaultClause(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode statements = (JSParseNode)((Object)nodes[2]);
        JSParseNode result = (JSParseNode)this.createNode(56, keyword);
        int i = 0;
        while (i < statements.getChildCount()) {
            result.appendChild(statements.getChild(i));
            ++i;
        }
        return result;
    }

    protected Object onDoStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode body = (JSParseNode)((Object)nodes[1]);
        JSParseNode condition = (JSParseNode)((Object)nodes[4]);
        Lexeme semicolon = (Lexeme)nodes[5];
        JSParseNode result = (JSParseNode)this.createNode(42, keyword);
        result.appendChild((IParseNode)body);
        result.appendChild((IParseNode)condition);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onElidedArray(Object[] nodes) {
        Lexeme lbracket = (Lexeme)nodes[0];
        ParseFragment elisions = (ParseFragment)nodes[1];
        Lexeme rbracket = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(54, lbracket);
        result.appendChild((IParseNode)elisions);
        result.includeLexemeInRange(rbracket);
        return result;
    }

    protected Object onEmptyArguments(Object[] nodes) {
        Lexeme lparen = (Lexeme)nodes[0];
        Lexeme rparen = (Lexeme)nodes[1];
        JSParseNode result = (JSParseNode)this.createNode(53, lparen);
        result.includeLexemeInRange(rparen);
        return result;
    }

    protected Object onEmptyArray(Object[] nodes) {
        Lexeme lbracket = (Lexeme)nodes[0];
        Lexeme rbracket = (Lexeme)nodes[1];
        JSParseNode result = (JSParseNode)this.createNode(54, lbracket);
        result.includeLexemeInRange(rbracket);
        return result;
    }

    protected Object onEmptyBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        Lexeme rcurly = (Lexeme)nodes[1];
        JSParseNode result = (JSParseNode)this.createNode(61, lcurly);
        result.includeLexemeInRange(rcurly);
        return result;
    }

    protected Object onEmptyCaseBlock(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        Lexeme rcurly = (Lexeme)nodes[1];
        ParseFragment result = new ParseFragment();
        result.includeLexemesInRange(lcurly, rcurly);
        return result;
    }

    protected Object onEmptyCaseClause(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        Lexeme colon = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(57, keyword);
        result.appendChild((IParseNode)expression);
        result.includeLexemeInRange(colon);
        return result;
    }

    protected Object onEmptyDefaultClause(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme colon = (Lexeme)nodes[1];
        JSParseNode result = (JSParseNode)this.createNode(56, keyword);
        result.includeLexemeInRange(colon);
        return result;
    }

    protected Object onEmptyFunctionBody(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        Lexeme rcurly = (Lexeme)nodes[1];
        JSParseNode result = (JSParseNode)this.createNode(61, lcurly);
        result.includeLexemeInRange(rcurly);
        return result;
    }

    protected Object onEmptyObject(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        Lexeme rcurly = (Lexeme)nodes[1];
        JSParseNode result = (JSParseNode)this.createNode(59, lcurly);
        result.includeLexemeInRange(rcurly);
        return result;
    }

    protected Object onEmptyParameterList(Object[] nodes) {
        Lexeme lparen = (Lexeme)nodes[0];
        Lexeme rparen = (Lexeme)nodes[1];
        JSParseNode params = (JSParseNode)this.createNode(43, lparen);
        params.includeLexemeInRange(rparen);
        return params;
    }

    protected Object onEmptyStatement(Object[] nodes) {
        Lexeme semicolon = (Lexeme)nodes[0];
        JSParseNode result = (JSParseNode)this.createNode(43, semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onExpressionStatement(Object[] nodes) {
        JSParseNode expression = (JSParseNode)((Object)nodes[0]);
        Lexeme semicolon = (Lexeme)nodes[1];
        expression.includeLexemeInRange(semicolon);
        expression.setIncludesSemicolon(true);
        return expression;
    }

    protected Object onFalse(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(63, keyword);
    }

    protected Object onFinally(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode body = (JSParseNode)((Object)nodes[1]);
        JSParseNode result = (JSParseNode)this.createNode(44, keyword);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onFirstArgument(Object[] nodes) {
        JSParseNode argument = (JSParseNode)((Object)nodes[0]);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)argument);
        return result;
    }

    protected Object onFirstCaseClause(Object[] nodes) {
        JSParseNode clause = (JSParseNode)((Object)nodes[0]);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)clause);
        return result;
    }

    protected Object onFirstElement(Object[] nodes) {
        JSParseNode element = (JSParseNode)((Object)nodes[0]);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)element);
        return result;
    }

    protected Object onFirstElidedElement(Object[] nodes) {
        ParseFragment elisions = (ParseFragment)nodes[0];
        JSParseNode element = (JSParseNode)((Object)nodes[1]);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)elisions);
        result.appendChild((IParseNode)element);
        return result;
    }

    protected Object onFirstElision(Object[] nodes) {
        JSParseNode nullNode = (JSParseNode)this.createNode(65, null);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)nullNode);
        return result;
    }

    protected Object onFirstParameter(Object[] nodes) {
        Lexeme name = (Lexeme)nodes[0];
        JSParseNode identifier = (JSParseNode)this.createNode(64, name);
        JSParseNode parameters = (JSParseNode)this.createNode(60, name);
        parameters.appendChild((IParseNode)identifier);
        return parameters;
    }

    protected Object onFirstProperty(Object[] nodes) {
        Lexeme identifier = (Lexeme)nodes[0];
        JSParseNode name = (JSParseNode)this.createNode(64, identifier);
        JSParseNode value = (JSParseNode)((Object)nodes[2]);
        JSParseNode property = (JSParseNode)this.createNode(70, null);
        property.appendChild((IParseNode)name);
        property.appendChild((IParseNode)value);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)property);
        return result;
    }

    protected Object onFirstSourceElement(Object[] nodes) {
        ParseFragment fragment = new ParseFragment();
        JSParseNode element = (JSParseNode)((Object)nodes[0]);
        fragment.appendChild((IParseNode)element);
        return fragment;
    }

    protected Object onFirstStatement(Object[] nodes) {
        JSParseNode statement = (JSParseNode)((Object)nodes[0]);
        JSParseNode result = (JSParseNode)this.createNode(61, null);
        result.appendChild((IParseNode)statement);
        return result;
    }

    protected Object onFirstVarDeclaration(Object[] nodes) {
        JSParseNode declaration = (JSParseNode)((Object)nodes[0]);
        ParseFragment result = new ParseFragment();
        result.appendChild((IParseNode)declaration);
        return result;
    }

    protected Object onForAdvanceOnlyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)this.createNode(43, null);
        JSParseNode condition = (JSParseNode)this.createNode(43, null);
        JSParseNode advance = (JSParseNode)((Object)nodes[4]);
        JSParseNode body = (JSParseNode)((Object)nodes[6]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForBodyOnlyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)this.createNode(43, null);
        JSParseNode condition = (JSParseNode)this.createNode(43, null);
        JSParseNode advance = (JSParseNode)this.createNode(43, null);
        JSParseNode body = (JSParseNode)((Object)nodes[5]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForConditionOnlyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)this.createNode(43, null);
        JSParseNode condition = (JSParseNode)((Object)nodes[3]);
        JSParseNode advance = (JSParseNode)this.createNode(43, null);
        JSParseNode body = (JSParseNode)((Object)nodes[6]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForInitializeOnlyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)((Object)nodes[2]);
        JSParseNode condition = (JSParseNode)this.createNode(43, null);
        JSParseNode advance = (JSParseNode)this.createNode(43, null);
        JSParseNode body = (JSParseNode)((Object)nodes[6]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForInStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)((Object)nodes[2]);
        JSParseNode object = (JSParseNode)((Object)nodes[4]);
        JSParseNode body = (JSParseNode)((Object)nodes[6]);
        JSParseNode result = (JSParseNode)this.createNode(45, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)object);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForNoAdvanceStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)((Object)nodes[2]);
        JSParseNode condition = (JSParseNode)((Object)nodes[4]);
        JSParseNode advance = (JSParseNode)this.createNode(43, null);
        JSParseNode body = (JSParseNode)((Object)nodes[7]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForNoConditionStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)((Object)nodes[2]);
        JSParseNode condition = (JSParseNode)this.createNode(43, null);
        JSParseNode advance = (JSParseNode)((Object)nodes[5]);
        JSParseNode body = (JSParseNode)((Object)nodes[7]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForNoInitializeStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)this.createNode(43, null);
        JSParseNode condition = (JSParseNode)((Object)nodes[3]);
        JSParseNode advance = (JSParseNode)((Object)nodes[5]);
        JSParseNode body = (JSParseNode)((Object)nodes[7]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode initialize = (JSParseNode)((Object)nodes[2]);
        JSParseNode condition = (JSParseNode)((Object)nodes[4]);
        JSParseNode advance = (JSParseNode)((Object)nodes[6]);
        JSParseNode body = (JSParseNode)((Object)nodes[8]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForVarInitializeOnlyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        ParseFragment declarations = (ParseFragment)nodes[3];
        JSParseNode initialize = (JSParseNode)this.createNode(62, null);
        initialize.appendChild((IParseNode)declarations);
        JSParseNode condition = (JSParseNode)this.createNode(43, null);
        JSParseNode advance = (JSParseNode)this.createNode(43, null);
        JSParseNode body = (JSParseNode)((Object)nodes[7]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForVarInStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        ParseFragment declarations = (ParseFragment)nodes[3];
        JSParseNode initialize = (JSParseNode)this.createNode(62, null);
        initialize.appendChild((IParseNode)declarations);
        JSParseNode object = (JSParseNode)((Object)nodes[5]);
        JSParseNode body = (JSParseNode)((Object)nodes[7]);
        JSParseNode result = (JSParseNode)this.createNode(45, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)object);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForVarNoAdvanceStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        ParseFragment declarations = (ParseFragment)nodes[3];
        JSParseNode initialize = (JSParseNode)this.createNode(62, null);
        initialize.appendChild((IParseNode)declarations);
        JSParseNode condition = (JSParseNode)((Object)nodes[5]);
        JSParseNode advance = (JSParseNode)this.createNode(43, null);
        JSParseNode body = (JSParseNode)((Object)nodes[8]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForVarNoConditionStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        ParseFragment declarations = (ParseFragment)nodes[3];
        JSParseNode initialize = (JSParseNode)this.createNode(62, null);
        initialize.appendChild((IParseNode)declarations);
        JSParseNode condition = (JSParseNode)this.createNode(43, null);
        JSParseNode advance = (JSParseNode)((Object)nodes[6]);
        JSParseNode body = (JSParseNode)((Object)nodes[8]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onForVarStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        ParseFragment declarations = (ParseFragment)nodes[3];
        JSParseNode initialize = (JSParseNode)this.createNode(62, null);
        initialize.appendChild((IParseNode)declarations);
        JSParseNode condition = (JSParseNode)((Object)nodes[5]);
        JSParseNode advance = (JSParseNode)((Object)nodes[7]);
        JSParseNode body = (JSParseNode)((Object)nodes[9]);
        JSParseNode result = (JSParseNode)this.createNode(46, keyword);
        result.appendChild((IParseNode)initialize);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)advance);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onFunctionBody(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        ParseFragment statements = (ParseFragment)nodes[1];
        Lexeme rcurly = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(61, lcurly);
        result.appendChild((IParseNode)statements);
        result.includeLexemeInRange(rcurly);
        return result;
    }

    protected Object onFunctionDeclaration(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme name = (Lexeme)nodes[1];
        JSParseNode params = (JSParseNode)((Object)nodes[2]);
        JSParseNode body = (JSParseNode)((Object)nodes[3]);
        JSFunctionNode result = (JSFunctionNode)this.createNode(47, keyword);
        result.appendChild((IParseNode)params);
        result.appendChild((IParseNode)body);
        result.setAttribute("name", name.getText());
        return result;
    }

    protected Object onFunctionExpression(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode params = (JSParseNode)((Object)nodes[1]);
        JSParseNode body = (JSParseNode)((Object)nodes[2]);
        JSFunctionNode result = (JSFunctionNode)this.createNode(47, keyword);
        result.appendChild((IParseNode)params);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onGetElement(Object[] nodes) {
        JSParseNode expression = (JSParseNode)((Object)nodes[0]);
        Lexeme lbrace = (Lexeme)nodes[1];
        JSParseNode indexExpression = (JSParseNode)((Object)nodes[2]);
        Lexeme rbrace = (Lexeme)nodes[3];
        JSParseNode result = (JSParseNode)this.createNode(13, lbrace);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)indexExpression);
        result.includeLexemeInRange(rbrace);
        return result;
    }

    protected Object onGetProperty(Object[] nodes) {
        JSParseNode expression = (JSParseNode)((Object)nodes[0]);
        Lexeme dot = (Lexeme)nodes[1];
        Lexeme identifier = (Lexeme)nodes[2];
        JSParseNode name = (JSParseNode)this.createNode(64, identifier);
        JSParseNode result = (JSParseNode)this.createNode(14, dot);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)name);
        return result;
    }

    protected Object onGroupExpression(Object[] nodes) {
        Lexeme lparen = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        Lexeme rparen = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(74, lparen);
        result.appendChild((IParseNode)expression);
        result.includeLexemeInRange(rparen);
        return result;
    }

    protected Object onIdentifier(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(64, keyword);
    }

    protected Object onIfElseStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode condition = (JSParseNode)((Object)nodes[2]);
        JSParseNode trueCase = (JSParseNode)((Object)nodes[4]);
        JSParseNode falseCase = (JSParseNode)((Object)nodes[6]);
        JSParseNode result = (JSParseNode)this.createNode(48, keyword);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)trueCase);
        result.appendChild((IParseNode)falseCase);
        return result;
    }

    protected Object onIfStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode condition = (JSParseNode)((Object)nodes[2]);
        JSParseNode trueCase = (JSParseNode)((Object)nodes[4]);
        JSParseNode falseCase = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(48, keyword);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)trueCase);
        result.appendChild((IParseNode)falseCase);
        return result;
    }

    protected Object onLabelledStatement(Object[] nodes) {
        Lexeme identifier = (Lexeme)nodes[0];
        JSParseNode label = (JSParseNode)this.createNode(64, identifier);
        JSParseNode statement = (JSParseNode)((Object)nodes[2]);
        JSParseNode result = (JSParseNode)this.createNode(50, null);
        result.appendChild((IParseNode)label);
        result.appendChild((IParseNode)statement);
        return result;
    }

    protected Object onNewExpression(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        JSParseNode arguments = (JSParseNode)((Object)nodes[2]);
        JSParseNode result = (JSParseNode)this.createNode(40, keyword);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)arguments);
        return result;
    }

    protected Object onNewExpressionWithoutArguments(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        JSParseNode arguments = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(40, keyword);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)arguments);
        return result;
    }

    protected Object onNull(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(65, keyword);
    }

    protected Object onNumber(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(66, keyword);
    }

    protected Object onObjectLiteral(Object[] nodes) {
        Lexeme lcurly = (Lexeme)nodes[0];
        ParseFragment properties = (ParseFragment)nodes[1];
        Lexeme rcurly = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(59, lcurly);
        result.appendChild((IParseNode)properties);
        result.includeLexemeInRange(rcurly);
        return result;
    }

    protected Object onParameterList(Object[] nodes) {
        Lexeme lparen = (Lexeme)nodes[0];
        JSParseNode params = (JSParseNode)((Object)nodes[1]);
        Lexeme rparen = (Lexeme)nodes[2];
        params.includeLexemeInRange(lparen);
        params.includeLexemeInRange(rparen);
        return params;
    }

    protected Object onPostfixExpression(Object[] nodes) {
        JSParseNode result;
        JSParseNode expression = (JSParseNode)((Object)nodes[0]);
        Lexeme operator = (Lexeme)nodes[1];
        switch (operator.typeIndex) {
            case 69: {
                result = (JSParseNode)this.createNode(80, operator);
                break;
            }
            case 76: {
                result = (JSParseNode)this.createNode(79, operator);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.JSASTHandler_Unknown_operator_0, operator));
            }
        }
        result.appendChild((IParseNode)expression);
        return result;
    }

    protected Object onRegex(Object[] nodes) {
        Lexeme regex = (Lexeme)nodes[0];
        JSParseNode result = (JSParseNode)this.createNode(67, regex);
        return result;
    }

    protected Object onReturn(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        Lexeme semicolon = (Lexeme)nodes[1];
        JSParseNode expression = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(83, keyword);
        result.appendChild((IParseNode)expression);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onReturnValue(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        Lexeme semicolon = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(83, keyword);
        result.appendChild((IParseNode)expression);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onString(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(68, keyword);
    }

    protected Object onSwitchStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[2]);
        ParseFragment clauses = (ParseFragment)nodes[4];
        JSParseNode result = (JSParseNode)this.createNode(58, keyword);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)clauses);
        return result;
    }

    protected Object onThis(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(71, keyword);
    }

    protected Object onThrowStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        Lexeme semicolon = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(84, keyword);
        result.appendChild((IParseNode)expression);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onTrue(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        return this.createNode(69, keyword);
    }

    protected Object onTryCatchFinallyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode body = (JSParseNode)((Object)nodes[1]);
        JSParseNode catchNode = (JSParseNode)((Object)nodes[2]);
        JSParseNode finallyNode = (JSParseNode)((Object)nodes[3]);
        JSParseNode result = (JSParseNode)this.createNode(72, keyword);
        result.appendChild((IParseNode)body);
        result.appendChild((IParseNode)catchNode);
        result.appendChild((IParseNode)finallyNode);
        return result;
    }

    protected Object onTryCatchStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode body = (JSParseNode)((Object)nodes[1]);
        JSParseNode catchNode = (JSParseNode)((Object)nodes[2]);
        JSParseNode finallyNode = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(72, keyword);
        result.appendChild((IParseNode)body);
        result.appendChild((IParseNode)catchNode);
        result.appendChild((IParseNode)finallyNode);
        return result;
    }

    protected Object onTryFinallyStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode body = (JSParseNode)((Object)nodes[1]);
        JSParseNode catchNode = (JSParseNode)this.createNode(43, null);
        JSParseNode finallyNode = (JSParseNode)((Object)nodes[2]);
        JSParseNode result = (JSParseNode)this.createNode(72, keyword);
        result.appendChild((IParseNode)body);
        result.appendChild((IParseNode)catchNode);
        result.appendChild((IParseNode)finallyNode);
        return result;
    }

    protected Object onUnaryExpression(Object[] nodes) {
        JSParseNode result;
        Lexeme operator = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[1]);
        switch (operator.typeIndex) {
            case 14: {
                result = (JSParseNode)this.createNode(73, operator);
                break;
            }
            case 39: {
                result = (JSParseNode)this.createNode(75, operator);
                break;
            }
            case 45: {
                result = (JSParseNode)this.createNode(77, operator);
                break;
            }
            case 76: {
                result = (JSParseNode)this.createNode(81, operator);
                break;
            }
            case 37: {
                result = (JSParseNode)this.createNode(78, operator);
                break;
            }
            case 69: {
                result = (JSParseNode)this.createNode(82, operator);
                break;
            }
            case 47: {
                result = (JSParseNode)this.createNode(76, operator);
                break;
            }
            case 29: {
                result = (JSParseNode)this.createNode(85, operator);
                break;
            }
            case 31: {
                result = (JSParseNode)this.createNode(86, operator);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.JSASTHandler_Unknown_operator_0, operator));
            }
        }
        result.appendChild((IParseNode)expression);
        return result;
    }

    protected Object onVarDeclaration(Object[] nodes) {
        Lexeme identifier = (Lexeme)nodes[0];
        JSParseNode id = (JSParseNode)this.createNode(64, identifier);
        JSParseNode assignment = (JSParseNode)this.createNode(43, null);
        JSParseNode result = (JSParseNode)this.createNode(41, null);
        result.appendChild((IParseNode)id);
        result.appendChild((IParseNode)assignment);
        return result;
    }

    protected Object onVarDeclarationAssignment(Object[] nodes) {
        Lexeme identifier = (Lexeme)nodes[0];
        JSParseNode id = (JSParseNode)this.createNode(64, identifier);
        JSParseNode assignment = (JSParseNode)((Object)nodes[2]);
        JSParseNode result = (JSParseNode)this.createNode(41, null);
        result.appendChild((IParseNode)id);
        result.appendChild((IParseNode)assignment);
        return result;
    }

    protected Object onVarStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        ParseFragment declarations = (ParseFragment)nodes[1];
        Lexeme semicolon = (Lexeme)nodes[2];
        JSParseNode result = (JSParseNode)this.createNode(62, keyword);
        result.appendChild((IParseNode)declarations);
        result.includeLexemeInRange(semicolon);
        result.setIncludesSemicolon(true);
        return result;
    }

    protected Object onWhileStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode condition = (JSParseNode)((Object)nodes[2]);
        JSParseNode body = (JSParseNode)((Object)nodes[4]);
        JSParseNode result = (JSParseNode)this.createNode(87, keyword);
        result.appendChild((IParseNode)condition);
        result.appendChild((IParseNode)body);
        return result;
    }

    protected Object onWithStatement(Object[] nodes) {
        Lexeme keyword = (Lexeme)nodes[0];
        JSParseNode expression = (JSParseNode)((Object)nodes[2]);
        JSParseNode body = (JSParseNode)((Object)nodes[4]);
        JSParseNode result = (JSParseNode)this.createNode(88, keyword);
        result.appendChild((IParseNode)expression);
        result.appendChild((IParseNode)body);
        return result;
    }
}

