/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.epl;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenWithMenu(IWorkbenchPage page, IAdaptable file) {
        super(ID);
        this.page = page;
        this.file = file;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        IFileStore file = this.getFileResource();
        if (file == null) {
            return null;
        }
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(file.getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(file.getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(descriptor, false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createOtherMenuItem(final Menu menu) {
        final IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        new MenuItem(menu, 2);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(IDEWorkbenchMessages.OpenWithMenu_Other);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        IEditorDescriptor editor;
                        EditorSelectionDialog dialog = new EditorSelectionDialog(menu.getShell());
                        dialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.OpenWithMenu_OtherDialogDescription, (Object)file.getName()));
                        if (dialog.open() != 0 || (editor = dialog.getSelectedEditor()) == null) break;
                        OpenWithMenu.this.openEditor(editor, editor.isOpenExternal());
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = null;
        try {
            preferredEditor = IDE.getEditorDescriptor((String)file.getName());
        }
        catch (PartInitException partInitException) {}
        IContentType finalType = null;
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                IContentType type = iContentTypeArray[n2];
                if (finalType != null) break;
                try {
                    String settings;
                    String[] stringArray = type.getSettings(null).getFileSpecs(4);
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        settings = stringArray[n4];
                        if (settings.equals(file.getName())) {
                            finalType = type;
                            break;
                        }
                        ++n4;
                    }
                    if (finalType != null) break block16;
                    stringArray = type.getSettings(null).getFileSpecs(8);
                    n3 = stringArray.length;
                    n4 = 0;
                    while (n4 < n3) {
                        settings = stringArray[n4];
                        if (settings.equals(OpenWithMenu.getExtension(file.getName()))) {
                            finalType = type;
                            break;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        IEditorDescriptor[] editors = this.registry.getEditors(file.getName(), finalType);
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        descriptor = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        if (descriptor != null) {
            this.createMenuItem(menu, descriptor, preferredEditor);
        }
        this.createOtherMenuItem(menu);
    }

    private IFileStore getFileResource() {
        File file;
        IFileStore fileStore = (IFileStore)this.file.getAdapter(IFileStore.class);
        if (fileStore == null && (file = (File)this.file.getAdapter(File.class)) != null) {
            fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        }
        return fileStore;
    }

    public boolean isDynamic() {
        return true;
    }

    protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
        IFileStore file = this.getFileResource();
        if (file == null) {
            return;
        }
        try {
            if (openUsingDescriptor) {
                ((WorkbenchPage)this.page).openEditorFromDescriptor(OpenWithMenu.getEditorInput(file), editorDescriptor, true, null);
            } else {
                String editorId = editorDescriptor == null ? "org.eclipse.ui.systemExternalEditor" : editorDescriptor.getId();
                ((WorkbenchPage)this.page).openEditor(OpenWithMenu.getEditorInput(file), editorId, true, 3);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenWithMenu_dialogTitle, (String)e.getMessage(), (PartInitException)e);
        }
    }

    public static String getExtension(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        if (index == fileName.length()) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    private static IEditorInput getEditorInput(IFileStore fileStore) {
        return new FileStoreEditorInput(fileStore);
    }
}

