/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.launchConfigurations;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.HttpServerLaunchConfiguration;
import com.aptana.ide.server.ui.launchConfigurations.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class LaunchBrowserSettingsTab
extends AbstractLaunchConfigurationTab {
    private HttpServerLaunchConfiguration launchConfiguration = new HttpServerLaunchConfiguration();
    private Text fBrowserExeText;
    private Button bBrowserExeBrowse;
    private Button rbCurrentPage;
    private Button rbSpecificPage;
    private Button bSpecificPageBrowse;
    private Text fSpecificPageText;
    private Button rbStartUrl;
    private Text fStartUrlText;
    private Text fbaseUrlText;
    private Button rbInternalServer;
    private Button rbCustomServer;
    private Label baseUrlLabel;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 5;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createBrowserExeControl(comp);
        this.createStartActionControl(comp);
        this.createServerControl(comp);
    }

    public void createBrowserExeControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_LBL_BrowserGroup);
        group.setFont(font);
        GridData gd = new GridData(4, 20, true, false);
        group.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        group.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 120;
        Label browserExeLabel = new Label((Composite)group, 0);
        browserExeLabel.setText(StringUtils.makeFormLabel((String)Messages.LaunchBrowserSettingsTab_LBL_BrowserExe));
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        browserExeLabel.setLayoutData((Object)data);
        this.bBrowserExeBrowse = new Button((Composite)group, 8);
        this.bBrowserExeBrowse.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        data = new FormData();
        data.top = new FormAttachment((Control)browserExeLabel, -1, 128);
        data.right = new FormAttachment(100, 0);
        this.bBrowserExeBrowse.setLayoutData((Object)data);
        this.fBrowserExeText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)browserExeLabel, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment((Control)this.bBrowserExeBrowse, -5, 16384);
        this.fBrowserExeText.setLayoutData((Object)data);
        this.bBrowserExeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(LaunchBrowserSettingsTab.this.getShell(), 0);
                fileDialog.setFileName(LaunchBrowserSettingsTab.this.fBrowserExeText.getText());
                String text = fileDialog.open();
                if (text != null) {
                    LaunchBrowserSettingsTab.this.fBrowserExeText.setText(text);
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LaunchBrowserSettingsTab.this.setDirty(true);
                LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.fBrowserExeText.addListener(24, listener);
    }

    public void createStartActionControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_LBL_Start);
        group.setFont(font);
        GridData gd = new GridData(4, 20, true, false);
        group.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        group.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 120;
        this.rbCurrentPage = new Button((Composite)group, 16);
        this.rbCurrentPage.setText(Messages.LaunchBrowserSettingsTab_LBL_UseCurrent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        this.rbCurrentPage.setLayoutData((Object)data);
        this.rbSpecificPage = new Button((Composite)group, 16);
        this.rbSpecificPage.setText(StringUtils.makeFormLabel((String)Messages.LaunchBrowserSettingsTab_LBL_SpecificPage));
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbCurrentPage, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.rbSpecificPage.setLayoutData((Object)data);
        this.bSpecificPageBrowse = new Button((Composite)group, 8);
        this.bSpecificPageBrowse.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbSpecificPage, -1, 128);
        data.right = new FormAttachment(100, 0);
        this.bSpecificPageBrowse.setLayoutData((Object)data);
        this.fSpecificPageText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbSpecificPage, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment((Control)this.bSpecificPageBrowse, -5, 16384);
        this.fSpecificPageText.setLayoutData((Object)data);
        this.rbStartUrl = new Button((Composite)group, 16);
        this.rbStartUrl.setText(StringUtils.makeFormLabel((String)Messages.LaunchBrowserSettingsTab_LBL_StartURL));
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbSpecificPage, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.rbStartUrl.setLayoutData((Object)data);
        this.fStartUrlText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbStartUrl, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment(100, 0);
        this.fStartUrlText.setLayoutData((Object)data);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LaunchBrowserSettingsTab.this.setDirty(true);
                LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
                LaunchBrowserSettingsTab.this.fStartUrlText.setEnabled(LaunchBrowserSettingsTab.this.rbStartUrl.getSelection());
                LaunchBrowserSettingsTab.this.fSpecificPageText.setEnabled(LaunchBrowserSettingsTab.this.rbSpecificPage.getSelection());
                LaunchBrowserSettingsTab.this.bSpecificPageBrowse.setEnabled(LaunchBrowserSettingsTab.this.rbSpecificPage.getSelection());
            }
        };
        this.rbCurrentPage.addListener(13, listener);
        this.rbSpecificPage.addListener(13, listener);
        this.fSpecificPageText.addListener(24, listener);
        this.rbStartUrl.addListener(13, listener);
        this.fStartUrlText.addListener(24, listener);
        this.bSpecificPageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = LaunchBrowserSettingsTab.this.chooseWorkspaceLocation();
                if (resource != null) {
                    LaunchBrowserSettingsTab.this.fSpecificPageText.setText(resource.getFullPath().toPortableString());
                }
            }
        });
    }

    public void createServerControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0x800000);
        group.setText(Messages.LaunchBrowserSettingsTab_LBL_Server);
        group.setFont(font);
        GridData gd = new GridData(4, 20, true, false);
        group.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        group.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column3Offset = 120;
        this.rbInternalServer = new Button((Composite)group, 16);
        this.rbInternalServer.setText(Messages.LaunchBrowserSettingsTab_LBL_InternalServer);
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        this.rbInternalServer.setLayoutData((Object)data);
        this.rbCustomServer = new Button((Composite)group, 16);
        this.rbCustomServer.setText(Messages.LaunchBrowserSettingsTab_LBL_ExternalServer);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbInternalServer, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.rbCustomServer.setLayoutData((Object)data);
        this.fbaseUrlText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbCustomServer, 10, 1024);
        data.left = new FormAttachment(0, column3Offset);
        data.right = new FormAttachment(100, 0);
        this.fbaseUrlText.setLayoutData((Object)data);
        this.baseUrlLabel = new Label((Composite)group, 0);
        this.baseUrlLabel.setText(StringUtils.makeFormLabel((String)Messages.LaunchBrowserSettingsTab_LBL_BaseURL));
        this.baseUrlLabel.setAlignment(131072);
        data = new FormData();
        data.right = new FormAttachment((Control)this.fbaseUrlText, -8, 16384);
        data.top = new FormAttachment((Control)this.fbaseUrlText, 0, 128);
        this.baseUrlLabel.setLayoutData((Object)data);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LaunchBrowserSettingsTab.this.setDirty(true);
                LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
                boolean customServerEnabled = LaunchBrowserSettingsTab.this.rbCustomServer.getSelection();
                LaunchBrowserSettingsTab.this.baseUrlLabel.setEnabled(customServerEnabled);
                LaunchBrowserSettingsTab.this.fbaseUrlText.setEnabled(customServerEnabled);
            }
        };
        this.rbCustomServer.addListener(13, listener);
        this.rbInternalServer.addListener(13, listener);
        this.fbaseUrlText.addListener(24, listener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        HttpServerLaunchConfiguration httpConfig = new HttpServerLaunchConfiguration();
        httpConfig.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration.load(configuration);
        this.fBrowserExeText.setText(this.launchConfiguration.getBrowserExe());
        this.rbCurrentPage.setSelection(this.launchConfiguration.getStartActionType() == 1);
        this.rbSpecificPage.setSelection(this.launchConfiguration.getStartActionType() == 2);
        this.rbStartUrl.setSelection(this.launchConfiguration.getStartActionType() == 3);
        this.fSpecificPageText.setText(this.launchConfiguration.getStartPagePath());
        this.fStartUrlText.setText(this.launchConfiguration.getStartPageUrl());
        this.rbInternalServer.setSelection(this.launchConfiguration.getServerType() == 4);
        this.rbCustomServer.setSelection(this.launchConfiguration.getServerType() == 5);
        this.fbaseUrlText.setText(this.launchConfiguration.getExternalBaseUrl());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfiguration.setBrowserExe(this.fBrowserExeText.getText());
        if (this.rbCurrentPage.getSelection()) {
            this.launchConfiguration.setStartActionType(1);
        } else if (this.rbSpecificPage.getSelection()) {
            this.launchConfiguration.setStartActionType(2);
        } else if (this.rbStartUrl.getSelection()) {
            this.launchConfiguration.setStartActionType(3);
        }
        this.launchConfiguration.setStartPagePath(this.fSpecificPageText.getText());
        this.launchConfiguration.setStartPageUrl(this.fStartUrlText.getText());
        if (this.rbInternalServer.getSelection()) {
            this.launchConfiguration.setServerType(4);
        } else if (this.rbCustomServer.getSelection()) {
            this.launchConfiguration.setServerType(5);
        }
        this.launchConfiguration.setExternalBaseUrl(this.fbaseUrlText.getText());
        this.launchConfiguration.save(configuration);
    }

    public String getName() {
        return Messages.LaunchBrowserSettingsTab_Name;
    }

    private IResource chooseWorkspaceLocation() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setMessage(Messages.LaunchBrowserSettingsTab_File_Title);
        dialog.open();
        Object result = dialog.getFirstResult();
        return (IResource)result;
    }
}

