/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui;

import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IModuleType;
import com.aptana.ide.server.core.IPublishOperation;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerImagesRegistry {
    private static ServerImagesRegistry instance;
    private HashMap<String, Element> serverImages = new HashMap();
    private HashMap<String, Element> moduleImages = new HashMap();
    private HashMap<String, Element> serverTypeImages = new HashMap();
    private HashMap<String, Element> operationImages = new HashMap();

    private ServerImagesRegistry() {
        this.load();
    }

    public static ServerImagesRegistry getInstance() {
        if (instance == null) {
            instance = new ServerImagesRegistry();
        }
        return instance;
    }

    void onDispose() {
        this.disposeMap(this.serverImages);
        this.disposeMap(this.moduleImages);
        this.disposeMap(this.serverTypeImages);
        this.disposeMap(this.operationImages);
    }

    private void disposeMap(HashMap<String, Element> serverImages2) {
        for (Element name : serverImages2.values()) {
            if (name.image == null || name.image.isDisposed()) continue;
            name.image.dispose();
        }
    }

    void load() {
        IConfigurationElement[] configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("com.aptana.ide.server.ui.serverImages");
        int a = 0;
        while (a < configurationElementsFor.length) {
            String name = configurationElementsFor[a].getName();
            Element element = new Element(configurationElementsFor[a]);
            if (name.equals("serverImage")) {
                this.serverImages.put(element.getId(), element);
            }
            if (name.equals("moduleImage")) {
                this.moduleImages.put(element.getId(), element);
            }
            if (name.equals("serverTypeImage")) {
                this.serverTypeImages.put(element.getId(), element);
            }
            if (name.equals("publishOperationImage")) {
                this.operationImages.put(element.getId(), element);
            }
            ++a;
        }
    }

    public ImageDescriptor getDescriptor(Object element) {
        if (element instanceof IPublishOperation) {
            IPublishOperation pop = (IPublishOperation)element;
            Element element2 = this.operationImages.get(pop.getId());
            if (element2 == null) {
                return null;
            }
            return element2.getImageDescriptor();
        }
        if (element instanceof IServerType) {
            IServerType pop = (IServerType)element;
            Element element2 = this.serverTypeImages.get(pop.getId());
            if (element2 == null) {
                return null;
            }
            return element2.getImageDescriptor();
        }
        if (element instanceof IModuleType) {
            IModuleType pop = (IModuleType)element;
            Element element2 = this.moduleImages.get(pop.getId());
            if (element2 == null) {
                return null;
            }
            return element2.getImageDescriptor();
        }
        if (element instanceof IModule) {
            IModule pop = (IModule)element;
            return this.getDescriptor(pop.getType());
        }
        if (element instanceof IServer) {
            IServer pop = (IServer)element;
            Element element2 = this.serverImages.get(pop.getServerType().getId());
            if (element2 == null) {
                return this.getDescriptor(pop.getServerType());
            }
            return element2.getImageDescriptor();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IPublishOperation) {
            IPublishOperation pop = (IPublishOperation)element;
            Element element2 = this.operationImages.get(pop.getId());
            if (element2 == null) {
                return null;
            }
            return element2.getImage();
        }
        if (element instanceof IServerType) {
            IServerType pop = (IServerType)element;
            Element element2 = this.serverTypeImages.get(pop.getId());
            if (element2 == null) {
                return null;
            }
            return element2.getImage();
        }
        if (element instanceof IModuleType) {
            IModuleType pop = (IModuleType)element;
            Element element2 = this.moduleImages.get(pop.getId());
            if (element2 == null) {
                return null;
            }
            return element2.getImage();
        }
        if (element instanceof IModule) {
            IModule pop = (IModule)element;
            return this.getImage(pop.getType());
        }
        if (element instanceof IServer) {
            IServer pop = (IServer)element;
            Element element2 = this.serverImages.get(pop.getServerType().getId());
            if (element2 == null) {
                return this.getImage(pop.getServerType());
            }
            return element2.getImage();
        }
        return null;
    }

    static class Element {
        final IConfigurationElement item;
        private Image image;

        public Element(IConfigurationElement item) {
            this.item = item;
        }

        public String getId() {
            return this.item.getAttribute("typeId");
        }

        public ImageDescriptor getImageDescriptor() {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.item.getNamespaceIdentifier(), (String)this.item.getAttribute("image"));
        }

        public Image getImage() {
            if ((this.image == null || this.image.isDisposed()) && this.getImageDescriptor() != null) {
                this.image = this.getImageDescriptor().createImage();
            }
            return this.image;
        }
    }
}

