/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.security.internal.linux;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.Base64;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.security.internal.linux.Messages;
import com.aptana.ide.security.internal.linux.StorageLoginDialog;
import com.aptana.ide.security.linux.Activator;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class PasswordProvider
extends org.eclipse.equinox.security.storage.provider.PasswordProvider {
    private static final String ALGORITHM = "AES/ECB/PKCS5Padding";
    private String accountName = System.getProperty("user.home");

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        String password;
        block7: {
            boolean passwordChange;
            boolean newPassword;
            block6: {
                if (this.accountName == null) {
                    return null;
                }
                newPassword = (passwordType & 1) != 0;
                passwordChange = (passwordType & 2) != 0;
                try {
                    char[] existing;
                    if (!newPassword && !passwordChange && (existing = this.getPassword()) != null && existing.length != 0) {
                        return new PBEKeySpec(existing);
                    }
                    if (PasswordProvider.useUI()) break block6;
                    return null;
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            final String[] result = new String[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    StorageLoginDialog loginDialog = new StorageLoginDialog(Display.getDefault().getActiveShell(), newPassword, passwordChange);
                    result[0] = loginDialog.open() == 0 ? loginDialog.getPassword() : null;
                }
            });
            password = result[0];
            if (password != null && password.trim().length() != 0) break block7;
            return null;
        }
        this.writePassword(password);
        return new PBEKeySpec(password.toCharArray());
    }

    private static boolean useUI() {
        return PlatformUI.isWorkbenchRunning();
    }

    private void writePassword(String password) throws IOException {
        SecretKeySpec key = this.getKeySpec();
        byte[] encrypted = this.encrypt(key, password);
        if (encrypted != null && encrypted.length > 0) {
            String b64 = Base64.encodeBytes((byte[])encrypted);
            FileUtils.writeStringToFile((String)b64, (File)this.getPasswordFile());
        }
    }

    private char[] getPassword() throws IOException {
        String encrypted = this.getEncryptedPassword();
        if (encrypted == null) {
            return new char[0];
        }
        byte[] bytes = Base64.decode((String)encrypted);
        if (bytes != null) {
            SecretKeySpec key = this.getKeySpec();
            byte[] decrypted = this.decrypt(key, bytes);
            if (decrypted == null || decrypted.length == 0) {
                return new char[0];
            }
            return new String(decrypted).toCharArray();
        }
        return new char[0];
    }

    private String getEncryptedPassword() throws IOException {
        File file = this.getPasswordFile();
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readContent((File)file);
    }

    private File getPasswordFile() throws IOException {
        File file = new File(String.valueOf(this.accountName) + File.separator + ".aptanasecure", ".store");
        file.getParentFile().mkdirs();
        return file;
    }

    private SecretKeySpec getKeySpec() {
        String ksPref = Platform.getPreferencesService().getString("com.aptana.ide.core", "com.aptana.ide.core.CACHED_KEY", "", null);
        byte[] key = null;
        if (!"".equals(ksPref)) {
            try {
                byte[] bytes = Base64.decode((String)ksPref);
                if (bytes != null) {
                    key = bytes;
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_UnableToDecodeExistingKey, (Throwable)e);
            }
        }
        if (key == null || key.length == 0) {
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey skey = kgen.generateKey();
                key = skey.getEncoded();
                String b64 = Base64.encodeBytes((byte[])skey.getEncoded());
                IEclipsePreferences node = new InstanceScope().getNode("com.aptana.ide.core");
                node.put("com.aptana.ide.core.CACHED_KEY", b64);
                node.flush();
            }
            catch (NoSuchAlgorithmException e) {
                IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_NoSuchAlgorithm, (Throwable)e);
                return null;
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)Messages.PasswordProvider_ERR_UnableToStoreKey, (Throwable)e);
                return null;
            }
        }
        return new SecretKeySpec(key, "AES");
    }

    private byte[] encrypt(SecretKeySpec skeySpec, String password) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, skeySpec);
            return cipher.doFinal(password.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_NoSuchAlgorithm, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_NoSuchPadding, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_InvalidKey, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_IllegalBlockSize, (Throwable)e);
        }
        catch (BadPaddingException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_BadPadding, (Throwable)e);
        }
        return null;
    }

    private byte[] decrypt(SecretKeySpec skeySpec, byte[] encryptedPassword) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, skeySpec);
            return cipher.doFinal(encryptedPassword);
        }
        catch (NoSuchAlgorithmException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_NoSuchAlgorithm, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_NoSuchPadding, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_InvalidKey, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_IllegalBlockSize, (Throwable)e);
        }
        catch (BadPaddingException e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)com.aptana.ide.core.ui.Messages.AptanaAuthenticator_ERR_BadPadding, (Throwable)e);
        }
        return null;
    }
}

