/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.ui;

import com.aptana.ide.update.ui.Messages;
import com.aptana.ide.update.ui.UpdateUIActivator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BrowserDialog
extends TrayDialog {
    private Browser browser;
    private String announceURL;
    private final int height;
    private final int width;
    private Button bTurnOffAllAnnouncements;
    private Button bTurnOffThisAnnouncement;

    public BrowserDialog(Shell parentShell, String announceURL, int height, int width) {
        super(parentShell);
        this.announceURL = announceURL;
        this.height = height;
        this.width = width;
        this.setShellStyle(67680);
        this.setHelpAvailable(false);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BrowserDialog_AnnouncementTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.browser = new Browser(parent, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.width;
        gridData.heightHint = this.height;
        this.browser.setLayoutData((Object)gridData);
        this.browser.setUrl(this.announceURL);
        return this.browser;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        composite.setFont(parent.getFont());
        if (this.isHelpAvailable()) {
            Control helpControl = this.createHelpControl(composite);
            ((GridData)helpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        }
        Composite checkboxComposite = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout2.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout2.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout2.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        checkboxComposite.setLayout((Layout)layout2);
        checkboxComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        checkboxComposite.setFont(parent.getFont());
        this.bTurnOffThisAnnouncement = new Button(checkboxComposite, 32);
        this.bTurnOffThisAnnouncement.setText(Messages.BrowserDialog_Label_DoNotShowThisAnnouncementAgain);
        new Label(checkboxComposite, 0);
        this.bTurnOffAllAnnouncements = new Button(checkboxComposite, 32);
        this.bTurnOffAllAnnouncements.setText(Messages.BrowserDialog_Label_DoNotShowAllAnnouncements);
        Button okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        GridData okGridData = (GridData)okButton.getLayoutData();
        okGridData.grabExcessVerticalSpace = false;
        okGridData.horizontalSpan = 2;
        okGridData.verticalAlignment = 0x1000008;
        okGridData.horizontalAlignment = 0x1000008;
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IPreferenceStore prefs = UpdateUIActivator.getDefault().getPreferenceStore();
            prefs.setValue("com.aptana.ide.update.ui.NEVER_SHOW_THIS_ANNOUNCEMENT", this.bTurnOffThisAnnouncement.getSelection());
            prefs.setValue("com.aptana.ide.update.ui.NEVER_SHOW_ANNOUNCEMENTS", this.bTurnOffAllAnnouncements.getSelection());
        }
        super.buttonPressed(buttonId);
    }
}

