/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Cons;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.LazySeq;
import clojure.lang.RT;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import clojure.lang.Streamable;

public final class Stream
implements Seqable,
Streamable,
Sequential {
    static final ISeq NO_SEQ = new Cons(null, null);
    ISeq seq = NO_SEQ;
    final IFn src;
    final IFn xform;
    Cons pushed = null;
    IFn tap = null;

    public Stream(IFn src) {
        this.src = src;
        this.xform = null;
    }

    public Stream(IFn xform, Stream src) {
        this.src = src.tap();
        this.xform = xform;
    }

    public final synchronized ISeq seq() {
        if (this.seq == NO_SEQ) {
            this.tap();
            this.seq = Stream.makeSeq(this.tap);
        }
        return this.seq;
    }

    static ISeq makeSeq(final IFn tap) {
        return RT.seq(new LazySeq(new AFn(){

            public Object invoke() throws Exception {
                Object v;
                while ((v = tap.invoke()) == RT.SKIP) {
                }
                if (v == RT.EOS) {
                    return null;
                }
                return new Cons(v, new LazySeq(this));
            }
        }));
    }

    public final synchronized Stream stream() throws Exception {
        return this;
    }

    public final synchronized IFn tap() {
        if (this.tap != null) {
            throw new IllegalStateException("Stream already tapped");
        }
        this.tap = Stream.makeTap(this.xform, this.src);
        return this.tap;
    }

    static IFn makeTap(final IFn xform, final IFn src) {
        return new AFn(){

            public Object invoke() throws Exception {
                Object v;
                while ((v = src.invoke()) == RT.SKIP) {
                }
                if (xform == null || v == RT.EOS) {
                    return v;
                }
                return xform.invoke(v);
            }
        };
    }
}

