/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IReference;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LispReader {
    static final Symbol QUOTE = Symbol.create("quote");
    static final Symbol THE_VAR = Symbol.create("var");
    static Symbol UNQUOTE = Symbol.create("clojure.core", "unquote");
    static Symbol UNQUOTE_SPLICING = Symbol.create("clojure.core", "unquote-splicing");
    static Symbol CONCAT = Symbol.create("clojure.core", "concat");
    static Symbol SEQ = Symbol.create("clojure.core", "seq");
    static Symbol LIST = Symbol.create("clojure.core", "list");
    static Symbol APPLY = Symbol.create("clojure.core", "apply");
    static Symbol HASHMAP = Symbol.create("clojure.core", "hash-map");
    static Symbol HASHSET = Symbol.create("clojure.core", "hash-set");
    static Symbol VECTOR = Symbol.create("clojure.core", "vector");
    static Symbol WITH_META = Symbol.create("clojure.core", "with-meta");
    static Symbol META = Symbol.create("clojure.core", "meta");
    static Symbol DEREF = Symbol.create("clojure.core", "deref");
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^/]].*/)?([\\D&&[^/]][^/]*)");
    static Pattern intPat = Pattern.compile("([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)\\.?");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("[-+]?[0-9]+(\\.[0-9]+)?([eE][-+]?[0-9]+)?[M]?");
    static final Symbol SLASH = Symbol.create("/");
    static final Symbol CLOJURE_SLASH = Symbol.create("clojure.core", "/");
    static Var GENSYM_ENV = Var.create(null);
    static Var ARG_ENV = Var.create(null);

    static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch) || ch == 44;
    }

    static void unread(PushbackReader r, int ch) throws IOException {
        if (ch != -1) {
            r.unread(ch);
        }
    }

    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive) throws Exception {
        try {
            int ch;
            block13: {
                Object ret;
                do {
                    ch = r.read();
                    while (LispReader.isWhitespace(ch)) {
                        ch = r.read();
                    }
                    if (ch == -1) {
                        if (eofIsError) {
                            throw new Exception("EOF while reading");
                        }
                        return eofValue;
                    }
                    if (Character.isDigit(ch)) {
                        Object n = LispReader.readNumber(r, (char)ch);
                        if (RT.suppressRead()) {
                            return null;
                        }
                        return n;
                    }
                    IFn macroFn = LispReader.getMacro(ch);
                    if (macroFn == null) break block13;
                    ret = macroFn.invoke(r, Character.valueOf((char)ch));
                    if (!RT.suppressRead()) continue;
                    return null;
                } while (ret == r);
                return ret;
            }
            if (ch == 43 || ch == 45) {
                int ch2 = r.read();
                if (Character.isDigit(ch2)) {
                    LispReader.unread(r, ch2);
                    Object n = LispReader.readNumber(r, (char)ch);
                    if (RT.suppressRead()) {
                        return null;
                    }
                    return n;
                }
                LispReader.unread(r, ch2);
            }
            String token = LispReader.readToken(r, (char)ch);
            if (RT.suppressRead()) {
                return null;
            }
            return LispReader.interpretToken(token);
        }
        catch (Exception e) {
            if (isRecursive || !(r instanceof LineNumberingPushbackReader)) {
                throw e;
            }
            LineNumberingPushbackReader rdr = (LineNumberingPushbackReader)r;
            throw new ReaderException(rdr.getLineNumber(), (Throwable)e);
        }
    }

    private static String readToken(PushbackReader r, char initch) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            int ch;
            if ((ch = r.read()) == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                LispReader.unread(r, ch);
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    private static Object readNumber(PushbackReader r, char initch) throws Exception {
        int ch;
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            if ((ch = r.read()) == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) break;
            sb.append((char)ch);
        }
        LispReader.unread(r, ch);
        String s = sb.toString();
        Object n = LispReader.matchNumber(s);
        if (n == null) {
            throw new NumberFormatException("Invalid number: " + s);
        }
        return n;
    }

    private static int readUnicodeChar(String token, int offset, int length, int base) throws Exception {
        if (token.length() != offset + length) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + token);
        }
        int uc = 0;
        for (int i = offset; i < offset + length; ++i) {
            int d = Character.digit(token.charAt(i), base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)d);
            }
            uc = uc * base + d;
        }
        return (char)uc;
    }

    private static int readUnicodeChar(PushbackReader r, int initch, int base, int length, boolean exact) throws Exception {
        int i;
        int uc = Character.digit(initch, base);
        if (uc == -1) {
            throw new IllegalArgumentException("Invalid digit: " + initch);
        }
        for (i = 1; i < length; ++i) {
            int ch = r.read();
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) {
                LispReader.unread(r, ch);
                break;
            }
            int d = Character.digit(ch, base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)ch);
            }
            uc = uc * base + d;
        }
        if (i != length && exact) {
            throw new IllegalArgumentException("Invalid character length: " + i + ", should be: " + length);
        }
        return uc;
    }

    private static Object interpretToken(String s) throws Exception {
        if (s.equals("nil")) {
            return null;
        }
        if (s.equals("true")) {
            return RT.T;
        }
        if (s.equals("false")) {
            return RT.F;
        }
        if (s.equals("/")) {
            return SLASH;
        }
        if (s.equals("clojure.core//")) {
            return CLOJURE_SLASH;
        }
        Object ret = null;
        ret = LispReader.matchSymbol(s);
        if (ret != null) {
            return ret;
        }
        throw new Exception("Invalid token: " + s);
    }

    private static Object matchSymbol(String s) {
        Matcher m = symbolPat.matcher(s);
        if (m.matches()) {
            int gc = m.groupCount();
            String ns = m.group(1);
            String name = m.group(2);
            if (ns != null && ns.endsWith(":/") || name.endsWith(":") || s.indexOf("::", 1) != -1) {
                return null;
            }
            if (s.startsWith("::")) {
                Symbol ks = Symbol.intern(s.substring(2));
                Namespace kns = ks.ns != null ? Compiler.namespaceFor(ks) : Compiler.currentNS();
                return Keyword.intern(kns.name.name, ks.name);
            }
            boolean isKeyword = s.charAt(0) == ':';
            Symbol sym = Symbol.intern(s.substring(isKeyword ? 1 : 0));
            if (isKeyword) {
                return Keyword.intern(sym);
            }
            return sym;
        }
        return null;
    }

    private static Object matchNumber(String s) {
        Matcher m = intPat.matcher(s);
        if (m.matches()) {
            if (m.group(2) != null) {
                return 0;
            }
            boolean negate = m.group(1).equals("-");
            int radix = 10;
            String n = m.group(3);
            if (n != null) {
                radix = 10;
            } else {
                n = m.group(4);
                if (n != null) {
                    radix = 16;
                } else {
                    n = m.group(5);
                    if (n != null) {
                        radix = 8;
                    } else {
                        n = m.group(7);
                        if (n != null) {
                            radix = Integer.parseInt(m.group(6));
                        }
                    }
                }
            }
            if (n == null) {
                return null;
            }
            BigInteger bn = new BigInteger(n, radix);
            return Numbers.reduce(negate ? bn.negate() : bn);
        }
        m = floatPat.matcher(s);
        if (m.matches()) {
            if (s.charAt(s.length() - 1) == 'M') {
                return new BigDecimal(s.substring(0, s.length() - 1));
            }
            return Double.parseDouble(s);
        }
        m = ratioPat.matcher(s);
        if (m.matches()) {
            return Numbers.divide(new BigInteger(m.group(1)), new BigInteger(m.group(2)));
        }
        return null;
    }

    private static IFn getMacro(int ch) {
        if (ch < macros.length) {
            return macros[ch];
        }
        return null;
    }

    private static boolean isMacro(int ch) {
        return ch < macros.length && macros[ch] != null;
    }

    private static boolean isTerminatingMacro(int ch) {
        return ch != 35 && ch < macros.length && macros[ch] != null;
    }

    static Symbol garg(int n) {
        return Symbol.intern(null, (n == -1 ? "rest" : "p" + n) + "__" + RT.nextID());
    }

    static Symbol registerArg(int n) {
        PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
        if (argsyms == null) {
            throw new IllegalStateException("arg literal not in #()");
        }
        Symbol ret = (Symbol)argsyms.valAt(n);
        if (ret == null) {
            ret = LispReader.garg(n);
            ARG_ENV.set(argsyms.assoc(n, ret));
        }
        return ret;
    }

    static boolean isUnquoteSplicing(Object form) {
        return form instanceof ISeq && RT.first(form).equals(UNQUOTE_SPLICING);
    }

    static boolean isUnquote(Object form) {
        return form instanceof ISeq && RT.first(form).equals(UNQUOTE);
    }

    public static List readDelimitedList(char delim, PushbackReader r, boolean isRecursive) throws Exception {
        ArrayList<Object> a = new ArrayList<Object>();
        while (true) {
            int ch = r.read();
            while (LispReader.isWhitespace(ch)) {
                ch = r.read();
            }
            if (ch == -1) {
                throw new Exception("EOF while reading");
            }
            if (ch == delim) break;
            IFn macroFn = LispReader.getMacro(ch);
            if (macroFn != null) {
                Object mret = macroFn.invoke(r, Character.valueOf((char)ch));
                if (mret == r) continue;
                a.add(mret);
                continue;
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, isRecursive);
            if (o == r) continue;
            a.add(o);
        }
        return a;
    }

    static {
        LispReader.macros[34] = new StringReader();
        LispReader.macros[59] = new CommentReader();
        LispReader.macros[39] = new WrappingReader(QUOTE);
        LispReader.macros[64] = new WrappingReader(DEREF);
        LispReader.macros[94] = new WrappingReader(META);
        LispReader.macros[96] = new SyntaxQuoteReader();
        LispReader.macros[126] = new UnquoteReader();
        LispReader.macros[40] = new ListReader();
        LispReader.macros[41] = new UnmatchedDelimiterReader();
        LispReader.macros[91] = new VectorReader();
        LispReader.macros[93] = new UnmatchedDelimiterReader();
        LispReader.macros[123] = new MapReader();
        LispReader.macros[125] = new UnmatchedDelimiterReader();
        LispReader.macros[92] = new CharacterReader();
        LispReader.macros[37] = new ArgReader();
        LispReader.macros[35] = new DispatchReader();
        LispReader.dispatchMacros[94] = new MetaReader();
        LispReader.dispatchMacros[39] = new VarReader();
        LispReader.dispatchMacros[34] = new RegexReader();
        LispReader.dispatchMacros[40] = new FnReader();
        LispReader.dispatchMacros[123] = new SetReader();
        LispReader.dispatchMacros[61] = new EvalReader();
        LispReader.dispatchMacros[33] = new CommentReader();
        LispReader.dispatchMacros[60] = new UnreadableReader();
        LispReader.dispatchMacros[95] = new DiscardReader();
    }

    public static class UnreadableReader
    extends AFn {
        public Object invoke(Object reader, Object leftangle) throws Exception {
            throw new Exception("Unreadable form");
        }
    }

    public static class UnmatchedDelimiterReader
    extends AFn {
        public Object invoke(Object reader, Object rightdelim) throws Exception {
            throw new Exception("Unmatched delimiter: " + rightdelim);
        }
    }

    public static class SetReader
    extends AFn {
        public Object invoke(Object reader, Object leftbracket) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return PersistentHashSet.create(LispReader.readDelimitedList('}', r, true));
        }
    }

    public static class MapReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return RT.map(LispReader.readDelimitedList('}', r, true).toArray());
        }
    }

    public static class VectorReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return LazilyPersistentVector.create(LispReader.readDelimitedList(']', r, true));
        }
    }

    public static class EvalReader
    extends AFn {
        public Object invoke(Object reader, Object eq) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            if (o instanceof Symbol) {
                return RT.classForName(o.toString());
            }
            if (o instanceof IPersistentList) {
                Symbol fs = (Symbol)RT.first(o);
                if (fs.equals(THE_VAR)) {
                    Symbol vs = (Symbol)RT.second(o);
                    return RT.var(vs.ns, vs.name);
                }
                if (fs.name.endsWith(".")) {
                    Object[] args = RT.toArray(RT.next(o));
                    return Reflector.invokeConstructor(RT.classForName(fs.name.substring(0, fs.name.length() - 1)), args);
                }
                if (Compiler.namesStaticMember(fs)) {
                    Object[] args = RT.toArray(RT.next(o));
                    return Reflector.invokeStaticMethod(fs.ns, fs.name, args);
                }
                Object v = Compiler.maybeResolveIn(Compiler.currentNS(), fs);
                if (v instanceof Var) {
                    return ((IFn)v).applyTo(RT.next(o));
                }
                throw new Exception("Can't resolve " + fs);
            }
            throw new IllegalArgumentException("Unsupported #= form");
        }
    }

    static class CtorReader
    extends AFn {
        static final Symbol cls = Symbol.create("class");

        CtorReader() {
        }

        public Object invoke(Object reader, Object leftangle) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            List list = LispReader.readDelimitedList('>', r, true);
            if (list.isEmpty()) {
                throw new Exception("Must supply 'class', classname or classname/staticMethod");
            }
            Symbol s = (Symbol)list.get(0);
            Object[] args = list.subList(1, list.size()).toArray();
            if (s.equals(cls)) {
                return RT.classForName(args[0].toString());
            }
            if (s.ns != null) {
                String classname = s.ns;
                String method = s.name;
                return Reflector.invokeStaticMethod(classname, method, args);
            }
            return Reflector.invokeConstructor(RT.classForName(s.name), args);
        }
    }

    public static class ListReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) throws Exception {
            List list;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((list = LispReader.readDelimitedList(')', r, true)).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj s = (IObj)((Object)PersistentList.create(list));
            if (line != -1) {
                return s.withMeta(RT.map(RT.LINE_KEY, line));
            }
            return s;
        }
    }

    public static class CharacterReader
    extends AFn {
        public Object invoke(Object reader, Object backslash) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            String token = LispReader.readToken(r, (char)ch);
            if (token.length() == 1) {
                return Character.valueOf(token.charAt(0));
            }
            if (token.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (token.equals("space")) {
                return Character.valueOf(' ');
            }
            if (token.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (token.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (token.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (token.equals("return")) {
                return Character.valueOf('\r');
            }
            if (token.startsWith("u")) {
                char c = (char)LispReader.readUnicodeChar(token, 1, 4, 16);
                if (c >= '\ud800' && c <= '\udfff') {
                    throw new Exception("Invalid character constant: \\u" + Integer.toString(c, 16));
                }
                return Character.valueOf(c);
            }
            if (token.startsWith("o")) {
                int len = token.length() - 1;
                if (len > 3) {
                    throw new Exception("Invalid octal escape sequence length: " + len);
                }
                int uc = LispReader.readUnicodeChar(token, 1, len, 8);
                if (uc > 255) {
                    throw new Exception("Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)uc);
            }
            throw new Exception("Unsupported character: \\" + token);
        }
    }

    static class UnquoteReader
    extends AFn {
        UnquoteReader() {
        }

        public Object invoke(Object reader, Object comma) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            if (ch == 64) {
                Object o = LispReader.read(r, true, null, true);
                return RT.list(UNQUOTE_SPLICING, o);
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, true);
            return RT.list(UNQUOTE, o);
        }
    }

    public static class SyntaxQuoteReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object reader, Object backquote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            try {
                Var.pushThreadBindings(RT.map(GENSYM_ENV, PersistentHashMap.EMPTY));
                Object form = LispReader.read(r, true, null, true);
                Object object = SyntaxQuoteReader.syntaxQuote(form);
                return object;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Object syntaxQuote(Object form) throws Exception {
            IPersistentMap newMeta;
            Object ret;
            if (Compiler.isSpecial(form)) {
                ret = RT.list(Compiler.QUOTE, form);
            } else if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null && sym.name.endsWith("#")) {
                    IPersistentMap gmap = (IPersistentMap)GENSYM_ENV.deref();
                    if (gmap == null) {
                        throw new IllegalStateException("Gensym literal not in syntax-quote");
                    }
                    Symbol gs = (Symbol)gmap.valAt(sym);
                    if (gs == null) {
                        gs = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1) + "__" + RT.nextID() + "__auto__");
                        GENSYM_ENV.set(gmap.assoc(sym, gs));
                    }
                    sym = gs;
                } else if (sym.ns == null && sym.name.endsWith(".")) {
                    Symbol csym = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1));
                    csym = Compiler.resolveSymbol(csym);
                    sym = Symbol.intern(null, csym.name.concat("."));
                } else if (sym.ns != null || !sym.name.startsWith(".")) {
                    sym = Compiler.resolveSymbol(sym);
                }
                ret = RT.list(Compiler.QUOTE, sym);
            } else {
                if (LispReader.isUnquote(form)) {
                    return RT.second(form);
                }
                if (LispReader.isUnquoteSplicing(form)) {
                    throw new IllegalStateException("splice not in list");
                }
                if (form instanceof IPersistentCollection) {
                    if (form instanceof IPersistentMap) {
                        IPersistentVector keyvals = SyntaxQuoteReader.flattenMap(form);
                        ret = RT.list(APPLY, HASHMAP, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(keyvals.seq()))));
                    } else if (form instanceof IPersistentVector) {
                        ret = RT.list(APPLY, VECTOR, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentVector)form).seq()))));
                    } else if (form instanceof IPersistentSet) {
                        ret = RT.list(APPLY, HASHSET, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentSet)form).seq()))));
                    } else {
                        if (!(form instanceof ISeq) && !(form instanceof IPersistentList)) throw new UnsupportedOperationException("Unknown Collection type");
                        ISeq seq = RT.seq(form);
                        ret = seq == null ? RT.cons(LIST, null) : RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(seq)));
                    }
                } else {
                    ret = form instanceof Keyword || form instanceof Number || form instanceof Character || form instanceof String ? form : RT.list(Compiler.QUOTE, form);
                }
            }
            if (!(form instanceof IObj) || RT.meta(form) == null || (newMeta = ((IObj)form).meta().without(RT.LINE_KEY)).count() <= 0) return ret;
            return RT.list(WITH_META, ret, SyntaxQuoteReader.syntaxQuote(((IObj)form).meta()));
        }

        private static ISeq sqExpandList(ISeq seq) throws Exception {
            PersistentVector ret = PersistentVector.EMPTY;
            while (seq != null) {
                Object item = seq.first();
                ret = LispReader.isUnquote(item) ? ret.cons(RT.list(LIST, RT.second(item))) : (LispReader.isUnquoteSplicing(item) ? ret.cons(RT.second(item)) : ret.cons(RT.list(LIST, SyntaxQuoteReader.syntaxQuote(item))));
                seq = seq.next();
            }
            return ret.seq();
        }

        private static IPersistentVector flattenMap(Object form) {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                IMapEntry e = (IMapEntry)s.first();
                keyvals = keyvals.cons(e.key());
                keyvals = keyvals.cons(e.val());
            }
            return keyvals;
        }
    }

    public static class MetaReader
    extends AFn {
        public Object invoke(Object reader, Object caret) throws Exception {
            Object meta;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((meta = LispReader.read(r, true, null, true)) instanceof Symbol || meta instanceof Keyword || meta instanceof String) {
                meta = RT.map(RT.TAG_KEY, meta);
            } else if (!(meta instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object o = LispReader.read(r, true, null, true);
            if (o instanceof IMeta) {
                if (line != -1 && o instanceof ISeq) {
                    meta = ((IPersistentMap)meta).assoc(RT.LINE_KEY, line);
                }
                if (o instanceof IReference) {
                    ((IReference)o).resetMeta((IPersistentMap)meta);
                    return o;
                }
                return ((IObj)o).withMeta((IPersistentMap)meta);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IMetas");
        }
    }

    static class ArgReader
    extends AFn {
        ArgReader() {
        }

        public Object invoke(Object reader, Object pct) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            LispReader.unread(r, ch);
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                return LispReader.registerArg(1);
            }
            Object n = LispReader.read(r, true, null, true);
            if (n.equals(Compiler._AMP_)) {
                return LispReader.registerArg(-1);
            }
            if (!(n instanceof Number)) {
                throw new IllegalStateException("arg literal must be %, %& or %integer");
            }
            return LispReader.registerArg(((Number)n).intValue());
        }
    }

    public static class FnReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object reader, Object lparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            if (ARG_ENV.deref() != null) {
                throw new IllegalStateException("Nested #()s are not allowed");
            }
            try {
                Var.pushThreadBindings(RT.map(ARG_ENV, PersistentTreeMap.EMPTY));
                r.unread(40);
                Object form = LispReader.read(r, true, null, true);
                PersistentVector args = PersistentVector.EMPTY;
                PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
                ISeq rargs = argsyms.rseq();
                if (rargs != null) {
                    Object restsym;
                    int higharg = (Integer)((Map.Entry)rargs.first()).getKey();
                    if (higharg > 0) {
                        for (int i = 1; i <= higharg; ++i) {
                            Object sym = argsyms.valAt(i);
                            if (sym == null) {
                                sym = LispReader.garg(i);
                            }
                            args = args.cons(sym);
                        }
                    }
                    if ((restsym = argsyms.valAt(-1)) != null) {
                        args = args.cons(Compiler._AMP_);
                        args = args.cons(restsym);
                    }
                }
                ISeq iSeq = RT.list(Compiler.FN, args, form);
                return iSeq;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    public static class DispatchReader
    extends AFn {
        public Object invoke(Object reader, Object hash) throws Exception {
            int ch = ((Reader)reader).read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            IFn fn = dispatchMacros[ch];
            if (fn == null) {
                throw new Exception(String.format("No dispatch macro for: %c", Character.valueOf((char)ch)));
            }
            return fn.invoke(reader, ch);
        }
    }

    public static class VarReader
    extends AFn {
        public Object invoke(Object reader, Object quote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            return RT.list(THE_VAR, o);
        }
    }

    public static class WrappingReader
    extends AFn {
        final Symbol sym;

        public WrappingReader(Symbol sym) {
            this.sym = sym;
        }

        public Object invoke(Object reader, Object quote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            return RT.list(this.sym, o);
        }
    }

    public static class DiscardReader
    extends AFn {
        public Object invoke(Object reader, Object underscore) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            LispReader.read(r, true, null, true);
            return r;
        }
    }

    public static class CommentReader
    extends AFn {
        public Object invoke(Object reader, Object semicolon) throws Exception {
            int ch;
            Reader r = (Reader)reader;
            while ((ch = r.read()) != -1 && ch != 10 && ch != 13) {
            }
            return r;
        }
    }

    public static class StringReader
    extends AFn {
        public Object invoke(Object reader, Object doublequote) throws Exception {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = r.read();
            while (ch != 34) {
                if (ch == -1) {
                    throw new Exception("EOF while reading string");
                }
                if (ch == 92) {
                    ch = r.read();
                    if (ch == -1) {
                        throw new Exception("EOF while reading string");
                    }
                    switch (ch) {
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 117: {
                            ch = r.read();
                            if (Character.digit(ch, 16) == -1) {
                                throw new Exception("Invalid unicode escape: \\u" + (char)ch);
                            }
                            ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 16, 4, true);
                            break;
                        }
                        default: {
                            if (Character.isDigit(ch)) {
                                if ((ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 8, 3, false)) <= 255) break;
                                throw new Exception("Octal escape sequence must be in range [0, 377].");
                            }
                            throw new Exception("Unsupported escape character: \\" + (char)ch);
                        }
                    }
                }
                sb.append((char)ch);
                ch = r.read();
            }
            return sb.toString();
        }
    }

    public static class RegexReader
    extends AFn {
        static StringReader stringrdr = new StringReader();

        public Object invoke(Object reader, Object doublequote) throws Exception {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = r.read();
            while (ch != 34) {
                if (ch == -1) {
                    throw new Exception("EOF while reading regex");
                }
                sb.append((char)ch);
                if (ch == 92) {
                    ch = r.read();
                    if (ch == -1) {
                        throw new Exception("EOF while reading regex");
                    }
                    sb.append((char)ch);
                }
                ch = r.read();
            }
            return Pattern.compile(sb.toString());
        }
    }

    public static class ReaderException
    extends Exception {
        final int line;

        public ReaderException(int line, Throwable cause) {
            super(cause);
            this.line = line;
        }
    }
}

