/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.asm.Attribute;
import clojure.asm.ByteVector;
import clojure.asm.ClassVisitor;
import clojure.asm.ClassWriter;
import clojure.asm.Label;
import clojure.asm.Opcodes;
import clojure.asm.Type;
import clojure.asm.commons.GeneratorAdapter;
import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.DynamicClassLoader;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazySeq;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.LispReader;
import clojure.lang.Namespace;
import clojure.lang.Obj;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.RestFn;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements Opcodes {
    static final Symbol DEF = Symbol.create("def");
    static final Symbol LOOP = Symbol.create("loop*");
    static final Symbol RECUR = Symbol.create("recur");
    static final Symbol IF = Symbol.create("if*");
    static final Symbol LET = Symbol.create("let*");
    static final Symbol LETFN = Symbol.create("letfn*");
    static final Symbol DO = Symbol.create("do");
    static final Symbol FN = Symbol.create("fn*");
    static final Symbol QUOTE = Symbol.create("quote");
    static final Symbol THE_VAR = Symbol.create("var");
    static final Symbol DOT = Symbol.create(".");
    static final Symbol ASSIGN = Symbol.create("set!");
    static final Symbol TRY = Symbol.create("try");
    static final Symbol CATCH = Symbol.create("catch");
    static final Symbol FINALLY = Symbol.create("finally");
    static final Symbol THROW = Symbol.create("throw");
    static final Symbol MONITOR_ENTER = Symbol.create("monitor-enter");
    static final Symbol MONITOR_EXIT = Symbol.create("monitor-exit");
    static final Symbol NEW = Symbol.create("new");
    static final Symbol LIST = Symbol.create("clojure.core", "list");
    static final Symbol HASHMAP = Symbol.create("clojure.core", "hash-map");
    static final Symbol VECTOR = Symbol.create("clojure.core", "vector");
    static final Symbol IDENTITY = Symbol.create("clojure.core", "identity");
    static final Symbol _AMP_ = Symbol.create("&");
    static final Symbol ISEQ = Symbol.create("clojure.lang.ISeq");
    static final Keyword inlineKey = Keyword.intern(null, "inline");
    static final Keyword inlineAritiesKey = Keyword.intern(null, "inline-arities");
    static final Symbol NS = Symbol.create("ns");
    static final Symbol IN_NS = Symbol.create("in-ns");
    public static final IPersistentMap specials = PersistentHashMap.create(DEF, new DefExpr.Parser(), LOOP, new LetExpr.Parser(), RECUR, new RecurExpr.Parser(), IF, new IfExpr.Parser(), LET, new LetExpr.Parser(), LETFN, new LetFnExpr.Parser(), DO, new BodyExpr.Parser(), FN, null, QUOTE, new ConstantExpr.Parser(), THE_VAR, new TheVarExpr.Parser(), DOT, new HostExpr.Parser(), ASSIGN, new AssignExpr.Parser(), TRY, new TryExpr.Parser(), THROW, new ThrowExpr.Parser(), MONITOR_ENTER, new MonitorEnterExpr.Parser(), MONITOR_EXIT, new MonitorExitExpr.Parser(), CATCH, null, FINALLY, null, NEW, new NewExpr.Parser(), _AMP_, null);
    private static final int MAX_POSITIONAL_ARITY = 20;
    private static final Type OBJECT_TYPE;
    private static final Type KEYWORD_TYPE;
    private static final Type VAR_TYPE;
    private static final Type SYMBOL_TYPE;
    private static final Type IFN_TYPE;
    private static final Type RT_TYPE;
    static final Type CLASS_TYPE;
    static final Type REFLECTOR_TYPE;
    static final Type THROWABLE_TYPE;
    static final Type BOOLEAN_OBJECT_TYPE;
    static final Type IPERSISTENTMAP_TYPE;
    static final Type IOBJ_TYPE;
    private static final Type[][] ARG_TYPES;
    private static final Type[] EXCEPTION_TYPES;
    public static final Var LOCAL_ENV;
    public static final Var LOOP_LOCALS;
    public static final Var LOOP_LABEL;
    public static final Var CONSTANTS;
    public static final Var KEYWORDS;
    public static final Var VARS;
    public static final Var METHOD;
    public static final Var IN_CATCH_FINALLY;
    public static final Var SOURCE;
    public static final Var SOURCE_PATH;
    public static final Var COMPILE_PATH;
    public static final Var COMPILE_FILES;
    public static final Var LINE;
    public static final Var LINE_BEFORE;
    public static final Var LINE_AFTER;
    public static final Var NEXT_LOCAL_NUM;
    public static final Var RET_LOCAL_NUM;
    public static final Var LOADER;
    static final NilExpr NIL_EXPR;
    static final BooleanExpr TRUE_EXPR;
    static final BooleanExpr FALSE_EXPR;
    public static final IPersistentMap CHAR_MAP;

    static boolean isSpecial(Object sym) {
        return specials.containsKey(sym);
    }

    static Symbol resolveSymbol(Symbol sym) {
        if (sym.name.indexOf(46) > 0) {
            return sym;
        }
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(sym);
            if (ns == null || ns.name.name == sym.ns) {
                return sym;
            }
            return Symbol.create(ns.name.name, sym.name);
        }
        Object o = Compiler.currentNS().getMapping(sym);
        if (o == null) {
            return Symbol.intern(Compiler.currentNS().name.name, sym.name);
        }
        if (o instanceof Class) {
            return Symbol.intern(null, ((Class)o).getName());
        }
        if (o instanceof Var) {
            Var v = (Var)o;
            return Symbol.create(v.ns.name.name, v.sym.name);
        }
        return null;
    }

    static Class maybePrimitiveType(Expr e) {
        try {
            Class c;
            if (e instanceof MaybePrimitiveExpr && e.hasJavaClass() && Util.isPrimitive(c = e.getJavaClass())) {
                return c;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static boolean subsumes(Class[] c1, Class[] c2) {
        Boolean better = false;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            if (!c1[i].isPrimitive() && c2[i].isPrimitive() || c2[i].isAssignableFrom(c1[i])) {
                better = true;
                continue;
            }
            return false;
        }
        return better;
    }

    static int getMatchingParams(String methodName, ArrayList<Class[]> paramlists, IPersistentVector argexprs, List<Class> rets) throws Exception {
        int matchIdx = -1;
        boolean tied = false;
        for (int i = 0; i < paramlists.size(); ++i) {
            boolean match = true;
            ISeq aseq = argexprs.seq();
            int exact = 0;
            for (int p = 0; match && p < argexprs.count() && aseq != null; ++p, aseq = aseq.next()) {
                Expr arg = (Expr)aseq.first();
                Class aclass = arg.hasJavaClass() ? arg.getJavaClass() : Object.class;
                Class pclass = paramlists.get(i)[p];
                if (arg.hasJavaClass() && aclass == pclass) {
                    ++exact;
                    continue;
                }
                match = Reflector.paramArgTypeMatch(pclass, aclass);
            }
            if (exact == argexprs.count()) {
                return i;
            }
            if (!match) continue;
            if (matchIdx == -1) {
                matchIdx = i;
                continue;
            }
            if (Compiler.subsumes(paramlists.get(i), paramlists.get(matchIdx))) {
                matchIdx = i;
                tied = false;
                continue;
            }
            if (Arrays.equals(paramlists.get(matchIdx), paramlists.get(i))) {
                if (!rets.get(matchIdx).isAssignableFrom(rets.get(i))) continue;
                matchIdx = i;
                continue;
            }
            if (Compiler.subsumes(paramlists.get(matchIdx), paramlists.get(i))) continue;
            tied = true;
        }
        if (tied) {
            throw new IllegalArgumentException("More than one matching method found: " + methodName);
        }
        return matchIdx;
    }

    public static String munge(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            String sub = (String)CHAR_MAP.valAt(Character.valueOf(c));
            if (sub != null) {
                sb.append(sub);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static LocalBinding registerLocal(Symbol sym, Symbol tag, Expr init) throws Exception {
        int num = Compiler.getAndIncLocalNum();
        LocalBinding b = new LocalBinding(num, sym, tag, init);
        IPersistentMap localsMap = (IPersistentMap)LOCAL_ENV.deref();
        LOCAL_ENV.set(RT.assoc(localsMap, b.sym, b));
        FnMethod method = (FnMethod)METHOD.deref();
        method.locals = (IPersistentMap)RT.assoc(method.locals, b, b);
        method.indexlocals = (IPersistentMap)RT.assoc(method.indexlocals, num, b);
        return b;
    }

    private static int getAndIncLocalNum() {
        int num = ((Number)NEXT_LOCAL_NUM.deref()).intValue();
        FnMethod m = (FnMethod)METHOD.deref();
        if (num > m.maxLocal) {
            m.maxLocal = num;
        }
        NEXT_LOCAL_NUM.set(num + 1);
        return num;
    }

    public static Expr analyze(C context, Object form) throws Exception {
        return Compiler.analyze(context, form, null);
    }

    private static Expr analyze(C context, Object form, String name) throws Exception {
        try {
            if (form instanceof LazySeq && (form = RT.seq(form)) == null) {
                form = PersistentList.EMPTY;
            }
            if (form == null) {
                return NIL_EXPR;
            }
            if (form == Boolean.TRUE) {
                return TRUE_EXPR;
            }
            if (form == Boolean.FALSE) {
                return FALSE_EXPR;
            }
            Class<?> fclass = form.getClass();
            if (fclass == Symbol.class) {
                return Compiler.analyzeSymbol((Symbol)form);
            }
            if (fclass == Keyword.class) {
                return Compiler.registerKeyword((Keyword)form);
            }
            if (fclass == String.class) {
                return new StringExpr(((String)form).intern());
            }
            if (form instanceof IPersistentCollection && ((IPersistentCollection)form).count() == 0) {
                Expr ret = new EmptyExpr(form);
                if (RT.meta(form) != null) {
                    ret = new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)form).meta()));
                }
                return ret;
            }
            if (form instanceof ISeq) {
                return Compiler.analyzeSeq(context, (ISeq)form, name);
            }
            if (form instanceof IPersistentVector) {
                return VectorExpr.parse(context, (IPersistentVector)form);
            }
            if (form instanceof IPersistentMap) {
                return MapExpr.parse(context, (IPersistentMap)form);
            }
            if (form instanceof IPersistentSet) {
                return SetExpr.parse(context, (IPersistentSet)form);
            }
            return new ConstantExpr(form);
        }
        catch (Throwable e) {
            if (!(e instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE.deref(), (Integer)LINE.deref(), e);
            }
            throw (CompilerException)e;
        }
    }

    public static Var isMacro(Object op) throws Exception {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false);
            if (v != null && v.isMacro()) {
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                return v;
            }
        }
        return null;
    }

    public static IFn isInline(Object op, int arity) throws Exception {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false);
            if (v != null) {
                IPersistentSet arities;
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                IFn ret = (IFn)RT.get(v.meta(), inlineKey);
                if (ret != null && ((arities = (IPersistentSet)RT.get(v.meta(), inlineAritiesKey)) == null || arities.contains(arity))) {
                    return ret;
                }
            }
        }
        return null;
    }

    public static boolean namesStaticMember(Symbol sym) {
        return sym.ns != null && Compiler.namespaceFor(sym) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object macroexpand1(Object x) throws Exception {
        if (x instanceof ISeq) {
            ISeq form = (ISeq)x;
            Object op = RT.first(form);
            if (Compiler.isSpecial(op)) {
                return x;
            }
            Var v = Compiler.isMacro(op);
            if (v != null) {
                try {
                    Var.pushThreadBindings(RT.map(RT.MACRO_META, RT.meta(form)));
                    Object object = v.applyTo(form.next());
                    return object;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
            if (op instanceof Symbol) {
                Symbol sym = (Symbol)op;
                String sname = sym.name;
                if (sym.name.charAt(0) == '.') {
                    if (RT.length(form) < 2) {
                        throw new IllegalArgumentException("Malformed member expression, expecting (.member target ...)");
                    }
                    Symbol meth = Symbol.intern(sname.substring(1));
                    Object target = RT.second(form);
                    if (HostExpr.maybeClass(target, false) != null) {
                        target = RT.list(IDENTITY, target);
                    }
                    return RT.listStar(DOT, target, meth, form.next().next());
                }
                if (Compiler.namesStaticMember(sym)) {
                    Symbol target = Symbol.intern(sym.ns);
                    Class c = HostExpr.maybeClass(target, false);
                    if (c != null) {
                        Symbol meth = Symbol.intern(sym.name);
                        return RT.listStar(DOT, target, meth, form.next());
                    }
                } else {
                    int idx = sname.lastIndexOf(46);
                    if (idx == sname.length() - 1) {
                        return RT.listStar(NEW, Symbol.intern(sname.substring(0, idx)), form.next());
                    }
                }
            }
        }
        return x;
    }

    private static Expr analyzeSeq(C context, ISeq form, String name) throws Exception {
        Integer line = (Integer)LINE.deref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = (Integer)RT.meta(form).valAt(RT.LINE_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line));
        try {
            Object me = Compiler.macroexpand1(form);
            if (me != form) {
                Expr expr = Compiler.analyze(context, me, name);
                return expr;
            }
            Object op = RT.first(form);
            if (op == null) {
                throw new IllegalArgumentException("Can't call nil");
            }
            IFn inline = Compiler.isInline(op, RT.count(RT.next(form)));
            if (inline != null) {
                Expr expr = Compiler.analyze(context, inline.applyTo(RT.next(form)));
                return expr;
            }
            if (op.equals(FN)) {
                Expr expr = FnExpr.parse(context, form, name);
                return expr;
            }
            IParser p = (IParser)specials.valAt(op);
            if (p != null) {
                Expr expr = p.parse(context, form);
                return expr;
            }
            Expr expr = InvokeExpr.parse(context, form);
            return expr;
        }
        catch (Throwable e) {
            if (!(e instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE.deref(), (Integer)LINE.deref(), e);
            }
            throw (CompilerException)e;
        }
        finally {
            Var.popThreadBindings();
        }
    }

    static String errorMsg(String source, int line, String s) {
        return String.format("%s (%s:%d)", s, source, line);
    }

    public static Object eval(Object form) throws Exception {
        boolean createdLoader = false;
        Var.pushThreadBindings(RT.map(LOADER, RT.makeClassLoader()));
        createdLoader = true;
        try {
            if (!(!(form instanceof IPersistentCollection) || RT.first(form) instanceof Symbol && ((Symbol)RT.first((Object)form)).name.startsWith("def"))) {
                FnExpr fexpr = (FnExpr)Compiler.analyze(C.EXPRESSION, RT.list(FN, PersistentVector.EMPTY, form), "eval");
                IFn fn = (IFn)fexpr.eval();
                Object object = fn.invoke();
                return object;
            }
            Expr expr = Compiler.analyze(C.EVAL, form);
            Object object = expr.eval();
            return object;
        }
        catch (Throwable e) {
            if (!(e instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE.deref(), (Integer)LINE.deref(), e);
            }
            throw (CompilerException)e;
        }
        finally {
            if (createdLoader) {
                Var.popThreadBindings();
            }
        }
    }

    private static int registerConstant(Object o) {
        if (!CONSTANTS.isBound()) {
            return -1;
        }
        PersistentVector v = (PersistentVector)CONSTANTS.deref();
        CONSTANTS.set(RT.conj(v, o));
        return v.count();
    }

    private static KeywordExpr registerKeyword(Keyword keyword) {
        if (!KEYWORDS.isBound()) {
            return new KeywordExpr(keyword);
        }
        IPersistentMap keywordsMap = (IPersistentMap)KEYWORDS.deref();
        Object id = RT.get(keywordsMap, keyword);
        if (id == null) {
            KEYWORDS.set(RT.assoc(keywordsMap, keyword, Compiler.registerConstant(keyword)));
        }
        return new KeywordExpr(keyword);
    }

    private static Expr analyzeSymbol(Symbol sym) throws Exception {
        Object o;
        Symbol nsSym;
        Class c;
        Symbol tag = Compiler.tagOf(sym);
        if (sym.ns == null) {
            LocalBinding b = Compiler.referenceLocal(sym);
            if (b != null) {
                return new LocalBindingExpr(b, tag);
            }
        } else if (Compiler.namespaceFor(sym) == null && (c = HostExpr.maybeClass(nsSym = Symbol.create(sym.ns), false)) != null && Reflector.getField(c, sym.name, true) != null) {
            return new StaticFieldExpr((Integer)LINE.deref(), c, sym.name);
        }
        if ((o = Compiler.resolve(sym)) instanceof Var) {
            Var v = (Var)o;
            if (Compiler.isMacro(v) != null) {
                throw new Exception("Can't take value of a macro: " + v);
            }
            Compiler.registerVar(v);
            return new VarExpr(v, tag);
        }
        if (o instanceof Class) {
            return new ConstantExpr(o);
        }
        if (o instanceof Symbol) {
            return new UnresolvedVarExpr((Symbol)o);
        }
        throw new Exception("Unable to resolve symbol: " + sym + " in this context");
    }

    static Object resolve(Symbol sym, boolean allowPrivate) throws Exception {
        return Compiler.resolveIn(Compiler.currentNS(), sym, allowPrivate);
    }

    static Object resolve(Symbol sym) throws Exception {
        return Compiler.resolveIn(Compiler.currentNS(), sym, false);
    }

    static Namespace namespaceFor(Symbol sym) {
        return Compiler.namespaceFor(Compiler.currentNS(), sym);
    }

    static Namespace namespaceFor(Namespace inns, Symbol sym) {
        Symbol nsSym = Symbol.create(sym.ns);
        Namespace ns = inns.lookupAlias(nsSym);
        if (ns == null) {
            ns = Namespace.find(nsSym);
        }
        return ns;
    }

    public static Object resolveIn(Namespace n, Symbol sym, boolean allowPrivate) throws Exception {
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(n, sym);
            if (ns == null) {
                throw new Exception("No such namespace: " + sym.ns);
            }
            Var v = ns.findInternedVar(Symbol.create(sym.name));
            if (v == null) {
                throw new Exception("No such var: " + sym);
            }
            if (v.ns != Compiler.currentNS() && !v.isPublic() && !allowPrivate) {
                throw new IllegalStateException("var: " + sym + " is not public");
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        Object o = n.getMapping(sym);
        if (o == null) {
            if (RT.booleanCast(RT.ALLOW_UNRESOLVED_VARS.deref())) {
                return sym;
            }
            throw new Exception("Unable to resolve symbol: " + sym + " in this context");
        }
        return o;
    }

    public static Object maybeResolveIn(Namespace n, Symbol sym) throws Exception {
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(n, sym);
            if (ns == null) {
                return null;
            }
            Var v = ns.findInternedVar(Symbol.create(sym.name));
            if (v == null) {
                return null;
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        Object o = n.getMapping(sym);
        return o;
    }

    static Var lookupVar(Symbol sym, boolean internNew) throws Exception {
        Var var = null;
        if (sym.ns != null) {
            Namespace ns = Compiler.namespaceFor(sym);
            if (ns == null) {
                return null;
            }
            Symbol name = Symbol.create(sym.name);
            var = internNew && ns == Compiler.currentNS() ? Compiler.currentNS().intern(name) : ns.findInternedVar(name);
        } else if (sym.equals(NS)) {
            var = RT.NS_VAR;
        } else if (sym.equals(IN_NS)) {
            var = RT.IN_NS_VAR;
        } else {
            Object o = Compiler.currentNS().getMapping(sym);
            if (o == null) {
                if (internNew) {
                    var = Compiler.currentNS().intern(Symbol.create(sym.name));
                }
            } else if (o instanceof Var) {
                var = (Var)o;
            } else {
                throw new Exception("Expecting var, but " + sym + " is mapped to " + o);
            }
        }
        if (var != null) {
            Compiler.registerVar(var);
        }
        return var;
    }

    private static void registerVar(Var var) throws Exception {
        if (!VARS.isBound()) {
            return;
        }
        IPersistentMap varsMap = (IPersistentMap)VARS.deref();
        Object id = RT.get(varsMap, var);
        if (id == null) {
            VARS.set(RT.assoc(varsMap, var, Compiler.registerConstant(var)));
        }
    }

    static Namespace currentNS() {
        return (Namespace)RT.CURRENT_NS.deref();
    }

    static void closeOver(LocalBinding b, FnMethod method) {
        if (b != null && method != null) {
            if (RT.get(method.locals, b) == null) {
                method.fn.closes = (IPersistentMap)RT.assoc(method.fn.closes, b, b);
                Compiler.closeOver(b, method.parent);
            } else if (IN_CATCH_FINALLY.deref() != null) {
                method.localsUsedInCatchFinally = (PersistentHashSet)method.localsUsedInCatchFinally.cons(b.idx);
            }
        }
    }

    static LocalBinding referenceLocal(Symbol sym) throws Exception {
        if (!LOCAL_ENV.isBound()) {
            return null;
        }
        LocalBinding b = (LocalBinding)RT.get(LOCAL_ENV.deref(), sym);
        if (b != null) {
            FnMethod method = (FnMethod)METHOD.deref();
            Compiler.closeOver(b, method);
        }
        return b;
    }

    private static Symbol tagOf(Object o) {
        Object tag = RT.get(RT.meta(o), RT.TAG_KEY);
        if (tag instanceof Symbol) {
            return (Symbol)tag;
        }
        if (tag instanceof String) {
            return Symbol.intern(null, (String)tag);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadFile(String file) throws Exception {
        FileInputStream f = new FileInputStream(file);
        try {
            Object object = Compiler.load(new InputStreamReader((InputStream)f, RT.UTF8), new File(file).getAbsolutePath(), new File(file).getName());
            return object;
        }
        finally {
            f.close();
        }
    }

    public static Object load(Reader rdr) throws Exception {
        return Compiler.load(rdr, null, "NO_SOURCE_FILE");
    }

    public static Object load(Reader rdr, String sourcePath, String sourceName) throws Exception {
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.map(LOADER, RT.makeClassLoader(), SOURCE_PATH, sourcePath, SOURCE, sourceName, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), LINE_AFTER, pushbackReader.getLineNumber()));
        try {
            Object r = LispReader.read(pushbackReader, false, EOF, false);
            while (r != EOF) {
                LINE_AFTER.set(pushbackReader.getLineNumber());
                ret = Compiler.eval(r);
                LINE_BEFORE.set(pushbackReader.getLineNumber());
                r = LispReader.read(pushbackReader, false, EOF, false);
            }
        }
        catch (LispReader.ReaderException e) {
            throw new CompilerException(sourceName, e.line, e.getCause());
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClassFile(String internalName, byte[] bytecode) throws Exception {
        String genPath = (String)COMPILE_PATH.deref();
        if (genPath == null) {
            throw new Exception("*compile-path* not set");
        }
        String[] dirs = internalName.split("/");
        String p = genPath;
        for (int i = 0; i < dirs.length - 1; ++i) {
            p = p + File.separator + dirs[i];
            new File(p).mkdir();
        }
        String path = genPath + File.separator + internalName + ".class";
        File cf = new File(path);
        cf.createNewFile();
        FileOutputStream cfs = new FileOutputStream(cf);
        try {
            cfs.write(bytecode);
            cfs.flush();
            cfs.getFD().sync();
        }
        finally {
            cfs.close();
        }
    }

    public static void pushNS() {
        Var.pushThreadBindings(PersistentHashMap.create(Var.intern(Symbol.create("clojure.core"), Symbol.create("*ns*")), null));
    }

    public static Object compile(Reader rdr, String sourcePath, String sourceName) throws Exception {
        if (COMPILE_PATH.deref() == null) {
            throw new Exception("*compile-path* not set");
        }
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.map(SOURCE_PATH, sourcePath, SOURCE, sourceName, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), LINE_AFTER, pushbackReader.getLineNumber(), CONSTANTS, PersistentVector.EMPTY, KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY));
        try {
            ClassWriter cw;
            FnExpr fn = new FnExpr(null);
            fn.internalName = sourcePath.replace(File.separator, "/").substring(0, sourcePath.lastIndexOf(46)) + "__init";
            fn.fntype = Type.getObjectType(fn.internalName);
            ClassWriter cv = cw = new ClassWriter(1);
            cv.visit(49, 33, fn.internalName, null, "java/lang/Object", null);
            GeneratorAdapter gen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void load ()"), null, null, cv);
            gen.visitCode();
            Object r = LispReader.read(pushbackReader, false, EOF, false);
            while (r != EOF) {
                LINE_AFTER.set(pushbackReader.getLineNumber());
                Expr expr = Compiler.analyze(C.EVAL, r);
                fn.keywords = (IPersistentMap)KEYWORDS.deref();
                fn.vars = (IPersistentMap)VARS.deref();
                fn.constants = (PersistentVector)CONSTANTS.deref();
                expr.emit(C.EXPRESSION, fn, gen);
                expr.eval();
                LINE_BEFORE.set(pushbackReader.getLineNumber());
                r = LispReader.read(pushbackReader, false, EOF, false);
            }
            gen.returnValue();
            gen.endMethod();
            for (int i = 0; i < fn.constants.count(); ++i) {
                cv.visitField(25, fn.constantName(i), fn.constantType(i).getDescriptor(), null, null);
            }
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            Label startTry = clinitgen.newLabel();
            Label endTry = clinitgen.newLabel();
            Label end = clinitgen.newLabel();
            Label finallyLabel = clinitgen.newLabel();
            if (fn.constants.count() > 0) {
                fn.emitConstants(clinitgen);
            }
            clinitgen.invokeStatic(Type.getType(Compiler.class), clojure.asm.commons.Method.getMethod("void pushNS()"));
            clinitgen.mark(startTry);
            clinitgen.invokeStatic(fn.fntype, clojure.asm.commons.Method.getMethod("void load()"));
            clinitgen.mark(endTry);
            clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
            clinitgen.goTo(end);
            clinitgen.mark(finallyLabel);
            clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
            clinitgen.throwException();
            clinitgen.mark(end);
            clinitgen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
            clinitgen.returnValue();
            clinitgen.endMethod();
            cv.visitEnd();
            Compiler.writeClassFile(fn.internalName, cw.toByteArray());
        }
        catch (LispReader.ReaderException e) {
            throw new CompilerException(sourceName, e.line, e.getCause());
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    static {
        KEYWORD_TYPE = Type.getType(Keyword.class);
        VAR_TYPE = Type.getType(Var.class);
        SYMBOL_TYPE = Type.getType(Symbol.class);
        IFN_TYPE = Type.getType(IFn.class);
        RT_TYPE = Type.getType(RT.class);
        CLASS_TYPE = Type.getType(Class.class);
        REFLECTOR_TYPE = Type.getType(Reflector.class);
        THROWABLE_TYPE = Type.getType(Throwable.class);
        BOOLEAN_OBJECT_TYPE = Type.getType(Boolean.class);
        IPERSISTENTMAP_TYPE = Type.getType(IPersistentMap.class);
        IOBJ_TYPE = Type.getType(IObj.class);
        EXCEPTION_TYPES = new Type[]{Type.getType(Exception.class)};
        OBJECT_TYPE = Type.getType(Object.class);
        ARG_TYPES = new Type[22][];
        for (int i = 0; i <= 20; ++i) {
            Type[] a = new Type[i];
            for (int j = 0; j < i; ++j) {
                a[j] = OBJECT_TYPE;
            }
            Compiler.ARG_TYPES[i] = a;
        }
        Type[] a = new Type[21];
        for (int j = 0; j < 20; ++j) {
            a[j] = OBJECT_TYPE;
        }
        a[20] = Type.getType("[Ljava/lang/Object;");
        Compiler.ARG_TYPES[21] = a;
        LOCAL_ENV = Var.create(null);
        LOOP_LOCALS = Var.create();
        LOOP_LABEL = Var.create();
        CONSTANTS = Var.create();
        KEYWORDS = Var.create();
        VARS = Var.create();
        METHOD = Var.create(null);
        IN_CATCH_FINALLY = Var.create(null);
        SOURCE = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*source-path*"), "NO_SOURCE_FILE");
        SOURCE_PATH = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*file*"), null);
        COMPILE_PATH = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*compile-path*"), null);
        COMPILE_FILES = Var.intern(Namespace.findOrCreate(Symbol.create("clojure.core")), Symbol.create("*compile-files*"), Boolean.FALSE);
        LINE = Var.create(0);
        LINE_BEFORE = Var.create(0);
        LINE_AFTER = Var.create(0);
        NEXT_LOCAL_NUM = Var.create(0);
        RET_LOCAL_NUM = Var.create();
        LOADER = Var.create();
        NIL_EXPR = new NilExpr();
        TRUE_EXPR = new BooleanExpr(true);
        FALSE_EXPR = new BooleanExpr(false);
        CHAR_MAP = PersistentHashMap.create(Character.valueOf('-'), "_", Character.valueOf(':'), "_COLON_", Character.valueOf('+'), "_PLUS_", Character.valueOf('>'), "_GT_", Character.valueOf('<'), "_LT_", Character.valueOf('='), "_EQ_", Character.valueOf('~'), "_TILDE_", Character.valueOf('!'), "_BANG_", Character.valueOf('@'), "_CIRCA_", Character.valueOf('#'), "_SHARP_", Character.valueOf('$'), "_DOLLARSIGN_", Character.valueOf('%'), "_PERCENT_", Character.valueOf('^'), "_CARET_", Character.valueOf('&'), "_AMPERSAND_", Character.valueOf('*'), "_STAR_", Character.valueOf('|'), "_BAR_", Character.valueOf('{'), "_LBRACE_", Character.valueOf('}'), "_RBRACE_", Character.valueOf('['), "_LBRACK_", Character.valueOf(']'), "_RBRACK_", Character.valueOf('/'), "_SLASH_", Character.valueOf('\\'), "_BSLASH_", Character.valueOf('?'), "_QMARK_");
    }

    public static class CompilerException
    extends Exception {
        public CompilerException(String source, int line, Throwable cause) {
            super(Compiler.errorMsg(source, line, cause.toString()), cause);
        }

        public String toString() {
            return this.getMessage();
        }
    }

    public static class RecurExpr
    implements Expr {
        public final IPersistentVector args;
        public final IPersistentVector loopLocals;

        public RecurExpr(IPersistentVector loopLocals, IPersistentVector args) {
            this.loopLocals = loopLocals;
            this.args = args;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval recur");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            LocalBinding lb;
            int i;
            Label loopLabel = (Label)LOOP_LABEL.deref();
            if (loopLabel == null) {
                throw new IllegalStateException();
            }
            for (i = 0; i < this.loopLocals.count(); ++i) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Expr arg = (Expr)this.args.nth(i);
                if (lb.getPrimitiveType() != null) {
                    Class primc = lb.getPrimitiveType();
                    try {
                        if (!(arg instanceof MaybePrimitiveExpr) || !arg.hasJavaClass() || arg.getJavaClass() != primc) {
                            throw new IllegalArgumentException("recur arg for primitive local: " + lb.name + " must be matching primitive");
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    ((MaybePrimitiveExpr)((Object)arg)).emitUnboxed(C.EXPRESSION, fn, gen);
                    continue;
                }
                arg.emit(C.EXPRESSION, fn, gen);
            }
            for (i = this.loopLocals.count() - 1; i >= 0; --i) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Class primc = lb.getPrimitiveType();
                if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), lb.idx);
                    continue;
                }
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), lb.idx);
            }
            gen.goTo(loopLabel);
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return null;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                IPersistentVector loopLocals = (IPersistentVector)LOOP_LOCALS.deref();
                if (context != C.RETURN || loopLocals == null) {
                    throw new UnsupportedOperationException("Can only recur from tail position");
                }
                if (IN_CATCH_FINALLY.deref() != null) {
                    throw new UnsupportedOperationException("Cannot recur from catch/finally");
                }
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.seq(form.next()); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(C.EXPRESSION, s.first()));
                }
                if (args.count() != loopLocals.count()) {
                    throw new IllegalArgumentException(String.format("Mismatched argument count to recur, expected: %d args, got: %d", loopLocals.count(), args.count()));
                }
                return new RecurExpr(loopLocals, args);
            }
        }
    }

    public static class LetExpr
    implements Expr {
        public final PersistentVector bindingInits;
        public final Expr body;
        public final boolean isLoop;

        public LetExpr(PersistentVector bindingInits, Expr body, boolean isLoop) {
            this.bindingInits = bindingInits;
            this.body = body;
            this.isLoop = isLoop;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval let/loop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            for (int i = 0; i < this.bindingInits.count(); ++i) {
                BindingInit bi = (BindingInit)this.bindingInits.nth(i);
                Class primc = Compiler.maybePrimitiveType(bi.init);
                if (primc != null) {
                    ((MaybePrimitiveExpr)((Object)bi.init)).emitUnboxed(C.EXPRESSION, fn, gen);
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), bi.binding.idx);
                    continue;
                }
                bi.init.emit(C.EXPRESSION, fn, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
            }
            Label loopLabel = gen.mark();
            if (this.isLoop) {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel));
                    this.body.emit(context, fn, gen);
                }
                finally {
                    Var.popThreadBindings();
                }
            } else {
                this.body.emit(context, fn, gen);
            }
            Label end = gen.mark();
            for (ISeq bis = this.bindingInits.seq(); bis != null; bis = bis.next()) {
                Class primc;
                BindingInit bi = (BindingInit)bis.first();
                String lname = bi.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = lname + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, loopLabel, end, bi.binding.idx);
                    continue;
                }
                gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, loopLabel, end, bi.binding.idx);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.body.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.body.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                boolean isLoop = RT.first(form).equals(LOOP);
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL || context == C.EXPRESSION && isLoop) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref());
                if (isLoop) {
                    dynamicBindings = dynamicBindings.assoc(LOOP_LOCALS, null);
                }
                try {
                    Var.pushThreadBindings(dynamicBindings);
                    PersistentVector bindingInits = PersistentVector.EMPTY;
                    PersistentVector loopLocals = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        if (!(bindings.nth(i) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                        }
                        Symbol sym = (Symbol)bindings.nth(i);
                        if (sym.getNamespace() != null) {
                            throw new Exception("Can't let qualified name: " + sym);
                        }
                        Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                        LocalBinding lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), init);
                        BindingInit bi = new BindingInit(lb, init);
                        bindingInits = bindingInits.cons(bi);
                        if (!isLoop) continue;
                        loopLocals = loopLocals.cons(lb);
                    }
                    if (isLoop) {
                        LOOP_LOCALS.set(loopLocals);
                    }
                    LetExpr letExpr = new LetExpr(bindingInits, new BodyExpr.Parser().parse(isLoop ? C.RETURN : context, body), isLoop);
                    return letExpr;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }
    }

    public static class LetFnExpr
    implements Expr {
        public final PersistentVector bindingInits;
        public final Expr body;

        public LetFnExpr(PersistentVector bindingInits, Expr body) {
            this.bindingInits = bindingInits;
            this.body = body;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval letfns");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            BindingInit bi;
            int i;
            for (int i2 = 0; i2 < this.bindingInits.count(); ++i2) {
                BindingInit bi2 = (BindingInit)this.bindingInits.nth(i2);
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi2.binding.idx);
            }
            IPersistentSet lbset = PersistentHashSet.EMPTY;
            for (i = 0; i < this.bindingInits.count(); ++i) {
                bi = (BindingInit)this.bindingInits.nth(i);
                lbset = (IPersistentSet)lbset.cons(bi.binding);
                bi.init.emit(C.EXPRESSION, fn, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
            }
            for (i = 0; i < this.bindingInits.count(); ++i) {
                bi = (BindingInit)this.bindingInits.nth(i);
                FnExpr fe = (FnExpr)bi.init;
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), bi.binding.idx);
                fe.emitLetFnInits(gen, fn, lbset);
            }
            Label loopLabel = gen.mark();
            this.body.emit(context, fn, gen);
            Label end = gen.mark();
            for (ISeq bis = this.bindingInits.seq(); bis != null; bis = bis.next()) {
                Class primc;
                BindingInit bi3 = (BindingInit)bis.first();
                String lname = bi3.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = lname + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi3.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, loopLabel, end, bi3.binding.idx);
                    continue;
                }
                gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, loopLabel, end, bi3.binding.idx);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.body.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.body.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref());
                try {
                    Var.pushThreadBindings(dynamicBindings);
                    PersistentVector lbs = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        if (!(bindings.nth(i) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                        }
                        Symbol sym = (Symbol)bindings.nth(i);
                        if (sym.getNamespace() != null) {
                            throw new Exception("Can't let qualified name: " + sym);
                        }
                        LocalBinding lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), null);
                        lbs = lbs.cons(lb);
                    }
                    PersistentVector bindingInits = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        Symbol sym = (Symbol)bindings.nth(i);
                        Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                        LocalBinding lb = (LocalBinding)lbs.nth(i / 2);
                        lb.init = init;
                        BindingInit bi = new BindingInit(lb, init);
                        bindingInits = bindingInits.cons(bi);
                    }
                    LetFnExpr letFnExpr = new LetFnExpr(bindingInits, new BodyExpr.Parser().parse(context, body));
                    return letFnExpr;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }
    }

    public static class BindingInit {
        LocalBinding binding;
        Expr init;

        public final LocalBinding binding() {
            return this.binding;
        }

        public final Expr init() {
            return this.init;
        }

        public BindingInit(LocalBinding binding, Expr init) {
            this.binding = binding;
            this.init = init;
        }
    }

    public static class BodyExpr
    implements Expr {
        PersistentVector exprs;

        public final PersistentVector exprs() {
            return this.exprs;
        }

        public BodyExpr(PersistentVector exprs) {
            this.exprs = exprs;
        }

        public Object eval() throws Exception {
            Object ret = null;
            for (Object o : this.exprs) {
                Expr e = (Expr)o;
                ret = e.eval();
            }
            return ret;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            for (int i = 0; i < this.exprs.count() - 1; ++i) {
                Expr e = (Expr)this.exprs.nth(i);
                e.emit(C.STATEMENT, fn, gen);
            }
            Expr last = (Expr)this.exprs.nth(this.exprs.count() - 1);
            last.emit(context, fn, gen);
        }

        public boolean hasJavaClass() throws Exception {
            return this.lastExpr().hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.lastExpr().getJavaClass();
        }

        private Expr lastExpr() {
            return (Expr)this.exprs.nth(this.exprs.count() - 1);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frms) throws Exception {
                ISeq forms = (ISeq)frms;
                if (Util.equals(RT.first(forms), DO)) {
                    forms = RT.next(forms);
                }
                PersistentVector exprs = PersistentVector.EMPTY;
                while (forms != null) {
                    Expr e = context != C.EVAL && (context == C.STATEMENT || forms.next() != null) ? Compiler.analyze(C.STATEMENT, forms.first()) : Compiler.analyze(context, forms.first());
                    exprs = exprs.cons(e);
                    forms = forms.next();
                }
                if (exprs.count() == 0) {
                    exprs = exprs.cons(NIL_EXPR);
                }
                return new BodyExpr(exprs);
            }
        }
    }

    public static class LocalBindingExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final LocalBinding b;
        public final Symbol tag;

        public LocalBindingExpr(LocalBinding b, Symbol tag) throws Exception {
            if (b.getPrimitiveType() != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a primitive local");
            }
            this.b = b;
            this.tag = tag;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        public void emitUnboxed(C context, FnExpr fn, GeneratorAdapter gen) {
            fn.emitUnboxedLocal(gen, this.b);
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                fn.emitLocal(gen, this.b);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.tag != null || this.b.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            if (this.tag != null) {
                return HostExpr.tagToClass(this.tag);
            }
            return this.b.getJavaClass();
        }
    }

    public static class LocalBinding {
        public final Symbol sym;
        public final Symbol tag;
        public Expr init;
        public final int idx;
        public final String name;

        public LocalBinding(int num, Symbol sym, Symbol tag, Expr init) throws Exception {
            if (Compiler.maybePrimitiveType(init) != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a local with a primitive initializer");
            }
            this.idx = num;
            this.sym = sym;
            this.tag = tag;
            this.init = init;
            this.name = Compiler.munge(sym.name);
        }

        public boolean hasJavaClass() throws Exception {
            if (this.init != null && this.init.hasJavaClass() && Util.isPrimitive(this.init.getJavaClass()) && !(this.init instanceof MaybePrimitiveExpr)) {
                return false;
            }
            return this.tag != null || this.init != null && this.init.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.init.getJavaClass();
        }

        public Class getPrimitiveType() {
            return Compiler.maybePrimitiveType(this.init);
        }
    }

    public static class FnMethod {
        public final FnMethod parent;
        IPersistentMap locals = null;
        IPersistentMap indexlocals = null;
        PersistentVector reqParms = PersistentVector.EMPTY;
        LocalBinding restParm = null;
        Expr body = null;
        FnExpr fn;
        PersistentVector argLocals;
        int maxLocal = 0;
        int line;
        PersistentHashSet localsUsedInCatchFinally = PersistentHashSet.EMPTY;

        public final IPersistentMap locals() {
            return this.locals;
        }

        public final PersistentVector reqParms() {
            return this.reqParms;
        }

        public final LocalBinding restParm() {
            return this.restParm;
        }

        public final Expr body() {
            return this.body;
        }

        public final FnExpr fn() {
            return this.fn;
        }

        public final PersistentVector argLocals() {
            return this.argLocals;
        }

        public final int maxLocal() {
            return this.maxLocal;
        }

        public final int line() {
            return this.line;
        }

        public FnMethod(FnExpr fn, FnMethod parent) {
            this.parent = parent;
            this.fn = fn;
        }

        boolean isVariadic() {
            return this.restParm != null;
        }

        int numParams() {
            return this.reqParms.count() + (this.isVariadic() ? 1 : 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FnMethod parse(FnExpr fn, ISeq form) throws Exception {
            IPersistentVector parms = (IPersistentVector)RT.first(form);
            ISeq body = RT.next(form);
            try {
                FnMethod method = new FnMethod(fn, (FnMethod)METHOD.deref());
                method.line = (Integer)LINE.deref();
                Var.pushThreadBindings(RT.map(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0));
                Compiler.registerLocal(Symbol.intern(fn.thisName != null ? fn.thisName : "fn__" + RT.nextID()), null, null);
                PSTATE state = PSTATE.REQ;
                PersistentVector argLocals = PersistentVector.EMPTY;
                block7: for (int i = 0; i < parms.count(); ++i) {
                    if (!(parms.nth(i) instanceof Symbol)) {
                        throw new IllegalArgumentException("fn params must be Symbols");
                    }
                    Symbol p = (Symbol)parms.nth(i);
                    if (p.getNamespace() != null) {
                        throw new Exception("Can't use qualified name as parameter: " + p);
                    }
                    if (p.equals(_AMP_)) {
                        if (state == PSTATE.REQ) {
                            state = PSTATE.REST;
                            continue;
                        }
                        throw new Exception("Invalid parameter list");
                    }
                    LocalBinding lb = Compiler.registerLocal(p, state == PSTATE.REST ? ISEQ : Compiler.tagOf(p), null);
                    argLocals = argLocals.cons(lb);
                    switch (state) {
                        case REQ: {
                            method.reqParms = method.reqParms.cons(lb);
                            continue block7;
                        }
                        case REST: {
                            method.restParm = lb;
                            state = PSTATE.DONE;
                            continue block7;
                        }
                        default: {
                            throw new Exception("Unexpected parameter");
                        }
                    }
                }
                if (method.reqParms.count() > 20) {
                    throw new Exception("Can't specify more than 20 params");
                }
                LOOP_LOCALS.set(argLocals);
                method.argLocals = argLocals;
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                FnMethod fnMethod = method;
                return fnMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit(FnExpr fn, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.isVariadic() ? "doInvoke" : "invoke", OBJECT_TYPE, ARG_TYPES[this.numParams()]);
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                this.body.emit(C.RETURN, fn, gen);
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, "Ljava/lang/Object;", null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
        }

        void emitClearLocals(GeneratorAdapter gen) {
            int i;
            for (i = 1; i < this.numParams() + 1; ++i) {
                if (this.localsUsedInCatchFinally.contains(i)) continue;
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), i);
            }
            for (i = this.numParams() + 1; i < this.maxLocal + 1; ++i) {
                LocalBinding b;
                if (this.localsUsedInCatchFinally.contains(i) || (b = (LocalBinding)RT.get(this.indexlocals, i)) != null && Compiler.maybePrimitiveType(b.init) != null) continue;
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), i);
            }
            if (this.fn.onceOnly) {
                this.fn.emitClearCloses(gen);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PSTATE {
        REQ,
        REST,
        DONE;

    }

    public static class FnExpr
    implements Expr {
        static final String CONST_PREFIX = "const__";
        IPersistentCollection methods;
        FnMethod variadicMethod = null;
        String name;
        String simpleName;
        String internalName;
        String thisName;
        Type fntype;
        public final Object tag;
        IPersistentMap closes = PersistentHashMap.EMPTY;
        IPersistentMap keywords = PersistentHashMap.EMPTY;
        IPersistentMap vars = PersistentHashMap.EMPTY;
        Class compiledClass;
        int line;
        PersistentVector constants;
        int constantsID;
        boolean onceOnly = false;
        String superName = null;
        static final clojure.asm.commons.Method kwintern = clojure.asm.commons.Method.getMethod("clojure.lang.Keyword intern(String, String)");
        static final clojure.asm.commons.Method symcreate = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String)");
        static final clojure.asm.commons.Method varintern = clojure.asm.commons.Method.getMethod("clojure.lang.Var intern(clojure.lang.Symbol, clojure.lang.Symbol)");
        static final clojure.asm.commons.Method afnctor = clojure.asm.commons.Method.getMethod("void <init>()");
        static final clojure.asm.commons.Method restfnctor = clojure.asm.commons.Method.getMethod("void <init>(int)");
        static final Type aFnType = Type.getType(AFunction.class);
        static final Type restFnType = Type.getType(RestFn.class);
        static final Type DYNAMIC_CLASSLOADER_TYPE = Type.getType(DynamicClassLoader.class);
        static final clojure.asm.commons.Method getClassMethod = clojure.asm.commons.Method.getMethod("Class getClass()");
        static final clojure.asm.commons.Method getClassLoaderMethod = clojure.asm.commons.Method.getMethod("ClassLoader getClassLoader()");
        static final clojure.asm.commons.Method getConstantsMethod = clojure.asm.commons.Method.getMethod("Object[] getConstants(int)");
        static final clojure.asm.commons.Method readStringMethod = clojure.asm.commons.Method.getMethod("Object readString(String)");
        private DynamicClassLoader loader;
        private byte[] bytecode;

        public final IPersistentCollection methods() {
            return this.methods;
        }

        public final FnMethod variadicMethod() {
            return this.variadicMethod;
        }

        public final String name() {
            return this.name;
        }

        public final String simpleName() {
            return this.simpleName;
        }

        public final String internalName() {
            return this.internalName;
        }

        public final String thisName() {
            return this.thisName;
        }

        public final Type fntype() {
            return this.fntype;
        }

        public final IPersistentMap closes() {
            return this.closes;
        }

        public final IPersistentMap keywords() {
            return this.keywords;
        }

        public final IPersistentMap vars() {
            return this.vars;
        }

        public final Class compiledClass() {
            return this.compiledClass;
        }

        public final int line() {
            return this.line;
        }

        public final PersistentVector constants() {
            return this.constants;
        }

        public final int constantsID() {
            return this.constantsID;
        }

        public FnExpr(Object tag) {
            this.tag = tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Expr parse(C context, ISeq form, String name) throws Exception {
            String basename;
            FnExpr fn = new FnExpr(Compiler.tagOf(form));
            FnMethod enclosingMethod = (FnMethod)METHOD.deref();
            if (((IMeta)form.first()).meta() != null) {
                fn.onceOnly = RT.booleanCast(RT.get(RT.meta(form.first()), Keyword.intern(null, "once")));
                fn.superName = (String)RT.get(RT.meta(form.first()), Keyword.intern(null, "super-name"));
            }
            String string = basename = enclosingMethod != null ? enclosingMethod.fn.name + "$" : Compiler.munge(Compiler.currentNS().name.name) + "$";
            if (RT.second(form) instanceof Symbol) {
                name = ((Symbol)RT.second((Object)form)).name;
            }
            fn.simpleName = (name != null ? Compiler.munge(name).replace(".", "_DOT_") : "fn") + "__" + RT.nextID();
            fn.name = basename + fn.simpleName;
            fn.internalName = fn.name.replace('.', '/');
            fn.fntype = Type.getObjectType(fn.internalName);
            try {
                Var.pushThreadBindings(RT.map(CONSTANTS, PersistentVector.EMPTY, KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY));
                if (RT.second(form) instanceof Symbol) {
                    fn.thisName = ((Symbol)RT.second((Object)form)).name;
                    form = RT.cons(FN, RT.next(RT.next(form)));
                }
                if (RT.second(form) instanceof IPersistentVector) {
                    form = RT.list(FN, RT.next(form));
                }
                fn.line = (Integer)LINE.deref();
                FnMethod[] methodArray = new FnMethod[21];
                FnMethod variadicMethod = null;
                ISeq s = RT.next(form);
                while (s != null) {
                    FnMethod f = FnMethod.parse(fn, (ISeq)RT.first(s));
                    if (f.isVariadic()) {
                        if (variadicMethod != null) throw new Exception("Can't have more than 1 variadic overload");
                        variadicMethod = f;
                    } else {
                        if (methodArray[f.reqParms.count()] != null) throw new Exception("Can't have 2 overloads with same arity");
                        methodArray[f.reqParms.count()] = f;
                    }
                    s = RT.next(s);
                }
                if (variadicMethod != null) {
                    for (int i = variadicMethod.reqParms.count() + 1; i <= 20; ++i) {
                        if (methodArray[i] == null) continue;
                        throw new Exception("Can't have fixed arity function with more params than variadic function");
                    }
                }
                IPersistentCollection methods = null;
                for (int i = 0; i < methodArray.length; ++i) {
                    if (methodArray[i] == null) continue;
                    methods = RT.conj(methods, methodArray[i]);
                }
                if (variadicMethod != null) {
                    methods = RT.conj(methods, variadicMethod);
                }
                fn.methods = methods;
                fn.variadicMethod = variadicMethod;
                fn.keywords = (IPersistentMap)KEYWORDS.deref();
                fn.vars = (IPersistentMap)VARS.deref();
                fn.constants = (PersistentVector)CONSTANTS.deref();
                fn.constantsID = RT.nextID();
            }
            finally {
                Var.popThreadBindings();
            }
            fn.compile();
            return fn;
        }

        boolean isVariadic() {
            return this.variadicMethod != null;
        }

        Type[] ctorTypes() {
            if (this.closes.count() == 0) {
                return ARG_TYPES[0];
            }
            PersistentVector tv = PersistentVector.EMPTY;
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                tv = lb.getPrimitiveType() != null ? tv.cons(Type.getType(lb.getPrimitiveType())) : tv.cons(OBJECT_TYPE);
            }
            Type[] ret = new Type[tv.count()];
            for (int i = 0; i < tv.count(); ++i) {
                ret[i] = (Type)tv.nth(i);
            }
            return ret;
        }

        private void compile() throws Exception {
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(1);
            cv.visit(49, 33, this.internalName, null, this.superName != null ? this.superName : (this.isVariadic() ? "clojure/lang/RestFn" : "clojure/lang/AFunction"), null);
            String source = (String)SOURCE.deref();
            int lineBefore = (Integer)LINE_BEFORE.deref();
            int lineAfter = (Integer)LINE_AFTER.deref() + 1;
            if (source != null && SOURCE_PATH.deref() != null) {
                String smap = "SMAP\n" + (source.lastIndexOf(46) > 0 ? source.substring(0, source.lastIndexOf(46)) : this.simpleName) + ".java\n" + "Clojure\n" + "*S Clojure\n" + "*F\n" + "+ 1 " + source + "\n" + (String)SOURCE_PATH.deref() + "\n" + "*L\n" + String.format("%d#1,%d:%d\n", lineBefore, lineAfter - lineBefore, lineBefore) + "*E";
                cv.visitSource(source, smap);
            }
            for (int i = 0; i < this.constants.count(); ++i) {
                cv.visitField(25, this.constantName(i), this.constantType(i).getDescriptor(), null, null);
            }
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            clinitgen.visitLineNumber(this.line, clinitgen.mark());
            if (this.constants.count() > 0) {
                this.emitConstants(clinitgen);
            }
            clinitgen.returnValue();
            clinitgen.endMethod();
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (lb.getPrimitiveType() != null) {
                    cv.visitField(1, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    continue;
                }
                cv.visitField(1, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes());
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            Label start = ctorgen.newLabel();
            Label end = ctorgen.newLabel();
            ctorgen.visitCode();
            ctorgen.visitLineNumber(this.line, ctorgen.mark());
            ctorgen.visitLabel(start);
            ctorgen.loadThis();
            if (this.superName != null) {
                ctorgen.invokeConstructor(Type.getObjectType(this.superName), afnctor);
            } else if (this.isVariadic()) {
                ctorgen.push(this.variadicMethod.reqParms.count());
                ctorgen.invokeConstructor(restFnType, restfnctor);
            } else {
                ctorgen.invokeConstructor(aFnType, afnctor);
            }
            int a = 1;
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                LocalBinding lb = (LocalBinding)s.first();
                ctorgen.loadThis();
                Class primc = lb.getPrimitiveType();
                if (primc != null) {
                    ctorgen.visitVarInsn(Type.getType(primc).getOpcode(21), a);
                    ctorgen.putField(this.fntype, lb.name, Type.getType(primc));
                    if (primc == Long.TYPE || primc == Double.TYPE) {
                        ++a;
                    }
                } else {
                    ctorgen.visitVarInsn(OBJECT_TYPE.getOpcode(21), a);
                    ctorgen.putField(this.fntype, lb.name, OBJECT_TYPE);
                }
                s = s.next();
                ++a;
            }
            ctorgen.visitLabel(end);
            ctorgen.returnValue();
            ctorgen.endMethod();
            for (s = RT.seq(this.methods); s != null; s = s.next()) {
                FnMethod method = (FnMethod)s.first();
                method.emit(this, cv);
            }
            cv.visitEnd();
            this.bytecode = cw.toByteArray();
            if (RT.booleanCast(COMPILE_FILES.deref())) {
                Compiler.writeClassFile(this.internalName, this.bytecode);
            }
        }

        void emitListAsObjectArray(Object value, GeneratorAdapter gen) {
            gen.push(((List)value).size());
            gen.newArray(OBJECT_TYPE);
            int i = 0;
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                gen.dup();
                gen.push(i);
                this.emitValue(it.next(), gen);
                gen.arrayStore(OBJECT_TYPE);
                ++i;
            }
        }

        void emitValue(Object value, GeneratorAdapter gen) {
            boolean partial = true;
            if (value instanceof String) {
                gen.push((String)value);
            } else if (value instanceof Integer) {
                gen.push((Integer)value);
                gen.invokeStatic(Type.getType(Integer.class), clojure.asm.commons.Method.getMethod("Integer valueOf(int)"));
            } else if (value instanceof Double) {
                gen.push((Double)value);
                gen.invokeStatic(Type.getType(Double.class), clojure.asm.commons.Method.getMethod("Double valueOf(double)"));
            } else if (value instanceof Character) {
                gen.push(((Character)value).charValue());
                gen.invokeStatic(Type.getType(Character.class), clojure.asm.commons.Method.getMethod("Character valueOf(char)"));
            } else if (value instanceof Class) {
                gen.push(((Class)value).getName());
                gen.invokeStatic(Type.getType(Class.class), clojure.asm.commons.Method.getMethod("Class forName(String)"));
            } else if (value instanceof Symbol) {
                gen.push(((Symbol)value).ns);
                gen.push(((Symbol)value).name);
                gen.invokeStatic(Type.getType(Symbol.class), clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String,String)"));
            } else if (value instanceof Keyword) {
                this.emitValue(((Keyword)value).sym, gen);
                gen.invokeStatic(Type.getType(Keyword.class), clojure.asm.commons.Method.getMethod("clojure.lang.Keyword intern(clojure.lang.Symbol)"));
            } else if (value instanceof Var) {
                Var var = (Var)value;
                gen.push(var.ns.name.toString());
                gen.push(var.sym.toString());
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Var var(String,String)"));
            } else if (value instanceof IPersistentMap) {
                ArrayList<Object> entries = new ArrayList<Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    entries.add(entry.getKey());
                    entries.add(entry.getValue());
                }
                this.emitListAsObjectArray(entries, gen);
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])"));
            } else if (value instanceof IPersistentVector) {
                this.emitListAsObjectArray(value, gen);
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])"));
            } else if (value instanceof ISeq || value instanceof IPersistentList) {
                this.emitListAsObjectArray(value, gen);
                gen.invokeStatic(Type.getType(Arrays.class), clojure.asm.commons.Method.getMethod("java.util.List asList(Object[])"));
                gen.invokeStatic(Type.getType(PersistentList.class), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentList create(java.util.List)"));
            } else {
                String cs = null;
                try {
                    cs = RT.printString(value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't embed object in code, maybe print-dup not defined: " + value);
                }
                if (cs.length() == 0) {
                    throw new RuntimeException("Can't embed unreadable object in code: " + value);
                }
                if (cs.startsWith("#<")) {
                    throw new RuntimeException("Can't embed unreadable object in code: " + cs);
                }
                gen.push(cs);
                gen.invokeStatic(RT_TYPE, readStringMethod);
                partial = false;
            }
            if (partial && value instanceof Obj && RT.count(((Obj)value).meta()) > 0) {
                gen.checkCast(IOBJ_TYPE);
                this.emitValue(((Obj)value).meta(), gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeInterface(IOBJ_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitConstants(GeneratorAdapter clinitgen) {
            try {
                Var.pushThreadBindings(RT.map(RT.PRINT_DUP, RT.T));
                for (int i = 0; i < this.constants.count(); ++i) {
                    this.emitValue(this.constants.nth(i), clinitgen);
                    clinitgen.checkCast(this.constantType(i));
                    clinitgen.putStatic(this.fntype, this.constantName(i), this.constantType(i));
                }
            }
            finally {
                Var.popThreadBindings();
            }
        }

        void emitClearCloses(GeneratorAdapter gen) {
            int a = 1;
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                LocalBinding lb = (LocalBinding)s.first();
                Class primc = lb.getPrimitiveType();
                if (primc == null) {
                    gen.loadThis();
                    gen.visitInsn(1);
                    gen.putField(this.fntype, lb.name, OBJECT_TYPE);
                }
                s = s.next();
                ++a;
            }
        }

        synchronized Class getCompiledClass() {
            if (this.compiledClass == null) {
                try {
                    if (RT.booleanCast(COMPILE_FILES.deref())) {
                        this.compiledClass = RT.classForName(this.name);
                    } else {
                        this.loader = (DynamicClassLoader)LOADER.deref();
                        this.compiledClass = this.loader.defineClass(this.name, this.bytecode);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.compiledClass;
        }

        public Object eval() throws Exception {
            return this.getCompiledClass().newInstance();
        }

        public void emitLetFnInits(GeneratorAdapter gen, FnExpr fn, IPersistentSet letFnLocals) {
            gen.checkCast(this.fntype);
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (!letFnLocals.contains(lb)) continue;
                Class primc = lb.getPrimitiveType();
                gen.dup();
                if (primc != null) {
                    fn.emitUnboxedLocal(gen, lb);
                    gen.putField(this.fntype, lb.name, Type.getType(primc));
                    continue;
                }
                fn.emitLocal(gen, lb);
                gen.putField(this.fntype, lb.name, OBJECT_TYPE);
            }
            gen.pop();
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            this.getCompiledClass();
            gen.newInstance(this.fntype);
            gen.dup();
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (lb.getPrimitiveType() != null) {
                    fn.emitUnboxedLocal(gen, lb);
                    continue;
                }
                fn.emitLocal(gen, lb);
            }
            gen.invokeConstructor(this.fntype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes()));
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : IFn.class;
        }

        private void emitLocal(GeneratorAdapter gen, LocalBinding lb) {
            if (this.closes.containsKey(lb)) {
                Class primc = lb.getPrimitiveType();
                gen.loadThis();
                if (primc != null) {
                    gen.getField(this.fntype, lb.name, Type.getType(primc));
                    HostExpr.emitBoxReturn(this, gen, primc);
                } else {
                    gen.getField(this.fntype, lb.name, OBJECT_TYPE);
                }
            } else {
                Class primc = lb.getPrimitiveType();
                if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
                    HostExpr.emitBoxReturn(this, gen, primc);
                } else {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), lb.idx);
                }
            }
        }

        private void emitUnboxedLocal(GeneratorAdapter gen, LocalBinding lb) {
            Class primc = lb.getPrimitiveType();
            if (this.closes.containsKey(lb)) {
                gen.loadThis();
                gen.getField(this.fntype, lb.name, Type.getType(primc));
            } else {
                gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
            }
        }

        public void emitVar(GeneratorAdapter gen, Var var) {
            Integer i = (Integer)this.vars.valAt(var);
            this.emitConstant(gen, i);
        }

        public void emitKeyword(GeneratorAdapter gen, Keyword k) {
            Integer i = (Integer)this.keywords.valAt(k);
            this.emitConstant(gen, i);
        }

        public void emitConstant(GeneratorAdapter gen, int id) {
            gen.getStatic(this.fntype, this.constantName(id), this.constantType(id));
        }

        String constantName(int id) {
            return CONST_PREFIX + id;
        }

        Type constantType(int id) {
            Object o = this.constants.nth(id);
            Class<?> c = o.getClass();
            if (Modifier.isPublic(c.getModifiers())) {
                if (LazySeq.class.isAssignableFrom(c)) {
                    return Type.getType(ISeq.class);
                }
                if (RestFn.class.isAssignableFrom(c)) {
                    return Type.getType(RestFn.class);
                }
                if (AFn.class.isAssignableFrom(c)) {
                    return Type.getType(AFn.class);
                }
                if (c == Var.class) {
                    return Type.getType(Var.class);
                }
                if (c == String.class) {
                    return Type.getType(String.class);
                }
            }
            return OBJECT_TYPE;
        }
    }

    static class FnLoaderThunk
    extends RestFn {
        FnExpr fx;
        Var v;
        IFn f;

        FnLoaderThunk(FnExpr fx, Var v) {
            super(0);
            this.fx = fx;
            this.v = v;
        }

        protected Object doInvoke(Object args) throws Exception {
            IFn f = this.loadFn();
            return f.applyTo((ISeq)args);
        }

        private synchronized IFn loadFn() throws Exception {
            if (this.f == null) {
                Class fc = this.fx.getCompiledClass();
                this.f = (IFn)fc.newInstance();
                this.v.swapRoot(this.f);
            }
            return this.f;
        }
    }

    static class SourceDebugExtensionAttribute
    extends Attribute {
        public SourceDebugExtensionAttribute() {
            super("SourceDebugExtension");
        }

        void writeSMAP(ClassWriter cw, String smap) {
            ByteVector bv = this.write(cw, null, -1, -1, -1);
            bv.putUTF8(smap);
        }
    }

    static class InvokeExpr
    implements Expr {
        public final Expr fexpr;
        public final Object tag;
        public final IPersistentVector args;
        public final int line;
        public final String source;

        public InvokeExpr(String source, int line, Symbol tag, Expr fexpr, IPersistentVector args) {
            this.source = source;
            this.fexpr = fexpr;
            this.args = args;
            this.line = line;
            this.tag = tag != null ? tag : (fexpr instanceof VarExpr ? ((VarExpr)fexpr).tag : null);
        }

        public Object eval() throws Exception {
            try {
                IFn fn = (IFn)this.fexpr.eval();
                PersistentVector argvs = PersistentVector.EMPTY;
                for (int i = 0; i < this.args.count(); ++i) {
                    argvs = argvs.cons(((Expr)this.args.nth(i)).eval());
                }
                return fn.applyTo(RT.seq(argvs));
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e);
                }
                throw (CompilerException)e;
            }
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            this.fexpr.emit(C.EXPRESSION, fn, gen);
            gen.checkCast(IFN_TYPE);
            for (int i = 0; i < Math.min(20, this.args.count()); ++i) {
                Expr e = (Expr)this.args.nth(i);
                e.emit(C.EXPRESSION, fn, gen);
            }
            if (this.args.count() > 20) {
                PersistentVector restArgs = PersistentVector.EMPTY;
                for (int i = 20; i < this.args.count(); ++i) {
                    restArgs = restArgs.cons(this.args.nth(i));
                }
                MethodExpr.emitArgsAsArray(restArgs, fn, gen);
            }
            if (context == C.RETURN) {
                FnMethod method = (FnMethod)METHOD.deref();
                method.emitClearLocals(gen);
            }
            gen.invokeInterface(IFN_TYPE, new clojure.asm.commons.Method("invoke", OBJECT_TYPE, ARG_TYPES[Math.min(21, this.args.count())]));
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return HostExpr.tagToClass(this.tag);
        }

        public static Expr parse(C context, ISeq form) throws Exception {
            if (context != C.EVAL) {
                context = C.EXPRESSION;
            }
            Expr fexpr = Compiler.analyze(context, form.first());
            PersistentVector args = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form.next()); s != null; s = s.next()) {
                args = args.cons(Compiler.analyze(context, s.first()));
            }
            return new InvokeExpr((String)SOURCE.deref(), (Integer)LINE.deref(), Compiler.tagOf(form), fexpr, args);
        }
    }

    public static class VectorExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method vectorMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])");

        public VectorExpr(IPersistentVector args) {
            this.args = args;
        }

        public Object eval() throws Exception {
            IPersistentVector ret = PersistentVector.EMPTY;
            for (int i = 0; i < this.args.count(); ++i) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
            }
            return ret;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.args, fn, gen);
            gen.invokeStatic(RT_TYPE, vectorMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentVector.class;
        }

        public static Expr parse(C context, IPersistentVector form) throws Exception {
            IPersistentVector args = PersistentVector.EMPTY;
            for (int i = 0; i < form.count(); ++i) {
                args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, form.nth(i)));
            }
            VectorExpr ret = new VectorExpr(args);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            return ret;
        }
    }

    public static class SetExpr
    implements Expr {
        public final IPersistentVector keys;
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentSet set(Object[])");

        public SetExpr(IPersistentVector keys) {
            this.keys = keys;
        }

        public Object eval() throws Exception {
            Object[] ret = new Object[this.keys.count()];
            for (int i = 0; i < this.keys.count(); ++i) {
                ret[i] = ((Expr)this.keys.nth(i)).eval();
            }
            return RT.set(ret);
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.keys, fn, gen);
            gen.invokeStatic(RT_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentSet.class;
        }

        public static Expr parse(C context, IPersistentSet form) throws Exception {
            IPersistentVector keys = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                Object e = s.first();
                keys = keys.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e));
            }
            SetExpr ret = new SetExpr(keys);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            return ret;
        }
    }

    public static class MapExpr
    implements Expr {
        public final IPersistentVector keyvals;
        static final clojure.asm.commons.Method mapMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])");

        public MapExpr(IPersistentVector keyvals) {
            this.keyvals = keyvals;
        }

        public Object eval() throws Exception {
            Object[] ret = new Object[this.keyvals.count()];
            for (int i = 0; i < this.keyvals.count(); ++i) {
                ret[i] = ((Expr)this.keyvals.nth(i)).eval();
            }
            return RT.map(ret);
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.keyvals, fn, gen);
            gen.invokeStatic(RT_TYPE, mapMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentMap.class;
        }

        public static Expr parse(C context, IPersistentMap form) throws Exception {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                IMapEntry e = (IMapEntry)s.first();
                keyvals = keyvals.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e.key()));
                keyvals = keyvals.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e.val()));
            }
            MapExpr ret = new MapExpr(keyvals);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, (MapExpr)MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            return ret;
        }
    }

    public static class ListExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method arrayToListMethod = clojure.asm.commons.Method.getMethod("clojure.lang.ISeq arrayToList(Object[])");

        public ListExpr(IPersistentVector args) {
            this.args = args;
        }

        public Object eval() throws Exception {
            IPersistentVector ret = PersistentVector.EMPTY;
            for (int i = 0; i < this.args.count(); ++i) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
            }
            return ret.seq();
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.args, fn, gen);
            gen.invokeStatic(RT_TYPE, arrayToListMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return IPersistentList.class;
        }
    }

    public static class EmptyExpr
    implements Expr {
        public final Object coll;
        static final Type HASHMAP_TYPE = Type.getType(PersistentArrayMap.class);
        static final Type HASHSET_TYPE = Type.getType(PersistentHashSet.class);
        static final Type VECTOR_TYPE = Type.getType(PersistentVector.class);
        static final Type LIST_TYPE = Type.getType(PersistentList.class);
        static final Type EMPTY_LIST_TYPE = Type.getType(PersistentList.EmptyList.class);

        public EmptyExpr(Object coll) {
            this.coll = coll;
        }

        public Object eval() throws Exception {
            return this.coll;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            if (this.coll instanceof IPersistentList) {
                gen.getStatic(LIST_TYPE, "EMPTY", EMPTY_LIST_TYPE);
            } else if (this.coll instanceof IPersistentVector) {
                gen.getStatic(VECTOR_TYPE, "EMPTY", VECTOR_TYPE);
            } else if (this.coll instanceof IPersistentMap) {
                gen.getStatic(HASHMAP_TYPE, "EMPTY", HASHMAP_TYPE);
            } else if (this.coll instanceof IPersistentSet) {
                gen.getStatic(HASHSET_TYPE, "EMPTY", HASHSET_TYPE);
            } else {
                throw new UnsupportedOperationException("Unknown Collection type");
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return true;
        }

        public Class getJavaClass() throws Exception {
            if (this.coll instanceof IPersistentList) {
                return IPersistentList.class;
            }
            if (this.coll instanceof IPersistentVector) {
                return IPersistentVector.class;
            }
            if (this.coll instanceof IPersistentMap) {
                return IPersistentMap.class;
            }
            if (this.coll instanceof IPersistentSet) {
                return IPersistentSet.class;
            }
            throw new UnsupportedOperationException("Unknown Collection type");
        }
    }

    public static class IfExpr
    implements Expr {
        public final Expr testExpr;
        public final Expr thenExpr;
        public final Expr elseExpr;
        public final int line;

        public IfExpr(int line, Expr testExpr, Expr thenExpr, Expr elseExpr) {
            this.testExpr = testExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.line = line;
        }

        public Object eval() throws Exception {
            Object t = this.testExpr.eval();
            if (t != null && t != Boolean.FALSE) {
                return this.thenExpr.eval();
            }
            return this.elseExpr.eval();
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            Label nullLabel = gen.newLabel();
            Label falseLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            try {
                if (this.testExpr instanceof MaybePrimitiveExpr && this.testExpr.hasJavaClass() && this.testExpr.getJavaClass() == Boolean.TYPE) {
                    ((MaybePrimitiveExpr)((Object)this.testExpr)).emitUnboxed(C.EXPRESSION, fn, gen);
                    gen.ifZCmp(153, falseLabel);
                } else {
                    this.testExpr.emit(C.EXPRESSION, fn, gen);
                    gen.dup();
                    gen.ifNull(nullLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.visitJumpInsn(165, falseLabel);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.thenExpr.emit(context, fn, gen);
            gen.goTo(endLabel);
            gen.mark(nullLabel);
            gen.pop();
            gen.mark(falseLabel);
            this.elseExpr.emit(context, fn, gen);
            gen.mark(endLabel);
        }

        public boolean hasJavaClass() throws Exception {
            return this.thenExpr.hasJavaClass() && this.elseExpr.hasJavaClass() && (this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() || this.thenExpr.getJavaClass() == null || this.elseExpr.getJavaClass() == null);
        }

        public Class getJavaClass() throws Exception {
            Class thenClass = this.thenExpr.getJavaClass();
            if (thenClass != null) {
                return thenClass;
            }
            return this.elseExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (form.count() > 4) {
                    throw new Exception("Too many arguments to if");
                }
                if (form.count() < 3) {
                    throw new Exception("Too few arguments to if");
                }
                return new IfExpr((Integer)LINE.deref(), Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form)), Compiler.analyze(context, RT.third(form)), Compiler.analyze(context, RT.fourth(form)));
            }
        }
    }

    public static class MetaExpr
    implements Expr {
        public final Expr expr;
        public final MapExpr meta;
        static final Type IOBJ_TYPE = Type.getType(IObj.class);
        static final clojure.asm.commons.Method withMetaMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");

        public MetaExpr(Expr expr, MapExpr meta) {
            this.expr = expr;
            this.meta = meta;
        }

        public Object eval() throws Exception {
            return ((IObj)this.expr.eval()).withMeta((IPersistentMap)this.meta.eval());
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            this.expr.emit(C.EXPRESSION, fn, gen);
            gen.checkCast(IOBJ_TYPE);
            this.meta.emit(C.EXPRESSION, fn, gen);
            gen.checkCast(IPERSISTENTMAP_TYPE);
            gen.invokeInterface(IOBJ_TYPE, withMetaMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.expr.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.expr.getJavaClass();
        }
    }

    public static class NewExpr
    implements Expr {
        public final IPersistentVector args;
        public final Constructor ctor;
        public final Class c;
        static final clojure.asm.commons.Method invokeConstructorMethod = clojure.asm.commons.Method.getMethod("Object invokeConstructor(Class,Object[])");
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class classForName(String)");

        public NewExpr(Class c, IPersistentVector args, int line) throws Exception {
            this.args = args;
            this.c = c;
            Constructor<?>[] allctors = c.getConstructors();
            ArrayList ctors = new ArrayList();
            ArrayList<Class[]> params = new ArrayList<Class[]>();
            ArrayList<Class> rets = new ArrayList<Class>();
            for (int i = 0; i < allctors.length; ++i) {
                Constructor<?> ctor = allctors[i];
                if (ctor.getParameterTypes().length != args.count()) continue;
                ctors.add(ctor);
                params.add(ctor.getParameterTypes());
                rets.add(c);
            }
            if (ctors.isEmpty()) {
                throw new IllegalArgumentException("No matching ctor found for " + c);
            }
            int ctoridx = 0;
            if (ctors.size() > 1) {
                ctoridx = Compiler.getMatchingParams(c.getName(), params, args, rets);
            }
            Constructor constructor = this.ctor = ctoridx >= 0 ? (Constructor)ctors.get(ctoridx) : null;
            if (this.ctor == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                ((PrintWriter)RT.ERR.deref()).format("Reflection warning, line: %d - call to %s ctor can't be resolved.\n", line, c.getName());
            }
        }

        public Object eval() throws Exception {
            Object[] argvals = new Object[this.args.count()];
            for (int i = 0; i < this.args.count(); ++i) {
                argvals[i] = ((Expr)this.args.nth(i)).eval();
            }
            if (this.ctor != null) {
                return this.ctor.newInstance(Reflector.boxArgs(this.ctor.getParameterTypes(), argvals));
            }
            return Reflector.invokeConstructor(this.c, argvals);
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            if (this.ctor != null) {
                Type type = Type.getType(this.c);
                gen.newInstance(type);
                gen.dup();
                MethodExpr.emitTypedArgs(fn, gen, this.ctor.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeConstructor(type, new clojure.asm.commons.Method("<init>", Type.getConstructorDescriptor(this.ctor)));
            } else {
                gen.push(this.c.getName());
                gen.invokeStatic(RT_TYPE, forNameMethod);
                MethodExpr.emitArgsAsArray(this.args, fn, gen);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeConstructorMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return this.c;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                int line = (Integer)LINE.deref();
                ISeq form = (ISeq)frm;
                if (form.count() < 2) {
                    throw new Exception("wrong number of arguments, expecting: (new Classname args...)");
                }
                Class c = HostExpr.maybeClass(RT.second(form), false);
                if (c == null) {
                    throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(form));
                }
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.next(RT.next(form)); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                }
                return new NewExpr(c, args, line);
            }
        }
    }

    static class ThrowExpr
    extends UntypedExpr {
        public final Expr excExpr;

        public ThrowExpr(Expr excExpr) {
            this.excExpr = excExpr;
        }

        public Object eval() throws Exception {
            throw new Exception("Can't eval throw");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            this.excExpr.emit(C.EXPRESSION, fn, gen);
            gen.checkCast(THROWABLE_TYPE);
            gen.throwException();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                return new ThrowExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    public static class TryExpr
    implements Expr {
        public final Expr tryExpr;
        public final Expr finallyExpr;
        public final PersistentVector catchExprs;
        public final int retLocal;
        public final int finallyLocal;

        public TryExpr(Expr tryExpr, PersistentVector catchExprs, Expr finallyExpr, int retLocal, int finallyLocal) {
            this.tryExpr = tryExpr;
            this.catchExprs = catchExprs;
            this.finallyExpr = finallyExpr;
            this.retLocal = retLocal;
            this.finallyLocal = finallyLocal;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval try");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            CatchClause clause;
            int i;
            Label startTry = gen.newLabel();
            Label endTry = gen.newLabel();
            Label endTryCatch = gen.newLabel();
            Label end = gen.newLabel();
            Label ret = gen.newLabel();
            Label finallyLabel = gen.newLabel();
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                clause.label = gen.newLabel();
                clause.endLabel = gen.newLabel();
            }
            gen.mark(startTry);
            this.tryExpr.emit(context, fn, gen);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
            }
            gen.mark(endTry);
            if (this.finallyExpr != null) {
                this.finallyExpr.emit(C.STATEMENT, fn, gen);
            }
            gen.goTo(ret);
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.mark(clause.label);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), clause.lb.idx);
                clause.handler.emit(context, fn, gen);
                if (context != C.STATEMENT) {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
                }
                gen.mark(clause.endLabel);
                if (this.finallyExpr != null) {
                    this.finallyExpr.emit(C.STATEMENT, fn, gen);
                }
                gen.goTo(ret);
            }
            gen.mark(endTryCatch);
            if (this.finallyExpr != null) {
                gen.mark(finallyLabel);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.finallyLocal);
                this.finallyExpr.emit(C.STATEMENT, fn, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.finallyLocal);
                gen.throwException();
            }
            gen.mark(ret);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.retLocal);
            }
            gen.mark(end);
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.visitTryCatchBlock(startTry, endTry, clause.label, clause.c.getName().replace('.', '/'));
            }
            if (this.finallyExpr != null) {
                gen.visitTryCatchBlock(startTry, endTryCatch, finallyLabel, null);
            }
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.visitLocalVariable(clause.lb.name, "Ljava/lang/Object;", null, clause.label, clause.endLabel, clause.lb.idx);
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.tryExpr.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.tryExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (context != C.RETURN) {
                    return Compiler.analyze(context, RT.list(RT.list(FN, PersistentVector.EMPTY, form)));
                }
                PersistentVector body = PersistentVector.EMPTY;
                PersistentVector catches = PersistentVector.EMPTY;
                Expr finallyExpr = null;
                boolean caught = false;
                int retLocal = Compiler.getAndIncLocalNum();
                int finallyLocal = Compiler.getAndIncLocalNum();
                for (ISeq fs = form.next(); fs != null; fs = fs.next()) {
                    Object op;
                    Object f = fs.first();
                    Object object = op = f instanceof ISeq ? ((ISeq)f).first() : null;
                    if (!Util.equals(op, CATCH) && !Util.equals(op, FINALLY)) {
                        if (caught) {
                            throw new Exception("Only catch or finally clause can follow catch in try expression");
                        }
                        body = body.cons(f);
                        continue;
                    }
                    if (Util.equals(op, CATCH)) {
                        Class c = HostExpr.maybeClass(RT.second(f), false);
                        if (c == null) {
                            throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(f));
                        }
                        if (!(RT.third(f) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + RT.third(f));
                        }
                        Symbol sym = (Symbol)RT.third(f);
                        if (sym.getNamespace() != null) {
                            throw new Exception("Can't bind qualified name:" + sym);
                        }
                        IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref(), IN_CATCH_FINALLY, RT.T);
                        try {
                            Var.pushThreadBindings(dynamicBindings);
                            LocalBinding lb = Compiler.registerLocal(sym, (Symbol)(RT.second(f) instanceof Symbol ? RT.second(f) : null), null);
                            Expr handler = new BodyExpr.Parser().parse(context, RT.next(RT.next(RT.next(f))));
                            catches = catches.cons(new CatchClause(c, lb, handler));
                        }
                        finally {
                            Var.popThreadBindings();
                        }
                        caught = true;
                        continue;
                    }
                    if (fs.next() != null) {
                        throw new Exception("finally clause must be last in try expression");
                    }
                    try {
                        Var.pushThreadBindings(RT.map(IN_CATCH_FINALLY, RT.T));
                        finallyExpr = new BodyExpr.Parser().parse(C.STATEMENT, RT.next(f));
                        continue;
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                }
                return new TryExpr(new BodyExpr.Parser().parse(context, RT.seq(body)), catches, finallyExpr, retLocal, finallyLocal);
            }
        }

        public static class CatchClause {
            public final Class c;
            public final LocalBinding lb;
            public final Expr handler;
            Label label;
            Label endLabel;

            public CatchClause(Class c, LocalBinding lb, Expr handler) {
                this.c = c;
                this.lb = lb;
                this.handler = handler;
            }
        }
    }

    static class MonitorExitExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorExitExpr(Expr target) {
            this.target = target;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval monitor-exit");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, fn, gen);
            gen.monitorExit();
            NIL_EXPR.emit(context, fn, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                return new MonitorExitExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class MonitorEnterExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorEnterExpr(Expr target) {
            this.target = target;
        }

        public Object eval() throws Exception {
            throw new UnsupportedOperationException("Can't eval monitor-enter");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, fn, gen);
            gen.monitorEnter();
            NIL_EXPR.emit(context, fn, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                return new MonitorEnterExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class StringExpr
    extends LiteralExpr {
        public final String str;

        public StringExpr(String str) {
            this.str = str;
        }

        Object val() {
            return this.str;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                gen.push(this.str);
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return String.class;
        }
    }

    static class BooleanExpr
    extends LiteralExpr {
        public final boolean val;

        public BooleanExpr(boolean val) {
            this.val = val;
        }

        Object val() {
            return this.val ? RT.T : RT.F;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            if (this.val) {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
            } else {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return Boolean.class;
        }
    }

    static class NilExpr
    extends LiteralExpr {
        NilExpr() {
        }

        Object val() {
            return null;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitInsn(1);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return null;
        }
    }

    static class ConstantExpr
    extends LiteralExpr {
        public final Object v;
        public final int id;

        public ConstantExpr(Object v) {
            this.v = v;
            this.id = Compiler.registerConstant(v);
        }

        Object val() {
            return this.v;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            fn.emitConstant(gen, this.id);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return Modifier.isPublic(this.v.getClass().getModifiers());
        }

        public Class getJavaClass() throws Exception {
            return this.v.getClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) {
                Object v = RT.second(form);
                if (v == null) {
                    return NIL_EXPR;
                }
                return new ConstantExpr(v);
            }
        }
    }

    static class UnresolvedVarExpr
    implements Expr {
        public final Symbol symbol;

        public UnresolvedVarExpr(Symbol symbol) {
            this.symbol = symbol;
        }

        public boolean hasJavaClass() {
            return false;
        }

        public Class getJavaClass() throws Exception {
            throw new IllegalArgumentException("UnresolvedVarExpr has no Java class");
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
        }

        public Object eval() throws Exception {
            throw new IllegalArgumentException("UnresolvedVarExpr cannot be evalled");
        }
    }

    static class StaticMethodExpr
    extends MethodExpr {
        public final Class c;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final Method method;
        static final clojure.asm.commons.Method invokeStaticMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeStaticMethod(String,String,Object[])");

        public StaticMethodExpr(String source, int line, Class c, String methodName, IPersistentVector args) throws Exception {
            this.c = c;
            this.methodName = methodName;
            this.args = args;
            this.source = source;
            this.line = line;
            List methods = Reflector.getMethods(c, args.count(), methodName, true);
            if (methods.isEmpty()) {
                throw new IllegalArgumentException("No matching method: " + methodName);
            }
            int methodidx = 0;
            if (methods.size() > 1) {
                ArrayList<Class[]> params = new ArrayList<Class[]>();
                ArrayList<Class> rets = new ArrayList<Class>();
                for (int i = 0; i < methods.size(); ++i) {
                    Method m = (Method)methods.get(i);
                    params.add(m.getParameterTypes());
                    rets.add(m.getReturnType());
                }
                methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
            }
            this.method = methodidx >= 0 ? methods.get(methodidx) : null;
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                ((PrintWriter)RT.ERR.deref()).format("Reflection warning, line: %d - call to %s can't be resolved.\n", line, methodName);
            }
        }

        public Object eval() throws Exception {
            try {
                Object[] argvals = new Object[this.args.count()];
                for (int i = 0; i < this.args.count(); ++i) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, null, argvals);
                }
                return Reflector.invokeStaticMethod(this.c, this.methodName, argvals);
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e);
                }
                throw (CompilerException)e;
            }
        }

        public void emitUnboxed(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                MethodExpr.emitTypedArgs(fn, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
            Type type = Type.getType(this.c);
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
            gen.invokeStatic(type, m);
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                MethodExpr.emitTypedArgs(fn, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                Type type = Type.getType(this.c);
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                gen.invokeStatic(type, m);
                HostExpr.emitBoxReturn(fn, gen, this.method.getReturnType());
            } else {
                gen.push(this.c.getName());
                gen.push(this.methodName);
                StaticMethodExpr.emitArgsAsArray(this.args, fn, gen);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeStaticMethodMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return this.method != null;
        }

        public Class getJavaClass() throws Exception {
            return this.method.getReturnType();
        }
    }

    static class InstanceMethodExpr
    extends MethodExpr {
        public final Expr target;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final Method method;
        static final clojure.asm.commons.Method invokeInstanceMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeInstanceMethod(Object,String,Object[])");

        public InstanceMethodExpr(String source, int line, Expr target, String methodName, IPersistentVector args) throws Exception {
            this.source = source;
            this.line = line;
            this.args = args;
            this.methodName = methodName;
            this.target = target;
            if (target.hasJavaClass()) {
                List methods = Reflector.getMethods(target.getJavaClass(), args.count(), methodName, false);
                if (methods.isEmpty()) {
                    this.method = null;
                } else {
                    Method m;
                    int methodidx = 0;
                    if (methods.size() > 1) {
                        ArrayList<Class[]> params = new ArrayList<Class[]>();
                        ArrayList<Class> rets = new ArrayList<Class>();
                        for (int i = 0; i < methods.size(); ++i) {
                            Method m2 = (Method)methods.get(i);
                            params.add(m2.getParameterTypes());
                            rets.add(m2.getReturnType());
                        }
                        methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
                    }
                    if ((m = (Method)(methodidx >= 0 ? methods.get(methodidx) : null)) != null && !Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                        m = Reflector.getAsMethodOfPublicBase(m.getDeclaringClass(), m);
                    }
                    this.method = m;
                }
            } else {
                this.method = null;
            }
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                ((PrintWriter)RT.ERR.deref()).format("Reflection warning, line: %d - call to %s can't be resolved.\n", line, methodName);
            }
        }

        public Object eval() throws Exception {
            try {
                Object targetval = this.target.eval();
                Object[] argvals = new Object[this.args.count()];
                for (int i = 0; i < this.args.count(); ++i) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, targetval, argvals);
                }
                return Reflector.invokeInstanceMethod(targetval, this.methodName, argvals);
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e);
                }
                throw (CompilerException)e;
            }
        }

        public void emitUnboxed(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Type type = Type.getType(this.method.getDeclaringClass());
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.checkCast(type);
                MethodExpr.emitTypedArgs(fn, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type, m);
                } else {
                    gen.invokeVirtual(type, m);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                Type type = Type.getType(this.method.getDeclaringClass());
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.checkCast(type);
                MethodExpr.emitTypedArgs(fn, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type, m);
                } else {
                    gen.invokeVirtual(type, m);
                }
                HostExpr.emitBoxReturn(fn, gen, this.method.getReturnType());
            } else {
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.push(this.methodName);
                InstanceMethodExpr.emitArgsAsArray(this.args, fn, gen);
                if (context == C.RETURN) {
                    FnMethod method = (FnMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeInstanceMethodMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return this.method != null;
        }

        public Class getJavaClass() throws Exception {
            return this.method.getReturnType();
        }
    }

    static abstract class MethodExpr
    extends HostExpr {
        MethodExpr() {
        }

        static void emitArgsAsArray(IPersistentVector args, FnExpr fn, GeneratorAdapter gen) {
            gen.push(args.count());
            gen.newArray(OBJECT_TYPE);
            for (int i = 0; i < args.count(); ++i) {
                gen.dup();
                gen.push(i);
                ((Expr)args.nth(i)).emit(C.EXPRESSION, fn, gen);
                gen.arrayStore(OBJECT_TYPE);
            }
        }

        public static void emitTypedArgs(FnExpr fn, GeneratorAdapter gen, Class[] parameterTypes, IPersistentVector args) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Expr e = (Expr)args.nth(i);
                try {
                    if (Compiler.maybePrimitiveType(e) == parameterTypes[i]) {
                        ((MaybePrimitiveExpr)((Object)e)).emitUnboxed(C.EXPRESSION, fn, gen);
                        continue;
                    }
                    e.emit(C.EXPRESSION, fn, gen);
                    HostExpr.emitUnboxArg(fn, gen, parameterTypes[i]);
                    continue;
                }
                catch (Exception e1) {
                    e1.printStackTrace((PrintWriter)RT.ERR.deref());
                }
            }
        }
    }

    static class StaticFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final String fieldName;
        public final Class c;
        public final Field field;
        static final clojure.asm.commons.Method getStaticFieldMethod = clojure.asm.commons.Method.getMethod("Object getStaticField(String,String)");
        static final clojure.asm.commons.Method setStaticFieldMethod = clojure.asm.commons.Method.getMethod("Object setStaticField(String,String,Object)");
        final int line;

        public StaticFieldExpr(int line, Class c, String fieldName) throws Exception {
            this.fieldName = fieldName;
            this.line = line;
            this.c = c;
            this.field = c.getField(fieldName);
        }

        public Object eval() throws Exception {
            return Reflector.getStaticField(this.c, this.fieldName);
        }

        public void emitUnboxed(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            HostExpr.emitBoxReturn(fn, gen, this.field.getType());
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws Exception {
            return this.field.getType();
        }

        public Object evalAssign(Expr val) throws Exception {
            return Reflector.setStaticField(this.c, this.fieldName, val.eval());
        }

        public void emitAssign(C context, FnExpr fn, GeneratorAdapter gen, Expr val) {
            gen.visitLineNumber(this.line, gen.mark());
            val.emit(C.EXPRESSION, fn, gen);
            gen.dup();
            HostExpr.emitUnboxArg(fn, gen, this.field.getType());
            gen.putStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    static class InstanceFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final Expr target;
        public final Class targetClass;
        public final Field field;
        public final String fieldName;
        public final int line;
        static final clojure.asm.commons.Method invokeNoArgInstanceMember = clojure.asm.commons.Method.getMethod("Object invokeNoArgInstanceMember(Object,String)");
        static final clojure.asm.commons.Method setInstanceFieldMethod = clojure.asm.commons.Method.getMethod("Object setInstanceField(Object,String,Object)");

        public InstanceFieldExpr(int line, Expr target, String fieldName) throws Exception {
            this.target = target;
            this.targetClass = target.hasJavaClass() ? target.getJavaClass() : null;
            this.field = this.targetClass != null ? Reflector.getField(this.targetClass, fieldName, false) : null;
            this.fieldName = fieldName;
            this.line = line;
            if (this.field == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                ((PrintWriter)RT.ERR.deref()).format("Reflection warning, line: %d - reference to field %s can't be resolved.\n", line, fieldName);
            }
        }

        public Object eval() throws Exception {
            return Reflector.invokeNoArgInstanceMember(this.target.eval(), this.fieldName);
        }

        public void emitUnboxed(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass == null || this.field == null) {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
            this.target.emit(C.EXPRESSION, fn, gen);
            gen.checkCast(Type.getType(this.targetClass));
            gen.getField(Type.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass != null && this.field != null) {
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.checkCast(Type.getType(this.targetClass));
                gen.getField(Type.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
                HostExpr.emitBoxReturn(fn, gen, this.field.getType());
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            } else {
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.push(this.fieldName);
                gen.invokeStatic(REFLECTOR_TYPE, invokeNoArgInstanceMember);
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            }
        }

        public boolean hasJavaClass() throws Exception {
            return this.field != null;
        }

        public Class getJavaClass() throws Exception {
            return this.field.getType();
        }

        public Object evalAssign(Expr val) throws Exception {
            return Reflector.setInstanceField(this.target.eval(), this.fieldName, val.eval());
        }

        public void emitAssign(C context, FnExpr fn, GeneratorAdapter gen, Expr val) {
            gen.visitLineNumber(this.line, gen.mark());
            if (this.targetClass != null) {
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.checkCast(Type.getType(this.targetClass));
                val.emit(C.EXPRESSION, fn, gen);
                gen.dupX1();
                HostExpr.emitUnboxArg(fn, gen, this.field.getType());
                gen.putField(Type.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
            } else {
                this.target.emit(C.EXPRESSION, fn, gen);
                gen.push(this.fieldName);
                val.emit(C.EXPRESSION, fn, gen);
                gen.invokeStatic(REFLECTOR_TYPE, setInstanceFieldMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    static abstract class FieldExpr
    extends HostExpr {
        FieldExpr() {
        }
    }

    public static abstract class HostExpr
    implements Expr,
    MaybePrimitiveExpr {
        static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
        static final Type CHAR_TYPE = Type.getType(Character.class);
        static final Type INTEGER_TYPE = Type.getType(Integer.class);
        static final Type LONG_TYPE = Type.getType(Long.class);
        static final Type FLOAT_TYPE = Type.getType(Float.class);
        static final Type DOUBLE_TYPE = Type.getType(Double.class);
        static final Type SHORT_TYPE = Type.getType(Short.class);
        static final Type BYTE_TYPE = Type.getType(Byte.class);
        static final Type NUMBER_TYPE = Type.getType(Number.class);
        static final clojure.asm.commons.Method charValueMethod = clojure.asm.commons.Method.getMethod("char charValue()");
        static final clojure.asm.commons.Method booleanValueMethod = clojure.asm.commons.Method.getMethod("boolean booleanValue()");
        static final clojure.asm.commons.Method charValueOfMethod = clojure.asm.commons.Method.getMethod("Character valueOf(char)");
        static final clojure.asm.commons.Method intValueOfMethod = clojure.asm.commons.Method.getMethod("Integer valueOf(int)");
        static final clojure.asm.commons.Method longValueOfMethod = clojure.asm.commons.Method.getMethod("Long valueOf(long)");
        static final clojure.asm.commons.Method floatValueOfMethod = clojure.asm.commons.Method.getMethod("Float valueOf(float)");
        static final clojure.asm.commons.Method doubleValueOfMethod = clojure.asm.commons.Method.getMethod("Double valueOf(double)");
        static final clojure.asm.commons.Method shortValueOfMethod = clojure.asm.commons.Method.getMethod("Short valueOf(short)");
        static final clojure.asm.commons.Method byteValueOfMethod = clojure.asm.commons.Method.getMethod("Byte valueOf(byte)");
        static final clojure.asm.commons.Method intValueMethod = clojure.asm.commons.Method.getMethod("int intValue()");
        static final clojure.asm.commons.Method longValueMethod = clojure.asm.commons.Method.getMethod("long longValue()");
        static final clojure.asm.commons.Method floatValueMethod = clojure.asm.commons.Method.getMethod("float floatValue()");
        static final clojure.asm.commons.Method doubleValueMethod = clojure.asm.commons.Method.getMethod("double doubleValue()");
        static final clojure.asm.commons.Method byteValueMethod = clojure.asm.commons.Method.getMethod("byte byteValue()");
        static final clojure.asm.commons.Method shortValueMethod = clojure.asm.commons.Method.getMethod("short shortValue()");
        static final clojure.asm.commons.Method fromIntMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(int)");
        static final clojure.asm.commons.Method fromLongMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(long)");
        static final clojure.asm.commons.Method fromDoubleMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(double)");

        public static void emitBoxReturn(FnExpr fn, GeneratorAdapter gen, Class returnType) {
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    Label falseLabel = gen.newLabel();
                    Label endLabel = gen.newLabel();
                    gen.ifZCmp(153, falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
                    gen.goTo(endLabel);
                    gen.mark(falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.mark(endLabel);
                } else if (returnType == Void.TYPE) {
                    NIL_EXPR.emit(C.EXPRESSION, fn, gen);
                } else if (returnType == Character.TYPE) {
                    gen.invokeStatic(CHAR_TYPE, charValueOfMethod);
                } else if (returnType == Integer.TYPE) {
                    gen.invokeStatic(INTEGER_TYPE, intValueOfMethod);
                } else if (returnType == Float.TYPE) {
                    gen.invokeStatic(FLOAT_TYPE, floatValueOfMethod);
                } else if (returnType == Double.TYPE) {
                    gen.invokeStatic(DOUBLE_TYPE, doubleValueOfMethod);
                } else if (returnType == Long.TYPE) {
                    gen.invokeStatic(LONG_TYPE, longValueOfMethod);
                } else if (returnType == Byte.TYPE) {
                    gen.invokeStatic(BYTE_TYPE, byteValueOfMethod);
                } else if (returnType == Short.TYPE) {
                    gen.invokeStatic(SHORT_TYPE, shortValueOfMethod);
                }
            }
        }

        public static void emitUnboxArg(FnExpr fn, GeneratorAdapter gen, Class paramType) {
            if (paramType.isPrimitive()) {
                if (paramType == Boolean.TYPE) {
                    gen.checkCast(BOOLEAN_TYPE);
                    gen.invokeVirtual(BOOLEAN_TYPE, booleanValueMethod);
                } else if (paramType == Character.TYPE) {
                    gen.checkCast(CHAR_TYPE);
                    gen.invokeVirtual(CHAR_TYPE, charValueMethod);
                } else {
                    clojure.asm.commons.Method m = intValueMethod;
                    gen.checkCast(NUMBER_TYPE);
                    if (paramType == Integer.TYPE) {
                        m = intValueMethod;
                    } else if (paramType == Float.TYPE) {
                        m = floatValueMethod;
                    } else if (paramType == Double.TYPE) {
                        m = doubleValueMethod;
                    } else if (paramType == Long.TYPE) {
                        m = longValueMethod;
                    } else if (paramType == Byte.TYPE) {
                        m = byteValueMethod;
                    } else if (paramType == Short.TYPE) {
                        m = shortValueMethod;
                    }
                    gen.invokeVirtual(NUMBER_TYPE, m);
                }
            } else {
                gen.checkCast(Type.getType(paramType));
            }
        }

        private static Class maybeClass(Object form, boolean stringOk) throws Exception {
            if (form instanceof Class) {
                return (Class)form;
            }
            Class c = null;
            if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null) {
                    if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
                        c = RT.classForName(sym.name);
                    } else {
                        Object o = Compiler.currentNS().getMapping(sym);
                        if (o instanceof Class) {
                            c = (Class)o;
                        }
                    }
                }
            } else if (stringOk && form instanceof String) {
                c = RT.classForName((String)form);
            }
            return c;
        }

        static Class tagToClass(Object tag) throws Exception {
            Class c = HostExpr.maybeClass(tag, true);
            if (tag instanceof Symbol) {
                Symbol sym = (Symbol)tag;
                if (sym.ns == null) {
                    if (sym.name.equals("ints")) {
                        c = int[].class;
                    } else if (sym.name.equals("longs")) {
                        c = long[].class;
                    } else if (sym.name.equals("floats")) {
                        c = float[].class;
                    } else if (sym.name.equals("doubles")) {
                        c = double[].class;
                    } else if (sym.name.equals("chars")) {
                        c = char[].class;
                    } else if (sym.name.equals("shorts")) {
                        c = short[].class;
                    } else if (sym.name.equals("bytes")) {
                        c = byte[].class;
                    } else if (sym.name.equals("booleans")) {
                        c = boolean[].class;
                    }
                }
            }
            if (c != null) {
                return c;
            }
            throw new IllegalArgumentException("Unable to resolve classname: " + tag);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                Symbol sym;
                boolean maybeField;
                ISeq form = (ISeq)frm;
                if (RT.length(form) < 3) {
                    throw new IllegalArgumentException("Malformed member expression, expecting (. target member ...)");
                }
                int line = (Integer)LINE.deref();
                String source = (String)SOURCE.deref();
                Class c = HostExpr.maybeClass(RT.second(form), false);
                Expr instance = null;
                if (c == null) {
                    instance = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                }
                boolean bl = maybeField = RT.length(form) == 3 && RT.third(form) instanceof Symbol;
                if (maybeField) {
                    sym = (Symbol)RT.third(form);
                    if (c != null) {
                        maybeField = Reflector.getMethods(c, 0, sym.name, true).size() == 0;
                    } else if (instance != null && instance.hasJavaClass() && instance.getJavaClass() != null) {
                        boolean bl2 = maybeField = Reflector.getMethods(instance.getJavaClass(), 0, sym.name, false).size() == 0;
                    }
                }
                if (maybeField) {
                    sym = (Symbol)RT.third(form);
                    if (c != null) {
                        return new StaticFieldExpr(line, c, sym.name);
                    }
                    return new InstanceFieldExpr(line, instance, sym.name);
                }
                ISeq call = (ISeq)(RT.third(form) instanceof ISeq ? RT.third(form) : RT.next(RT.next(form)));
                if (!(RT.first(call) instanceof Symbol)) {
                    throw new IllegalArgumentException("Malformed member expression");
                }
                Symbol sym2 = (Symbol)RT.first(call);
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.next(call); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                }
                if (c != null) {
                    return new StaticMethodExpr(source, line, c, sym2.name, args);
                }
                return new InstanceMethodExpr(source, line, instance, sym2.name, args);
            }
        }
    }

    public static interface MaybePrimitiveExpr {
        public void emitUnboxed(C var1, FnExpr var2, GeneratorAdapter var3);
    }

    static interface AssignableExpr {
        public Object evalAssign(Expr var1) throws Exception;

        public void emitAssign(C var1, FnExpr var2, GeneratorAdapter var3, Expr var4);
    }

    public static abstract class LiteralExpr
    implements Expr {
        abstract Object val();

        public Object eval() {
            return this.val();
        }
    }

    public static class KeywordExpr
    implements Expr {
        public final Keyword k;

        public KeywordExpr(Keyword k) {
            this.k = k;
        }

        public Object eval() throws Exception {
            return this.k;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            fn.emitKeyword(gen, this.k);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws ClassNotFoundException {
            return Keyword.class;
        }
    }

    public static class TheVarExpr
    implements Expr {
        public final Var var;

        public TheVarExpr(Var var) {
            this.var = var;
        }

        public Object eval() throws Exception {
            return this.var;
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            fn.emitVar(gen, this.var);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() throws ClassNotFoundException {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, false);
                if (v != null) {
                    return new TheVarExpr(v);
                }
                throw new Exception("Unable to resolve var: " + sym + " in this context");
            }
        }
    }

    public static class VarExpr
    implements Expr,
    AssignableExpr {
        public final Var var;
        public final Object tag;
        static final clojure.asm.commons.Method getMethod = clojure.asm.commons.Method.getMethod("Object get()");
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("Object set(Object)");

        public VarExpr(Var var, Symbol tag) {
            this.var = var;
            this.tag = tag != null ? tag : var.getTag();
        }

        public Object eval() throws Exception {
            return this.var.deref();
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            fn.emitVar(gen, this.var);
            gen.invokeVirtual(VAR_TYPE, getMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return this.tag != null;
        }

        public Class getJavaClass() throws Exception {
            return HostExpr.tagToClass(this.tag);
        }

        public Object evalAssign(Expr val) throws Exception {
            return this.var.set(val.eval());
        }

        public void emitAssign(C context, FnExpr fn, GeneratorAdapter gen, Expr val) {
            fn.emitVar(gen, this.var);
            val.emit(C.EXPRESSION, fn, gen);
            gen.invokeVirtual(VAR_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    public static class AssignExpr
    implements Expr {
        public final AssignableExpr target;
        public final Expr val;

        public AssignExpr(AssignableExpr target, Expr val) {
            this.target = target;
            this.val = val;
        }

        public Object eval() throws Exception {
            return this.target.evalAssign(this.val);
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            this.target.emitAssign(context, fn, gen, this.val);
        }

        public boolean hasJavaClass() throws Exception {
            return this.val.hasJavaClass();
        }

        public Class getJavaClass() throws Exception {
            return this.val.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object frm) throws Exception {
                ISeq form = (ISeq)frm;
                if (RT.length(form) != 3) {
                    throw new IllegalArgumentException("Malformed assignment, expecting (set! target val)");
                }
                Expr target = Compiler.analyze(C.EXPRESSION, RT.second(form));
                if (!(target instanceof AssignableExpr)) {
                    throw new IllegalArgumentException("Invalid assignment target");
                }
                return new AssignExpr((AssignableExpr)((Object)target), Compiler.analyze(C.EXPRESSION, RT.third(form)));
            }
        }
    }

    static class DefExpr
    implements Expr {
        public final Var var;
        public final Expr init;
        public final Expr meta;
        public final boolean initProvided;
        public final String source;
        public final int line;
        static final clojure.asm.commons.Method bindRootMethod = clojure.asm.commons.Method.getMethod("void bindRoot(Object)");
        static final clojure.asm.commons.Method setTagMethod = clojure.asm.commons.Method.getMethod("void setTag(clojure.lang.Symbol)");
        static final clojure.asm.commons.Method setMetaMethod = clojure.asm.commons.Method.getMethod("void setMeta(clojure.lang.IPersistentMap)");
        static final clojure.asm.commons.Method symcreate = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String, String)");

        public DefExpr(String source, int line, Var var, Expr init, Expr meta, boolean initProvided) {
            this.source = source;
            this.line = line;
            this.var = var;
            this.init = init;
            this.meta = meta;
            this.initProvided = initProvided;
        }

        public Object eval() throws Exception {
            try {
                if (this.initProvided) {
                    this.var.bindRoot(this.init.eval());
                }
                if (this.meta != null) {
                    this.var.setMeta((IPersistentMap)this.meta.eval());
                }
                return this.var;
            }
            catch (Throwable e) {
                if (!(e instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, e);
                }
                throw (CompilerException)e;
            }
        }

        public void emit(C context, FnExpr fn, GeneratorAdapter gen) {
            fn.emitVar(gen, this.var);
            if (this.initProvided) {
                gen.dup();
                this.init.emit(C.EXPRESSION, fn, gen);
                gen.invokeVirtual(VAR_TYPE, bindRootMethod);
            }
            if (this.meta != null) {
                gen.dup();
                this.meta.emit(C.EXPRESSION, fn, gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeVirtual(VAR_TYPE, setMetaMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public boolean hasJavaClass() {
            return true;
        }

        public Class getJavaClass() {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            public Expr parse(C context, Object form) throws Exception {
                if (RT.count(form) > 3) {
                    throw new Exception("Too many arguments to def");
                }
                if (RT.count(form) < 2) {
                    throw new Exception("Too few arguments to def");
                }
                if (!(RT.second(form) instanceof Symbol)) {
                    throw new Exception("Second argument to def must be a Symbol");
                }
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, true);
                if (v == null) {
                    throw new Exception("Can't refer to qualified var that doesn't exist");
                }
                if (!v.ns.equals(Compiler.currentNS())) {
                    if (sym.ns == null) {
                        throw new Exception("Name conflict, can't def " + sym + " because namespace: " + Compiler.currentNS().name + " refers to:" + v);
                    }
                    throw new Exception("Can't create defs outside of current ns");
                }
                IPersistentMap mm = sym.meta();
                mm = (IPersistentMap)RT.assoc(mm, RT.LINE_KEY, LINE.deref()).assoc(RT.FILE_KEY, SOURCE.deref());
                Expr meta = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, mm);
                return new DefExpr((String)SOURCE.deref(), (Integer)LINE.deref(), v, Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.third(form), v.sym.name), meta, RT.count(form) == 3);
            }
        }
    }

    static interface IParser {
        public Expr parse(C var1, Object var2) throws Exception;
    }

    public static abstract class UntypedExpr
    implements Expr {
        public Class getJavaClass() {
            throw new IllegalArgumentException("Has no Java class");
        }

        public boolean hasJavaClass() {
            return false;
        }
    }

    static interface Expr {
        public Object eval() throws Exception;

        public void emit(C var1, FnExpr var2, GeneratorAdapter var3);

        public boolean hasJavaClass() throws Exception;

        public Class getJavaClass() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum C {
        STATEMENT,
        EXPRESSION,
        RETURN,
        EVAL;

    }
}

