/**
 * Copyright (c) Rich Hickey. All rights reserved.
 * The use and distribution terms for this software are covered by the
 * Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
 * which can be found in the file epl-v10.html at the root of this distribution.
 * By using this software in any fashion, you are agreeing to be bound by
 * the terms of this license.
 * You must not remove this notice, or any other, from this software.
 */

package clojure.lang;

import java.io.PushbackReader;
import java.io.Reader;
import java.io.LineNumberReader;
import java.io.IOException;


public class LineNumberingPushbackReader extends PushbackReader{

public LineNumberingPushbackReader(Reader r){
	super(new LineNumberReader(r));
}

public int getLineNumber(){
	return ((LineNumberReader) in).getLineNumber() + 1;
}

public String readLine() throws IOException{
	return ((LineNumberReader)in).readLine();
}
}
