/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentVector;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.Obj;
import clojure.lang.PersistentVector;
import java.util.Collection;

public class LazilyPersistentVector
extends APersistentVector {
    final Object[] array;
    PersistentVector v = null;

    public static IPersistentVector createOwning(Object ... items) {
        if (items.length == 0) {
            return PersistentVector.EMPTY;
        }
        return new LazilyPersistentVector(null, items, null);
    }

    public static IPersistentVector create(Collection coll) {
        return LazilyPersistentVector.createOwning(coll.toArray());
    }

    LazilyPersistentVector(IPersistentMap meta, Object[] array, PersistentVector v) {
        super(meta);
        this.array = array;
        this.v = v;
    }

    public Object[] toArray() {
        return (Object[])this.array.clone();
    }

    public Object nth(int i) {
        return this.array[i];
    }

    public IPersistentVector assocN(int i, Object val) {
        return (IPersistentVector)this.v().assoc(i, val);
    }

    public int count() {
        return this.array.length;
    }

    public IPersistentVector cons(Object o) {
        return this.v().cons(o);
    }

    public IPersistentCollection empty() {
        return PersistentVector.EMPTY.withMeta(this.meta());
    }

    public IPersistentStack pop() {
        return this.v().pop();
    }

    private synchronized IPersistentVector v() {
        if (this.v == null) {
            this.v = PersistentVector.create(this.array);
        }
        return this.v;
    }

    public Obj withMeta(IPersistentMap meta) {
        if (meta != this._meta) {
            return new LazilyPersistentVector(meta, this.array, this.v);
        }
        return this;
    }
}

