/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Compile {
    private static final String PATH_PROP = "clojure.compile.path";
    private static final Var compile_path = RT.var("clojure.core", "*compile-path*");
    private static final Var compile = RT.var("clojure.core", "compile");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        OutputStreamWriter out = (OutputStreamWriter)RT.OUT.get();
        PrintWriter err = (PrintWriter)RT.ERR.get();
        String path = System.getProperty(PATH_PROP);
        int count = args.length;
        if (path == null) {
            err.println("ERROR: Must set system property clojure.compile.path\nto the location for compiled .class files.\nThis directory must also be on your CLASSPATH.");
            System.exit(1);
        }
        try {
            Var.pushThreadBindings(RT.map(compile_path, path));
            for (String lib : args) {
                out.write("Compiling " + lib + " to " + path + "\n");
                out.flush();
                compile.invoke(Symbol.intern(lib));
            }
        }
        finally {
            Var.popThreadBindings();
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace(err);
            }
        }
    }
}

