/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.APersistentSet;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.PersistentTreeMap;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Sorted;
import java.util.Comparator;
import java.util.List;

public class PersistentTreeSet
extends APersistentSet
implements Reversible,
Sorted {
    public static final PersistentTreeSet EMPTY = new PersistentTreeSet(null, PersistentTreeMap.EMPTY);

    public static PersistentTreeSet create(Object ... init) {
        PersistentTreeSet ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            ret = (PersistentTreeSet)ret.cons(init[i]);
        }
        return ret;
    }

    public static PersistentTreeSet create(List init) {
        PersistentTreeSet ret = EMPTY;
        for (Object key : init) {
            ret = (PersistentTreeSet)ret.cons(key);
        }
        return ret;
    }

    public static PersistentTreeSet create(ISeq items) {
        PersistentTreeSet ret = EMPTY;
        while (items != null) {
            ret = (PersistentTreeSet)ret.cons(items.first());
            items = items.rest();
        }
        return ret;
    }

    PersistentTreeSet(IPersistentMap meta, IPersistentMap impl) {
        super(meta, impl);
    }

    public IPersistentSet disjoin(Object key) throws Exception {
        if (this.contains(key)) {
            return new PersistentTreeSet(this.meta(), this.impl.without(key));
        }
        return this;
    }

    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentTreeSet(this.meta(), this.impl.assoc(o, o));
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public ISeq rseq() throws Exception {
        return APersistentMap.KeySeq.create(((Reversible)((Object)this.impl)).rseq());
    }

    public PersistentTreeSet withMeta(IPersistentMap meta) {
        return new PersistentTreeSet(meta, this.impl);
    }

    public Comparator comparator() {
        return ((Sorted)((Object)this.impl)).comparator();
    }

    public Object entryKey(Object entry) {
        return entry;
    }

    public ISeq seq(boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seq(ascending));
    }

    public ISeq seqFrom(Object key, boolean ascending) {
        PersistentTreeMap m = (PersistentTreeMap)this.impl;
        return RT.keys(m.seqFrom(key, ascending));
    }
}

