/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Cons;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.IStream;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Streamable;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;

public abstract class ASeq
extends Obj
implements ISeq,
Collection,
Streamable {
    transient int _hash = -1;

    public String toString() {
        return RT.printString(this);
    }

    public IPersistentCollection empty() {
        return null;
    }

    protected ASeq(IPersistentMap meta) {
        super(meta);
    }

    protected ASeq() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = ((IPersistentCollection)obj).seq();
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equal(s.first(), ms.first())) {
                return false;
            }
            s = s.rest();
            ms = ms.rest();
        }
        return ms == null;
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                hash = Util.hashCombine(hash, Util.hash(s.first()));
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public int count() {
        int i = 1;
        ISeq s = this.rest();
        while (s != null) {
            s = s.rest();
            ++i;
        }
        return i;
    }

    public ISeq seq() {
        return this;
    }

    public ISeq cons(Object o) {
        return new Cons(o, this);
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.rest()) {
            if (!Util.equal(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new SeqIterator(this);
    }

    public IStream stream() throws Exception {
        return new Stream(this);
    }

    static class Stream
    implements IStream {
        ISeq s;

        public Stream(ISeq s) {
            this.s = s;
        }

        public synchronized Object next() throws Exception {
            if (this.s != null) {
                Object ret = this.s.first();
                this.s = this.s.rest();
                return ret;
            }
            return RT.eos();
        }
    }
}

