/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.BigInt;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IReference;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LispReader {
    static final Symbol QUOTE = Symbol.intern("quote");
    static final Symbol THE_VAR = Symbol.intern("var");
    static Symbol UNQUOTE = Symbol.intern("clojure.core", "unquote");
    static Symbol UNQUOTE_SPLICING = Symbol.intern("clojure.core", "unquote-splicing");
    static Symbol CONCAT = Symbol.intern("clojure.core", "concat");
    static Symbol SEQ = Symbol.intern("clojure.core", "seq");
    static Symbol LIST = Symbol.intern("clojure.core", "list");
    static Symbol APPLY = Symbol.intern("clojure.core", "apply");
    static Symbol HASHMAP = Symbol.intern("clojure.core", "hash-map");
    static Symbol HASHSET = Symbol.intern("clojure.core", "hash-set");
    static Symbol VECTOR = Symbol.intern("clojure.core", "vector");
    static Symbol WITH_META = Symbol.intern("clojure.core", "with-meta");
    static Symbol META = Symbol.intern("clojure.core", "meta");
    static Symbol DEREF = Symbol.intern("clojure.core", "deref");
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^/]].*/)?([\\D&&[^/]][^/]*)");
    static Pattern intPat = Pattern.compile("([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
    static final Symbol SLASH = Symbol.intern("/");
    static final Symbol CLOJURE_SLASH = Symbol.intern("clojure.core", "/");
    static Var GENSYM_ENV = Var.create(null).setDynamic();
    static Var ARG_ENV = Var.create(null).setDynamic();
    static IFn ctorReader = new CtorReader();

    static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch) || ch == 44;
    }

    static void unread(PushbackReader r, int ch) {
        if (ch != -1) {
            try {
                r.unread(ch);
            }
            catch (IOException e) {
                throw Util.sneakyThrow(e);
            }
        }
    }

    public static int read1(Reader r) {
        try {
            return r.read();
        }
        catch (IOException e) {
            throw Util.sneakyThrow(e);
        }
    }

    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive) {
        try {
            int ch;
            block13: {
                Object ret;
                do {
                    ch = LispReader.read1(r);
                    while (LispReader.isWhitespace(ch)) {
                        ch = LispReader.read1(r);
                    }
                    if (ch == -1) {
                        if (eofIsError) {
                            throw Util.runtimeException("EOF while reading");
                        }
                        return eofValue;
                    }
                    if (Character.isDigit(ch)) {
                        Object n = LispReader.readNumber(r, (char)ch);
                        if (RT.suppressRead()) {
                            return null;
                        }
                        return n;
                    }
                    IFn macroFn = LispReader.getMacro(ch);
                    if (macroFn == null) break block13;
                    ret = macroFn.invoke(r, Character.valueOf((char)ch));
                    if (!RT.suppressRead()) continue;
                    return null;
                } while (ret == r);
                return ret;
            }
            if (ch == 43 || ch == 45) {
                int ch2 = LispReader.read1(r);
                if (Character.isDigit(ch2)) {
                    LispReader.unread(r, ch2);
                    Object n = LispReader.readNumber(r, (char)ch);
                    if (RT.suppressRead()) {
                        return null;
                    }
                    return n;
                }
                LispReader.unread(r, ch2);
            }
            String token = LispReader.readToken(r, (char)ch);
            if (RT.suppressRead()) {
                return null;
            }
            return LispReader.interpretToken(token);
        }
        catch (Exception e) {
            if (isRecursive || !(r instanceof LineNumberingPushbackReader)) {
                throw Util.sneakyThrow(e);
            }
            LineNumberingPushbackReader rdr = (LineNumberingPushbackReader)r;
            throw new ReaderException(rdr.getLineNumber(), (Throwable)e);
        }
    }

    private static String readToken(PushbackReader r, char initch) {
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            int ch;
            if ((ch = LispReader.read1(r)) == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                LispReader.unread(r, ch);
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    private static Object readNumber(PushbackReader r, char initch) {
        int ch;
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            if ((ch = LispReader.read1(r)) == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) break;
            sb.append((char)ch);
        }
        LispReader.unread(r, ch);
        String s = sb.toString();
        Object n = LispReader.matchNumber(s);
        if (n == null) {
            throw new NumberFormatException("Invalid number: " + s);
        }
        return n;
    }

    private static int readUnicodeChar(String token, int offset, int length, int base) {
        if (token.length() != offset + length) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + token);
        }
        int uc = 0;
        for (int i = offset; i < offset + length; ++i) {
            int d = Character.digit(token.charAt(i), base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + token.charAt(i));
            }
            uc = uc * base + d;
        }
        return (char)uc;
    }

    private static int readUnicodeChar(PushbackReader r, int initch, int base, int length, boolean exact) {
        int i;
        int uc = Character.digit(initch, base);
        if (uc == -1) {
            throw new IllegalArgumentException("Invalid digit: " + (char)initch);
        }
        for (i = 1; i < length; ++i) {
            int ch = LispReader.read1(r);
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) {
                LispReader.unread(r, ch);
                break;
            }
            int d = Character.digit(ch, base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)ch);
            }
            uc = uc * base + d;
        }
        if (i != length && exact) {
            throw new IllegalArgumentException("Invalid character length: " + i + ", should be: " + length);
        }
        return uc;
    }

    private static Object interpretToken(String s) {
        if (s.equals("nil")) {
            return null;
        }
        if (s.equals("true")) {
            return RT.T;
        }
        if (s.equals("false")) {
            return RT.F;
        }
        if (s.equals("/")) {
            return SLASH;
        }
        if (s.equals("clojure.core//")) {
            return CLOJURE_SLASH;
        }
        Object ret = null;
        ret = LispReader.matchSymbol(s);
        if (ret != null) {
            return ret;
        }
        throw Util.runtimeException("Invalid token: " + s);
    }

    private static Object matchSymbol(String s) {
        Matcher m = symbolPat.matcher(s);
        if (m.matches()) {
            int gc = m.groupCount();
            String ns = m.group(1);
            String name = m.group(2);
            if (ns != null && ns.endsWith(":/") || name.endsWith(":") || s.indexOf("::", 1) != -1) {
                return null;
            }
            if (s.startsWith("::")) {
                Symbol ks = Symbol.intern(s.substring(2));
                Namespace kns = ks.ns != null ? Compiler.namespaceFor(ks) : Compiler.currentNS();
                if (kns != null) {
                    return Keyword.intern(kns.name.name, ks.name);
                }
                return null;
            }
            boolean isKeyword = s.charAt(0) == ':';
            Symbol sym = Symbol.intern(s.substring(isKeyword ? 1 : 0));
            if (isKeyword) {
                return Keyword.intern(sym);
            }
            return sym;
        }
        return null;
    }

    private static Object matchNumber(String s) {
        Matcher m = intPat.matcher(s);
        if (m.matches()) {
            if (m.group(2) != null) {
                if (m.group(8) != null) {
                    return BigInt.ZERO;
                }
                return Numbers.num(0L);
            }
            boolean negate = m.group(1).equals("-");
            int radix = 10;
            String n = m.group(3);
            if (n != null) {
                radix = 10;
            } else {
                n = m.group(4);
                if (n != null) {
                    radix = 16;
                } else {
                    n = m.group(5);
                    if (n != null) {
                        radix = 8;
                    } else {
                        n = m.group(7);
                        if (n != null) {
                            radix = Integer.parseInt(m.group(6));
                        }
                    }
                }
            }
            if (n == null) {
                return null;
            }
            BigInteger bn = new BigInteger(n, radix);
            if (negate) {
                bn = bn.negate();
            }
            if (m.group(8) != null) {
                return BigInt.fromBigInteger(bn);
            }
            return bn.bitLength() < 64 ? Numbers.num(bn.longValue()) : BigInt.fromBigInteger(bn);
        }
        m = floatPat.matcher(s);
        if (m.matches()) {
            if (m.group(4) != null) {
                return new BigDecimal(m.group(1));
            }
            return Double.parseDouble(s);
        }
        m = ratioPat.matcher(s);
        if (m.matches()) {
            return Numbers.divide((Object)Numbers.reduceBigInt(BigInt.fromBigInteger(new BigInteger(m.group(1)))), (Object)Numbers.reduceBigInt(BigInt.fromBigInteger(new BigInteger(m.group(2)))));
        }
        return null;
    }

    private static IFn getMacro(int ch) {
        if (ch < macros.length) {
            return macros[ch];
        }
        return null;
    }

    private static boolean isMacro(int ch) {
        return ch < macros.length && macros[ch] != null;
    }

    private static boolean isTerminatingMacro(int ch) {
        return ch != 35 && ch != 39 && LispReader.isMacro(ch);
    }

    static Symbol garg(int n) {
        return Symbol.intern(null, (n == -1 ? "rest" : "p" + n) + "__" + RT.nextID() + "#");
    }

    static Symbol registerArg(int n) {
        PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
        if (argsyms == null) {
            throw new IllegalStateException("arg literal not in #()");
        }
        Symbol ret = (Symbol)argsyms.valAt(n);
        if (ret == null) {
            ret = LispReader.garg(n);
            ARG_ENV.set(argsyms.assoc(n, ret));
        }
        return ret;
    }

    static boolean isUnquoteSplicing(Object form) {
        return form instanceof ISeq && Util.equals(RT.first(form), UNQUOTE_SPLICING);
    }

    static boolean isUnquote(Object form) {
        return form instanceof ISeq && Util.equals(RT.first(form), UNQUOTE);
    }

    public static List readDelimitedList(char delim, PushbackReader r, boolean isRecursive) {
        int firstline = r instanceof LineNumberingPushbackReader ? ((LineNumberingPushbackReader)r).getLineNumber() : -1;
        ArrayList<Object> a = new ArrayList<Object>();
        while (true) {
            int ch = LispReader.read1(r);
            while (LispReader.isWhitespace(ch)) {
                ch = LispReader.read1(r);
            }
            if (ch == -1) {
                if (firstline < 0) {
                    throw Util.runtimeException("EOF while reading");
                }
                throw Util.runtimeException("EOF while reading, starting at line " + firstline);
            }
            if (ch == delim) break;
            IFn macroFn = LispReader.getMacro(ch);
            if (macroFn != null) {
                Object mret = macroFn.invoke(r, Character.valueOf((char)ch));
                if (mret == r) continue;
                a.add(mret);
                continue;
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, isRecursive);
            if (o == r) continue;
            a.add(o);
        }
        return a;
    }

    static {
        LispReader.macros[34] = new StringReader();
        LispReader.macros[59] = new CommentReader();
        LispReader.macros[39] = new WrappingReader(QUOTE);
        LispReader.macros[64] = new WrappingReader(DEREF);
        LispReader.macros[94] = new MetaReader();
        LispReader.macros[96] = new SyntaxQuoteReader();
        LispReader.macros[126] = new UnquoteReader();
        LispReader.macros[40] = new ListReader();
        LispReader.macros[41] = new UnmatchedDelimiterReader();
        LispReader.macros[91] = new VectorReader();
        LispReader.macros[93] = new UnmatchedDelimiterReader();
        LispReader.macros[123] = new MapReader();
        LispReader.macros[125] = new UnmatchedDelimiterReader();
        LispReader.macros[92] = new CharacterReader();
        LispReader.macros[37] = new ArgReader();
        LispReader.macros[35] = new DispatchReader();
        LispReader.dispatchMacros[94] = new MetaReader();
        LispReader.dispatchMacros[39] = new VarReader();
        LispReader.dispatchMacros[34] = new RegexReader();
        LispReader.dispatchMacros[40] = new FnReader();
        LispReader.dispatchMacros[123] = new SetReader();
        LispReader.dispatchMacros[61] = new EvalReader();
        LispReader.dispatchMacros[33] = new CommentReader();
        LispReader.dispatchMacros[60] = new UnreadableReader();
        LispReader.dispatchMacros[95] = new DiscardReader();
    }

    public static class CtorReader
    extends AFn {
        public Object invoke(Object reader, Object firstChar) {
            PushbackReader r = (PushbackReader)reader;
            Object name = LispReader.read(r, true, null, false);
            if (!(name instanceof Symbol)) {
                throw new RuntimeException("Reader tag must be a symbol");
            }
            Symbol sym = (Symbol)name;
            return sym.getName().contains(".") ? this.readRecord(r, sym) : this.readTagged(r, sym);
        }

        private Object readTagged(PushbackReader reader, Symbol tag) {
            Object o = LispReader.read(reader, true, null, true);
            ILookup data_readers = (ILookup)RT.DATA_READERS.deref();
            IFn data_reader = (IFn)RT.get(data_readers, tag);
            if (data_reader == null && (data_reader = (IFn)RT.get(data_readers = (ILookup)RT.DEFAULT_DATA_READERS.deref(), tag)) == null) {
                throw new RuntimeException("No reader function for tag " + tag.toString());
            }
            return data_reader.invoke(o);
        }

        private Object readRecord(PushbackReader r, Symbol recordName) {
            char endch;
            Class recordClass = RT.classForName(recordName.toString());
            boolean shortForm = true;
            int ch = LispReader.read1(r);
            if (ch == 123) {
                endch = '}';
                shortForm = false;
            } else if (ch == 91) {
                endch = ']';
            } else {
                throw Util.runtimeException("Unreadable constructor form starting with \"#" + recordName + (char)ch + "\"");
            }
            Object[] recordEntries = LispReader.readDelimitedList(endch, r, true).toArray();
            Object ret = null;
            Constructor<?>[] allctors = recordClass.getConstructors();
            if (shortForm) {
                boolean ctorFound = false;
                for (Constructor<?> ctor : allctors) {
                    if (ctor.getParameterTypes().length != recordEntries.length) continue;
                    ctorFound = true;
                }
                if (!ctorFound) {
                    throw Util.runtimeException("Unexpected number of constructor arguments to " + recordClass.toString() + ": got " + recordEntries.length);
                }
                ret = Reflector.invokeConstructor(recordClass, recordEntries);
            } else {
                IPersistentMap vals = RT.map(recordEntries);
                for (ISeq s = RT.keys(vals); s != null; s = s.next()) {
                    if (s.first() instanceof Keyword) continue;
                    throw Util.runtimeException("Unreadable defrecord form: key must be of type clojure.lang.Keyword, got " + s.first().toString());
                }
                ret = Reflector.invokeStaticMethod(recordClass, "create", new Object[]{vals});
            }
            return ret;
        }
    }

    public static class UnreadableReader
    extends AFn {
        public Object invoke(Object reader, Object leftangle) {
            throw Util.runtimeException("Unreadable form");
        }
    }

    public static class UnmatchedDelimiterReader
    extends AFn {
        public Object invoke(Object reader, Object rightdelim) {
            throw Util.runtimeException("Unmatched delimiter: " + rightdelim);
        }
    }

    public static class SetReader
    extends AFn {
        public Object invoke(Object reader, Object leftbracket) {
            PushbackReader r = (PushbackReader)reader;
            return PersistentHashSet.createWithCheck(LispReader.readDelimitedList('}', r, true));
        }
    }

    public static class MapReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) {
            PushbackReader r = (PushbackReader)reader;
            Object[] a = LispReader.readDelimitedList('}', r, true).toArray();
            if ((a.length & 1) == 1) {
                throw Util.runtimeException("Map literal must contain an even number of forms");
            }
            return RT.map(a);
        }
    }

    public static class VectorReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) {
            PushbackReader r = (PushbackReader)reader;
            return LazilyPersistentVector.create(LispReader.readDelimitedList(']', r, true));
        }
    }

    public static class EvalReader
    extends AFn {
        public Object invoke(Object reader, Object eq) {
            if (!RT.booleanCast(RT.READEVAL.deref())) {
                throw Util.runtimeException("EvalReader not allowed when *read-eval* is false.");
            }
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            if (o instanceof Symbol) {
                return RT.classForName(o.toString());
            }
            if (o instanceof IPersistentList) {
                Symbol fs = (Symbol)RT.first(o);
                if (fs.equals(THE_VAR)) {
                    Symbol vs = (Symbol)RT.second(o);
                    return RT.var(vs.ns, vs.name);
                }
                if (fs.name.endsWith(".")) {
                    Object[] args = RT.toArray(RT.next(o));
                    return Reflector.invokeConstructor(RT.classForName(fs.name.substring(0, fs.name.length() - 1)), args);
                }
                if (Compiler.namesStaticMember(fs)) {
                    Object[] args = RT.toArray(RT.next(o));
                    return Reflector.invokeStaticMethod(fs.ns, fs.name, args);
                }
                Object v = Compiler.maybeResolveIn(Compiler.currentNS(), fs);
                if (v instanceof Var) {
                    return ((IFn)v).applyTo(RT.next(o));
                }
                throw Util.runtimeException("Can't resolve " + fs);
            }
            throw new IllegalArgumentException("Unsupported #= form");
        }
    }

    public static class ListReader
    extends AFn {
        public Object invoke(Object reader, Object leftparen) {
            List list;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((list = LispReader.readDelimitedList(')', r, true)).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj s = (IObj)((Object)PersistentList.create(list));
            if (line != -1) {
                return s.withMeta(RT.map(RT.LINE_KEY, line));
            }
            return s;
        }
    }

    public static class CharacterReader
    extends AFn {
        public Object invoke(Object reader, Object backslash) {
            PushbackReader r = (PushbackReader)reader;
            int ch = LispReader.read1(r);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            String token = LispReader.readToken(r, (char)ch);
            if (token.length() == 1) {
                return Character.valueOf(token.charAt(0));
            }
            if (token.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (token.equals("space")) {
                return Character.valueOf(' ');
            }
            if (token.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (token.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (token.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (token.equals("return")) {
                return Character.valueOf('\r');
            }
            if (token.startsWith("u")) {
                char c = (char)LispReader.readUnicodeChar(token, 1, 4, 16);
                if (c >= '\ud800' && c <= '\udfff') {
                    throw Util.runtimeException("Invalid character constant: \\u" + Integer.toString(c, 16));
                }
                return Character.valueOf(c);
            }
            if (token.startsWith("o")) {
                int len = token.length() - 1;
                if (len > 3) {
                    throw Util.runtimeException("Invalid octal escape sequence length: " + len);
                }
                int uc = LispReader.readUnicodeChar(token, 1, len, 8);
                if (uc > 255) {
                    throw Util.runtimeException("Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)uc);
            }
            throw Util.runtimeException("Unsupported character: \\" + token);
        }
    }

    static class UnquoteReader
    extends AFn {
        UnquoteReader() {
        }

        public Object invoke(Object reader, Object comma) {
            PushbackReader r = (PushbackReader)reader;
            int ch = LispReader.read1(r);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            if (ch == 64) {
                Object o = LispReader.read(r, true, null, true);
                return RT.list(UNQUOTE_SPLICING, o);
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, true);
            return RT.list(UNQUOTE, o);
        }
    }

    public static class SyntaxQuoteReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object reader, Object backquote) {
            Object object;
            PushbackReader r = (PushbackReader)reader;
            try {
                Var.pushThreadBindings(RT.map(GENSYM_ENV, PersistentHashMap.EMPTY));
                Object form = LispReader.read(r, true, null, true);
                object = SyntaxQuoteReader.syntaxQuote(form);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Var.popThreadBindings();
                throw throwable;
            }
            Var.popThreadBindings();
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Object syntaxQuote(Object form) {
            IPersistentMap newMeta;
            Object ret;
            if (Compiler.isSpecial(form)) {
                ret = RT.list(Compiler.QUOTE, form);
            } else if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null && sym.name.endsWith("#")) {
                    IPersistentMap gmap = (IPersistentMap)GENSYM_ENV.deref();
                    if (gmap == null) {
                        throw new IllegalStateException("Gensym literal not in syntax-quote");
                    }
                    Symbol gs = (Symbol)gmap.valAt(sym);
                    if (gs == null) {
                        gs = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1) + "__" + RT.nextID() + "__auto__");
                        GENSYM_ENV.set(gmap.assoc(sym, gs));
                    }
                    sym = gs;
                } else if (sym.ns == null && sym.name.endsWith(".")) {
                    Symbol csym = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1));
                    csym = Compiler.resolveSymbol(csym);
                    sym = Symbol.intern(null, csym.name.concat("."));
                } else if (sym.ns != null || !sym.name.startsWith(".")) {
                    Object maybeClass = null;
                    if (sym.ns != null) {
                        maybeClass = Compiler.currentNS().getMapping(Symbol.intern(null, sym.ns));
                    }
                    sym = maybeClass instanceof Class ? Symbol.intern(((Class)maybeClass).getName(), sym.name) : Compiler.resolveSymbol(sym);
                }
                ret = RT.list(Compiler.QUOTE, sym);
            } else {
                if (LispReader.isUnquote(form)) {
                    return RT.second(form);
                }
                if (LispReader.isUnquoteSplicing(form)) {
                    throw new IllegalStateException("splice not in list");
                }
                if (form instanceof IPersistentCollection) {
                    if (form instanceof IPersistentMap) {
                        IPersistentVector keyvals = SyntaxQuoteReader.flattenMap(form);
                        ret = RT.list(APPLY, HASHMAP, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(keyvals.seq()))));
                    } else if (form instanceof IPersistentVector) {
                        ret = RT.list(APPLY, VECTOR, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentVector)form).seq()))));
                    } else if (form instanceof IPersistentSet) {
                        ret = RT.list(APPLY, HASHSET, RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentSet)form).seq()))));
                    } else {
                        if (!(form instanceof ISeq) && !(form instanceof IPersistentList)) throw new UnsupportedOperationException("Unknown Collection type");
                        ISeq seq = RT.seq(form);
                        ret = seq == null ? RT.cons(LIST, null) : RT.list(SEQ, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(seq)));
                    }
                } else {
                    ret = form instanceof Keyword || form instanceof Number || form instanceof Character || form instanceof String ? form : RT.list(Compiler.QUOTE, form);
                }
            }
            if (!(form instanceof IObj) || RT.meta(form) == null || (newMeta = ((IObj)form).meta().without(RT.LINE_KEY)).count() <= 0) return ret;
            return RT.list(WITH_META, ret, SyntaxQuoteReader.syntaxQuote(((IObj)form).meta()));
        }

        private static ISeq sqExpandList(ISeq seq) {
            PersistentVector ret = PersistentVector.EMPTY;
            while (seq != null) {
                Object item = seq.first();
                ret = LispReader.isUnquote(item) ? ret.cons(RT.list(LIST, RT.second(item))) : (LispReader.isUnquoteSplicing(item) ? ret.cons(RT.second(item)) : ret.cons(RT.list(LIST, SyntaxQuoteReader.syntaxQuote(item))));
                seq = seq.next();
            }
            return ret.seq();
        }

        private static IPersistentVector flattenMap(Object form) {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                IMapEntry e = (IMapEntry)s.first();
                keyvals = keyvals.cons(e.key());
                keyvals = keyvals.cons(e.val());
            }
            return keyvals;
        }
    }

    public static class MetaReader
    extends AFn {
        public Object invoke(Object reader, Object caret) {
            Object meta;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((meta = LispReader.read(r, true, null, true)) instanceof Symbol || meta instanceof String) {
                meta = RT.map(RT.TAG_KEY, meta);
            } else if (meta instanceof Keyword) {
                meta = RT.map(meta, RT.T);
            } else if (!(meta instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object o = LispReader.read(r, true, null, true);
            if (o instanceof IMeta) {
                if (line != -1 && o instanceof ISeq) {
                    meta = ((IPersistentMap)meta).assoc(RT.LINE_KEY, line);
                }
                if (o instanceof IReference) {
                    ((IReference)o).resetMeta((IPersistentMap)meta);
                    return o;
                }
                Associative ometa = RT.meta(o);
                for (ISeq s = RT.seq(meta); s != null; s = s.next()) {
                    IMapEntry kv = (IMapEntry)s.first();
                    ometa = RT.assoc(ometa, kv.getKey(), kv.getValue());
                }
                return ((IObj)o).withMeta((IPersistentMap)ometa);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IMetas");
        }
    }

    static class ArgReader
    extends AFn {
        ArgReader() {
        }

        public Object invoke(Object reader, Object pct) {
            PushbackReader r = (PushbackReader)reader;
            if (ARG_ENV.deref() == null) {
                return LispReader.interpretToken(LispReader.readToken(r, '%'));
            }
            int ch = LispReader.read1(r);
            LispReader.unread(r, ch);
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                return LispReader.registerArg(1);
            }
            Object n = LispReader.read(r, true, null, true);
            if (n.equals(Compiler._AMP_)) {
                return LispReader.registerArg(-1);
            }
            if (!(n instanceof Number)) {
                throw new IllegalStateException("arg literal must be %, %& or %integer");
            }
            return LispReader.registerArg(((Number)n).intValue());
        }
    }

    public static class FnReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object reader, Object lparen) {
            ISeq iSeq;
            PushbackReader r = (PushbackReader)reader;
            if (ARG_ENV.deref() != null) {
                throw new IllegalStateException("Nested #()s are not allowed");
            }
            try {
                Var.pushThreadBindings(RT.map(ARG_ENV, PersistentTreeMap.EMPTY));
                LispReader.unread(r, 40);
                Object form = LispReader.read(r, true, null, true);
                PersistentVector args = PersistentVector.EMPTY;
                PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.deref();
                ISeq rargs = argsyms.rseq();
                if (rargs != null) {
                    Object restsym;
                    int higharg = (Integer)((Map.Entry)rargs.first()).getKey();
                    if (higharg > 0) {
                        for (int i = 1; i <= higharg; ++i) {
                            Object sym = argsyms.valAt(i);
                            if (sym == null) {
                                sym = LispReader.garg(i);
                            }
                            args = args.cons(sym);
                        }
                    }
                    if ((restsym = argsyms.valAt(-1)) != null) {
                        args = args.cons(Compiler._AMP_);
                        args = args.cons(restsym);
                    }
                }
                iSeq = RT.list(Compiler.FN, args, form);
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                Var.popThreadBindings();
                throw throwable;
            }
            Var.popThreadBindings();
            return iSeq;
        }
    }

    public static class DispatchReader
    extends AFn {
        public Object invoke(Object reader, Object hash) {
            int ch = LispReader.read1((Reader)reader);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            IFn fn = dispatchMacros[ch];
            if (fn == null) {
                LispReader.unread((PushbackReader)reader, ch);
                Object result = ctorReader.invoke(reader, ch);
                if (result != null) {
                    return result;
                }
                throw Util.runtimeException(String.format("No dispatch macro for: %c", Character.valueOf((char)ch)));
            }
            return fn.invoke(reader, ch);
        }
    }

    public static class VarReader
    extends AFn {
        public Object invoke(Object reader, Object quote) {
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            return RT.list(THE_VAR, o);
        }
    }

    public static class DeprecatedWrappingReader
    extends AFn {
        final Symbol sym;
        final String macro;

        public DeprecatedWrappingReader(Symbol sym, String macro) {
            this.sym = sym;
            this.macro = macro;
        }

        public Object invoke(Object reader, Object quote) {
            System.out.println("WARNING: reader macro " + this.macro + " is deprecated; use " + this.sym.getName() + " instead");
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            return RT.list(this.sym, o);
        }
    }

    public static class WrappingReader
    extends AFn {
        final Symbol sym;

        public WrappingReader(Symbol sym) {
            this.sym = sym;
        }

        public Object invoke(Object reader, Object quote) {
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            return RT.list(this.sym, o);
        }
    }

    public static class DiscardReader
    extends AFn {
        public Object invoke(Object reader, Object underscore) {
            PushbackReader r = (PushbackReader)reader;
            LispReader.read(r, true, null, true);
            return r;
        }
    }

    public static class CommentReader
    extends AFn {
        public Object invoke(Object reader, Object semicolon) {
            int ch;
            Reader r = (Reader)reader;
            while ((ch = LispReader.read1(r)) != -1 && ch != 10 && ch != 13) {
            }
            return r;
        }
    }

    public static class StringReader
    extends AFn {
        public Object invoke(Object reader, Object doublequote) {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = LispReader.read1(r);
            while (ch != 34) {
                if (ch == -1) {
                    throw Util.runtimeException("EOF while reading string");
                }
                if (ch == 92) {
                    ch = LispReader.read1(r);
                    if (ch == -1) {
                        throw Util.runtimeException("EOF while reading string");
                    }
                    switch (ch) {
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 117: {
                            ch = LispReader.read1(r);
                            if (Character.digit(ch, 16) == -1) {
                                throw Util.runtimeException("Invalid unicode escape: \\u" + (char)ch);
                            }
                            ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 16, 4, true);
                            break;
                        }
                        default: {
                            if (Character.isDigit(ch)) {
                                if ((ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 8, 3, false)) <= 255) break;
                                throw Util.runtimeException("Octal escape sequence must be in range [0, 377].");
                            }
                            throw Util.runtimeException("Unsupported escape character: \\" + (char)ch);
                        }
                    }
                }
                sb.append((char)ch);
                ch = LispReader.read1(r);
            }
            return sb.toString();
        }
    }

    public static class RegexReader
    extends AFn {
        static StringReader stringrdr = new StringReader();

        public Object invoke(Object reader, Object doublequote) {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = LispReader.read1(r);
            while (ch != 34) {
                if (ch == -1) {
                    throw Util.runtimeException("EOF while reading regex");
                }
                sb.append((char)ch);
                if (ch == 92) {
                    ch = LispReader.read1(r);
                    if (ch == -1) {
                        throw Util.runtimeException("EOF while reading regex");
                    }
                    sb.append((char)ch);
                }
                ch = LispReader.read1(r);
            }
            return Pattern.compile(sb.toString());
        }
    }

    public static class ReaderException
    extends RuntimeException {
        final int line;

        public ReaderException(int line, Throwable cause) {
            super(cause);
            this.line = line;
        }
    }
}

