/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AMapEntry;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.Box;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Sorted;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class PersistentTreeMap
extends APersistentMap
implements Reversible,
Sorted {
    public final Comparator comp;
    public final Node tree;
    public final int _count;
    public static final PersistentTreeMap EMPTY = new PersistentTreeMap();

    public static IPersistentMap create(Map other) {
        IPersistentMap ret = EMPTY;
        Iterator i$ = other.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = i$.next();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    public PersistentTreeMap() {
        this(RT.DEFAULT_COMPARATOR);
    }

    public PersistentTreeMap withMeta(IPersistentMap meta) {
        return new PersistentTreeMap(meta, this.comp, this.tree, this._count);
    }

    private PersistentTreeMap(Comparator comp) {
        this(null, comp);
    }

    public PersistentTreeMap(IPersistentMap meta, Comparator comp) {
        super(meta);
        this.comp = comp;
        this.tree = null;
        this._count = 0;
    }

    PersistentTreeMap(IPersistentMap meta, Comparator comp, Node tree, int _count) {
        super(meta);
        this.comp = comp;
        this.tree = tree;
        this._count = _count;
    }

    public static PersistentTreeMap create(ISeq items) {
        IPersistentMap ret = EMPTY;
        while (items != null) {
            if (items.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            ret = ret.assoc(items.first(), RT.second(items));
            items = items.next().next();
        }
        return ret;
    }

    public static PersistentTreeMap create(Comparator comp, ISeq items) {
        IPersistentMap ret = new PersistentTreeMap(comp);
        while (items != null) {
            if (items.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            ret = ret.assoc(items.first(), RT.second(items));
            items = items.next().next();
        }
        return ret;
    }

    public boolean containsKey(Object key) {
        return this.entryAt(key) != null;
    }

    public PersistentTreeMap assocEx(Object key, Object val) throws Exception {
        Box found = new Box(null);
        Node t = this.add(this.tree, key, val, found);
        if (t == null) {
            throw new Exception("Key already present");
        }
        return new PersistentTreeMap(this.comp, t.blacken(), this._count + 1, this.meta());
    }

    public PersistentTreeMap assoc(Object key, Object val) {
        Box found = new Box(null);
        Node t = this.add(this.tree, key, val, found);
        if (t == null) {
            Node foundNode = (Node)found.val;
            if (foundNode.val() == val) {
                return this;
            }
            return new PersistentTreeMap(this.comp, this.replace(this.tree, key, val), this._count, this.meta());
        }
        return new PersistentTreeMap(this.comp, t.blacken(), this._count + 1, this.meta());
    }

    public PersistentTreeMap without(Object key) {
        Box found = new Box(null);
        Node t = this.remove(this.tree, key, found);
        if (t == null) {
            if (found.val == null) {
                return this;
            }
            return new PersistentTreeMap(this.meta(), this.comp);
        }
        return new PersistentTreeMap(this.comp, t.blacken(), this._count - 1, this.meta());
    }

    public ISeq seq() {
        if (this._count > 0) {
            return Seq.create(this.tree, true, this._count);
        }
        return null;
    }

    public IPersistentCollection empty() {
        return new PersistentTreeMap(this.meta(), this.comp);
    }

    public ISeq rseq() throws Exception {
        if (this._count > 0) {
            return Seq.create(this.tree, false, this._count);
        }
        return null;
    }

    public Comparator comparator() {
        return this.comp;
    }

    public Object entryKey(Object entry) {
        return ((IMapEntry)entry).key();
    }

    public ISeq seq(boolean ascending) {
        if (this._count > 0) {
            return Seq.create(this.tree, ascending, this._count);
        }
        return null;
    }

    public ISeq seqFrom(Object key, boolean ascending) {
        if (this._count > 0) {
            ISeq stack = null;
            Node t = this.tree;
            while (t != null) {
                int c = this.doCompare(key, t.key);
                if (c == 0) {
                    stack = RT.cons(t, stack);
                    return new Seq(stack, ascending);
                }
                if (ascending) {
                    if (c < 0) {
                        stack = RT.cons(t, stack);
                        t = t.left();
                        continue;
                    }
                    t = t.right();
                    continue;
                }
                if (c > 0) {
                    stack = RT.cons(t, stack);
                    t = t.right();
                    continue;
                }
                t = t.left();
            }
            if (stack != null) {
                return new Seq(stack, ascending);
            }
        }
        return null;
    }

    public NodeIterator iterator() {
        return new NodeIterator(this.tree, true);
    }

    public NodeIterator reverseIterator() {
        return new NodeIterator(this.tree, false);
    }

    public Iterator keys() {
        return this.keys(this.iterator());
    }

    public Iterator vals() {
        return this.vals(this.iterator());
    }

    public Iterator keys(NodeIterator it) {
        return new KeyIterator(it);
    }

    public Iterator vals(NodeIterator it) {
        return new ValIterator(it);
    }

    public Object minKey() {
        Node t = this.min();
        return t != null ? t.key : null;
    }

    public Node min() {
        Node t = this.tree;
        if (t != null) {
            while (t.left() != null) {
                t = t.left();
            }
        }
        return t;
    }

    public Object maxKey() {
        Node t = this.max();
        return t != null ? t.key : null;
    }

    public Node max() {
        Node t = this.tree;
        if (t != null) {
            while (t.right() != null) {
                t = t.right();
            }
        }
        return t;
    }

    public int depth() {
        return this.depth(this.tree);
    }

    int depth(Node t) {
        if (t == null) {
            return 0;
        }
        return 1 + Math.max(this.depth(t.left()), this.depth(t.right()));
    }

    public Object valAt(Object key, Object notFound) {
        Node n = this.entryAt(key);
        return n != null ? n.val() : notFound;
    }

    public Object valAt(Object key) {
        return this.valAt(key, null);
    }

    public int capacity() {
        return this._count;
    }

    public int count() {
        return this._count;
    }

    public Node entryAt(Object key) {
        Node t = this.tree;
        while (t != null) {
            int c = this.doCompare(key, t.key);
            if (c == 0) {
                return t;
            }
            if (c < 0) {
                t = t.left();
                continue;
            }
            t = t.right();
        }
        return t;
    }

    public int doCompare(Object k1, Object k2) {
        return this.comp.compare(k1, k2);
    }

    Node add(Node t, Object key, Object val, Box found) {
        Node ins;
        if (t == null) {
            if (val == null) {
                return new Red(key);
            }
            return new RedVal(key, val);
        }
        int c = this.doCompare(key, t.key);
        if (c == 0) {
            found.val = t;
            return null;
        }
        Node node = ins = c < 0 ? this.add(t.left(), key, val, found) : this.add(t.right(), key, val, found);
        if (ins == null) {
            return null;
        }
        if (c < 0) {
            return t.addLeft(ins);
        }
        return t.addRight(ins);
    }

    Node remove(Node t, Object key, Box found) {
        Node del;
        if (t == null) {
            return null;
        }
        int c = this.doCompare(key, t.key);
        if (c == 0) {
            found.val = t;
            return PersistentTreeMap.append(t.left(), t.right());
        }
        Node node = del = c < 0 ? this.remove(t.left(), key, found) : this.remove(t.right(), key, found);
        if (del == null && found.val == null) {
            return null;
        }
        if (c < 0) {
            if (t.left() instanceof Black) {
                return PersistentTreeMap.balanceLeftDel(t.key, t.val(), del, t.right());
            }
            return PersistentTreeMap.red(t.key, t.val(), del, t.right());
        }
        if (t.right() instanceof Black) {
            return PersistentTreeMap.balanceRightDel(t.key, t.val(), t.left(), del);
        }
        return PersistentTreeMap.red(t.key, t.val(), t.left(), del);
    }

    static Node append(Node left, Node right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof Red) {
            if (right instanceof Red) {
                Node app = PersistentTreeMap.append(left.right(), right.left());
                if (app instanceof Red) {
                    return PersistentTreeMap.red(app.key, app.val(), PersistentTreeMap.red(left.key, left.val(), left.left(), app.left()), PersistentTreeMap.red(right.key, right.val(), app.right(), right.right()));
                }
                return PersistentTreeMap.red(left.key, left.val(), left.left(), PersistentTreeMap.red(right.key, right.val(), app, right.right()));
            }
            return PersistentTreeMap.red(left.key, left.val(), left.left(), PersistentTreeMap.append(left.right(), right));
        }
        if (right instanceof Red) {
            return PersistentTreeMap.red(right.key, right.val(), PersistentTreeMap.append(left, right.left()), right.right());
        }
        Node app = PersistentTreeMap.append(left.right(), right.left());
        if (app instanceof Red) {
            return PersistentTreeMap.red(app.key, app.val(), PersistentTreeMap.black(left.key, left.val(), left.left(), app.left()), PersistentTreeMap.black(right.key, right.val(), app.right(), right.right()));
        }
        return PersistentTreeMap.balanceLeftDel(left.key, left.val(), left.left(), PersistentTreeMap.black(right.key, right.val(), app, right.right()));
    }

    static Node balanceLeftDel(Object key, Object val, Node del, Node right) {
        if (del instanceof Red) {
            return PersistentTreeMap.red(key, val, del.blacken(), right);
        }
        if (right instanceof Black) {
            return PersistentTreeMap.rightBalance(key, val, del, right.redden());
        }
        if (right instanceof Red && right.left() instanceof Black) {
            return PersistentTreeMap.red(right.left().key, right.left().val(), PersistentTreeMap.black(key, val, del, right.left().left()), PersistentTreeMap.rightBalance(right.key, right.val(), right.left().right(), right.right().redden()));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    static Node balanceRightDel(Object key, Object val, Node left, Node del) {
        if (del instanceof Red) {
            return PersistentTreeMap.red(key, val, left, del.blacken());
        }
        if (left instanceof Black) {
            return PersistentTreeMap.leftBalance(key, val, left.redden(), del);
        }
        if (left instanceof Red && left.right() instanceof Black) {
            return PersistentTreeMap.red(left.right().key, left.right().val(), PersistentTreeMap.leftBalance(left.key, left.val(), left.left().redden(), left.right().left()), PersistentTreeMap.black(key, val, left.right().right(), del));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    static Node leftBalance(Object key, Object val, Node ins, Node right) {
        if (ins instanceof Red && ins.left() instanceof Red) {
            return PersistentTreeMap.red(ins.key, ins.val(), ins.left().blacken(), PersistentTreeMap.black(key, val, ins.right(), right));
        }
        if (ins instanceof Red && ins.right() instanceof Red) {
            return PersistentTreeMap.red(ins.right().key, ins.right().val(), PersistentTreeMap.black(ins.key, ins.val(), ins.left(), ins.right().left()), PersistentTreeMap.black(key, val, ins.right().right(), right));
        }
        return PersistentTreeMap.black(key, val, ins, right);
    }

    static Node rightBalance(Object key, Object val, Node left, Node ins) {
        if (ins instanceof Red && ins.right() instanceof Red) {
            return PersistentTreeMap.red(ins.key, ins.val(), PersistentTreeMap.black(key, val, left, ins.left()), ins.right().blacken());
        }
        if (ins instanceof Red && ins.left() instanceof Red) {
            return PersistentTreeMap.red(ins.left().key, ins.left().val(), PersistentTreeMap.black(key, val, left, ins.left().left()), PersistentTreeMap.black(ins.key, ins.val(), ins.left().right(), ins.right()));
        }
        return PersistentTreeMap.black(key, val, left, ins);
    }

    Node replace(Node t, Object key, Object val) {
        int c = this.doCompare(key, t.key);
        return t.replace(t.key, c == 0 ? val : t.val(), c < 0 ? this.replace(t.left(), key, val) : t.left(), c > 0 ? this.replace(t.right(), key, val) : t.right());
    }

    PersistentTreeMap(Comparator comp, Node tree, int count, IPersistentMap meta) {
        super(meta);
        this.comp = comp;
        this.tree = tree;
        this._count = count;
    }

    static Red red(Object key, Object val, Node left, Node right) {
        if (left == null && right == null) {
            if (val == null) {
                return new Red(key);
            }
            return new RedVal(key, val);
        }
        if (val == null) {
            return new RedBranch(key, left, right);
        }
        return new RedBranchVal(key, val, left, right);
    }

    static Black black(Object key, Object val, Node left, Node right) {
        if (left == null && right == null) {
            if (val == null) {
                return new Black(key);
            }
            return new BlackVal(key, val);
        }
        if (val == null) {
            return new BlackBranch(key, left, right);
        }
        return new BlackBranchVal(key, val, left, right);
    }

    static class ValIterator
    implements Iterator {
        NodeIterator it;

        ValIterator(NodeIterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((Node)this.it.next()).val();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class KeyIterator
    implements Iterator {
        NodeIterator it;

        KeyIterator(NodeIterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((Node)this.it.next()).key;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NodeIterator
    implements Iterator {
        Stack stack = new Stack();
        boolean asc;

        NodeIterator(Node t, boolean asc) {
            this.asc = asc;
            this.push(t);
        }

        void push(Node t) {
            while (t != null) {
                this.stack.push(t);
                t = this.asc ? t.left() : t.right();
            }
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            Node t = (Node)this.stack.pop();
            this.push(this.asc ? t.right() : t.left());
            return t;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Seq
    extends ASeq {
        final ISeq stack;
        final boolean asc;
        final int cnt;

        public Seq(ISeq stack, boolean asc) {
            this.stack = stack;
            this.asc = asc;
            this.cnt = -1;
        }

        public Seq(ISeq stack, boolean asc, int cnt) {
            this.stack = stack;
            this.asc = asc;
            this.cnt = cnt;
        }

        Seq(IPersistentMap meta, ISeq stack, boolean asc, int cnt) {
            super(meta);
            this.stack = stack;
            this.asc = asc;
            this.cnt = cnt;
        }

        static Seq create(Node t, boolean asc, int cnt) {
            return new Seq(Seq.push(t, null, asc), asc, cnt);
        }

        static ISeq push(Node t, ISeq stack, boolean asc) {
            while (t != null) {
                stack = RT.cons(t, stack);
                t = asc ? t.left() : t.right();
            }
            return stack;
        }

        public Object first() {
            return this.stack.first();
        }

        public ISeq next() {
            Node t = (Node)this.stack.first();
            ISeq nextstack = Seq.push(this.asc ? t.right() : t.left(), this.stack.next(), this.asc);
            if (nextstack != null) {
                return new Seq(nextstack, this.asc, this.cnt - 1);
            }
            return null;
        }

        public int count() {
            if (this.cnt < 0) {
                return super.count();
            }
            return this.cnt;
        }

        public Obj withMeta(IPersistentMap meta) {
            return new Seq(meta, this.stack, this.asc, this.cnt);
        }
    }

    static class RedBranchVal
    extends RedBranch {
        final Object val;

        public RedBranchVal(Object key, Object val, Node left, Node right) {
            super(key, left, right);
            this.val = val;
        }

        public Object val() {
            return this.val;
        }

        Node blacken() {
            return new BlackBranchVal(this.key, this.val, this.left, this.right);
        }
    }

    static class RedBranch
    extends Red {
        final Node left;
        final Node right;

        public RedBranch(Object key, Node left, Node right) {
            super(key);
            this.left = left;
            this.right = right;
        }

        public Node left() {
            return this.left;
        }

        public Node right() {
            return this.right;
        }

        Node balanceLeft(Node parent) {
            if (this.left instanceof Red) {
                return PersistentTreeMap.red(this.key, this.val(), this.left.blacken(), PersistentTreeMap.black(parent.key, parent.val(), this.right, parent.right()));
            }
            if (this.right instanceof Red) {
                return PersistentTreeMap.red(this.right.key, this.right.val(), PersistentTreeMap.black(this.key, this.val(), this.left, this.right.left()), PersistentTreeMap.black(parent.key, parent.val(), this.right.right(), parent.right()));
            }
            return super.balanceLeft(parent);
        }

        Node balanceRight(Node parent) {
            if (this.right instanceof Red) {
                return PersistentTreeMap.red(this.key, this.val(), PersistentTreeMap.black(parent.key, parent.val(), parent.left(), this.left), this.right.blacken());
            }
            if (this.left instanceof Red) {
                return PersistentTreeMap.red(this.left.key, this.left.val(), PersistentTreeMap.black(parent.key, parent.val(), parent.left(), this.left.left()), PersistentTreeMap.black(this.key, this.val(), this.left.right(), this.right));
            }
            return super.balanceRight(parent);
        }

        Node blacken() {
            return new BlackBranch(this.key, this.left, this.right);
        }
    }

    static class RedVal
    extends Red {
        final Object val;

        public RedVal(Object key, Object val) {
            super(key);
            this.val = val;
        }

        public Object val() {
            return this.val;
        }

        Node blacken() {
            return new BlackVal(this.key, this.val);
        }
    }

    static class Red
    extends Node {
        public Red(Object key) {
            super(key);
        }

        Node addLeft(Node ins) {
            return PersistentTreeMap.red(this.key, this.val(), ins, this.right());
        }

        Node addRight(Node ins) {
            return PersistentTreeMap.red(this.key, this.val(), this.left(), ins);
        }

        Node removeLeft(Node del) {
            return PersistentTreeMap.red(this.key, this.val(), del, this.right());
        }

        Node removeRight(Node del) {
            return PersistentTreeMap.red(this.key, this.val(), this.left(), del);
        }

        Node blacken() {
            return new Black(this.key);
        }

        Node redden() {
            throw new UnsupportedOperationException("Invariant violation");
        }

        Node replace(Object key, Object val, Node left, Node right) {
            return PersistentTreeMap.red(key, val, left, right);
        }
    }

    static class BlackBranchVal
    extends BlackBranch {
        final Object val;

        public BlackBranchVal(Object key, Object val, Node left, Node right) {
            super(key, left, right);
            this.val = val;
        }

        public Object val() {
            return this.val;
        }

        Node redden() {
            return new RedBranchVal(this.key, this.val, this.left, this.right);
        }
    }

    static class BlackBranch
    extends Black {
        final Node left;
        final Node right;

        public BlackBranch(Object key, Node left, Node right) {
            super(key);
            this.left = left;
            this.right = right;
        }

        public Node left() {
            return this.left;
        }

        public Node right() {
            return this.right;
        }

        Node redden() {
            return new RedBranch(this.key, this.left, this.right);
        }
    }

    static class BlackVal
    extends Black {
        final Object val;

        public BlackVal(Object key, Object val) {
            super(key);
            this.val = val;
        }

        public Object val() {
            return this.val;
        }

        Node redden() {
            return new RedVal(this.key, this.val);
        }
    }

    static class Black
    extends Node {
        public Black(Object key) {
            super(key);
        }

        Node addLeft(Node ins) {
            return ins.balanceLeft(this);
        }

        Node addRight(Node ins) {
            return ins.balanceRight(this);
        }

        Node removeLeft(Node del) {
            return PersistentTreeMap.balanceLeftDel(this.key, this.val(), del, this.right());
        }

        Node removeRight(Node del) {
            return PersistentTreeMap.balanceRightDel(this.key, this.val(), this.left(), del);
        }

        Node blacken() {
            return this;
        }

        Node redden() {
            return new Red(this.key);
        }

        Node replace(Object key, Object val, Node left, Node right) {
            return PersistentTreeMap.black(key, val, left, right);
        }
    }

    static abstract class Node
    extends AMapEntry {
        final Object key;

        Node(Object key) {
            this.key = key;
        }

        public Object key() {
            return this.key;
        }

        public Object val() {
            return null;
        }

        public Object getKey() {
            return this.key();
        }

        public Object getValue() {
            return this.val();
        }

        Node left() {
            return null;
        }

        Node right() {
            return null;
        }

        abstract Node addLeft(Node var1);

        abstract Node addRight(Node var1);

        abstract Node removeLeft(Node var1);

        abstract Node removeRight(Node var1);

        abstract Node blacken();

        abstract Node redden();

        Node balanceLeft(Node parent) {
            return PersistentTreeMap.black(parent.key, parent.val(), this, parent.right());
        }

        Node balanceRight(Node parent) {
            return PersistentTreeMap.black(parent.key, parent.val(), parent.left(), this);
        }

        abstract Node replace(Object var1, Object var2, Node var3, Node var4);
    }
}

