/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.RT;
import clojure.lang.Stream;

public class ArrayStream
extends AFn {
    int i = 0;
    final Object[] array;

    public ArrayStream(Object[] array) {
        this.array = array;
    }

    public Object invoke() throws Exception {
        if (this.i < this.array.length) {
            return this.array[this.i++];
        }
        return RT.EOS;
    }

    static Stream createFromObject(Object array) {
        Class<?> aclass = array.getClass().getComponentType();
        if (!aclass.isPrimitive()) {
            return new Stream(new ArrayStream((Object[])array));
        }
        if (aclass == Integer.TYPE) {
            return new Stream(new ArrayStream_int((int[])array));
        }
        if (aclass == Long.TYPE) {
            return new Stream(new ArrayStream_long((long[])array));
        }
        if (aclass == Float.TYPE) {
            return new Stream(new ArrayStream_float((float[])array));
        }
        if (aclass == Double.TYPE) {
            return new Stream(new ArrayStream_double((double[])array));
        }
        if (aclass == Character.TYPE) {
            return new Stream(new ArrayStream_char((char[])array));
        }
        if (aclass == Byte.TYPE) {
            return new Stream(new ArrayStream_byte((byte[])array));
        }
        if (aclass == Short.TYPE) {
            return new Stream(new ArrayStream_short((short[])array));
        }
        if (aclass == Boolean.TYPE) {
            return new Stream(new ArrayStream_boolean((boolean[])array));
        }
        throw new IllegalArgumentException(String.format("Unsupported array type %s", array));
    }

    public static class ArrayStream_boolean
    extends AFn {
        int i = 0;
        final boolean[] array;

        public ArrayStream_boolean(boolean[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return this.array[this.i++];
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_short
    extends AFn {
        int i = 0;
        final short[] array;

        public ArrayStream_short(short[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return this.array[this.i++];
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_byte
    extends AFn {
        int i = 0;
        final byte[] array;

        public ArrayStream_byte(byte[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return this.array[this.i++];
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_char
    extends AFn {
        int i = 0;
        final char[] array;

        public ArrayStream_char(char[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return Character.valueOf(this.array[this.i++]);
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_double
    extends AFn {
        int i = 0;
        final double[] array;

        public ArrayStream_double(double[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return this.array[this.i++];
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_float
    extends AFn {
        int i = 0;
        final float[] array;

        public ArrayStream_float(float[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return Float.valueOf(this.array[this.i++]);
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_long
    extends AFn {
        int i = 0;
        final long[] array;

        public ArrayStream_long(long[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return this.array[this.i++];
            }
            return RT.EOS;
        }
    }

    public static class ArrayStream_int
    extends AFn {
        int i = 0;
        final int[] array;

        public ArrayStream_int(int[] array) {
            this.array = array;
        }

        public Object invoke() throws Exception {
            if (this.i < this.array.length) {
                return this.array[this.i++];
            }
            return RT.EOS;
        }
    }
}

