<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

/*
 * Posts
 * 
 * Post template (keys with empty values may be removed)
 * -------------
insert($POST, array(
"id" => ++$posts,
"title" => "Sample post (id: $posts)", "date" => "Jun 12 2007",
[ "toggle" => <modules list>, ]
[ more_keys => values, ]
"body" => "The post body",
"));
 * -------------
*/

$posts = 0;

/* CHeMS-0.1 */
$__title = "CHeMS-0.1";
insert($POST, array(
"id" => ++$posts,
"title" => isset($_GET['post']) && (int)$_GET['post'] === $posts ? "$__title" :
"<a href='?modname=posts_mgr&amp;post=$posts' title='permalink'>$__title</a>",
"date" => "2007-10-16 16:11",
"categories" => "chems",
"body" => "
The first CHeMS release (0.1) has been published.
<br /><br />
The download page for this release is available
<a href='https://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183&amp;release_id=547399'>here</a>.
"));

/* CHeMS-0.2RC1 */
$__title = "CHeMS-0.2RC1";
insert($POST, array(
"id" => ++$posts,
"title" => isset($_GET['post']) && (int)$_GET['post'] === $posts ? "$__title" :
"<a href='?modname=posts_mgr&amp;post=$posts' title='permalink'>$__title</a>",
"date" => "2007-10-18 14:02",
"categories" => "chems",
"body" => "
First release candidate (RC) of CHeMS 0.2. It includes the following main
changes:

<br />

<ul>
	<li>Added this ChangeLog</li>
	<li>Removed the navbar when there is only one page or post available</li>
	<li>Added the NAVBAR_FORCE_SHOW option which always show the navbar</li>
	<li>Created the getNonPrintIdx() function which is needed to improve
	    the getPost() function to don't truncate the words when the value
	    of POST_MAX_LEN is non-zero</li>
	<li>Fixed the POST_MAX_LEN bug about HTML closing tag in the preview</li>
	<li>Custom titles on modules <q>pages</q> and <q>posts</q> are now allowed</li>
	<li>Fixed the menu generation. Now the elements are moved from a side
	    to another when the element's menu side is disabled</li>
	<li>Moved the modules' options into the <q>modconf.php</q> file</li>
        <li>Improved pages and posts generation</li>
	<li>Fixed bug about *ROOT definitions in <q>index.php</q></li>
	<li>Little improvement about the titles which are now provided two
            differents options for the application title and header title</li>
	<li>Miscellaneous fixes and improvements (and optimizations)</li>
</ul>

The download page for this release is available
<a href='https://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183&amp;release_id=547826'>here</a>.
"));

/* CHeMS-0.2 */
$__title = "CHeMS-0.2";
insert($POST, array(
"id" => ++$posts,
"title" => isset($_GET['post']) && (int)$_GET['post'] === $posts ? "$__title" :
"<a href='?modname=posts_mgr&amp;post=$posts' title='permalink'>$__title</a>",
"date" => "2007-10-28 22:30",
"categories" => "chems",
"body" => "
Released CHeMS 0.2. Merging the changes applied to the first release candidate
(0.2RC1), has been made the following complete list of changes:

<br />

<ul>
	<li>Merged the newpage() and newpost() functions to insert()</li>
	<li>New default theme: <q>clean</q></li>
	<li>The <q>static links</q> module has been written</li>
	<li>New MOD_COMM_FIELD_ANTISPAM option for the <q>comments</q> module</li>
	<li>Added a new set of format operators for the <q>comments</q> module</li>
	<li>Comments system based on the new CHeMS T-F-B DB API</li>
	<li>New CHeMS text-file-based database API: see <q>src/cdb.php</q> for more
	    informations about provided routines</li>
	<li>Added the <q>dir</q> XHTML attribute to the &lt;html&gt; tag in <q>src/main.php</q></li>
	<li>Removed the %[curr_post] format operators. The same results can be
    	    got with the %[elem_curr] when the request type is <q>posts</q></li>
	<li>Removed the fs2ascii() function: it really wasn't needed</li>
	<li>Extended the modules system: now modules can be placed ``inside'' a
	    page beween posts, on bottom or on top, depending on the request type</li>
	<li>Added a new dynamic format operators: %[curr_post] which assumes the
	    ID of the current post in the posts list (request type: posts)</li>
	<li>Fixed *_TITLE about total elements visualization in modconf.php.
	    The \$posts and \$pages variables can't be used there so we have to
	    use the format operators</li>
	<li>Fixed *_MAX stuff of posts_links and pages_links modules</li>
	<li>Improved the modules system</li>
	<li>Added the Blogroll module</li>
	<li>Added the FreeHands module</li>
	<li>Removed TODO file in favour of the feature requests tracking system</li>
	<li>Added this <q>Changes</q> file</li>
	<li>Removed the navbar when there is only one page or post available</li>
	<li>Added the NAVBAR_FORCE_SHOW option which always show the navbar</li>
	<li>Created the getNonPrintIdx() function which is needed to improve
	    the getPost() function to don't truncate the words when the value
	    of POST_MAX_LEN is non-zero</li>
	<li>Fixed the POST_MAX_LEN bug about HTML closing tag in the preview</li>
	<li>Custom titles on modules <q>pages</q> and <q>posts</q> are now allowed</li>
	<li>Fixed the menu generation. Now the elements are moved from a side
	    to another when the element's menu side is disabled</li>
	<li>Moved the modules' options into the <q>modconf.php</q> file</li>
	<li>Improved pages and posts generation</li>
	<li>Fixed bug about *ROOT definitions in <q>index.php</q></li>
	<li>Little improvement about the titles which are now provided two
	    differents options for the application title and header title</li>
	<li>Added the <q>codeout</q> section into the <q>simple</q> theme CSS. Now
	    output and source code can be highlighted and formatted</li>
	<li>Improved the code style</li>
	<li>Added the POST_CONT option which allow to customize the suspension
 	    characters at the end of a truncated post in the posts list/preview</li>
	<li>A lot of minor fixes, improvements and optimizations</li>

</ul>

The download page for this release is available
<a href='https://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183&amp;release_id=550253'>here</a>.
"));

/* CHeMS-0x03 */
$__title = "CHeMS-0x03";
insert($POST, array(
"id" => ++$posts,
"title" => isset($_GET['post']) && (int)$_GET['post'] === $posts ? "$__title" :
"<a href='?modname=posts_mgr&amp;post=$posts' title='permalink'>$__title</a>",
"date" => "2008-02-05 18:45",
"categories" => "chems",
"body" => "
Since the third release (fourth also considering the 0.2RC1) the CHeMS versioning
system has been changed from the decimal notation to the hexadecimal one. Here is
a quote from the relative FAQ:

<br /><br />

<i>
<q>An hexadecimal notation is used in order to mark the CHeMS releases. In
an hex number there are three place where to store version informations:
major number goes befor the 'x' and minor numbers goes after the 'x'. So,
0x01 means major 0 and minor 01. Bugfixes releases are released by using
the previous release hex number followed by an underscore and the ID (in
a decimal form) of the bugfix release, e.g., 0x01_1 means the first bugfix
release of the 0x01 version. That's all.</q>
</i>

<br /><br />

Apart of this <i>geeky</i> change, the following list of improvements has
been done:

<br />

<ul>
	<li>New format operators added, %[pages_total] and %[posts_total], which return
	    the number of elements in its corresponding (pages/posts) .inc file. The
	    format operator has been implemented into the respective modules and not
	    inside the CHeMS core.</li>
	<li>We have now a logo, an header image, and several meta icons. Special thanks
	    to Leonardo Taccari (aka leot).</li>
	<li>A first stub of the guide has been (finally) made (docs/GUIDE).</li>
	<li>Several documentation improvements. New FAQs has been added and the old has
	    been changed relatively to the CHeMS changes.</li>
	<li>The getModule() has been extended and renamed to getModFunc()</li>
	<li>New module <q>showfiles</q>: it's not a real geek module but may be useful in
	    some case. The pages generated are, of course, XHTML-1.1 compliant</li>
	<li>Added the <q>core</q> theme which should be used as start point for all new
	    themes</li>
	<li>Added the monochrome theme. It's the new CHeMS default theme</li>
	<li>All previous themes has been removed</li>
	<li>Changed <q>page_body</q> and <q>page_title</q> IDs to XHTML classes</li>
	<li>New module <q>rssfeeds</q> which consists essentially of a link to an XML page
	    (the feeds) generated dinamycally. It's loaded by default into the
	    <q>posts_mgr</q> module. The feeds RSS version is 2.0</li>
	<li>The insert() function has been rewritten from scratch. Objects insertion
	    is much intuitive and easy to handle for both CHeMS core and modules which
	    can be configured individually for each object (by using the array pairs
	    key/value)</li>
	<li>The navigation bar has been modularized in order to make CHeMS very modular
	    and flexible</li>
	<li>The constants for pathname and files has been (finally) addedd into the
	    index.php file</li>
	<li>Added the <q>categories</q> module which allow to specify tags for both pages
	    and modules</li>
	<li>A file (docs/MODULES) with the descriptions of modules currently released
	    with CHeMS is now provided</li>
	<li>New option MODULES_SECURE which prevents getting pages from modules
	    internals links when the modules are not loaded. This required a new
 	    function: modisload()</li>
	<li>Added an easily configurable multi-color theme: ``colorlite''. See the
	    README file into the <q>themes/colorlite/</q> directory for more informations.</li>
	<li>Added support for configurables multiple modules instances (identifiers)</li>
	<li>New ``meta tags'' instance of the freehands module. It includes by default
	    the following tags: XHTML 1.1, CSS2, Any browser, RSS 2.0, of course
	    CHeMS 0x03 and CC BY-SA 3.0.</li>
	<li>Large amount of changes into the whole sources tree. CHeMS is now full
	    modularized (including posts and pages visualization). The requests types
	    system has been totally removed in favour of the modularized approach. Lots
	    of options has been renamed, removed and added. The modules system has been
    	    improved and a new function modload() has been added. The core file
   	    (main.php) includes lots of changes (it's smaller). CHeMS is now faster and
	    geekest!</li>
	<li>New core implementation: almost the whole CHeMS core (main.php) has been
 	    modified in order to fit the new approach without request types. All the
	    routines has been improved and the modules has been modified in order to
	    be compliant with the new implementation</li>
	<li>The new core implementation allowed to remove the following functions:
	    gnameetAllModules(), getAllSideModulesIdx(), getModPage()</li>
	<li>The old default request type option has been replaced by the DEF_MODNAME
	    one (since there is not the requests types system, anymore)</li>
	<li>Add the modules failure return values CHEMS_MODULE_FAILURE</li>
	<li>Removed the force_lmenu and force_rmenu feature from themes</li>
	<li>Module system has been reimplemented. It's now more flexible, using the
	    array() construct it's possible to easily add new options to the core
	   without have to modify the actual configuration or modules.</li>
	<li>Added the file/md5 pair recognition for getting local files content. This
	   allow modules to call internal files directly from the index.php in order
	   to still get the CHeMS paths constant without have to guess them (as the
	   old <q>rssfeeds</q> module did)</li>
	<li>Removed all classes (src/classes.php file deleted)</li>
	<li>The options CHEMS_HEADER_TITLE and CHEMS_DESCRIPTION has been merged into
	    one option, CHEMS_HEADER</li>
	<li>Various fixes, improvements and code cleanups</li>
</ul>

The download page for this release is available
<a href='https://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183&amp;release_id=574157'>here</a>.
"));

/* CHeMS-0x03_1 */
$__title = "CHeMS-0x03_1";
insert($POST, array(
"id" => ++$posts,
"title" => isset($_GET['post']) && (int)$_GET['post'] === $posts ? "$__title" :
"<a href='?modname=posts_mgr&amp;post=$posts' title='permalink'>$__title</a>",
"date" => "2008-04-20 17:17",
"categories" => "chems",
"body" => "
This is the first patch release of CHeMS (_1), 0x03_1. The following very few
changes has been applied:

<br />

<ul>
	<li>Fixed missing %[elem_curr] format operator in <q>posts_mgr</q></li>
	<li>Fixed wrong URL generation in feed links for <q>rssfeeds</q></li>
	<li>Fixed wrong URI in the MOD_POSTS_SUSP variable</li>
	<li>Others (not so) minor fixes, improvements and code cleanups.</li>
</ul>

The download page for this release is available
<a href='https://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183&amp;release_id=593649'>here</a>.
"));

/* CHeMS-0x04 */
$__title = "CHeMS-0x04";
insert($POST, array(
"id" => ++$posts,
"title" => isset($_GET['post']) && (int)$_GET['post'] === $posts ? "$__title" :
"<a href='?modname=posts_mgr&amp;post=$posts' title='permalink'>$__title</a>",
"date" => "2009-04-09 11:00",
"categories" => "chems",
"body" => "

Release 0x04 of CHeMS. This is a minor release which includes lots of fix and
improvements, among the others, the following:

<br /><br />

<b>Core</b>
<br />
<ul>
	<li>Removed the order field (\$id) from the modload() routine. The problem with
	     that field is that its value only influence the previously loaded modules
	     making impossible to set an absolute id for a module placed randomly into
	     the modload() calls list. A new order mechanism may appear in further
	     releases of CHeMS.</li>
	<li>The following options has been renamed:
	<pre>
        [old name ]		[new name]	[ description ]
        ------------------------------------------------------------
        FIELDS_SEPARATOR	FSL		field separator list
        DEF_MODNAME		BASEMOD		base module
        *_POSTS_*		*_POSTSMGR_*	posts_mgr module
        *_PAGES_*		*_PAGESMGR_*	pages_mgr module
        *_COMM_*		*_COMMENTS_*	comments module</pre>
	</li>

	<li>Fixed an high priority bug about USE_UTF8 which, if disabled, didn't show
	     nothing at all (modules, pages, posts, ...).</li>
	<li>Allowed to load modules which only have pages (_page routine)
	     without a menu block (_main) by setting the \$side and/or the
	     \$mods variable of modload() to <q>none</q>.</li>
	<li>New option TAG_BODY_CODE which allow to append text inside the &lt;body&gt;
	     tag declaration. This may result useful, for example, with the option
	     CHEMS_SECTION_HEAD which includes some Javascript code, then the
	     onLoad() routine may be used inside the TAG_BODY_CODE option in order
	     to run Javascript script on page load.</li>
	<li>Toggle the menu bars when no menu modules are loaded.</li>
	<li>Fixed few problems about loading multiple instances of modules.</li>
	<li>Fixed <q>null modules</q> (which returns NULL or empty strings) which are
	     now fully ignored from CHeMS.</li>
</ul>

<br />
<b>Modules</b>
<br />
<ul>
	<li>Added two options: MOD_COMMENTS_PREFORM and MOD_COMMENTS_POSTFORM
	     which allow to place HTML code before/after the comments module form.</li>
	<li>Integrated categories support based on the categories module into the
	     posts_mgr module in order to allow per-post categories in posts list.
	     A new option MOD_POSTSMGR_SHOWCATS has been provided.</li>
	<li>New options MOD_COMMENTS_MSG_SUBMIT and MOD_COMMENTS_MSG_RESET for the
	     comments module form buttons <q>submit</q> and <q>reset</q>.</li>
	<li>New option MOD_POSTSMGR_LIST_SORT. Need testing.</li>
	<li>Removed the <q>&amp;\$var</q> arguments from the xtrset() call into the modules
	     <q>categories</q> and <q>navbar</q>. The xtrset() definition is unaltered since
	     it already had set the relative arguments to be passed by reference.
	     A new optional argument allow to choose the sorting type (asc, desc).</li>
	<li>Fixed INC files about key values for the insert() routine (id, body, etc.)
	     which was variables, not strings.</li>
	<li>Fixed and cleanups modules with E_ALL PHP messages enabled. All the
	     modules are involved.</li>
	<li>Fixed mkfeed.php which now fetch the feed in reverse order. This is not
	     strictly a fix, rather it's an improvement (more correct behaviour).</li>
	<li>Removed the %[posts_total] format operator from the navbar module.
	     It isn't needed at all since it's show only into the single-post
	     view (where posts_totals and pages_totals coincide).</li>
	<li>New module <q>contacts</q> which allow users to send mails to the listed
	     member (names, not email addresses). This remove the need to public
	     emails into the web application preventing the spam phenomen. NOTE:
	     this module doesn't have any block menu implementation so it need
	     to be linked somewhere with the <q>?modname=contacts</q> URI string. The
	     contacts module is disabled by default.</li>
	<li>Implemented full instances support for all modules. For curious, the
	     following regexp (in Vim) helped a lot:
	     <pre>	%s/\.\(MOD_.*[A-Z]\)/.@constant(\"\\1\$instpfx\")/g</pre>
  
	     The following modules couldn't be changed: pages_mgr, posts_mgr and
	     navbar.</li>
	<li>Fixed MOD_POSTSMGR_POSTSPERPAGE and MOD_POSTSMGR_MAXLEN which had problems
	     with negative values.</li>
	<li>Removed the %[modname] format operator since \$_GET['modname'] produces
	     the same result.</li>
	<li>New module chtheme (change theme) which allow to switch between themes on
	     the fly.</li>
	<li>Fixed HTML modules divs IDs and classes</li>
</ul>

<br />
<b>Documentation</b>
<br />
<ul>
	<li>Fixed a bit of documentation (lots need to be check!) and FAQs.</li>
	<li>Added few FAQs.</li>
   	<li>New chapter <q>Internals</q> into the guide.</li>
	<li>News section about the _CEXEC constant into the guide.</li>
</ul>

<br />
<b>Misc</b>
<br />
<ul>
	<li>The guide has been updated to reflect the upcoming changes.</li>
	<li>Introduced the <q>core</q> meta-theme.</li>
	<li>Theme informations interface has changed. Look a .theme file to learn about
	     the new way to store theme informations.</li>
	<li>Added globals format operators in main.php. Actually only the theme
	     informations has been provided.</li>
	<li>Defined the _CEXEC costant in index.php. This allow to check if a file has been
	     called from the CHeMS core or directly by the user. In the latter case an
	     error message (<q>Restricted access!</q>) is print and none of the code is run.</li>
	<li>New logo. THX to Roberto Cascio to made this nice new image.</li>
	<li>New header, feed RSS and some meta images. THX to Azzurra Di Girolamo to made
	     this great work.</li>
	<li>Lots of fixes and code cleanups.</li>
</ul>
The download page for this release is available
<a href='https://sourceforge.net/project/showfiles.php?group_id=208013&amp;amp;package_id=249183&amp;amp;release_id=574157'>here</a>.
"));

?>
