<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

/*
 * Pages
 *
 * Page template (keys for empty values may be removed)
 * -------------
insert($PAGE, array(
"id" => ++$pages,
"title" => "Page title (id: $pages)", date => "",
[ "toggle" => <modules list>, ]
[ more_keys => values, ]
"body" => "The post body",
"));
 * -------------
*/

$pages = 0;

/* Home page */
$__title = "Home Page";
insert($PAGE, array(
"id" => ++$pages,
"title" => (!isset($_GET['page']) && $GLOBALS["module"]->modname === "pages_mgr") ||
           (isset($_GET['page']) && (int)$_GET['page'] === $pages) ? "$__title" :
"<a href='?modname=pages_mgr&amp;page=$pages' title='permalink'>$__title</a>",
"body" => "
<b>Welcome to CHeMS</b>
<br />
CHeMS is a free (as in freedom) modular code-driven content helper management system
(the first!) written in PHP fully compliant with the XHTML 1.1 and CSS2 standards.
One of its main purpose is to help developers and (not so) advanced users to easily
setting up a web application (blog, site, etc.) without have to deal with the
<q>boring</q> side of this process such as layout generation code, menu blocks and
so on. Its modularization system allow to mantain a light and fast core which only have
to generate the layout and load the modules to delegate all the real and hard work to them.
You never have to learn new weird APIs in order to deal with the CHeMS internals, there is
full controll. That's why CHeMS is not a Content Management System (CMS) but rather it's
an assistant.

<br /><br />

Its main characterists are the following:
<br />

<ul>
	<li>It's free (as in <b>freedom</b>) software!</li>
	<li>Developed from scratch</li>
	<li>Offline editing</li>
	<li>No database requirements</li>
	<li>Compliant with <b>XHTML 1.1</b> and <b>CSS2</b> standards</li>
	<li>Full customizable (through editing its source code)</li>
	<li>Extensible</li>
	<li>Fully modular</li>
	<li>No installation required</li>
	<li>Compatible with both version 4 and 5 of PHP</li>
	<li>It's only <b>pure XHTML</b> and PHP (no PHP extensions, no JavaScript, no other)</li>
</ul>

The latest stable version (<b>0x04</b>) has been released on April 09, 2009.
Next release has not yet been scheduled.
<!-- date('d', strtotime('09 April 2009') - time()) -->

<br /><br />

At the moment there are available most useful (to the author) module which implements
basics functionality. Though it's likely that new module and features will come soon.
The main current goal is to make CHeMS very stable and usable, then the process of
including new features will start again.

<br /><br />

Actually CHeMS is divided into two main modules: pages_mgr and posts_mgr. The first
handle the pages as normal web site does, the second deal with posts in a way similar
to a blog. To see the <i>blog</i> as is as the posts_mgr module made it
<a href='?modname=posts_mgr'>click here</a>.

<br /><br />

You can found more informations into the <a href='?modname=showfiles&amp;id=0&amp;path=docs'>docs/</a>
directory or by visit the CHeMS <a href='http://chems.sf.net/'>official web site</a>. The CHeMS testing
web server is available <a href='http://smoppi.selfip.org/chems/'>here</a>.
<br /><br />

<b>Enjoy CHeMS!</b>.
"));

/* FAQs (taken from the "docs/FAQs" file) */
$__tmp = ""; foreach(file("docs/FAQs") as $ln => $l) $__tmp .= htmlentities($l);
$__title = "FAQs";
insert($PAGE, array(
"id" => ++$pages,
"title" => isset($_GET['page']) && (int)$_GET['page'] === $pages ? "$__title" :
"<a href='?modname=pages_mgr&amp;page=$pages' title='permalink'>$__title</a>",
"body" => "<pre>$__tmp</pre>
")); unset($__tmp);

/* Guide (taken from the "docs/GUIDE" file) */
$__tmp = ""; foreach(file("docs/GUIDE") as $ln => $l) $__tmp .= htmlentities($l);
$__title = "Guide";
insert($PAGE, array(
"id" => ++$pages,
"title" => isset($_GET['page']) && (int)$_GET['page'] === $pages ? "$__title" :
"<a href='?modname=pages_mgr&amp;page=$pages' title='permalink'>$__title</a>",
"body" => "<pre>$__tmp</pre>
")); unset($__tmp);

/* Support */
$__title = "Support";
insert($PAGE, array(
"id" => ++$pages,
"title" => isset($_GET['page']) && (int)$_GET['page'] === $pages ? "$__title" :
"<a href='?modname=pages_mgr&amp;page=$pages' title='permalink'>$__title</a>",
"body" => "
You may need a bit of help with CHeMS, expecially if you are a completely new
user or if you are not much familiar with PHP and (X)HTML. The following is a
comprehensive list of place where you can gather informations and ask for help.
Please, strictly follow the same order as they are placed it in order to save
your and other's time.

<ul style='width: 80%;'>
	<li>
		Frequently Asked Question: this is a list of commons questions
		and the relative answers. It's likely your problem has already
		been asked before so here is a good place to look for. Visit
		the <a href='?page=2'>FAQs page</a> and give it a try.
		<br /><br />
	</li>

	<li>
		Read the guide! It's very useful for new users, further power
		users and developers. I can't guarantee that all things concerning
		CHeMS are explained here; though what you need may easily be
		there. So, be careful while <a href='?page=3'>read it online</a>.
		<br /><br />
	</li>

	<li>
		Search the <a href='http://sourceforge.net/mailarchive/forum.php?forum_name=chems-discuss'>mailing
		list archive</a> to see if someone already had your problem and,
		perhaps, solved it. You could found some post which is not exactly
		what you are looking for but give you a good point to start on
		working at your own solution.
		<br /><br />
	</li>

	<li>
		Okay, at this point i can assume you'd read everything you can.
		If you didn't figure out a solution at your problem (hard but
		still possible) it's a good time to ask on the mailing list.
		Be patient, time is an optional these days. Hopeful someone will
		reply your post in very few days, hours, minutes... The list
		is <a href='http://sourceforge.net/mailarchive/forum.php?forum_name=chems-discuss'>chems-discuss</a>
		and you can subscribe yourself
		<a href='https://lists.sourceforge.net/lists/listinfo/chems-discuss'>here</a>.
		<br />
	</li>
</ul>

If you think you have found a bug and you are absolutely sure it's really a bug,
then <a href='http://sourceforge.net/tracker/?group_id=208013&amp;atid=1003991p'>send a report</a>
including as many nformations as possible. On the contrary, if you think a feature
is fully missing or you need some feature CHeMS doesn't provide yet, try to submit
a <a href='http://sourceforge.net/tracker/?group_id=208013&amp;atid=1003994'>feature
request</a>. The request will be evalutate and, eventually, someone (very likely myself)
will write code you need. Features which conflict with the CHeMS main goals will
be undoubtedly <b>discarded</b>.

<br /><br />

For any other thing use the <a href='http://sourceforge.net/mailarchive/forum.php?forum_name=chems-discuss'>mailing list</a>.
"));

/* Download */
$__title = "Download";
insert($PAGE, array(
"id" => ++$pages,
"title" => isset($_GET['page']) && (int)$_GET['page'] === $pages ? "$__title" :
"<a href='?modname=pages_mgr&amp;page=$pages' title='permalink'>$__title</a>",
"body" => "
<b>Getting CHeMS</b>
<br />
The latest stable release of CHeMS is the 0x03_1. Starting from this release of
CHeMS the versioning system has been changed from the usual decimal notation to
the hexadecimal one. So this release is the 0.3 with the old versioning system.
You can download one of the following tarball (see the current
<a href='https://sourceforge.net/project/shownotes.php?group_id=208013&amp;release_id=574157'>upcoming changes</a>
list to learn about new relevant features of this release).

<br /><br />

<a href='http://downloads.sourceforge.net/chems/chems-0x04.tar.bz2?use_mirror=osdn'>chems-0x04.tar.bz2</a> (314 KiB)<br />
<a href='http://downloads.sourceforge.net/chems/chems-0x04.tar.gz?use_mirror=osdn'>chems-0x04.tar.gz</a> (319 KiB)<br />
<a href='http://downloads.sourceforge.net/chems/chems-0x04.zip?use_mirror=osdn'>chems-0x04.zip</a> (369 KiB)<br />

<br />

Check the
<a href='http://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183&amp;release_id=574157'>release page</a>
for more informations about CHeMS 0x03_1.

<br /><br />

You can also get any older versions from the
<a href='http://sourceforge.net/project/showfiles.php?group_id=208013&amp;package_id=249183'>file releases page</a>.
If you are interested in development activities you may found useful this CVS
<a href='http://sourceforge.net/project/stats/detail.php?group_id=208013&amp;ugn=chems&amp;type=cvs'>statistics page</a>.

<br /><br />

<b>Latest development sources</b>
<br />
It's possible to get the current development branch source code from CVS as follow:

<pre>
   $ cvs -d:pserver:anonymous@chems.cvs.sourceforge.net:/cvsroot/chems co -d chems-dev -P chems
</pre>

For an online browsing of the sources you can use the CVS
<a href='http://chems.cvs.sourceforge.net/chems'>web interface</a>.
"));

/* Project page (redirect) */
insert($PAGE, array(
"id" => ++$pages,
"title" => "<a href='?page=$pages'>Project page</a>",
)); if( isset($_GET['page']) && (int)$_GET['page'] == $pages )
	header("Location: http://sourceforge.net/projects/chems");

/* Releases page (redirect) */
insert($PAGE, array(
"id" => ++$pages,
"title" => "<a href='?page=$pages'>Releases</a>",
)); if( isset($_GET['page']) && (int)$_GET['page'] == $pages )
	header("Location: http://sourceforge.net/project/platformdownload.php?group_id=208013");

?>
