<?php
/* 
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Modules configuration file
*/

/*
 * Pages manager configuration.
 *
 * In order to make the module a bit more flexible, the
 * %[pages_total] format operator is provided. It is
 * replaced with the number of total pages.
*/

/*
 * The pages database
*/
define("MOD_PAGESMGR_DB", PATH_USER . "pages.inc");

/*
 * Max number of links in the "pages_mgr" module
 * Use '0' to disable this limit.
*/
define("MOD_PAGESMGR_PAGE_MAX", 10);

/*
 * Sorting type for the links in the "pages_mgr" module.
 * The allowed values are "asc" (ascending order), "desc"
 * (descending order, this is default) and "none" (disable
 * any kind of sorting.
*/
define("MOD_PAGESMGR_PAGE_SORT", "asc");

/*
 * Max length for the links of the "pages_mgr" module.
 * The values allowed are all integers positive (total
 * length for the link), negative (removes n characters
 * from the end of link) or zero (disable this feature).
*/
define("MOD_PAGESMGR_LINK_LEN", 0);

/*
 * Pages links module's title (shown at the top of the module)
*/
define("MOD_PAGESMGR_PAGE_TITLE", "Menu");

/*
 * Text to show when a non-existent page is requested
*/
define("MOD_PAGESMGR_MSGNOPAGE", "
   <div id='chems_module_error' class='chems_module'>
      <div id='error_title' class='chems_module_title'>Page error.</div>
      <div id='error_body' class='chems_module_body'>
         The selected page doesn't exists (yet/anymore).
      </div>
   </div>
");

/*
 * This text is put before each link in the pages list
*/
define("MOD_PAGESMGR_PRELINK", "");

/*
 * This text is put after each link in the pages list
*/
define("MOD_PAGESMGR_POSTLINK", "<br />");

/*
 * Posts manager configuration.
 *
 * In order to make the module a bit more flexible, the
 * %[posts_total] format operator is provided. It
 * is replaced with the number of total posts.
*/

/*
 * The posts database
*/
define("MOD_POSTSMGR_DB", PATH_USER.      "posts.inc");

/*
 * As MOD_PAGESMGR_PAGE_MAX but for "posts_mgr" module
*/
define("MOD_POSTSMGR_POST_MAX", 10);

/*
 * As MOD_PAGESMGR_PAGE_SORT but for "posts_mgr" module
*/
define("MOD_POSTSMGR_POST_SORT", "none");

/*
 * Sort type for the posts listing.
 * Allowed values: "asc" and "desc" (default)
*/
define("MOD_POSTSMGR_LIST_SORT", "desc");

/*
 * Toggle per-post categories into the posts list
*/
define("MOD_POSTSMGR_SHOWCATS", True);

/*
 * As MOD_PAGESMGR_LINK_LEN but for the "posts_mgr" module
*/
define("MOD_POSTSMGR_LINK_LEN", 0);

/*
 * Posts manager module's title (shown at the top of the module)
*/
define("MOD_POSTSMGR_POST_TITLE", "Posts");

/*
 * Posts separator. The content of this constant
 * is appended after each non-last post into the
 * posts listing.
*/
define("MOD_POSTSMGR_SEP", "<br /><br />");

/*
 * Number of posts to show in each page.
 * The expected value is an integer which may be
 * positive, negative (which case all posts will
 * be shown) or zero (no posts shown - print an
 * error message).
 * 
*/
define("MOD_POSTSMGR_POSTSPERPAGE", 3);

/*
 * Max length for the post body in the main page.
 * If zero the whole post is shown, if negative
 * the specified number of characters is removed
 * beginning from the end of the post body. A
 * suspension string is automatically added at
 * the end of the truncated posts (see also the
 * MOD_POSTSMGR_SUSP option).
*/
define("MOD_POSTSMGR_MAXLEN", 150);

/*
 * Suspension characters. This value is placed at
 * the end of a post preview which has been truncated
 * by the POST_MAX_LEN option.
*/
define("MOD_POSTSMGR_SUSP", "
.. <a href='?modname=posts_mgr&amp;post=%[elem_curr]'>Read more</a>
");

/*
 * Non existent post (or just wrong request) message.
 * This message is shown when something in the request
 * is not valid (e.g. the type or the the page/post ID).
 * This message also replace the missing posts (this can only
 * occurr if you don't respect the posts sequence in "posts.inc").
 * To prevent this kind of errors ensure to increment the $posts
 * variable ONLY _before_ write a new posts (possibly inside the
 * $POST index, as in $POST[++$posts]).
*/
define("MOD_POSTSMGR_MSGNOPOST", "
   <div id='error_title' class='chems_module_title'>Post error.</div>
   <div id='error_body' class='chems_module_body'>
      The selected post doesn't exists (yet/anymore).
   </div>
");

/*
 * This text is put before each link in the pages list
*/
define("MOD_POSTSMGR_PRELINK", "");

/*
 * This text is put after each link in the pages list
*/
define("MOD_POSTSMGR_POSTLINK", "<br />");

/*
 * Freehands module
 *
 * This module supports multiple instances. Please, see the
 * CHeMS guide (docs/GUIDE) to learn more about whai it is
 * and how to use it.
*/

/*
 * The main instance title
*/
define("MOD_FREEHANDS_TITLE", "Freehands");

/*
 * The main instance body
*/
define("MOD_FREEHANDS_BODY", "
   <div style='text-align: justify;'>
      This is the <b>FreeHands</b> module body. Add here all your stuff.
   </div>
"
);

/*
 * Meta tags instance of the freehands module
*/

/* title */
define("MOD_FREEHANDS_TITLE_META", "Meta tags");

/* body */
define("MOD_FREEHANDS_BODY_META", "
   <p style='text-align: center;'>

   <!-- Valid XHTML 1.1 page -->
   <a href='http://validator.w3.org/check/referer'><img
      src='usr/images/meta/xhtml11.png' alt='Valid XHTML 1.1 page' />
   </a>
   
   <!-- Valid CSS2 -->
   <a href='http://jigsaw.w3.org/css-validator/check/referer'><img
      src='usr/images/meta/css2.png' alt='Valid CSS2' />
   </a>

   <!-- Viewable with any browser -->
   <a href='http://www.anybrowser.org/campaign/'><img
      src='usr/images/meta/anybrowser.png' alt='Viewable with any browser' />
   </a>

   <!-- RSS 2.0 feeds -->
   <a href='http://www.rssboard.org/rss-specification'><img
      src='usr/images/meta/rss2.png' alt='RSS 2.0 feeds' />
   </a>

   <!-- CHeMS -->
   <a href='http://chems.sourceforge.net/'><img
      src='usr/images/meta/chems.png' alt='CHeMS 0x04' />
   </a>

   <!-- Creative Commons -->
   <a href='http://creativecommons.org/licenses/by-sa/3.0/'><img
      src='usr/images/meta/cc-by-sa30.png'
      alt='Creative Commons License' />
   </a>

   </p>
");

/*
 * "Thanks" instance of the freehands module
*/
define("MOD_FREEHANDS_TITLE_THX", "Special Thanks");
define("MOD_FREEHANDS_BODY_THX", "
	<p style='text-align: center; margin-top: 0px;'>
		<b>Roberto Cascio</b> and <b>Azzurra Di Girolamo</b>,
		which provides such minimal but elegant logo, a wonderful
		header image and others.
	</p>
	<span style='text-align: center;'>
		<img	src='".WEBROOT."usr/images/logo.png'
			alt='CHeMS Logo' width='120px' />
	</span>
");

/*
 * Links instance of the freehands module
*/

/* title */
define("MOD_FREEHANDS_TITLE_LINKS", "Links");

/* body */
define("MOD_FREEHANDS_BODY_LINKS", "
   <!-- SourceForge -->
   <a href='http://sourceforge.net/'>SourceForge</a><br />

   <!-- WWW Consortium -->
   <a href='http://w3c.org/'>WWW Consortium</a><br />

   <!-- PHP.net -->
   <a href='http://php.net/'>PHP.net</a><br />

");


/*
 * Blogroll module
 *
 * The %[blogs] format operator is provided, which
 * is provided by the number of blogs into the roll.
*/

/* title */
define("MOD_BLOGROLL_TITLE", "Blogroll (%[blogs])");

/* rolls */
$MOD_BLOGROLL_ROLL = array(

/*
 * "User", "URL"
*/

// Claudio M. Alessi
array("Claudio M. Alessi", "http://cma.teroristi.org/chems/?modname=posts_mgr"),

);

/*
 * Comments system module
*/

/*
 * File used as comments database. All the comments will be
 * stored here; removing/renaming this file will toggle all
 * the comments from the ``front office'' web interface.
*/
define("MOD_COMMENTS_DBFILE", PATH_USER."comments.db");

/*
 * Messages
*/

/*
 * Set the title for the comment form
*/
define("MOD_COMMENTS_MSG_TITLE", "Leave a comment");

/*
 * Information message to show when a comment
 * has been inserted succeffully
*/
define("MOD_COMMENTS_MSG_INSOK", "
   <h3>Your comment has been posted successfully.</h3>
");

/*
 * Information message to show when something
 * went wrong while inserting a new comment.
*/
define("MOD_COMMENTS_MSG_INSKO", "
   <h3>Sorry, your comment could not be insert.</h3>
");

/*
 * Informations message to show when the visitor
 * inserted a wrong anti-spam code (o didn't insert
 * it at all)
*/
define("MOD_COMMENTS_MSG_WRONGSPAMCODE", "
   <h3>Wrong anti-spam code. Please, try again.</h3>
");

/*
 * Label for the visitor name field
*/
define("MOD_COMMENTS_MSG_FIELDNAME", "Name");

/*
 * Label for the visitor page field
*/
define("MOD_COMMENTS_MSG_FIELDPAGE", "Page");

/*
 * Label for the submit button
*/
define("MOD_COMMENTS_MSG_SUBMIT", "Send");

/*
 * Label for the reset button
*/
define("MOD_COMMENTS_MSG_RESET", "Clear");

/*
 * Label for the visitor email field
*/
define("MOD_COMMENTS_MSG_FIELDMAIL", "Email (don't published)");

/*
 * Label for the comment body field
*/
define("MOD_COMMENTS_MSG_FIELDBODY", "Body");

/*
 * Label for the anti-spam code field
*/
define("MOD_COMMENTS_MSG_FIELDCODE", "Insert the following code: ");

/*
 * Message to notice how many comments
 * are available for the current page.
*/
define("MOD_COMMENTS_MSG_TOTAL", "This post contains <b>%[totals]</b> comment(s).<br /><br />");

/*
 * As MOD_COMMENTS_MSG_TOTAL but it's shown
 * where there are no comments availables
*/
define("MOD_COMMENTS_MSG_NONE", "<h3>There are no comments, yet.</h3>");

/*
 * The following values are used by the format operators (see below)
 * when a specified information is missing for a field.
*/

/* author's name */
define("MOD_COMMENTS_UKN_AUTHORNAME", "Unknown author");

/* author's page */
define("MOD_COMMENTS_UKN_AUTHORPAGE", "No page");

/* author's email */
define("MOD_COMMENTS_UKN_AUTHOREMAIL", "No email");

/*
 * Comment box.
 * This is the single comment published in the pages.
 * You can use the format operators provided by the
 * module in order to show the comments as you like.
 * The availables format operators are the following:
 *
 *    %[name]		Author's full name
 *    %[page]		Author's web page
 *    %[email]		Author's email address
 *    %[body]		Author's message (the comment itself)
 *
 * Another "special" format operator is provided. It's
 * dynamic, this mean it change depending on some condition:
 *
 *    %[dyname]		Author's name (dynamic)
 *
 * This format operator is essentially the same as %[name]
 * except for the following: if a web page is given, than
 * the return value is a link to this page URL; if no
 * author's name is given then the value assumed by the
 * operator is read from the string specified to the option
 * "MOD_COMMENTS_MSG_AUTHORUKN". If only the name is given
 * and no author's web page is specified, the operator acts
 * exacltly as %[name]. This format operator always return
 * a value between the <b></b> HTML tags.
 * 
*/
define("MOD_COMMENTS_COMM_BOX", "
   %[dyname]
   %[body]
   <br /><br />
");

/*
 * HTML code to put before the comments form
*/
define("MOD_COMMENTS_PREFORM", "");

/*
 * HTML code to put after the comments form
*/
define("MOD_COMMENTS_POSTFORM", "
   <i>None of the above fields except the body and,
   of course, the anti-spam code, are mandatory.</i>
");

/*
 * Toggle the anti-spam verification code for comments post
*/
define("MOD_COMMENTS_FIELD_ANTISPAM", True);

/*
 * The length for the spam code
*/
define("MOD_COMMENTS_CODE_LEN", 5);

/*
 * Showfiles module
 *
*/

/*
 * Showfiles title
 *
 * The %[dirs] format operator is provided which is
 * replaced with the number of directories in list.
*/
define("MOD_SHOWFILES_TITLE", "Directories");

/*
 * Toggle the links from the directory listing obejects
*/
define("MOD_SHOWFILES_LINK", True);

/*
 * Showfiles paths list.
 * It's possible to use any path here but the files out of
 * the WWW root directory (that accessible from the web server)
 * are not linked. The ".." path is ignored so as all the paths
 * that contains the ".." string; this choice has been made due
 * to security reason. If such paths are encountered then the
 * message specified with MOD_SHOWFILES_EPERM (see below) is
 * print and no files are listed. Absolute path are allowed and
 * the "." can be used (since it represent che current WWW root
 * directory).
*/
$MOD_SHOWFILES_PATHS = array(

/*
 * "link name", "path"
*/

array("Documentation", "docs"),
array("User files", "usr"),
array("Source code", "src"),
array("Modules", "modules"),
array("Themes", "themes"),
array("Web root", "."),

);

/*
 * Perl Compatible Regular Expression (PCRE) which
 * allow to hide all matchig files (so the directory
 * too, of course) from the files list
*/
define("MOD_SHOWFILES_HIDE", "/^[\.-].*/");

/*
 * Toggle the symbolic links from listing. This value
 * set if show or not the symlink into the files list.
*/
define("MOD_SHOWFILES_SYMLINK", True);

/*
 * Page header for the directories
*/
define("MOD_SHOWFILES_PAGEHEAD", "<h3>Path: %[linked_path] %[uplink]</h3>");

/*
 * Message to show when the path ID is not recognized.
 * This may happen only if a wrong URL has been typed.
*/
define("MOD_SHOWFILES_MSG_INVID", "<h3>Invalid path ID.</h3>");

/*
 * Message to show when the given path is not recognized
 * (due to a wrong or malicious URL) or when the ".."
 * string is used as path in MOD_SHOWFILES_PATHS (see
 * above). If you followed a different way before to get
 * this message, be enjoy: you found a new bug :-)
 * In this case, please submit a report or contact us as
 * soon as possible. Thanks.
*/
define("MOD_SHOWFILES_MSG_EPERM", "<br /><h3>Wrong path or permission denied.</h3>");

/*
 * Name of the link to the parent directory
*/
define("MOD_SHOWFILES_PLNAME", "[ &uarr; ]");

/*
 * Specify the visualization type for the files. Actually the only
 * type implemented are the following:
 *
 *    list:	just show the files, one for line. Each file is
 *              preceded by a flags field which contains few
 *              informations about the file.
 *
 *    image:	show the files nicely and use an graphical interface
 *              a bit improved. No flags field are provided and the
 *              output have some unseful user configurable option.
 *
 * No real documentation exists; the source code is the better way
 * to understand how this module works. You can also try to do some
 * test, even if you are not a PHP coder (you should be, btw :P).
*/
define("MOD_SHOWFILES_LSTYPE", "image");

/*
 * Set the number or columns in which the files have to be disposed.
 * Negative values can be used but are treat exactly as positive. A
 * value of zero disable this feature; this mean that there is not
 * any newline (<br />) included at all. In this case the files are
 * dispose depending on the CHeMS layout.
 *
 * This option only works with MOD_SHOWFILES_LSTYPE set to "image".
*/
define("MOD_SHOWFILES_COLS", 4);

/*
 * Max length for filenames. A value of zero don't show
 * the filename at all. Negative values are allewed too
 * in order to start removing from the end of filename.
*/
define("MOD_SHOWFILES_FILEMAXLEN", 19);

/*
 * Toggle files sorting. If enabled the files are sort
 * alphabetically and the directories are placed at the
 * bottom of the list. If disable no sorting algorhytms
 * are used at all.
*/
define("MOD_SHOWFILES_SORT", True);

/*
 * Informations area. Here it's possible to write a bit of
 * more or less useful informations about the current "view".
 * The whole text is put at the bottom of the page after the
 * files and directories. A format operator is provided in
 * order to insert the number of files (%[files_tot]). It's
 * possible that in further versions of the "showfiles"
 * module will be implemented a couple of useful format
 * operators but ATM it's only a beta testing feature.
*/
define("MOD_SHOWFILES_INFO", "
   <br />
   Totals: %[files_tot]<br />
   ".(MOD_SHOWFILES_HIDE?"Filter: ".MOD_SHOWFILES_HIDE."<br />" : "")."
");

/*
 * Set the position where to show the informations from the option
 * MOD_SHOWFILES_INFO or if don't show them at all. The implemented
 * values are the follow:
 *
 *    up: show the statistics before the files list
 *  down: show the statistics after the files list
 *  both: show the statistics before and after the files list
 *  none: don't show the statistics at all
 *
*/
define("MOD_SHOWFILES_INFOPOS", "down");

/*
 * Message to show when the directory is empty
*/
define("MOD_SHOWFILES_EMPTYDIR", "<h3>The directory is empty.</h3>");

/*
 * Message to show when the directory doesn't exists
*/
define("MOD_SHOWFILES_WRONGDIR", "<h3>The directory doesn't exists.</h3>");

/*
 * List of the images file extensions for which have to be shown a
 * preview, rather than the module's icons. You can use any valid
 * separator here. See also the CHeMS option FSL.
*/
define("MOD_SHOWFILES_IMGEXTS", "png jpeg jpg gif ico");

/*
 * Configure the inline style for the icons (<img>)
*/
define("MOD_SHOWFILES_IMGSTYLE", "
width:    50%;
height:   50%;
margin:   10%;
border:   none;
");

/*
 * Set the inline style for the table (all objects)
 *
 * The margin-* directives are needed to center the tables. Toggle one
 * of margin left or right for a left or right alignment. If none are
 * presents, then the default alignment (left) is used instead.
*/
define("MOD_SHOWFILES_TBLSTYLE", "
text-align: center;
margin-left: auto;
margin-right: auto;
");

/*
 * Set the inline style for the objects into the table (the <td>s)
*/
define("MOD_SHOWFILES_OBJSTYLE", "
width: 150px;
border: 0.2px solid gray;
");

/*
 * Icons settings
*/

/*
 * The path where to search the (local or remote) icons. This path
 * must be a web sub-directory (to be clear, have to be under the
 * WEBROOT) accessible by the web server. If not, the icons are
 * not shown at all.
 *
 * It's possible to set this value to both local or remote path; the
 * icons file names are append to it automatically in order to generate
 * a complete local path or web URL. Finally don't forget to add the
 * trailing slash.
 *
 * NOTE: if an icon starts with a non local suffix (as http://
 * or ftp://) then this value is not checked at all and the
 * given (full - absolute) remote path is used instead.
*/
define("MOD_SHOWFILES_ICONSDIR",
   "http://upload.wikimedia.org/wikipedia/commons/thumb/");

/*
 * Directories icon
*/
define("MOD_SHOWFILES_ICON_DIR",
   "d/dd/Edge-drawer.png/120px-Edge-drawer.png");

/*
 * Regular files icon
*/
define("MOD_SHOWFILES_ICON_FILE",
   "1/16/Edge-gnome-fs-desktop.png/120px-Edge-gnome-fs-desktop.png");

/*
 * Symbolic links icon
*/
define("MOD_SHOWFILES_ICON_SYMLINK",
   "6/6a/Edge-emblem-symbolic-link.png/120px-Edge-emblem-symbolic-link.png");

/*
 * Unreadable files icon
*/
define("MOD_SHOWFILES_ICON_UNREADABLE",
   "e/e3/Edge-gtk-stop.svg/120px-Edge-gtk-stop.svg.png");

/*
 * RSS Feeds module
*/

/*
 * Name of the link
*/
define("MOD_RSSFEEDS_LINKNAME", "
<img src='".WEBROOT."usr/images/feed.png' alt='RSS Feeds' />
");

/*
 * Text to show when the mouse is hover on the RSS Feeds icon
*/
define("MOD_RSSFEEDS_LINKTITLE", "Feeds RSS");

/*
 * Objects to include.
 * A value of zero disable this limit.
*/
define("MOD_RSSFEEDS_MAXOBJS", 5);

/*
 * Alignment: since this module will likely never moved
 * from its current position (at the bottom of the selected
 * requests) it's nice to have such option in order to leave
 * users enjoy with differents choice. All styles "text-align"
 * values are allowed.
*/
define("MOD_RSSFEEDS_ALIGN", "right");

/*
 * RSS Feed title
*/
define("MOD_RSSFEEDS_RSSTITLE", "Title of the RSS Feeds list");

/*
 * RSS Feed description
*/
define("MOD_RSSFEEDS_DESCR", "Description of the RSS Feeds list");

/*
 * Maximum length for the RSS item description
*/
define("MOD_RSSFEEDS_LEN", 250);

/*
 * Suspension characters. This value is placed at
 * the end of a post preview which has been truncated
 * by the MOD_RSSFEEDS_LEN option.
*/
define("MOD_RSSFEEDS_SUSP", " [ .. ]");

/*
 * Navigation bar
*/

/*
 * In order to make this module very flexible, the following formats
 * operators are provided:
 *
 *    %[post_prev]
 *
 *       Get the previous available post ID in a "circular" way. If the
 *       current post is the first available, then its value become the
 *       ID of the last available post.
 *
 *    %[post_next]
 *
 *       Get the next available post ID in a "circular" way. If the
 *       current post is the last available, then its value become the
 *       ID of the first available post.
 *
 *    %[posts_total_link]
 *
 *       As %[posts_total] but create a link to the post ID. If the
 *       current ID is equal to the total posts number, then no link is
 *       created and this acts exactly as %[posts_total]
 *
 *    %[page_prev]
 *
 *       Get the previous available page ID in a "circular" way. If the
 *       current page is the first available, then its value become the
 *       ID of the last available page.
 *
 *    %[page_next]
 *
 *       Get the next available page ID in a "circular" way. If the
 *       current page is the last available, then its value become the
 *       ID of the first available page.
 *
 *    %[pages_total]
 *
 *       Number pages available
 *
 *    %[pages_total_link]
 *
 *       As %[pages_total] but create a link to the page ID. If the
 *       current ID is equal to the total pages number, then no link is
 *       created and this acts exactly as %[pages_total]
 *
 *    %[post_inf]
 *
 *       Post with the lowest ID in the current page
 *
 *    %[post_sup]
 *
 *       Post with the highest ID in the current page
*/

/*
 * Navigation bar for the single post visualization.
 * This is included when the request type is "post".
*/
define("MOD_NAVBAR_MSGPOST", "
   Post %[elem_curr] of %[posts_total_link] ::
   <a href='?modname=posts_mgr&amp;post=%[post_prev]'>Previous</a> /
   <a href='?modname=posts_mgr&amp;post=%[post_next]'>Next</a>
");

/*
 * Navigation bar for the page visualization.
 * This is included when the request type is "page".
*/
define("MOD_NAVBAR_MSGPAGE", "
   Page %[elem_curr] of %[pages_total_link] ::
   <a href='?modname=pages_mgr&amp;page=%[page_prev]'>Previous</a> /
   <a href='?modname=pages_mgr&amp;page=%[page_next]'>Next</a>
");

/*
 * Navigation bar for the posts visualization.
 * This is included when the request type is "posts".
*/
define("MOD_NAVBAR_MSGPOSTS", "
   Page %[elem_curr] of %[pages_total_link] ::
   Post from <a href='?modname=posts_mgr&amp;post=%[post_sup]'>%[post_sup]</a>
   to <a href='?modname=posts_mgr&amp;post=%[post_inf]'>%[post_inf]</a> ::
   <a href='?modname=posts_mgr&amp;list=%[page_prev]'>Previous</a> /
   <a href='?modname=posts_mgr&amp;list=%[page_next]'>Next</a><br />
");

/*
 * Categories
 *
 * In order to make this module a bit more flexible the
 * following format operators has been provided:
 *
 *    %[name]
 *
 *       Name of the current category. It's replaced with the current
 *       category name if in a page or with the name of each category
 *       in a block. This format operator isn't expanded if used into
 *       the MOD_CATEGORIES_BLOCKTITLE option.
 *
 *    %[elements]
 *
 *       Number of elements which are members of the current category.
 *
 *    %[type]
 *
 *       Since this module is designed to work with the "posts_mgr"
 *       and "pages_mgr" module, it's possible to get the type (post
 *       or page) for the current page.
 *
 *    %[categories]
 *
 *       Total number of categories.
 *
 * Note that the behaviour of the format operators may change depending
 * on the option they are used (e.g. the %[name] may or may not be linked
 * to the relative category page, etc.). More specifics format operators
 * could be provided by other options (as MOD_CATEGORIES_OBJECT).
 *
*/

/*
 * The categories module block title
 *
 * The format operator %[categories] is provided which
 * is replaced with the number of totals categories.
*/
define("MOD_CATEGORIES_BLOCKTITLE", "Categories (%[categories])");

/*
 * The categories module page title
*/
define("MOD_CATEGORIES_PAGETITLE", "Category: %[name]");

/*
 * Message to show when there are no categories.
 * See also the MOD_CATEGORIES_UNSHOW option.
*/
define("MOD_CATEGORIES_NOCATS", "No categories");

/*
 * Toggle the module when there are no categories
*/
define("MOD_CATEGORIES_UNSHOW", True);

/*
 * Set the maximum zoom level. This value specify all the
 * possible sizes (starting from 1) for the categories. A
 * value of zero disable the zoom.
*/
define("MOD_CATEGORIES_ZOOM", 9);

/*
 * Link name.
 * This is the text it's shown for each category found.
 *
 * See also the MOD_CATEGORIES_ZOOM option
*/
define("MOD_CATEGORIES_LINK", "%[name]");

/*
 * Introduction text for the current category page.
 * This text is put at the bottom of a category, before the
 * objects list.
*/
define("MOD_CATEGORIES_INTRO", "
   <b>%[elements]</b> %[type](s) in this category.
   <br /><br />
");

/*
 * This represent the single object shown into the selected category
 * page. For each element this option is parsed, all format operators
 * are expanded and finally the text is included into the page.
 * The following format operators are provided:
 *
 *    %[object]		the object (page/post) title
 *    %[cats]		a list of linked related categories
*/
define("MOD_CATEGORIES_OBJECT", "
   <b>%[object]</b>
   <br />
   Categories: %[cats]
   <br /><br />
");

/*
 * The change theme module
*/

/*
 * Change theme block title
*/
define("MOD_CHTHEME_TITLE", "Change theme");

/*
 * Text to show when no themes are availables
*/
define("MOD_CHTHEME_NOTHEMES", "There are no themes availables.");

/*
 * The contacts module
*/

/*
 * Contacts module title
*/
define("MOD_CONTACTS_TITLE", "Contacts");

/*
 * Pre form text
*/
define("MOD_CONTACTS_PREFORM", "
<br />
Please, contact us by choosing one of the listed contact
names in order to send an email directly to the interested
email address. To be as detailed as possible allow you to
got better reply and sooner. Thank you to contacted us.
<br /><br />
");

/*
 * Post form text
*/
define("MOD_CONTACTS_POSTFORM", "
<br />
Our team will reply to you as soon as possible. Please, be
patient and check your email address to ensure a reply has
been received. We are working for you!
<br /><br />
");

/*
 * Message to show after the mail has been sent successfully
*/
define("MOD_CONTACTS_FINISH", "
Your mail has been received. Thank you to contacted us!
");

/*
 * Message to show if the mail has not been sent
*/
define("MOD_CONTACTS_ERROR", "
An error occurred while sending your mail. Please, contact
the <a href='#'>webmaster</a> of this site in order to help
us to correct the problem. Thanks!
");

/*
 * Message to show for the wrong requests (actually wrong value,
 * other than "send", for the "do" variable of the GET method.
*/
define("MOD_CONTACTS_WRONG", "
An invalid request has been sent. Please, contact the
<a href='#'>webmaster</a> of this site in order to help us to
correct the problem. Thanks!
");

/*
 * Text to prepend to the user sujbect. Useful to quickly identify
 * and/or easily filter the mails.
*/
define("MOD_CONTACTS_PRESUBJ", "[chems]: ");

/*
 * Contacts form title
*/
define("MOD_CONTACTS_FORM_TITLE", "Contact us");

/*
 * Contacts form member field name
*/
define("MOD_CONTACTS_FIELDPEOPLE", "To member");

/*
 * Contacts form name field name
*/
define("MOD_CONTACTS_FIELDNAME", "Name");

/*
 * Contacts form sujbect field name
*/
define("MOD_CONTACTS_FIELDSUBJ", "Subject");

/*
 * Contacts form body field name
*/
define("MOD_CONTACTS_FIELDBODY", "Body");

/*
 * Contacts form body field name
*/
define("MOD_CONTACTS_FIELDEMAIL", "Email");

/*
 * Contacts form ``mail copy'' checkbox name
*/
define("MOD_CONTACTS_FIELDCOPY", "Send a copy of this mail to your address.");

/*
 * Replacement for the name field when empty
*/
define("MOD_CONTACTS_NOFIELD_NAME", "[EMPTY NAME]");

/*
 * Replacement for the subject field when empty
*/
define("MOD_CONTACTS_NOFIELD_SUBJ", "[EMPTY SUBJ]");

/*
 * Replacement for the mail field when empty
*/
define("MOD_CONTACTS_NOFIELD_MAIL", "[EMPTY MAIL]");

/*
 * Replacement for the body field when empty
*/
define("MOD_CONTACTS_NOFIELD_BODY", "[EMPTY BODY]");

/*
 * Contacts module names and addresses list
*/
$MOD_CONTACTS_NAMES = array(

/*
 * name (listed), address (hidden)
*/
array("Claudio M. Alessi", "smoppy@gmail.com"),

);

/*
 * Label for the submit button
*/
define("MOD_CONTACTS_SUBMIT", "Send");

/*
 * Label for the reset button
*/
define("MOD_CONTACTS_RESET", "Clear");

// Commons routines
require_once(PATH_MODULES."commons.php");

?>
