<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * CHeMS configuration
 *
 * NOTE: there is no check for the values, yet. This mean
 * that CHeMS will NOT notice you about errors. Please, be
 * careful before change any value while your application
 * is online.
 *
 * The following globals format operators are provided:
 *
 *    %[chems_version]	Current CHeMS release version
 *
 *    %[theme_name]	Name of the current theme
 *    %[theme_version]	Version of the current theme
 *    %[theme_lang]	Lang of the current theme
 *    %[theme_favicon]	Favicon of the current theme
 *    %[theme_css]	StyleSheet of the current theme
 *
*/


/*
 * The name of the application (blog or site). This is the application
 * title which is shown in the browser titlebar only. See also the
 * CHEMS_HEADER_TITLE option.
*/
define("CHEMS_APP_TITLE", "CHeMS-0x04");

/*
 * The CHeMS header. It's shown at the top of each page so it
 * is the good place where to put the application title, logo
 * and description.
*/
define("CHEMS_HEADER", "
   <div id='chems_title'>

      ". // Link the header if it's not the home page
      ( ! ( isset($_GET['page']) || isset($_GET['post']) || isset($_GET['modname']) ) ? "" : "<a href='".WEBROOT."'>")."

      <img
         src='".WEBROOT."usr/images/header.png'
	 alt='CHeMS header image' title='Home Page' />

      ". // Close the <a> tag, if needed
      ( ! ( isset($_GET['page']) || isset($_GET['post']) || isset($_GET['modname']) ) ? "" : "</a>")."

      <br />
      The geekest content helper management system
      <br /><br />
   </div>
   <div>
      This is the header of <b>CHeMS-%[chems_version]</b> with the
      <b>%[theme_name]</b> (v. %[theme_version]) theme, which uses
      the <b>%[theme_lang]</b> encoding.<br /> Current favicon is
      &quot;%[theme_favicon]&quot; and the style file is
      &quot;%[theme_css]&quot;.
   </div>
"); // End of header

/*
 * The footer (always shown)
*/
define("CHEMS_FOOTER", "
   <br /><br />

   ".date("l d F Y")." - ".date("G:i:s")."
   (<a href='http://en.wikipedia.org/wiki/Unix_time'>Unix time</a>:
   ".time().")<br />
   Last modified: " . date("m/d/Y - h:ia", filemtime(PATH_USER)) . "
   <br />-<br />
   This is an <a href='http://validator.w3.org/check/referer'>XHTML 1.1</a>
   and <a href='http://jigsaw.w3.org/css-validator/check/referer'>CSS2</a>
   valid page powered by <a href='http://chems.sourceforge.net/'>CHeMS</a>.
   <br /> &copy; 2007-".date("Y")." Claudio M. Alessi - Email: smoppy AT gmail.com.
"); // End of footer

/*
 * The head section.
 * The whole content will be put at the bottom of the <head> tag.
*/
define("CHEMS_SECTION_HEAD", "
   <!-- Meta tags -->
   <meta name='description' content='Default CHeMS-0x03 Demo' />
   <meta name='keywords' content='CHeMS 0x03 (CHMS) - Demo' />
   <meta name='copyright' content='© 2007-2009 Claudio M. Alessi' />
   <meta name='author' content='Claudio M. Alessi' />

   <!-- Custom tags -->
   <link rel='alternate' type='application/rss+xml'
         title='RSS feeds for CHeMS' />
");

/*
 * This code is appended just after the body tag opening (useful
 * to load Javascript routines onLoad(), etc.
*/
define("TAG_BODY_CODE", "");

/*
 * The application theme.
 * At least two themes are always provided: "simple" (which is
 * the default CHeMS theme) and "none" (which don't load any
 * graphic stuff at all, included the CSS).
*/
define("CHEMS_THEME", "colorlite");

/*
 * Specify where to show the menu bar with a list of fields
 * (see the FSL option). The actual recognized "sides" are
 * left, right, bottom and top. A special value "all" is
 * provided in which case all sides are selected. Unrecognized
 * values are just ignored and if the entry is empty no blocks
 * are show at all.
*/
define("MENUBAR", "all");

/*
 * This value allow to choose what kind of element have
 * to be considered as default. This will be used if no
 * "modname" option is passed to the URL. The allowed
 * values are any valid module name which supports the
 * internal page visualization. Note, the module *must*
 * provide a *_page() function which doesn't need any
 * argument (GET) to work. This is a current CHeMS core
 * limitation that will be removed in further releases.
*/
define("BASEMOD", "pages_mgr");

/*
 * It's the default fields separator used in *all* part
 * of CHeMS and modules released with it. The value is
 * passed "as is" directly to the split() option so use
 * its documentation to learn more about all possibles
 * values.
*/
define("FSL", "[,; ]");

/*
 * Use the UTF-8 encoding.
 *
 * NOTE: this feature just encode the text before printing.
 * The application charset is *always* UTF-8, even with this
 * option disabled.
 *
 * Values: True, False.
*/
define("USE_UTF8", True);

/*
 * This message is shows when a module fails to load.
*/
define("MODULES_MSG_ERROR", "
   <div id='error_title'>Module error.</div>
   <div id='error_body'>
      The <b>".$_GET['modname']."</b> module caused an error.
      Please, contact the web master by sending an
      email to the address shown at the bottom of
      this page. Thanks!
   </div>
");

/*
 * This "page" is shown when an URI for a module which
 * is not loaded yet/anymore is opened and the option
 * MODULES_SECURE is enabled.
*/
define("MODULES_MSG_UNSECMOD", MODULES_MSG_ERROR);

/*
 * Some module provides internal links which allow to navigate
 * through a certain list of objects as the directories into the
 * filesystem, the categories, etc. When you unload a module the
 * objects still exists and you can navigate them anyway if you
 * know the right URL. This option allow to prevent the modules
 * pages to be shown when the relative module is not effectively
 * loaded. You have to specify the list of modules you want to
 * "protect" or the special word "all" in order to enable this
 * feature for all modules. See also the FSL option.
*/
define("MODULES_SECURE", "all");

/*
 * Space between modules (number of "<br />"s among
 * the $MODULES[] divs). You may want to change this
 * depending on the theme. This is what we mean when
 * talking about ``full customizable'' CHMS :-)
 * Note, this value does not affect the modules placed
 * at the "bottom" and "top" sides which always have
 * a spacing of one newline.
*/
define("MODULES_SPACES", 1);

/*
 * Modules - The list of modules to load.
 *
 * Each module have to be load by calling the modload() function (see
 * below) which add the specified module into the modules list (which
 * will be appended to the output page). The modules loading function
 * prototype is the following:
 *
 *    modload($name, $side, $mods [, $opts ])
 *
 * The arguments have to be set respectively to the name of the module,
 * the side where it's have to be placed and the module pages where
 * it have to be shown. The last one may be set to "all" in order to
 * be shown everywhere. The last argument $opts is optional and have
 * to be specified as an array of key/value pairs. Actually the only
 * recognized values are "instance", which specify the module instance
 * name, and "toggle" which set a list separated (see the FSL option)
 * of modules pages where this module have to not be shown.
 *
 * Read the CHeMS guide to learn more about modules. Please, also see
 * the module comments and/or the module README file to know if a
 * module supports a specified feature (and relative key/value pair)
 * or not.
*/

// Include the modules configurations
require_once(FILE_MODCONF);

// Pages manager
modload("pages_mgr", "left", "all");

// Blogroll
//modload("blogroll", "left", "all");

// Links
modload("freehands", "left", "all", array(
	"instance" => "links"
));

// Logo
modload("freehands", "left", "all", array(
	"instance" => "thx"
));

// Freehands
//modload("freehands", "left", "all");

// Posts manager
modload("posts_mgr", "right", "all");

// Showfiles
modload("showfiles", "right", "all");

// Categories
//modload("categories", isset($_GET['post']) ?  "bottom" : "right",
//	"posts_mgr, pages_mgr"
//);

// Meta tags
modload("freehands", "right", "all", array(
	"instance" => "meta"
));

// Navigation bar
modload("navbar", "bottom", "posts_mgr, pages_mgr");

// Comments
//modload("comments", "bottom", "posts_mgr", array(
//	"show" => "1, 3", // Show only into the posts 1 and 3
//));

// RSS feeds
modload("rssfeeds", "bottom", "posts_mgr");

// Change theme (for testing themes)
//modload("chtheme", "left", "all");

// Contacts (disabled by default)
//modload("contacts", "none", "none");

/* End of configuration file */

?>
