<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * CHeMS database - Text-file-based database API
 *
 * NOTE: this file has been written very quickly and it's probably
 *       that contains several bugs and most unefficient routines.
 *       This will change in future, maybe with a total rewrite of
 *       the whole (or some part) text-file-based database API.
 *
 * The following routines are provided:
 *
 *    cdb_insert()	insert a new record
 *    cdb_return()	return the given record
 *    cdb_totals()	get the number of records
 *
 * Not implemented functions:
 *
 *    cdb_delete()	delete a record from a DB
 *    cdb_update()	update a record of the DB
 *    cdb_search()	return the ID of the first record in the DB which match a pattern
 *
*/

/*
 * Insert a record into a file.
 * The function return -1 the ID of the inserted record which correspond
 * to the total number of records minus one. Add one to this value to
 * get the total number of records into the DB :-)
*/
function cdb_insert($file, $record)
{

   // Check the file and, eventually, directory permissions
   if( ($exists = file_exists($file)) &&
       ! (is_writable(dirname($file)) && is_writable($file)) )
      return -1;

   // Ensure there is at least an element
   if( ! sizeof($record) )
      return -1;

   $rec = ''; // avoid a PHP warning

   // If it's a new file, initialize the "$records" variable
   if( ! $exists ) {
      $rec .= "<?php
/*
 * CHeMS text-file-based database
 * (created: ".date(DATE_RFC822).")
 *
 * DO NOT EDIT THIS FILE BY HAND. USE THE CHEMS API FUNCTIONS INSTEAD.
 *
*/

\$records = 0;

";

   // Create the file
   if( ! ($fh = @fopen($file, "w")) )
      return -1;

      fclose($fh);
   }

   // Loop the current element keys
   foreach(array_keys($record) as $key) {
      if( $record[$key] )
         $rec .= '$RECORD[$records][\''.$key.'\'] = "' . $record[$key] . '";'."\n";
   }
   $rec .= "++\$records;\n\n"; // Increments the record ID

   // Open the file
   if( ! ($fh = @fopen($file, "r+")) )
      return -1;

   /*
    * Move the pointer to the given offset starting from the end of file. If
    * the file already exists then move the pointer 2 bytes back in order to
    * skip the PHP closing tag. If the $file is a new file, then stay at the
    * end of the file and adding the tag after finished.
   */
   fseek($fh, ($exists ? -3 : 0), SEEK_END);

   // Get the length of the string and check if it's not zero
   if( ! ($slen = strlen($rec)) )
      return -1;

   // Write the record into the file and add the PHP closing tag
   fwrite($fh, $rec."?>", $slen+2);

   // Close the file
   fclose($fh);

   // Include the file: i have to check the value of the $records variable
   require_once($file);

   return ($records - 1);
} /* eof cdb_insert() */

/*
 * Return the given record taken from the given file. 
 * If the $match parameter is given, then the function
 * return only the records which matchs the same pair
 * of key/value existing in the array $match. If $id
 * is -1 than the latest inserted record is returned.
*/
function cdb_return($file, $id, $match)
{

   // Check if the file exists and it's readable
   if( ! (file_exists($file) && is_readable($file)) )
      return;
    
   // Include the file
   require($file);

   // If the $id is -1, then set it to the last
   // record then check if it's is a valid record ID 	
   if( ($id === -1 ? ($id = $records - 1) : $id) < 0 || $id > $records )
      return;

   // Generate the record
   foreach($RECORD[$id] as $key => $value) {
      
      // If an element doesn't corespond, then ignore the record
      if( isset($match[$key]) && $match[$key] && $match[$key] != $value )
         return;

      $rec[$key] = $value;
   }

   return $rec;
} /* eof cdb_return() */

/*
 * Return the number of records of the given file. 
 * If the $match parameter is given, then the function return only
 * the records which matchs the same pair of key/value existing in
 * the array $match. If the third argument is given then it will
 * be populated with a list of all matching elements indexes.
*/
function cdb_totals($file, $match, &$reclist)
{

   // Check if the file exists and is readable
   if( ! (file_exists($file) && is_readable($file)) )
      return;

   // Include the file (DB)
   require($file);

   if( ! isset($records) )
      $records = 0;

   // Loop all records
   for($r = $rectot = $i = 0, $inc = 1; $r < $records; $inc = 1, $r++) {
      
      // Loop all the current record keys
      foreach($RECORD[$r] as $key => $value) {
         
	 // If the record match, then allow to increment the counter
         if( isset($match[$key]) && $match[$key] && $match[$key] != $value ) {
	    $inc = 0;
	    break;
         }
      }

      // Increment the number of matching record
      if( $inc ) {
         ++$rectot;
         $reclist[$i++] = $r;
      }
   }

   return $rectot;
}

?>
