<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Posts manager module
 *
 * There is only a format operator provided which returns the
 * number of pages in "posts.inc": %[posts_total] .
*/

// Includes all the needed routines
require_once("posts_mgr_functions.php");

/*
 * The CHeMS module get function
*/
function posts_mgr_main()
{

   // Check if the posts file exists
   if( ! file_exists(MOD_POSTSMGR_DB) )
      return;

   // Include the file (insert the posts) 
   require(MOD_POSTSMGR_DB);
   
   $text = "\n
      <div id='mod_posts_mgr_main' class='chems_module'>
         <div class='chems_module_title'>".MOD_POSTSMGR_POST_TITLE."</div>\n";

   /*
    * Generate the links
   */

   $text .= "\n<div class='chems_module_body'>";

   // Ascending order
   if( MOD_POSTSMGR_POST_SORT === "asc" ) {

      $epost = (MOD_POSTSMGR_POST_MAX ? MOD_POSTSMGR_POST_MAX : $posts);

      for($p = 1; $p <= $epost; $p++)
         if( isset($POST[$p]) )
            $text .= MOD_POSTSMGR_PRELINK.$POST[$p]['title'].MOD_POSTSMGR_POSTLINK."\n";
   }

   // Descending order (default)
   else {
      $epost = (MOD_POSTSMGR_POST_MAX ? ($posts > MOD_POSTSMGR_POST_MAX ? $posts - MOD_POSTSMGR_POST_MAX : 0) : 0); 

      for($p = $posts; $p > $epost; $p--)
         if( isset($POST[$p]) )
            $text .= MOD_POSTSMGR_PRELINK.$POST[$p]['title'].MOD_POSTSMGR_POSTLINK."\n";
   }
	          
   $text .= "</div></div>\n";

   return str_replace("%[posts_total]", $posts, $text);
} /* eof posts_mgr_main() */

/*
 * Posts module page
*/
function posts_mgr_page()
{
   require(MOD_POSTSMGR_DB);

   $text = "<div id='mod_posts_mgr_page' class='chems_module'>";

   if( isset($_GET['post']) && ($id = $_GET['post']) ) {
      $page_current = ($id < 1 || $id > $posts ? 0 : $id);

      // Check if the post is valid and exists
      if( ! ($page_current && ($post = getPost($id, 0, NULL))) )
         return MOD_POSTSMGR_MSGNOPOST;
         
      $text .= "<div id='post_$id' class='post'>$post</div>";
   }
   else {
      // Get the inf/sup extremes
      xtrset($posts, MOD_POSTSMGR_POSTSPERPAGE, $einf, $esup, MOD_POSTSMGR_LIST_SORT);

      // Check if it's a valid posts range
      if( ! ($einf && $esup) )
         return MOD_POSTSMGR_MSGNOPOST;
      
      // Get the posts
      if( MOD_POSTSMGR_LIST_SORT === "asc" ) {

         for($p = $einf; $p <= $esup; $p++) {

            /*
             * Check if the current posts exists..
             * This condition should never occurr since the
             * MOD_POSTSMGR_DB file always have progressive IDs.
            */
            if( ! ($post = getPost($p, MOD_POSTSMGR_MAXLEN, MOD_POSTSMGR_SUSP)) )
	       $post = MOD_POSTSMGR_MSGNOPOST;

            // Add the post to the page
            // (expanding the %[elem_curr] format operator)
            $text .= str_replace("%[elem_curr]", $p, $post);

            // It's NOT the last post
            if( $p < $esup ) {
                  /* Include the spaces between posts */
                  $text .= MOD_POSTSMGR_SEP;
            }
	 }
      }
      else { // descending order (default)
         for($p = $esup; $p >= $einf; $p--) {
            if( ! ($post = getPost($p, MOD_POSTSMGR_MAXLEN, MOD_POSTSMGR_SUSP)) )
	       $post = MOD_POSTSMGR_MSGNOPOST;

            // Add the post to the page
            // (expanding the %[elem_curr] format operator)
            $text .= str_replace("%[elem_curr]", $p, $post);

	    /*
	     * Show per-post categories.
	     *
	     * XXX
	     * This is an hack, not a solution. CHeMS doesn't provide any API
	     * to make modules interacts between them. This piece of code uses
	     * CHeMS internals routines and other functions implemented into
	     * the categories module. This may change in further releases.
	    */
            if( MOD_POSTSMGR_SHOWCATS ) {
	       global $MODULES;
	       if( modisload($MODULES, "categories") ) {
   	          require(MOD_POSTSMGR_DB);
	          $text .= "<br /><div class='mod_postsmgr_categories'>";
	          foreach(getCats($POST, $p) as $cat => $occur) {
	             $text .= "<a href='?modname=categories&amp;name=$cat&amp;objtype=post'>$cat</a> ";
		  }
		  $text .= "</div>";
	       }
            }

            // It's NOT the last post
            if( $p > $einf ) {
                  /* Include the spaces between posts */
                  $text .= MOD_POSTSMGR_SEP;
            }
	 }
      }

   }

   $text .= "</div>";

   return $text;
} /* eof posts_mgr_page() */

?>
