/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing.table;

import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charvax.swing.table.TableModel;

public class TableHeader
extends Component {
    private TableModel _model = null;

    public TableHeader(TableModel model_) {
        this._model = model_;
    }

    public void setModel(TableModel model_) {
        this._model = model_;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() {
    }

    public void draw() {
        int i;
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        int columns = this._model.getColumnCount();
        int colorpair = this.getCursesColor();
        term.blankBox(origin, this.getSize(), colorpair);
        term.drawBox(origin, this.getSize(), colorpair);
        int x = 1;
        int attr = Toolkit.A_BOLD;
        for (i = 0; i < columns; ++i) {
            term.setCursor(origin.addOffset(x, 0));
            term.addChar(32, attr, colorpair);
            term.addString(this._model.getColumnName(i), attr, colorpair);
            term.addChar(32, attr, colorpair);
            x += this.getColumnWidth(i) + 1;
        }
        x = this.getColumnWidth(0) + 1;
        for (i = 0; i < columns - 1; ++i) {
            term.setCursor(origin.addOffset(x, 0));
            term.addChar(Toolkit.ACS_TTEE, 0, colorpair);
            x += this.getColumnWidth(i + 1) + 1;
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getWidth() {
        int columns = this._model.getColumnCount();
        int width = 1;
        for (int i = 0; i < columns; ++i) {
            width += this.getColumnWidth(i) + 1;
        }
        return width;
    }

    public int getHeight() {
        return 2;
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("TableHeader origin=" + this._origin + " size=" + this.getSize());
    }

    private int getColumnWidth(int column_) {
        int columnwidth = this._model.getColumnName(column_).length() + 2;
        for (int j = 0; j < this._model.getRowCount(); ++j) {
            int width;
            Object value = this._model.getValueAt(j, column_);
            if (value == null || (width = value.toString().length()) <= columnwidth) continue;
            columnwidth = width;
        }
        return columnwidth;
    }
}

