/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charvax.swing.AbstractButton;

public class JMenuItem
extends AbstractButton {
    protected Dimension _size = new Dimension(0, 0);

    public JMenuItem() {
    }

    public JMenuItem(String text_) {
        this(text_, -1);
    }

    public JMenuItem(String text_, int mnemonic_) {
        super.setText(text_);
        super.setActionCommand(text_);
        super.setMnemonic(mnemonic_);
    }

    public void draw() {
        int mnemonicPos;
        int attribute;
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        term.setCursor(origin);
        int colorpair = this.getCursesColor();
        if (!super.isEnabled()) {
            attribute = Toolkit.A_NORMAL;
            term.addString("<", attribute, colorpair);
            term.addString(super.getText(), attribute, colorpair);
            term.addString(">", attribute, colorpair);
        } else {
            attribute = super.hasFocus() ? Toolkit.A_BOLD : Toolkit.A_NORMAL;
            term.addString(" ", attribute, colorpair);
            term.addString(super.getText(), attribute, colorpair);
            term.addString(" ", attribute, colorpair);
        }
        if (super.getMnemonic() > 0 && (mnemonicPos = super.getText().indexOf((char)super.getMnemonic())) != -1) {
            term.setCursor(origin.addOffset(1 + mnemonicPos, 0));
            term.addChar(super.getMnemonic(), attribute | Toolkit.A_UNDERLINE, colorpair);
        }
    }

    public Dimension minimumSize() {
        return new Dimension(this.getWidth(), 1);
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public int getWidth() {
        return this.getText().length() + 2;
    }

    public int getHeight() {
        return 1;
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Toolkit.getDefaultToolkit().setCursor(origin);
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JMenuItem origin=" + this._origin + " size=" + this._size);
    }

    public String toString() {
        return "JMenuItem: text=" + this.getText();
    }
}

