/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charvax.swing.JComponent;

public class JLabel
extends JComponent {
    private String _labeltext;
    private int _width;

    public JLabel() {
        this("", 303);
    }

    public JLabel(String text_) {
        this(text_, 303);
    }

    public JLabel(String text_, int align_) {
        this._labeltext = text_;
        this._width = text_.length();
        switch (align_) {
            case 303: {
                this._alignmentX = 0.0f;
                break;
            }
            case 301: {
                this._alignmentX = 0.5f;
                break;
            }
            case 304: {
                this._alignmentX = 1.0f;
            }
        }
    }

    public void setLength(int length_) {
        this._width = length_;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        super.draw();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        Toolkit term = Toolkit.getDefaultToolkit();
        term.setCursor(origin);
        StringBuffer buf = new StringBuffer(this._labeltext);
        int textlength = this._labeltext.length();
        if (this._width > textlength) {
            for (int i = textlength; i < this._width; ++i) {
                buf.append(' ');
            }
        } else if (this._width < textlength) {
            buf.setLength(this._width);
        }
        int colorpair = this.getCursesColor();
        term.addString(buf.toString(), 0, colorpair);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._width + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public synchronized void setText(String label_) {
        this._labeltext = label_;
        if (label_.length() > this._width) {
            this._width = label_.length();
        }
        this.repaint();
    }

    public String getText() {
        return this._labeltext;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void processKeyEvent(KeyEvent ke_) {
    }

    public void requestFocus() {
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JLabel origin=" + this._origin + " size=" + this.getSize() + " label=" + this._labeltext);
    }

    public String toString() {
        return "JLabel: [" + this.getText() + "]";
    }
}

