/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.BorderLayout;
import charva.awt.Color;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Frame;
import charva.awt.Insets;
import charvax.swing.JMenuBar;
import charvax.swing.JPanel;

public class JFrame
extends Frame {
    private JMenuBar _menubar = null;
    private JPanel _contentPane = new JPanel();
    private int _closeOperation = 202;
    public static final int EXIT_ON_CLOSE = 200;
    public static final int DISPOSE_ON_CLOSE = 201;
    public static final int DO_NOTHING_ON_CLOSE = 202;
    public static final int HIDE_ON_CLOSE = 203;

    public JFrame() {
        this("");
    }

    public JFrame(String title_) {
        super(title_);
        this.add(this._contentPane);
        this._contentPane.setLayout(new BorderLayout());
    }

    public Container getContentPane() {
        return this._contentPane;
    }

    public void setJMenuBar(JMenuBar menubar_) {
        this._menubar = menubar_;
        this._insets = new Insets(2, 1, 1, 1);
        this._components.insertElementAt(menubar_, 0);
        menubar_.setParent(this);
        menubar_.doLayout();
    }

    public Dimension minimumSize() {
        Dimension minsize = super.minimumSize();
        if (this._menubar == null) {
            return minsize;
        }
        Dimension menubarSize = this._menubar.minimumSize();
        if (menubarSize.width + this._insets.left + this._insets.right > minsize.width) {
            minsize.width = menubarSize.width + this._insets.left + this._insets.right;
        }
        if (menubarSize.height > minsize.height) {
            minsize.height = menubarSize.height;
        }
        return minsize;
    }

    public void setForeground(Color color_) {
        super.setForeground(color_);
        this._contentPane.setForeground(color_);
        if (this._menubar != null && this._menubar.getForeground() == null) {
            this._menubar.setForeground(color_);
        }
    }

    public void setBackground(Color color_) {
        super.setBackground(color_);
        this._contentPane.setBackground(color_);
        if (this._menubar != null && this._menubar.getBackground() == null) {
            this._menubar.setBackground(color_);
        }
    }

    public void setDefaultCloseOperation(int operation_) {
        if (operation_ < 200 || operation_ > 202) {
            throw new IllegalArgumentException("invalid operation");
        }
        this._closeOperation = operation_;
    }
}

