/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Dialog;
import charva.awt.Dimension;
import charva.awt.FlowLayout;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.EventListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charvax.swing.DefaultListModel;
import charvax.swing.JButton;
import charvax.swing.JComponent;
import charvax.swing.JDialog;
import charvax.swing.JLabel;
import charvax.swing.JList;
import charvax.swing.JOptionPane;
import charvax.swing.JPanel;
import charvax.swing.JScrollPane;
import charvax.swing.JTextField;
import charvax.swing.ListModel;
import charvax.swing.border.EmptyBorder;
import charvax.swing.border.TitledBorder;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import charvax.swing.filechooser.FileFilter;
import java.io.File;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JFileChooser
extends JComponent {
    private static final Log LOG = LogFactory.getLog((Class)(class$charvax$swing$JFileChooser == null ? (class$charvax$swing$JFileChooser = JFileChooser.class$("charvax.swing.JFileChooser")) : class$charvax$swing$JFileChooser));
    protected String _title;
    protected String _approveButtonText = "Open File";
    protected File _currentDirectory = null;
    protected DirList _dirList = new DirList();
    protected String _location = "";
    protected boolean _cancelWasPressed = true;
    protected int _fileSelectionMode = 200;
    protected FileFilter _fileFilter = null;
    protected Vector _filelisteners = new Vector();
    protected static final int _COLS = 50;
    protected static final int _ROWS = 20;
    public static final int FILES_ONLY = 200;
    public static final int DIRECTORIES_ONLY = 201;
    public static final int FILES_AND_DIRECTORIES = 202;
    public static final int CANCEL_OPTION = 300;
    public static final int APPROVE_OPTION = 301;
    public static final int ERROR_OPTION = 302;
    public static String CANCEL_LABEL = "Cancel";
    public static String APPROVE_LABEL = "Approve";
    public static String PARENT_DIRECTORY_LABEL = "Parent Directory";
    public static String NEW_DIRECTORY_LABEL = "New Directory";
    public static int CANCEL_ACCELERATOR = -1;
    public static int APPROVE_ACCELERATOR = -1;
    public static int PARENT_DIRECTORY_ACCELERATOR = -1;
    public static int NEW_DIRECTORY_ACCELERATOR = -1;
    static /* synthetic */ Class class$charvax$swing$JFileChooser;

    public JFileChooser() {
        this((File)null);
    }

    public JFileChooser(File currentDirectory_) {
        this.setCurrentDirectory(currentDirectory_);
    }

    public JFileChooser(String currentDirectoryPath_) {
        if (currentDirectoryPath_ == null) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectory(new File(currentDirectoryPath_));
        }
    }

    public void setCurrentDirectory(File dir_) {
        if (dir_ == null) {
            String home = System.getProperty("user.home");
            dir_ = new File(home);
        }
        if (!dir_.isDirectory()) {
            throw new IllegalArgumentException("not a directory");
        }
        this._currentDirectory = dir_;
        this._location = dir_.getAbsolutePath();
    }

    public File getCurrentDirectory() {
        return this._currentDirectory;
    }

    public File getSelectedFile() {
        if (this._cancelWasPressed) {
            return null;
        }
        return new File(this._location);
    }

    public void setSelectedFile(File file_) {
        if (!file_.isAbsolute()) {
            file_ = new File(this._currentDirectory, file_.getPath());
        }
        File parent = file_.getParentFile();
        if (!file_.isDirectory() && parent != null) {
            this._currentDirectory = parent;
            this._location = file_.getAbsolutePath();
        } else if (file_.isDirectory()) {
            this._currentDirectory = file_;
            this._location = file_.getAbsolutePath();
        }
        this.fireFileChooserEvent();
    }

    public int showDialog(Component parent_, String approveButtonText_) {
        this._approveButtonText = approveButtonText_;
        ChooserDialog chooserDialog = new ChooserDialog(parent_);
        chooserDialog.setLocationRelativeTo(parent_);
        chooserDialog.show();
        if (this._cancelWasPressed) {
            return 300;
        }
        return 301;
    }

    public int showSaveDialog(Component parent_) {
        return this.showDialog(parent_, "Save");
    }

    public int showOpenDialog(Component parent_) {
        return this.showDialog(parent_, "Open");
    }

    public void setFileSelectionMode(int mode_) {
        if (mode_ < 200 || mode_ > 202) {
            throw new IllegalArgumentException("invalid file selection mode");
        }
        this._fileSelectionMode = mode_;
    }

    public int getFileSelectionMode() {
        return this._fileSelectionMode;
    }

    public void setDialogTitle(String title_) {
        this._title = title_;
    }

    public void setFileFilter(FileFilter filter_) {
        this._fileFilter = filter_;
    }

    public FileFilter getFileFilter() {
        return this._fileFilter;
    }

    public void debug(int level_) {
        LOG.debug((Object)("JFileChooser origin=" + this._origin + " title=" + this._title));
    }

    public Dimension minimumSize() {
        return null;
    }

    public Dimension getSize() {
        return null;
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    protected void addFileChooserListener(FileChooserListener l) {
        this._filelisteners.addElement(l);
    }

    protected void fireFileChooserEvent() {
        Enumeration e = this._filelisteners.elements();
        while (e.hasMoreElements()) {
            FileChooserListener l = (FileChooserListener)e.nextElement();
            l.fileChanged(new FileChooserEvent(this));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FileChooserEvent
    extends EventObject {
        public FileChooserEvent(Object source_) {
            super(source_);
        }
    }

    private static interface FileChooserListener
    extends EventListener {
        public void fileChanged(FileChooserEvent var1);
    }

    private class NewDirDialog
    extends JDialog
    implements ActionListener {
        private File _parent;
        private JButton _okButton;
        private JButton _cancelButton;
        private JTextField _dirnameField;
        private File _directory = null;

        NewDirDialog(Dialog owner_, File parent_) {
            super(owner_);
            this.setTitle("Enter the new directory name");
            this._parent = parent_;
            this.setSize(60, 10);
            JPanel midpan = new JPanel();
            midpan.setBorder(new EmptyBorder(2, 2, 2, 2));
            midpan.add(new JLabel("Directory name:"));
            this._dirnameField = new JTextField(35);
            this._dirnameField.setActionCommand("dirname");
            this._dirnameField.addActionListener(this);
            midpan.add(this._dirnameField);
            this.add(midpan, "Center");
            this._okButton = new JButton("OK");
            this._okButton.addActionListener(this);
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(this);
            JPanel southpan = new JPanel();
            southpan.setLayout(new FlowLayout(3, 1, 1));
            southpan.add(this._okButton);
            southpan.add(this._cancelButton);
            this.add(southpan, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent e_) {
            String cmd = e_.getActionCommand();
            if (cmd.equals("OK") || cmd.equals("dirname")) {
                if (!this._parent.canWrite()) {
                    String[] msgs = new String[]{"Permission denied"};
                    JOptionPane.showMessageDialog(this, msgs, "Error", 100);
                    return;
                }
                File newdir = new File(this._parent, this._dirnameField.getText());
                boolean ok = newdir.mkdir();
                if (!ok) {
                    String[] msgs = new String[]{"Invalid directory"};
                    JOptionPane.showMessageDialog(this, msgs, "Error", 100);
                } else {
                    this._directory = newdir;
                    this.hide();
                }
            } else if (cmd.equals("Cancel")) {
                this._directory = null;
                this.hide();
            }
        }

        File getDirectory() {
            return this._directory;
        }
    }

    private class DirList
    extends JList {
        private StringBuffer _matchbuf = new StringBuffer();

        DirList() {
            this.setVisibleRowCount(10);
            this.setSelectionMode(201);
        }

        void clear() {
            int min = this.getSelectionModel().getMinSelectionIndex();
            if (min != -1) {
                int max = this.getSelectionModel().getMaxSelectionIndex();
                this.getSelectionModel().removeIndexInterval(min, max);
            }
            ((DefaultListModel)this.getModel()).clear();
            this._currentRow = 0;
            this._matchbuf.setLength(0);
        }

        public void processKeyEvent(KeyEvent evt_) {
            int key = evt_.getKeyCode();
            ListModel listmodel = super.getModel();
            if (listmodel.getSize() > 0 && (key == 263 || key > 32 && key < 255)) {
                String item;
                int i;
                if (key == 263) {
                    if (this._matchbuf.length() > 0) {
                        this._matchbuf.setLength(this._matchbuf.length() - 1);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this._matchbuf.append((char)key);
                }
                String matchstring = this._matchbuf.toString();
                for (i = 0; i < listmodel.getSize() && matchstring.compareTo((String)listmodel.getElementAt(i)) > 0; ++i) {
                }
                if (i == listmodel.getSize()) {
                    --i;
                }
                if (!(item = (String)listmodel.getElementAt(i)).startsWith(matchstring)) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this._currentRow = i;
                super.ensureIndexIsVisible(i);
            }
            super.processKeyEvent(evt_);
        }
    }

    private class ChooserDialog
    extends JDialog
    implements ActionListener,
    ListSelectionListener,
    KeyListener,
    FileChooserListener {
        private JScrollPane _scrollPane;
        protected JButton _cancelButton = new JButton("Cancel");
        protected JButton _approveButton = new JButton("Open");
        protected JButton _parentButton = new JButton("Parent Directory");
        protected JButton _newButton = new JButton("New Directory");
        private JTextField _locationField = new JTextField(35);

        ChooserDialog(Component parent_) {
            this.setTitle(JFileChooser.this._title);
            this.setSize(50, 20);
            if (JFileChooser.this.getForeground() == null) {
                this.setForeground(parent_.getForeground());
            } else {
                this.setForeground(JFileChooser.this.getForeground());
            }
            if (JFileChooser.this.getBackground() == null) {
                this.setBackground(parent_.getBackground());
            } else {
                this.setBackground(JFileChooser.this.getBackground());
            }
            JFileChooser.this._dirList.setVisibleRowCount(12);
            JFileChooser.this._dirList.setColumns(45);
            JFileChooser.this._dirList.addListSelectionListener(this);
            this.displayCurrentDirectory();
            this._scrollPane = new JScrollPane(JFileChooser.this._dirList);
            this._scrollPane.setViewportBorder(new TitledBorder("Files"));
            this.add(this._scrollPane, "West");
            JPanel toppanel = new JPanel();
            toppanel.setBorder(new EmptyBorder(0, 1, 0, 1));
            toppanel.setLayout(new FlowLayout(3, 1, 0));
            toppanel.add(this._parentButton);
            this._parentButton.setText(PARENT_DIRECTORY_LABEL);
            this._parentButton.addActionListener(this);
            toppanel.add(this._newButton);
            this._newButton.setText(NEW_DIRECTORY_LABEL);
            this._newButton.addActionListener(this);
            this.add(toppanel, "North");
            JPanel southpanel = new JPanel();
            southpanel.setLayout(new BorderLayout());
            JPanel topsouth = new JPanel();
            topsouth.add(new JLabel("Pathname:"));
            topsouth.add(this._locationField);
            this._locationField.setText(JFileChooser.this._location);
            this._locationField.setActionCommand("locationField");
            this._locationField.addActionListener(this);
            southpanel.add(topsouth, "North");
            JPanel bottomsouth = new JPanel();
            bottomsouth.setLayout(new FlowLayout(3, 1, 0));
            bottomsouth.setBorder(new EmptyBorder(1, 1, 0, 1));
            bottomsouth.add(this._approveButton);
            bottomsouth.add(this._cancelButton);
            this._approveButton.setText(JFileChooser.this._approveButtonText);
            this._cancelButton.setText(CANCEL_LABEL);
            this._approveButton.addActionListener(this);
            this._cancelButton.addActionListener(this);
            southpanel.add(bottomsouth, "South");
            this.add(southpanel, "South");
            this.pack();
            Insets insets = this.getInsets();
            JFileChooser.this._dirList.setColumns(this.getWidth() - insets.left - insets.right - 2);
            this.addKeyListener(this);
            JFileChooser.this.addFileChooserListener(this);
        }

        public void actionPerformed(ActionEvent e_) {
            Object source = e_.getSource();
            if (source == this._parentButton) {
                this._doParentDirectoryAction();
            } else if (source == this._newButton) {
                this._doNewDirectoryAction();
            } else if (source == this._approveButton) {
                this._doApproveAction();
            } else if (source == this._cancelButton) {
                this._doCancelAction();
            } else if (source == this._locationField) {
                this._doApproveAction();
            }
        }

        public void keyPressed(KeyEvent e_) {
            int key = e_.getKeyCode();
            if (key == PARENT_DIRECTORY_ACCELERATOR) {
                this._doParentDirectoryAction();
            } else if (key == NEW_DIRECTORY_ACCELERATOR) {
                this._doNewDirectoryAction();
            } else if (key == APPROVE_ACCELERATOR) {
                this._doApproveAction();
            } else if (key == CANCEL_ACCELERATOR) {
                this._doCancelAction();
            }
        }

        public void keyTyped(KeyEvent e_) {
        }

        public void keyReleased(KeyEvent e_) {
        }

        public void valueChanged(ListSelectionEvent e_) {
            File file;
            String listitem = (String)JFileChooser.this._dirList.getSelectedValue();
            if (listitem == null) {
                this._locationField.setText(JFileChooser.this._currentDirectory.getAbsolutePath());
                return;
            }
            if (listitem.endsWith("/")) {
                listitem = listitem.substring(0, listitem.length() - 1);
            }
            if (!(file = new File(JFileChooser.this._currentDirectory, listitem)).canRead()) {
                String[] msgs = new String[]{"File or directory not readable:", file.getAbsolutePath()};
                JOptionPane.showMessageDialog(this, msgs, "Error", 100);
                return;
            }
            if (!file.isDirectory()) {
                if (JFileChooser.this._fileSelectionMode == 201) {
                    String[] msgs = new String[]{"Not a directory:", file.getAbsolutePath()};
                    JOptionPane.showMessageDialog(this, msgs, "Error", 100);
                } else {
                    this._locationField.setText(file.getAbsolutePath());
                }
                return;
            }
            JFileChooser.this.setCurrentDirectory(file);
            this.displayCurrentDirectory();
            this.repaint();
            this._scrollPane.getViewport().setViewPosition(new Point(0, 0));
            this._scrollPane.repaint();
            if (!this._isRoot(JFileChooser.this._currentDirectory)) {
                this._parentButton.setEnabled(true);
            }
        }

        public void fileChanged(FileChooserEvent e) {
            this.displayCurrentDirectory();
            this.repaint();
        }

        private void _doNewDirectoryAction() {
            NewDirDialog dlg = new NewDirDialog(this, JFileChooser.this._currentDirectory);
            dlg.setLocation(this.getLocation().addOffset(2, 2));
            dlg.show();
            File newdir = dlg.getDirectory();
            if (newdir != null) {
                JFileChooser.this.setCurrentDirectory(newdir);
            }
            this.displayCurrentDirectory();
            this.repaint();
        }

        private void _doParentDirectoryAction() {
            if (this._isRoot(JFileChooser.this._currentDirectory)) {
                File[] roots = File.listRoots();
                for (int i = 0; i < roots.length; ++i) {
                    DefaultListModel listModel = (DefaultListModel)JFileChooser.this._dirList.getModel();
                    listModel.addElement(roots[i].getAbsolutePath());
                }
                JFileChooser.this._location = "";
            } else {
                File parent = JFileChooser.this._currentDirectory.getParentFile();
                if (this._isRoot(parent)) {
                    this._parentButton.setEnabled(false);
                    JFileChooser.this._dirList.requestFocus();
                }
                JFileChooser.this.setCurrentDirectory(parent);
                this.displayCurrentDirectory();
                this.repaint();
            }
        }

        private void _doApproveAction() {
            File file = new File(this._locationField.getText());
            String errmsg = null;
            if (JFileChooser.this._fileSelectionMode == 201 && !file.isDirectory()) {
                errmsg = "Entry is not a directory: ";
            } else if (JFileChooser.this._fileSelectionMode == 200 && file.isDirectory()) {
                JFileChooser.this.setCurrentDirectory(file);
                this.displayCurrentDirectory();
                this.repaint();
                return;
            }
            if (errmsg != null) {
                String[] msgs = new String[]{errmsg, this._locationField.getText()};
                JOptionPane.showMessageDialog(this, msgs, "Error", 100);
                return;
            }
            JFileChooser.this._cancelWasPressed = false;
            JFileChooser.this._location = this._locationField.getText();
            this.hide();
        }

        private void _doCancelAction() {
            JFileChooser.this._cancelWasPressed = true;
            this.hide();
        }

        private boolean _isRoot(File dir_) {
            String dirname = dir_.getAbsolutePath();
            File[] roots = File.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                if (!roots[i].getAbsolutePath().equals(dirname)) continue;
                return true;
            }
            return false;
        }

        private void displayCurrentDirectory() {
            JFileChooser.this._dirList.clear();
            DefaultListModel listModel = (DefaultListModel)JFileChooser.this._dirList.getModel();
            File[] files = JFileChooser.this._currentDirectory.listFiles();
            Comparator fileSorter = new Comparator(this){
                private final /* synthetic */ ChooserDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object obj1, Object obj2) {
                    String file1 = (String)obj1;
                    String file2 = (String)obj2;
                    return file1.compareTo(file2);
                }
            };
            TreeSet<String> dirs = new TreeSet<String>(fileSorter);
            int numEntries = 0;
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    dirs.add(files[i].getName() + "/");
                } else if (JFileChooser.this._fileSelectionMode != 201 && (JFileChooser.this._fileFilter == null || JFileChooser.this._fileFilter.accept(files[i]))) {
                    dirs.add(files[i].getName());
                }
                ++numEntries;
            }
            Iterator iter = dirs.iterator();
            while (iter.hasNext()) {
                listModel.addElement(iter.next());
            }
            this._locationField.setText(JFileChooser.this._location);
        }
    }
}

