/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Frame;
import charva.awt.Insets;
import charva.awt.ItemSelectable;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.ItemEvent;
import charva.awt.event.ItemListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charvax.swing.ComboBoxModel;
import charvax.swing.DefaultComboBoxModel;
import charvax.swing.JComponent;
import charvax.swing.JList;
import charvax.swing.JScrollPane;
import charvax.swing.MutableComboBoxModel;
import charvax.swing.border.LineBorder;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import java.util.Enumeration;
import java.util.Vector;

public class JComboBox
extends JComponent
implements ListSelectionListener,
ItemSelectable {
    private ComboBoxModel _model;
    private int _columns = 3;
    private int _maxRows = 3;
    protected Vector _actionListeners = null;
    protected Vector _itemListeners = null;
    private Popup _popup;

    public JComboBox() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.setModel(model);
    }

    public JComboBox(ComboBoxModel model) {
        this.setModel(model);
    }

    public JComboBox(Object[] items_) {
        DefaultComboBoxModel model = new DefaultComboBoxModel(items_);
        this.setModel(model);
    }

    public JComboBox(Vector items_) {
        DefaultComboBoxModel model = new DefaultComboBoxModel(items_);
        this.setModel(model);
    }

    public void setModel(ComboBoxModel model_) {
        this._model = model_;
        for (int i = 0; i < this._model.getSize(); ++i) {
            String str = this._model.getElementAt(i).toString();
            if (str.length() <= this._columns) continue;
            this._columns = str.length();
        }
        if (super.isDisplayed()) {
            super.repaint();
        }
    }

    public void addItem(Object item_) {
        ((MutableComboBoxModel)this._model).addElement(item_);
        if (item_.toString().length() > this._columns) {
            this._columns = item_.toString().length();
        }
    }

    public void insertItemAt(Object item_, int index_) {
        ((MutableComboBoxModel)this._model).insertElementAt(item_, index_);
        if (item_.toString().length() > this._columns) {
            this._columns = item_.toString().length();
        }
    }

    public void removeItemAt(int index_) {
        ((MutableComboBoxModel)this._model).removeElementAt(index_);
    }

    public void removeItem(Object item_) {
        ((MutableComboBoxModel)this._model).removeElement(item_);
    }

    public void removeAllItems() {
        while (this._model.getSize() > 0) {
            this.removeItemAt(0);
        }
    }

    public Object getSelectedItem() {
        return this._model.getSelectedItem();
    }

    public void setSelectedItem(Object obj_) {
        this._model.setSelectedItem(obj_);
    }

    public void setSelectedIndex(int index_) {
        Object selected = this._model.getElementAt(index_);
        this._model.setSelectedItem(selected);
    }

    public void setMaximumRowCount(int rows_) {
        this._maxRows = rows_;
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._columns + insets.left + insets.right + 2;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        super.draw();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.right);
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        term.setCursor(origin);
        String selectedItem = (String)this._model.getSelectedItem();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._columns + 1; ++i) {
            buf.append(' ');
        }
        if (selectedItem != null) {
            buf.replace(1, selectedItem.length() + 1, selectedItem);
        }
        int attribute = super.isEnabled() ? Toolkit.A_REVERSE : Toolkit.A_NORMAL;
        term.addString(buf.toString(), attribute, colorpair);
        term.setCursor(origin.addOffset(this._columns + 1, 0));
        term.addChar(Toolkit.ACS_DIAMOND, attribute, colorpair);
    }

    public void addItemListener(ItemListener il_) {
        if (this._itemListeners == null) {
            this._itemListeners = new Vector();
        }
        this._itemListeners.add(il_);
    }

    public void removeItemListener(ItemListener listener_) {
        if (this._itemListeners == null) {
            return;
        }
        this._itemListeners.remove(listener_);
    }

    protected void fireItemStateChanged(ItemEvent ie_) {
        if (this._itemListeners != null) {
            Enumeration e = this._itemListeners.elements();
            while (e.hasMoreElements()) {
                ItemListener il = (ItemListener)e.nextElement();
                il.itemStateChanged(ie_);
            }
        }
    }

    public void processEvent(AWTEvent evt_) {
        super.processEvent(evt_);
        if (evt_ instanceof ActionEvent) {
            this.fireActionEvent((ActionEvent)evt_);
            ItemEvent item_event = new ItemEvent(this, this, 100);
            this.fireItemStateChanged(item_event);
        }
    }

    public void addActionListener(ActionListener al_) {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        this._actionListeners.add(al_);
    }

    protected void fireActionEvent(ActionEvent ae_) {
        if (this._actionListeners != null) {
            Enumeration e = this._actionListeners.elements();
            while (e.hasMoreElements()) {
                ActionListener al = (ActionListener)e.nextElement();
                al.actionPerformed(ae_);
            }
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (key == 343) {
            this._activate();
        }
    }

    public void processMouseEvent(MouseEvent e_) {
        super.processMouseEvent(e_);
        if (e_.getButton() == 1 && e_.getModifiers() == 102 && this.isFocusTraversable()) {
            this._activate();
        }
    }

    public void setEditable(boolean editable) {
    }

    public void valueChanged(ListSelectionEvent e_) {
        this._popup.hide();
        EventQueue evtqueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Object selectedItem = this._popup.getSelectedItem();
        if (selectedItem != null) {
            this._model.setSelectedItem(selectedItem);
        }
        evtqueue.postEvent(new ActionEvent(this, this._model.getSelectedItem().toString()));
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit.getDefaultToolkit().setCursor(origin.addOffset(insets.left, insets.top));
    }

    public String toString() {
        return "JComboBox location=" + this.getLocation() + " selectedItem=\"" + this.getSelectedItem() + "\"";
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println(this.toString());
    }

    private void _activate() {
        this._popup = new Popup(this, this._model);
        this._popup.setMaximumRowCount(this._maxRows);
        Point origin = this.getLocationOnScreen();
        this._popup.setLocation(origin);
        this._popup.show();
    }

    private class Popup
    extends Frame {
        private JList _list = new JList();
        private JScrollPane _scrollpane;

        Popup(JComboBox parent_, ComboBoxModel model_) {
            this.setBackground(parent_.getBackground());
            this.setForeground(parent_.getForeground());
            this._scrollpane = new JScrollPane(this._list);
            this._scrollpane.setViewportBorder(new LineBorder(this.getForeground()));
            this._list.setModel(model_);
            this._list.setColumns(JComboBox.this._columns);
            Object selected = model_.getSelectedItem();
            int selectedIndex = 0;
            for (int i = 0; i < model_.getSize(); ++i) {
                Object obj = model_.getElementAt(i);
                if (selected == obj) {
                    selectedIndex = i;
                }
                String str = obj.toString();
            }
            this._list.setSelectedIndex(selectedIndex);
            super.add(this._scrollpane);
            this._list.addListSelectionListener(parent_);
            this._list.ensureIndexIsVisible(selectedIndex);
        }

        Object getSelectedItem() {
            return this._list.getSelectedValue();
        }

        void setMaximumRowCount(int rows_) {
            this._list.setVisibleRowCount(rows_);
            this.pack();
        }
    }
}

