/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charvax.swing.Action;
import charvax.swing.JComponent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

abstract class AbstractActionPropertyChangeListener
implements PropertyChangeListener {
    private static ReferenceQueue queue;
    private WeakReference target;
    private Action action;

    AbstractActionPropertyChangeListener(JComponent c, Action a) {
        this.setTarget(c);
        this.action = a;
    }

    public void setTarget(JComponent c) {
        OwnedWeakReference r;
        if (queue == null) {
            queue = new ReferenceQueue();
        }
        while ((r = (OwnedWeakReference)queue.poll()) != null) {
            AbstractActionPropertyChangeListener oldPCL = (AbstractActionPropertyChangeListener)r.getOwner();
            Action oldAction = oldPCL.getAction();
            if (oldAction == null) continue;
            oldAction.removePropertyChangeListener(oldPCL);
        }
        this.target = new OwnedWeakReference(c, queue, this);
    }

    public JComponent getTarget() {
        return (JComponent)this.target.get();
    }

    public Action getAction() {
        return this.action;
    }

    private static class OwnedWeakReference
    extends WeakReference {
        private Object owner;

        OwnedWeakReference(Object target, ReferenceQueue queue, Object owner) {
            super(target, queue);
            this.owner = owner;
        }

        public Object getOwner() {
            return this.owner;
        }
    }
}

