/*
 * Decompiled with CFR 0.152.
 */
package charva.awt.util;

import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;

public class MultiLineLabel
extends Component {
    private Vector _labeltext = new Vector();
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;

    public MultiLineLabel(String[] textarray_) {
        for (int i = 0; i < textarray_.length; ++i) {
            this._labeltext.add(textarray_[i]);
        }
    }

    public Dimension minimumSize() {
        int width = 0;
        int height = 0;
        Enumeration e = this._labeltext.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.length() > width) {
                width = s.length();
            }
            ++height;
        }
        return new Dimension(width, height);
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        Enumeration e = this._labeltext.elements();
        int row = 0;
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            term.setCursor(origin.addOffset(0, row));
            term.addString(s, 0, 0);
            ++row;
        }
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public synchronized void setText(String[] textarray_) {
        this._labeltext.removeAllElements();
        for (int i = 0; i < textarray_.length; ++i) {
            this._labeltext.add(textarray_[i]);
        }
        this.repaint();
    }

    public String[] getText() {
        String[] strings = new String[this._labeltext.size()];
        Enumeration e = this._labeltext.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            String s;
            strings[i] = s = (String)e.nextElement();
            ++i;
        }
        return strings;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void processKeyEvent(KeyEvent ke_) {
    }

    public void requestFocus() {
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("MultiLineLabel origin=" + this._origin + " size=" + this.getSize() + " label=" + this._labeltext.elementAt(0));
    }
}

