/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.messages.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SCMarkerGenerator
implements IMarkerGenerator {
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        ProblemMarkerInfo info = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar);
        this.addMarker(info);
    }

    public void addMarker(final ProblemMarkerInfo problemMarkerInfo) {
        try {
            IMarker[] cur = problemMarkerInfo.file.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (cur != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("lineNumber");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && mesg.equals(problemMarkerInfo.description)) {
                        return;
                    }
                    ++i;
                }
            }
            Job markerJob = new Job(Messages.SCMarkerGenerator_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IMarker marker = problemMarkerInfo.file.createMarker("org.eclipse.cdt.core.problem");
                        marker.setAttribute("message", (Object)problemMarkerInfo.description);
                        marker.setAttribute("severity", SCMarkerGenerator.this.mapMarkerSeverity(problemMarkerInfo.severity));
                        marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
                        marker.setAttribute("charStart", -1);
                        marker.setAttribute("charEnd", -1);
                        if (problemMarkerInfo.variableName != null) {
                            marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
                        }
                        if (problemMarkerInfo.externalPath != null) {
                            marker.setAttribute("problem.externalLocation", (Object)problemMarkerInfo.externalPath.toOSString());
                        }
                    }
                    catch (CoreException e) {
                        return new Status(4, MakeCorePlugin.getUniqueIdentifier(), Messages.SCMarkerGenerator_1, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            markerJob.setRule((ISchedulingRule)problemMarkerInfo.file);
            markerJob.schedule();
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    public void removeMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        IWorkspace workspace = file.getWorkspace();
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (markers != null) {
                ArrayList<IMarker> exactMarkers = new ArrayList<IMarker>();
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    int location = (Integer)marker.getAttribute("lineNumber");
                    String error = (String)marker.getAttribute("message");
                    int sev = (Integer)marker.getAttribute("severity");
                    if (location == lineNumber && errorDesc.equals(error) && sev == severity) {
                        exactMarkers.add(marker);
                    }
                    ++i;
                }
                if (exactMarkers.size() > 0) {
                    workspace.deleteMarkers(exactMarkers.toArray(new IMarker[exactMarkers.size()]));
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }
}

