/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.examples.dsf.pda.launch.PDALaunch;
import org.eclipse.cdt.examples.dsf.pda.ui.PDAAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PDAUIPlugin
extends AbstractUIPlugin {
    public static String PLUGIN_ID = "org.eclipse.cdt.examples.dsf.pda.ui ";
    private static PDAUIPlugin plugin;
    private static BundleContext fContext;
    private static final String ICONS_PATH = "icons/full/";
    private static final String PATH_OBJECT = "icons/full/obj16/";
    public static final String IMG_OBJ_PDA = "IMB_OBJ_PDA";
    public static final RGB KEYWORD;
    public static final RGB LABEL;
    private Map<RGB, Color> fColors = new HashMap<RGB, Color>();

    static {
        KEYWORD = new RGB(0, 0, 255);
        LABEL = new RGB(128, 128, 0);
    }

    public PDAUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        fContext = context;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.disposeAdapterSets();
        super.stop(context);
        plugin = null;
        fContext = null;
        for (Map.Entry<RGB, Color> entry : this.fColors.entrySet()) {
            entry.getValue().dispose();
        }
    }

    public static PDAUIPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fContext;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.declareImage(IMG_OBJ_PDA, "icons/full/obj16/pda.gif");
    }

    private void declareImage(String key, String path) {
        URL url = BundleUtility.find((String)"org.eclipse.cdt.examples.dsf.pda.ui", (String)path);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getImageRegistry().put(key, desc);
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColors.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColors.put(rgb, color);
        }
        return color;
    }

    private void disposeAdapterSets() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof PDALaunch) {
                PDAAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
    }
}

