/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.expression;

import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionsChangedEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.VMExpressionUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.jface.viewers.TreePath;

public class ExpressionVMProviderModelProxyStrategy
extends DefaultVMModelProxyStrategy {
    public ExpressionVMProviderModelProxyStrategy(ExpressionVMProvider provider, Object rootElement) {
        super(provider, rootElement);
    }

    private ExpressionVMProvider getExpressionVMProvider() {
        return (ExpressionVMProvider)this.getVMProvider();
    }

    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        IExpressionVMNode matchingNode = this.getExpressionVMProvider().findNodeToParseExpression(null, expression);
        if (matchingNode != null) {
            return this.getNodeDeltaFlagsForExpression(matchingNode, expression, event);
        }
        return 0;
    }

    private int getNodeDeltaFlagsForExpression(IExpressionVMNode node, IExpression expression, Object event) {
        int flags = node.getDeltaFlagsForExpression(expression, event);
        IExpressionVMNode matchingNode = this.getExpressionVMProvider().findNodeToParseExpression(node, expression);
        if (matchingNode != null && !matchingNode.equals(node)) {
            flags |= this.getNodeDeltaFlagsForExpression(matchingNode, expression, event);
        } else {
            IVMNode[] iVMNodeArray = this.getVMProvider().getChildVMNodes(node);
            int n = iVMNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMNode childNode = iVMNodeArray[n2];
                if (!childNode.equals(node)) {
                    int childNodeDeltaFlags = this.getDeltaFlags(childNode, null, event);
                    if ((childNodeDeltaFlags & 0x400) != 0) {
                        childNodeDeltaFlags &= 0xFFFFFBFF;
                        childNodeDeltaFlags |= 0x800;
                    }
                    flags |= childNodeDeltaFlags;
                }
                ++n2;
            }
        }
        return flags;
    }

    public void buildDeltaForExpression(IExpression expression, int expressionElementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        IExpressionVMNode matchingNode = this.getExpressionVMProvider().findNodeToParseExpression(null, expression);
        if (matchingNode != null) {
            this.buildNodeDeltaForExpression(matchingNode, expression, expressionElementIdx, event, parentDelta, path, rm);
        } else {
            rm.done();
        }
    }

    private void buildNodeDeltaForExpression(final IExpressionVMNode node, final IExpression expression, final int expressionElementIdx, final Object event, final VMDelta parentDelta, final TreePath path, final RequestMonitor rm) {
        node.buildDeltaForExpression(expression, expressionElementIdx, event, parentDelta, path, new RequestMonitor(this.getVMProvider().getExecutor(), rm){

            protected void handleSuccess() {
                IExpressionVMNode matchingNode = ExpressionVMProviderModelProxyStrategy.this.getExpressionVMProvider().findNodeToParseExpression(node, expression);
                if (matchingNode != null && !matchingNode.equals(node)) {
                    ExpressionVMProviderModelProxyStrategy.this.buildNodeDeltaForExpression(matchingNode, expression, expressionElementIdx, event, parentDelta, path, rm);
                } else {
                    ExpressionVMProviderModelProxyStrategy.this.getExpressionVMProvider().update(new VMExpressionUpdate((IModelDelta)parentDelta, ExpressionVMProviderModelProxyStrategy.this.getVMProvider().getPresentationContext(), expression, new DataRequestMonitor<Object>(ExpressionVMProviderModelProxyStrategy.this.getVMProvider().getExecutor(), rm){

                        protected void handleSuccess() {
                            ExpressionVMProviderModelProxyStrategy.this.buildDeltaForExpressionElement(node, expression, this.getData(), expressionElementIdx, event, parentDelta, path, rm);
                        }

                        protected void handleErrorOrWarning() {
                            rm.done();
                        }
                    }));
                }
            }
        });
    }

    private void buildDeltaForExpressionElement(IExpressionVMNode node, IExpression expression, Object expressionElement, int expressionElementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getVMProvider().getExecutor(), rm);
        int multiRmCount = 0;
        node.buildDeltaForExpressionElement(expressionElement, expressionElementIdx, event, parentDelta, (RequestMonitor)multiRm);
        ++multiRmCount;
        Map<IVMNode, Integer> childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(node, parentDelta, event);
        if (childNodesWithDeltaFlags.size() != 0) {
            this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, parentDelta.addNode(expressionElement, expressionElementIdx, 0), event, (RequestMonitor)multiRm);
            ++multiRmCount;
        }
        if (event instanceof ExpressionsChangedEvent) {
            this.buildDeltaForExpressionsChangedEvent(expressionElement, expressionElementIdx, (ExpressionsChangedEvent)event, parentDelta, (RequestMonitor)multiRm);
            ++multiRmCount;
        }
        multiRm.setDoneCount(multiRmCount);
    }

    private void buildDeltaForExpressionsChangedEvent(Object element, int elementIdx, ExpressionsChangedEvent event, VMDelta parentDelta, RequestMonitor rm) {
        switch (event.getType()) {
            case ADDED: {
                parentDelta.addNode(element, -1, 1);
                break;
            }
            case CHANGED: {
                parentDelta.setFlags(parentDelta.getFlags() | 0x400);
                break;
            }
            case MOVED: {
                parentDelta.addNode(element, -1, 2);
                parentDelta.addNode(element, elementIdx, 16);
                break;
            }
            case REMOVED: {
                parentDelta.addNode(element, -1, 2);
                break;
            }
            case INSERTED: {
                parentDelta.addNode(element, elementIdx, 16);
                break;
            }
        }
        rm.done();
    }
}

