/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.processes;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.processes.CreateSourceFolder;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateIncludeFolder
extends CreateSourceFolder {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        String targetPath = args[1].getSimpleValue();
        this.createSourceFolder(projectName, targetPath, monitor);
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)projectHandle);
        try {
            IConfiguration[] configs = info.getManagedProject().getConfigurations();
            int i = 0;
            while (i < configs.length) {
                String path = projectHandle.getFolder(targetPath).getLocation().toOSString();
                IToolChain toolChain = configs[i].getToolChain();
                this.setIncludePathOptionForConfig(path, configs[i], toolChain.getOptions(), toolChain);
                ITool[] tools = configs[i].getTools();
                int j = 0;
                while (j < tools.length) {
                    this.setIncludePathOptionForConfig(path, configs[i], tools[j].getOptions(), tools[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (BuildException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateIncludeFolder.3")) + e.getMessage(), (Throwable)e);
        }
        ManagedBuildManager.saveBuildInfo(projectHandle, true);
    }

    private void setIncludePathOptionForConfig(String path, IConfiguration config, IOption[] options, IHoldsOptions optionHolder) throws BuildException {
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            if (option.getValueType() == 4) {
                String[] includePaths = option.getIncludePaths();
                String[] newPaths = new String[includePaths.length + 1];
                System.arraycopy(includePaths, 0, newPaths, 0, includePaths.length);
                newPaths[includePaths.length] = path;
                ManagedBuildManager.setOption(config, optionHolder, option, newPaths);
            }
            ++i;
        }
    }
}

