/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.IObjectSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.MatchObjectElement;

public class ObjectSet
implements IObjectSet {
    private int fObjectType;
    private Set fObjectSet;

    public ObjectSet(int objectType, Set objectSet) {
        this.fObjectType = objectType;
        this.fObjectSet = objectSet;
    }

    public final int getObjectType() {
        return this.fObjectType;
    }

    public IRealBuildObjectAssociation[] getRealBuildObjects() {
        return this.fObjectSet.toArray(new IRealBuildObjectAssociation[this.fObjectSet.size()]);
    }

    public Collection getRealBuildObjects(Collection set) {
        if (set == null) {
            set = new HashSet();
        }
        set.addAll(this.fObjectSet);
        return set;
    }

    public boolean matchesObject(IRealBuildObjectAssociation obj) {
        return this.fObjectSet.contains(obj.getRealBuildObject());
    }

    public boolean retainMatches(Collection collection) {
        return collection.retainAll(this.fObjectSet);
    }

    public int getNumObjects() {
        return this.fObjectSet.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(MatchObjectElement.TypeToStringAssociation.getAssociation(this.fObjectType).getString());
        buf.append("[");
        boolean isFirst = true;
        Iterator iter = this.fObjectSet.iterator();
        while (iter.hasNext()) {
            if (isFirst) {
                buf.append(", ");
                isFirst = false;
            }
            buf.append(((IRealBuildObjectAssociation)iter.next()).getId());
        }
        buf.append("]");
        return buf.toString();
    }
}

