/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;

public class ExternalExtensionEnvironmentSupplier
implements IEnvironmentVariableSupplier {
    private EnvironmentVariableProvider fProvider;
    private static final String[] fNonOverloadableVariables = new String[]{EnvVarOperationProcessor.normalizeName((String)"CWD"), EnvVarOperationProcessor.normalizeName((String)"PWD")};

    public ExternalExtensionEnvironmentSupplier(IEnvironmentVariableManager mngr) {
        this.fProvider = new EnvironmentVariableProvider(mngr);
    }

    public IEnvironmentVariable getVariable(String name, Object context) {
        if (context == null) {
            return null;
        }
        if ((name = this.getValidName(name)) == null) {
            return null;
        }
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            IConfigurationEnvironmentVariableSupplier supplier = cfg.getEnvironmentVariableSupplier();
            if (supplier == null) {
                return null;
            }
            return supplier.getVariable(name, cfg, this.fProvider);
        }
        if (context instanceof IManagedProject) {
            IProjectEnvironmentVariableSupplier supplier;
            IManagedProject project = (IManagedProject)context;
            IProjectType pType = project.getProjectType();
            IProjectEnvironmentVariableSupplier iProjectEnvironmentVariableSupplier = supplier = pType != null ? pType.getEnvironmentVariableSupplier() : null;
            if (supplier == null) {
                return null;
            }
            return supplier.getVariable(name, project, this.fProvider);
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables(Object context) {
        if (context == null) {
            return null;
        }
        IBuildEnvironmentVariable[] variables = null;
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            IConfigurationEnvironmentVariableSupplier supplier = cfg.getEnvironmentVariableSupplier();
            if (supplier == null) {
                return null;
            }
            variables = supplier.getVariables(cfg, this.fProvider);
        } else if (context instanceof IManagedProject) {
            IProjectEnvironmentVariableSupplier supplier;
            IManagedProject project = (IManagedProject)context;
            IProjectEnvironmentVariableSupplier iProjectEnvironmentVariableSupplier = supplier = project.getProjectType() != null ? project.getProjectType().getEnvironmentVariableSupplier() : null;
            if (supplier == null) {
                return null;
            }
            variables = supplier.getVariables(project, this.fProvider);
        }
        return this.filterVariables(variables);
    }

    protected IEnvironmentVariableSupplier[] filterValidSuppliers(IEnvironmentVariableSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] == this) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return null;
        }
        int startNum = i + 1;
        IEnvironmentVariableSupplier[] validSuppliers = new IEnvironmentVariableSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    protected String getValidName(String name) {
        if ((name = EnvVarOperationProcessor.normalizeName((String)name)) == null) {
            return null;
        }
        if (fNonOverloadableVariables != null) {
            int i = 0;
            while (i < fNonOverloadableVariables.length) {
                if (name.equals(fNonOverloadableVariables[i])) {
                    return null;
                }
                ++i;
            }
        }
        return name;
    }

    protected IEnvironmentVariable[] filterVariables(IBuildEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables((IEnvironmentVariable[])variables, (String[])fNonOverloadableVariables);
    }
}

