/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.IKindBasedInfo;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildEntryStorage;

public class BuildLanguageData
extends CLanguageData {
    private ITool fTool;
    private IInputType fInputType;
    private KindBasedStore fKindToOptionArrayStore = new KindBasedStore();
    private KindBasedStore fKindToUndefOptionArrayStore = new KindBasedStore();
    private static final IOption[] EMPTY_OPTION_ARRAY = new IOption[0];
    private boolean fOptionStoreInited;
    private KindBasedStore fKindToEntryStore = new KindBasedStore();
    private String fId;

    public BuildLanguageData(ITool tool, IInputType inType) {
        this.fTool = tool;
        if (inType != null) {
            this.fInputType = inType;
            if (inType.getParent() != tool) {
                throw new IllegalArgumentException();
            }
            this.fId = inType.getId();
        } else {
            this.fInputType = null;
            this.fId = new StringBuffer(this.fTool.getId()).append(".").append("languagedata").toString();
        }
    }

    private void obtainEditableInputType() {
        if (this.fInputType != null) {
            this.fInputType = this.fTool.getEditableInputType(this.fInputType);
        }
    }

    public void setEntries(int kind, ICLanguageSettingEntry[] entries) {
        BuildEntryStorage storage = this.getEntryStorage(kind);
        if (storage != null) {
            storage.setEntries(entries);
        }
    }

    private BuildEntryStorage getEntryStorage(int kind) {
        if (this.getOptionsForKind(kind).length == 0 && this.isToolChainDiscoveryProfile()) {
            return null;
        }
        BuildEntryStorage storage = (BuildEntryStorage)((Object)this.fKindToEntryStore.get(kind));
        if (storage == null) {
            storage = new BuildEntryStorage(kind, this);
            this.fKindToEntryStore.put(kind, (Object)storage);
        }
        return storage;
    }

    private void notifyOptionsChangeForKind(int kind) {
        this.fOptionStoreInited = false;
        BuildEntryStorage storage = this.getEntryStorage(kind);
        if (storage != null) {
            storage.optionsChanged();
        }
    }

    public void optionsChanged(int type) {
        int kind = ManagedBuildManager.optionTypeToEntryKind(type);
        if (kind == 0) {
            kind = ManagedBuildManager.optionUndefTypeToEntryKind(type);
        }
        if (kind != 0) {
            this.notifyOptionsChangeForKind(kind);
        }
    }

    public String getLanguageId() {
        return this.fInputType != null ? this.fInputType.getLanguageId(this.fTool) : null;
    }

    public ICLanguageSettingEntry[] getEntries(int kinds) {
        BuildEntryStorage storage;
        ArrayList list = new ArrayList();
        if ((kinds & 1) != 0) {
            BuildEntryStorage storage2 = this.getEntryStorage(1);
            if (storage2 != null) {
                storage2.getEntries(list);
            }
        } else if ((kinds & 2) != 0) {
            BuildEntryStorage storage3 = this.getEntryStorage(2);
            if (storage3 != null) {
                storage3.getEntries(list);
            }
        } else if ((kinds & 4) != 0) {
            BuildEntryStorage storage4 = this.getEntryStorage(4);
            if (storage4 != null) {
                storage4.getEntries(list);
            }
        } else if ((kinds & 8) != 0) {
            BuildEntryStorage storage5 = this.getEntryStorage(8);
            if (storage5 != null) {
                storage5.getEntries(list);
            }
        } else if ((kinds & 0x10) != 0) {
            BuildEntryStorage storage6 = this.getEntryStorage(16);
            if (storage6 != null) {
                storage6.getEntries(list);
            }
        } else if ((kinds & 0x20) != 0 && (storage = this.getEntryStorage(32)) != null) {
            storage.getEntries(list);
        }
        return list.toArray(new ICLanguageSettingEntry[list.size()]);
    }

    public void updateInputType(IInputType type) {
        this.fInputType = type;
    }

    public String[] getSourceContentTypeIds() {
        if (this.fInputType != null) {
            return this.fInputType.getSourceContentTypeIds();
        }
        return null;
    }

    public String[] getSourceExtensions() {
        return this.fInputType != null ? this.fInputType.getSourceExtensions(this.fTool) : this.fTool.getPrimaryInputExtensions();
    }

    public int getSupportedEntryKinds() {
        KindBasedStore store = this.getKindToOptionArrayStore();
        IKindBasedInfo[] infos = store.getContents();
        int kinds = 0;
        int i = 0;
        while (i < infos.length) {
            if (((IOption[])infos[i].getInfo()).length > 0) {
                kinds |= infos[i].getKind();
            }
            ++i;
        }
        return kinds;
    }

    private KindBasedStore getKindToOptionArrayStore() {
        this.initOptionStores();
        return this.fKindToOptionArrayStore;
    }

    private void initOptionStores() {
        if (!this.fOptionStoreInited) {
            this.initOptionStoresSynch();
        }
    }

    private synchronized void initOptionStoresSynch() {
        if (!this.fOptionStoreInited) {
            this.calculateKindToOptionArrayStore();
            this.calculateKindToUndefOptionArrayStore();
            this.fOptionStoreInited = true;
        }
    }

    private KindBasedStore getKindToUndefOptionArrayStore() {
        this.initOptionStores();
        return this.fKindToUndefOptionArrayStore;
    }

    private void calculateKindToOptionArrayStore() {
        this.fKindToOptionArrayStore.clear();
        IOption[] options = this.fTool.getOptions();
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            try {
                int type = option.getValueType();
                int entryKind = ManagedBuildManager.optionTypeToEntryKind(type);
                if (entryKind != 0) {
                    this.getOptionList(this.fKindToOptionArrayStore, entryKind).add(option);
                }
            }
            catch (BuildException buildException) {}
            ++i;
        }
        IKindBasedInfo[] infos = this.fKindToOptionArrayStore.getContents();
        int i2 = 0;
        while (i2 < infos.length) {
            IKindBasedInfo info = infos[i2];
            List list = (List)info.getInfo();
            if (list != null) {
                IOption[] opts = list.toArray(new IOption[list.size()]);
                info.setInfo((Object)opts);
            } else {
                info.setInfo((Object)EMPTY_OPTION_ARRAY);
            }
            ++i2;
        }
    }

    private void calculateKindToUndefOptionArrayStore() {
        this.fKindToUndefOptionArrayStore.clear();
        IOption[] options = this.fTool.getOptions();
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            try {
                int type = option.getValueType();
                int entryKind = ManagedBuildManager.optionUndefTypeToEntryKind(type);
                if (entryKind != 0) {
                    this.getOptionList(this.fKindToUndefOptionArrayStore, entryKind).add(option);
                }
            }
            catch (BuildException buildException) {}
            ++i;
        }
        IKindBasedInfo[] infos = this.fKindToUndefOptionArrayStore.getContents();
        int i2 = 0;
        while (i2 < infos.length) {
            IKindBasedInfo info = infos[i2];
            List list = (List)info.getInfo();
            if (list != null) {
                IOption[] opts = list.toArray(new IOption[list.size()]);
                info.setInfo((Object)opts);
            } else {
                info.setInfo((Object)EMPTY_OPTION_ARRAY);
            }
            ++i2;
        }
    }

    IOption[] getUndefOptionsForKind(int entryKind) {
        KindBasedStore store = this.getKindToUndefOptionArrayStore();
        return (IOption[])store.get(entryKind);
    }

    IOption[] getOptionsForKind(int entryKind) {
        KindBasedStore store = this.getKindToOptionArrayStore();
        return (IOption[])store.get(entryKind);
    }

    private List getOptionList(KindBasedStore store, int kind) {
        ArrayList list = (ArrayList)store.get(kind);
        if (list == null) {
            list = new ArrayList();
            store.put(kind, list);
        }
        return list;
    }

    public void setLanguageId(String id) {
        if (CDataUtil.objectsEqual((Object)id, (Object)this.fInputType.getLanguageId(this.fTool))) {
            this.obtainEditableInputType();
            this.fInputType.setLanguageIdAttribute(id);
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        String name;
        if (this.fInputType == null) {
            name = this.fTool.getName();
            if (name == null) {
                String[] exts = this.getSourceExtensions();
                name = exts.length != 0 ? CDataUtil.arrayToString((String[])exts, (String)",") : this.fTool.getId();
            }
        } else {
            name = this.fInputType.getLanguageName(this.fTool);
        }
        return name;
    }

    public boolean isValid() {
        return true;
    }

    public void setName(String name) {
    }

    public ITool getTool() {
        return this.fTool;
    }

    public IInputType getInputType() {
        return this.fInputType;
    }

    boolean isToolChainDiscoveryProfile() {
        return this.fInputType != null ? ((InputType)this.fInputType).getDiscoveryProfileIdAttribute() == null : true;
    }

    String getDiscoveryProfileId() {
        IToolChain tCh;
        if (this.fInputType != null) {
            return this.fInputType.getDiscoveryProfileId(this.fTool);
        }
        IBuildObject bo = this.fTool.getParent();
        if (bo instanceof IToolChain) {
            return ((IToolChain)bo).getScannerConfigDiscoveryProfileId();
        }
        if (bo instanceof IResourceInfo && (tCh = ((ResourceConfiguration)bo).getBaseToolChain()) != null) {
            return tCh.getScannerConfigDiscoveryProfileId();
        }
        return null;
    }

    public IConfiguration getConfiguration() {
        return this.fTool.getParentResourceInfo().getParent();
    }

    public void setSourceContentTypeIds(String[] ids) {
        String[] headerIds = this.fInputType.getHeaderContentTypeIds();
        ArrayList<String> newSrc = new ArrayList<String>(ids.length);
        ArrayList<String> newHeaders = new ArrayList<String>(ids.length);
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            int j = 0;
            while (j < headerIds.length) {
                if (id.equals(headerIds[j])) {
                    newHeaders.add(id);
                    break;
                }
                ++j;
            }
            if (j == headerIds.length) {
                newSrc.add(id);
            }
            ++i;
        }
        Object[] newSrcIds = newSrc.toArray(new String[newSrc.size()]);
        Object[] newHeaderIds = newHeaders.toArray(new String[newHeaders.size()]);
        if (!Arrays.equals(newSrcIds, this.fInputType.getSourceContentTypeIds())) {
            this.obtainEditableInputType();
            this.fInputType.setSourceContentTypeIds((String[])newSrcIds);
        }
        if (!Arrays.equals(newHeaderIds, this.fInputType.getHeaderContentTypeIds())) {
            this.obtainEditableInputType();
            this.fInputType.setHeaderContentTypeIds((String[])newHeaderIds);
        }
    }

    public void setSourceExtensions(String[] exts) {
    }

    void clearCachedData() {
        this.fKindToEntryStore.clear();
    }

    public boolean containsDiscoveredScannerInfo() {
        IResourceInfo rcInfo = this.fTool.getParentResourceInfo();
        if (rcInfo instanceof FolderInfo) {
            return ((FolderInfo)rcInfo).containsDiscoveredScannerInfo();
        }
        return true;
    }
}

