/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.HoldsOptions;
import org.eclipse.cdt.managedbuilder.internal.core.MultiResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public class OptionCategory
extends BuildObject
implements IOptionCategory {
    private static final String EMPTY_STRING = new String();
    private static final IOptionCategory[] emtpyCategories = new IOptionCategory[0];
    private IHoldsOptions holder;
    private List children;
    private IOptionCategory owner;
    private String ownerId;
    private URL iconPathURL;
    private boolean isExtensionOptionCategory = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public OptionCategory(IOptionCategory owner) {
        this.owner = owner;
    }

    public OptionCategory(IHoldsOptions parent, IManagedConfigElement element) {
        this.holder = parent;
        this.isExtensionOptionCategory = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionOptionCategory(this);
        parent.addOptionCategory(this);
    }

    public OptionCategory(IHoldsOptions parent, ICStorageElement element) {
        this.holder = parent;
        this.isExtensionOptionCategory = false;
        this.loadFromProject(element);
        parent.addOptionCategory(this);
    }

    public void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.ownerId = element.getAttribute("owner");
        if (element.getAttribute("icon") != null && element instanceof DefaultManagedConfigElement) {
            String icon = element.getAttribute("icon");
            this.iconPathURL = ManagedBuildManager.getURLInBuildDefinitions((DefaultManagedConfigElement)element, (IPath)new Path(icon));
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        if (element.getAttribute("owner") != null) {
            this.ownerId = element.getAttribute("owner");
        }
        this.owner = this.ownerId != null ? this.holder.getOptionCategory(this.ownerId) : this.getNullOptionCategory();
        if (element.getAttribute("icon") != null) {
            String iconPath = element.getAttribute("icon");
            try {
                this.iconPathURL = new URL(iconPath);
            }
            catch (MalformedURLException malformedURLException) {
                ManagedBuildManager.outputIconError(iconPath);
                this.iconPathURL = null;
            }
        }
        if (this.owner == null) {
            ((HoldsOptions)this.holder).addChildCategory(this);
        } else if (this.owner instanceof Tool) {
            ((Tool)this.owner).addChildCategory(this);
        } else {
            ((OptionCategory)this.owner).addChildCategory(this);
        }
    }

    private IOptionCategory getNullOptionCategory() {
        if (this.holder instanceof IOptionCategory) {
            return (IOptionCategory)((Object)this.holder);
        }
        return null;
    }

    public void serialize(ICStorageElement element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.owner != null) {
            element.setAttribute("owner", this.owner.getId());
        }
        if (this.iconPathURL != null) {
            element.setAttribute("icon", this.iconPathURL.toString());
        }
        this.isDirty = false;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.children != null) {
            return this.children.toArray(new IOptionCategory[this.children.size()]);
        }
        return emtpyCategories;
    }

    public void addChildCategory(OptionCategory category) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(category);
    }

    public Object[][] getOptions(IConfiguration configuration, IHoldsOptions optionHolder) {
        IHoldsOptions[] optionHolders = new IHoldsOptions[]{optionHolder};
        return this.getOptions(optionHolders, 2);
    }

    public Object[][] getOptions(IConfiguration configuration) {
        IHoldsOptions[] optionHolders = null;
        if (configuration != null) {
            IHoldsOptions optionHolder = this.getOptionHolder();
            if (optionHolder instanceof ITool) {
                optionHolders = configuration.getFilteredTools();
            } else if (optionHolder instanceof IToolChain) {
                optionHolders = new IHoldsOptions[]{configuration.getToolChain()};
            }
        }
        return this.getOptions(optionHolders, 2);
    }

    public Object[][] getOptions(IResourceInfo resinfo, IHoldsOptions optionHolder) {
        IHoldsOptions[] optionHolders = new IHoldsOptions[]{optionHolder};
        boolean isRoot = false;
        if (resinfo instanceof ResourceInfo) {
            isRoot = ((ResourceInfo)resinfo).isRoot();
        } else if (resinfo instanceof MultiResourceInfo) {
            isRoot = ((MultiResourceInfo)resinfo).isRoot();
        }
        return this.getOptions(optionHolders, isRoot ? 2 : 1);
    }

    public Object[][] getOptions(IResourceConfiguration resConfig) {
        IHoldsOptions[] optionHolders = null;
        if (resConfig != null) {
            IHoldsOptions optionHolder = this.getOptionHolder();
            if (optionHolder instanceof ITool) {
                optionHolders = resConfig.getTools();
            } else if (optionHolder instanceof IToolChain) {
                optionHolders = new IHoldsOptions[]{null};
            }
        }
        return this.getOptions(optionHolders, 1);
    }

    private IHoldsOptions getOptionHoldersSuperClass(IHoldsOptions optionHolder) {
        if (optionHolder instanceof ITool) {
            return ((ITool)optionHolder).getSuperClass();
        }
        if (optionHolder instanceof IToolChain) {
            return ((IToolChain)optionHolder).getSuperClass();
        }
        return null;
    }

    private Object[][] getOptions(IHoldsOptions[] optionHolders, int filterValue) {
        IHoldsOptions catHolder = this.getOptionHolder();
        IHoldsOptions optionHolder = null;
        if (optionHolders != null) {
            int i = 0;
            while (i < optionHolders.length) {
                IHoldsOptions current = optionHolders[i];
                do {
                    if (catHolder != current) continue;
                    optionHolder = optionHolders[i];
                    break;
                } while ((current = this.getOptionHoldersSuperClass(current)) != null);
                if (optionHolder != null) break;
                ++i;
            }
        }
        if (optionHolder == null) {
            optionHolder = catHolder;
        }
        IOption[] allOptions = optionHolder.getOptions();
        Object[][] myOptions = new Object[allOptions.length][2];
        int index = 0;
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this) && (option.getResourceFilter() == 0 || option.getResourceFilter() == filterValue)) {
                myOptions[index] = new Object[2];
                myOptions[index][0] = optionHolder;
                myOptions[index][1] = option;
                ++index;
            }
            ++i;
        }
        return myOptions;
    }

    public IOptionCategory getOwner() {
        return this.owner;
    }

    public IHoldsOptions getOptionHolder() {
        if (this.owner != null) {
            return this.owner.getOptionHolder();
        }
        return this.holder;
    }

    public ITool getTool() {
        IHoldsOptions parent = this.owner.getOptionHolder();
        if (parent instanceof ITool) {
            return (ITool)parent;
        }
        return null;
    }

    public URL getIconPath() {
        return this.iconPathURL;
    }

    public boolean isExtensionElement() {
        return this.isExtensionOptionCategory;
    }

    public boolean isDirty() {
        if (this.isExtensionOptionCategory) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        boolean error = false;
        if (!this.resolved) {
            this.resolved = true;
            if (this.ownerId != null) {
                this.owner = this.holder.getOptionCategory(this.ownerId);
                if (this.owner == null) {
                    if (this.holder instanceof IOptionCategory) {
                        ManagedBuildManager.outputResolveError("owner", this.ownerId, "optionCategory", this.getId());
                        error = true;
                    } else if (!this.holder.getId().equals(this.ownerId)) {
                        ManagedBuildManager.outputResolveError("owner", this.ownerId, "optionCategory", this.getId());
                        error = true;
                    }
                }
            }
            if (this.owner == null) {
                this.owner = this.getNullOptionCategory();
            }
            if (this.owner == null && !error) {
                ((HoldsOptions)this.holder).addChildCategory(this);
            } else if (this.owner instanceof Tool) {
                ((Tool)this.owner).addChildCategory(this);
            } else {
                ((OptionCategory)this.owner).addChildCategory(this);
            }
        }
    }

    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getOptionHolder() != null) {
            return this.getOptionHolder().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getOptionHolder() != null) {
            return this.getOptionHolder().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public static String makeMatchName(IBuildObject catOrTool) {
        String catName = EMPTY_STRING;
        do {
            catName = String.valueOf(catOrTool.getName()) + "|" + catName;
        } while (!(catOrTool instanceof ITool) && catOrTool instanceof IOptionCategory && (catOrTool = ((IOptionCategory)catOrTool).getOwner()) != null);
        return catName;
    }

    public static Object findOptionCategoryByMatchName(String matchName, IOptionCategory[] cats) {
        Object primary = null;
        int j = 0;
        while (j < cats.length) {
            IOptionCategory catOrTool = cats[j];
            String catName = OptionCategory.makeMatchName(catOrTool);
            if (catName.equals(matchName)) {
                primary = cats[j];
                break;
            }
            if (matchName.startsWith(catName) && (primary = OptionCategory.findOptionCategoryByMatchName(matchName, cats[j].getChildCategories())) != null) break;
            ++j;
        }
        return primary;
    }
}

