/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class EnvVarBuildPath
implements IEnvVarBuildPath {
    private int type;
    private String[] variableNames;
    private String pathDelimiter;
    private IBuildPathResolver buildPathResolver;
    private IConfigurationElement buildPathResolverElement;

    public EnvVarBuildPath(ITool tool, IManagedConfigElement element) {
        this.loadFromManifest(element);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.setType(this.convertPathTypeToInt(element.getAttribute("pathType")));
        this.setVariableNames(element.getAttribute("variableList"));
        this.setPathDelimiter(element.getAttribute("pathDelimiter"));
        String buildPathResolver = element.getAttribute("buildPathResolver");
        if (buildPathResolver != null && element instanceof DefaultManagedConfigElement) {
            this.buildPathResolverElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String[] names) {
        this.variableNames = names;
    }

    public void setVariableNames(String names) {
        this.setVariableNames(this.getNamesFromString(names));
    }

    public String[] getNamesFromString(String names) {
        if (names == null) {
            return null;
        }
        return names.split(",");
    }

    public String getPathDelimiter() {
        return this.pathDelimiter;
    }

    public void setPathDelimiter(String delimiter) {
        if (delimiter == null) {
            delimiter = ManagedBuildManager.getEnvironmentVariableProvider().getDefaultDelimiter();
        }
        this.pathDelimiter = delimiter;
    }

    private int convertPathTypeToInt(String pathType) {
        if (pathType != null && "buildpathLibrary".equals(pathType)) {
            return 2;
        }
        return 1;
    }

    private String convertPathTypeToString(int pathType) {
        switch (pathType) {
            case 2: {
                return "buildpathLibrary";
            }
        }
        return "buildpathInclude";
    }

    public IBuildPathResolver getBuildPathResolver() {
        if (this.buildPathResolver == null && this.buildPathResolverElement != null) {
            try {
                if (this.buildPathResolverElement.getAttribute("buildPathResolver") != null) {
                    this.buildPathResolver = (IBuildPathResolver)this.buildPathResolverElement.createExecutableExtension("buildPathResolver");
                }
            }
            catch (CoreException coreException) {}
        }
        return this.buildPathResolver;
    }
}

