/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class CountingRequestMonitor
extends RequestMonitor {
    private int fDoneCounter;
    private boolean fInitialCountSet = false;

    public CountingRequestMonitor(Executor executor, RequestMonitor parentRequestMonitor) {
        super(executor, parentRequestMonitor);
        super.setStatus((IStatus)new MultiStatus("org.eclipse.cdt.dsf", 0, "", null){

            public String getMessage() {
                StringBuffer message = new StringBuffer();
                IStatus[] children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    message.append(children[i].getMessage());
                    if (i + 1 < children.length) {
                        message.append(" ,");
                    }
                    ++i;
                }
                return message.toString();
            }
        });
    }

    public synchronized void setDoneCount(int count) {
        assert (!this.fInitialCountSet);
        this.fInitialCountSet = true;
        this.fDoneCounter += count;
        if (this.fDoneCounter <= 0) {
            assert (this.fDoneCounter == 0);
            super.done();
        }
    }

    public synchronized void done() {
        --this.fDoneCounter;
        if (this.fInitialCountSet && this.fDoneCounter <= 0) {
            assert (this.fDoneCounter == 0);
            super.done();
        }
    }

    public String toString() {
        return "CountingRequestMonitor: " + this.getStatus().toString();
    }

    public synchronized void setStatus(IStatus status) {
        if (this.getStatus() instanceof MultiStatus) {
            ((MultiStatus)this.getStatus()).add(status);
        }
    }
}

