/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;

public class DOMSearchUtil {
    private static final IASTName[] BLANK_NAME_ARRAY = new IASTName[0];
    public static final int DECLARATIONS = 1;
    public static final int DEFINITIONS = 2;
    public static final int DECLARATIONS_DEFINITIONS = 3;
    public static final int REFERENCES = 4;
    public static final int ALL_OCCURRENCES = 5;

    public static ParserLanguage getLanguageFromFile(IFile file) {
        String lid;
        IProject project = file.getProject();
        IContentType contentType = CCorePlugin.getContentType((IProject)project, (String)file.getFullPath().lastSegment());
        if (contentType != null && ("org.eclipse.cdt.core.cxxSource".equals(lid = contentType.getId()) || "org.eclipse.cdt.core.cxxHeader".equals(lid))) {
            return ParserLanguage.CPP;
        }
        return ParserLanguage.C;
    }

    public static ParserLanguage getLanguage(IPath path, IProject project) {
        String id = null;
        IContentType contentType = CCorePlugin.getContentType((IProject)project, (String)path.lastSegment());
        if (contentType != null) {
            id = contentType.getId();
        }
        if (id != null) {
            if ("org.eclipse.cdt.core.cxxHeader".equals(id)) {
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cxxSource".equals(id)) {
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cHeader".equals(id)) {
                return ParserLanguage.C;
            }
            if ("org.eclipse.cdt.core.cSource".equals(id)) {
                return ParserLanguage.C;
            }
            "org.eclipse.cdt.core.asmSource".equals(id);
        }
        return ParserLanguage.CPP;
    }

    public static IName[] getNamesFromDOM(IASTName searchName, int limitTo) {
        IName[] names = null;
        IASTTranslationUnit tu = searchName.getTranslationUnit();
        if (tu == null) {
            return BLANK_NAME_ARRAY;
        }
        IBinding binding = searchName.resolveBinding();
        if (binding instanceof IIndexBinding) {
            Assert.fail((String)"Not implemented");
        } else {
            names = DOMSearchUtil.getNames(tu, binding, limitTo);
            if (names == null || names.length == 0) {
                try {
                    if ((binding instanceof ICPPConstructor || binding instanceof ICPPMethod && ((ICPPMethod)binding).isDestructor()) && binding.getScope() instanceof ICPPClassScope) {
                        binding = ((ICPPClassScope)binding.getScope()).getClassType();
                        names = DOMSearchUtil.getNames(tu, binding, limitTo);
                    }
                }
                catch (DOMException dOMException) {}
            }
        }
        return names;
    }

    private static IASTName[] getNames(IASTTranslationUnit tu, IBinding binding, int limitTo) {
        Object[] names = null;
        if (limitTo == 1 || limitTo == 3) {
            names = tu.getDeclarationsInAST(binding);
        } else if (limitTo == 4) {
            names = tu.getReferences(binding);
        } else if (limitTo == 2) {
            names = tu.getDefinitionsInAST(binding);
        } else if (limitTo == 5) {
            names = tu.getDeclarationsInAST(binding);
            names = (IASTName[])ArrayUtil.addAll(IASTName.class, (Object[])names, (Object[])tu.getReferences(binding));
        } else {
            names = tu.getDeclarationsInAST(binding);
            names = (IASTName[])ArrayUtil.addAll(IASTName.class, (Object[])names, (Object[])tu.getReferences(binding));
        }
        return names;
    }

    public static class CNameCollector
    extends CASTVisitor {
        public List nameList;

        public CNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName getName(int idx) {
            if (idx < 0 || idx >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(idx);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    public static class CPPNameCollector
    extends CPPASTVisitor {
        public List nameList;

        public CPPNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName getName(int idx) {
            if (idx < 0 || idx >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(idx);
        }

        public int size() {
            return this.nameList.size();
        }
    }
}

