/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakInsert
extends MICommand<MIBreakInsertInfo> {
    public MIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, String func) {
        this(ctx, false, false, null, 0, func, 0);
    }

    public MIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, boolean isTemporary, boolean isHardware, String condition, int ignoreCount, String line, int tid) {
        super((IDMContext)ctx, "-break-insert");
        int i = 0;
        if (isTemporary) {
            ++i;
        }
        if (isHardware) {
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            i += 2;
        }
        if (ignoreCount > 0) {
            i += 2;
        }
        if (tid > 0) {
            i += 2;
        }
        String[] opts = new String[i];
        i = 0;
        if (isTemporary) {
            opts[i] = "-t";
            ++i;
        }
        if (isHardware) {
            opts[i] = "-h";
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            opts[i] = "-c";
            opts[++i] = condition;
            ++i;
        }
        if (ignoreCount > 0) {
            opts[i] = "-i";
            opts[++i] = Integer.toString(ignoreCount);
            ++i;
        }
        if (tid > 0) {
            opts[i] = "-p";
            opts[++i] = Integer.toString(tid);
        }
        if (opts.length > 0) {
            this.setOptions(opts);
        }
        this.setParameters(new PathAdjustable(line));
    }

    @Override
    public MIBreakInsertInfo getResult(MIOutput output) {
        return new MIBreakInsertInfo(output);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathAdjustable
    extends MICommand.MIStandardParameterAdjustable {
        public PathAdjustable(String path) {
            super(path);
        }

        @Override
        public String getAdjustedValue() {
            String adjustedValue = super.getAdjustedValue();
            return adjustedValue.replace("\\\\", "\\");
        }
    }
}

