/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.tests.AbstractDebugTest;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.core.runtime.CoreException;

public class LocationTests
extends AbstractDebugTest {
    public static Test suite() {
        return new AbstractDebugTest.DebugTestWrapper(LocationTests.class){};
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LocationTests.suite());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createDebugSession();
        LocationTests.assertNotNull((Object)this.currentTarget);
        this.currentTarget.deleteAllBreakpoints();
        this.pause();
    }

    public void testIsEquals() throws CoreException, MIException, IOException, CDIException {
        ICDITarget cdiTarget = this.currentTarget;
        ICDIFunctionLocation functionLocation = cdiTarget.createFunctionLocation("main.c", "func1");
        ICDIFunctionLocation functionLocation2 = cdiTarget.createFunctionLocation("main.c", "func1");
        LocationTests.assertTrue((boolean)functionLocation.equals((ICDILocation)functionLocation2));
        ICDILineLocation lineLocation = cdiTarget.createLineLocation("main.c", 10);
        ICDILineLocation lineLocation2 = cdiTarget.createLineLocation("main.c", 10);
        LocationTests.assertTrue((boolean)lineLocation.equals((ICDILocation)lineLocation2));
        functionLocation = cdiTarget.createFunctionLocation("main.c", "func1");
        LocationTests.assertNotNull((Object)functionLocation);
        functionLocation2 = cdiTarget.setFunctionBreakpoint(0, functionLocation, null, false).getLocator();
        ICDIBreakpoint[] breakpoints = cdiTarget.getBreakpoints();
        LocationTests.assertNotNull((Object)breakpoints);
        LocationTests.assertTrue((breakpoints.length == 1 ? 1 : 0) != 0);
        Object curbreak = breakpoints[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)breakpoints[0] : null;
        LocationTests.assertNotNull(curbreak);
        LocationTests.assertTrue((boolean)curbreak.getLocator().equals((ICDILocation)functionLocation2));
        cdiTarget.deleteAllBreakpoints();
        this.pause();
        functionLocation = cdiTarget.createFunctionLocation("main.c", "func1");
        LocationTests.assertNotNull((Object)functionLocation);
        cdiTarget.setFunctionBreakpoint(0, functionLocation, null, false);
        breakpoints = cdiTarget.getBreakpoints();
        LocationTests.assertNotNull((Object)breakpoints);
        LocationTests.assertTrue((breakpoints.length == 1 ? 1 : 0) != 0);
        curbreak = breakpoints[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)breakpoints[0] : null;
        LocationTests.assertNotNull((Object)curbreak);
        LocationTests.assertTrue((String)"PR:23879", (boolean)curbreak.getLocator().equals((ICDILocation)functionLocation));
    }
}

