/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.testplugin.CDebugHelper;
import org.eclipse.cdt.debug.testplugin.CProjectHelper;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDebugTest
extends TestCase {
    IWorkspace workspace;
    IWorkspaceRoot root;
    NullProgressMonitor monitor;
    static ICProject testProject = null;
    static ICDISession session = null;
    static ICDITarget[] targets = null;
    ICDITarget currentTarget;
    static boolean oneTimeSetupDone = false;

    protected void setUp() throws Exception {
        super.setUp();
        if (!oneTimeSetupDone) {
            this.oneTimeSetUp();
            oneTimeSetupDone = false;
        }
        this.workspace = ResourcesPlugin.getWorkspace();
        this.root = this.workspace.getRoot();
        this.monitor = new NullProgressMonitor();
        if (this.workspace == null) {
            AbstractDebugTest.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            AbstractDebugTest.fail((String)"Workspace root was not setup");
        }
    }

    void createDebugSession() throws IOException, MIException, CModelException {
        session = CDebugHelper.createSession(this.getProjectBinary(), testProject);
        AbstractDebugTest.assertNotNull((Object)session);
        targets = session.getTargets();
        AbstractDebugTest.assertNotNull((Object)targets);
        AbstractDebugTest.assertTrue((targets.length > 0 ? 1 : 0) != 0);
        this.currentTarget = targets[0];
    }

    protected void oneTimeSetUp() throws CoreException, InvocationTargetException, IOException {
        ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        Path imputFile = new Path(this.getProjectZip());
        testProject = CProjectHelper.createCProjectWithImport(this.getProjectName(), (IPath)imputFile);
        if (testProject == null) {
            AbstractDebugTest.fail((String)"Unable to create project");
        }
        testProject.getProject().build(6, null);
        oneTimeSetupDone = true;
    }

    protected String getProjectName() {
        return "filetest";
    }

    protected String getProjectZip() {
        return "resources/debugTest.zip";
    }

    protected String getProjectBinary() {
        return "main";
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static void uimsleep(int msec) {
        long cur = System.currentTimeMillis();
        long pass = 0L;
        Display display = AbstractDebugTest.getDisplay();
        while (pass < (long)msec) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
            pass = System.currentTimeMillis() - cur;
        }
    }

    protected void oneTimeTearDown() throws CoreException {
        if (targets != null) {
            try {
                targets[0].terminate();
            }
            catch (CDIException cDIException) {}
        }
        if (session != null) {
            try {
                session.terminate();
            }
            catch (CDIException cDIException) {}
        }
        CProjectHelper.delete(testProject);
        if (!oneTimeSetupDone) {
            this.oneTimeTearDown();
        }
    }

    void pause() {
        AbstractDebugTest.uimsleep(200);
    }

    public ICDILocator getCurrentLocator() throws CDIException {
        return this.getCurrentFrame().getLocator();
    }

    public ICDIStackFrame getCurrentFrame() throws CDIException {
        return this.currentTarget.getCurrentThread().getStackFrames()[0];
    }

    void waitSuspend(ICDITarget currentTarget) {
        int loop = 0;
        while (!currentTarget.isSuspended() && !currentTarget.isTerminated() && loop < 20) {
            AbstractDebugTest.uimsleep(500);
            ++loop;
        }
        AbstractDebugTest.assertFalse((String)("Target should be suspended, but it is terminated " + currentTarget.isTerminated()), (boolean)currentTarget.isTerminated());
        AbstractDebugTest.assertTrue((String)"Target should be suspended but it is not", (boolean)currentTarget.isSuspended());
    }

    public void resumeCurrentTarget() throws CDIException {
        this.currentTarget.resume(false);
    }

    void setBreakOnMain() throws CDIException {
        ICDIFunctionLocation location = null;
        location = this.currentTarget.createFunctionLocation("", "main");
        this.currentTarget.setFunctionBreakpoint(1, location, null, false);
    }

    protected void tearDown() throws Exception {
        if (session == null) {
            session.terminate();
            session = null;
        }
        super.tearDown();
    }

    static class DebugTestWrapper
    extends TestSetup {
        private AbstractDebugTest newInstance;

        public DebugTestWrapper(Class clazz) {
            super((Test)new TestSuite(clazz));
            try {
                this.newInstance = (AbstractDebugTest)((Object)clazz.newInstance());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected void setUp() throws FileNotFoundException, IOException, InterruptedException, InvocationTargetException, CoreException {
            this.newInstance.oneTimeSetUp();
        }

        protected void tearDown() throws FileNotFoundException, IOException, CoreException {
            this.newInstance.oneTimeTearDown();
        }
    }
}

